/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.transmutation;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class CommutativeTransmutationRecipe
extends TransmutationRecipe {
    private final ArrayList<class_1799> communalInputs;
    private class_1799 viewStack = new class_1799((class_1935)class_1802.field_8077);

    public CommutativeTransmutationRecipe(String name, class_1799 reagent1, class_1799 reagent2) {
        super(name, reagent1, reagent2);
        this.communalInputs = new ArrayList();
    }

    public CommutativeTransmutationRecipe with(class_1792 ... items) {
        for (class_1792 item : items) {
            this.addItem(item);
        }
        return this;
    }

    public CommutativeTransmutationRecipe with(class_1799 ... items) {
        for (class_1799 item : items) {
            this.addItemStack(item);
        }
        return this;
    }

    public CommutativeTransmutationRecipe with(Either<class_6862<class_1792>, class_6862<class_2248>> tag) {
        block7: {
            block6: {
                if (!tag.left().isPresent()) break block6;
                for (class_6880 itemEntry : class_7923.field_41178.method_40295()) {
                    try {
                        if (!itemEntry.method_40220((class_6862)tag.left().get())) continue;
                        this.addItem((class_1792)itemEntry.comp_349());
                    }
                    catch (Exception e) {
                        ArcanaNovum.log(2, "Error getting tags for " + itemEntry.method_55840());
                    }
                }
                break block7;
            }
            if (!tag.right().isPresent()) break block7;
            for (class_6880 itemEntry : class_7923.field_41178.method_40295()) {
                try {
                    class_1747 blockItem;
                    Object object = itemEntry.comp_349();
                    if (!(object instanceof class_1747) || (blockItem = (class_1747)object).method_7711() == null || !blockItem.method_7711().method_40142().method_40220((class_6862)tag.right().get())) continue;
                    this.addItem((class_1792)itemEntry.comp_349());
                }
                catch (Exception e) {
                    ArcanaNovum.log(2, "Error getting tags for " + itemEntry.method_55840());
                }
            }
        }
        return this;
    }

    public CommutativeTransmutationRecipe withViewStack(class_1799 viewStack) {
        this.viewStack = viewStack;
        return this;
    }

    private void addItem(class_1792 item) {
        this.addItemStack(new class_1799((class_1935)item));
    }

    private void addItemStack(class_1799 stack) {
        for (class_1799 communalInput : this.communalInputs) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)communalInput)) continue;
            return;
        }
        this.communalInputs.add(stack);
    }

    @Override
    public List<class_1799> doTransmutation(class_1799 positiveInput, class_1799 negativeInput, class_1799 reagent1, class_1799 reagent2, class_1799 aequalisInput, class_3222 player) {
        return List.of(negativeInput.method_46651(positiveInput.method_7947()), negativeInput, aequalisInput);
    }

    @Override
    public List<class_3545<class_1799, String>> doTransmutation(class_1542 sourceEntity, class_1542 focusEntity, class_1542 reagent1Entity, class_1542 reagent2Entity, class_1542 aequalisEntity, TransmutationAltarBlockEntity altar, class_3222 player) {
        int take;
        class_1799 reagent2;
        boolean cross;
        class_1799 reagent2Stack;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        class_1799 sourceStack = sourceEntity != null ? sourceEntity.method_6983() : class_1799.field_8037;
        class_1799 focusStack = focusEntity != null ? focusEntity.method_6983() : class_1799.field_8037;
        class_1799 reagent1Stack = reagent1Entity != null ? reagent1Entity.method_6983() : class_1799.field_8037;
        class_1799 class_17992 = reagent2Stack = reagent2Entity != null ? reagent2Entity.method_6983() : class_1799.field_8037;
        if (!this.canTransmute(sourceStack, focusStack, reagent1Stack, reagent2Stack, class_1799.field_8037, altar)) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        class_1799 outputStack = focusStack.method_46651(sourceStack.method_7947());
        if (sourceEntity != null) {
            sourceEntity.method_31472();
        }
        boolean m11 = this.validStack(re1, reagent1Stack);
        boolean m22 = this.validStack(re2, reagent2Stack);
        boolean m12 = this.validStack(re1, reagent2Stack);
        boolean m21 = this.validStack(re2, reagent1Stack);
        boolean straight = m11 && m22;
        boolean bl = cross = !straight && m12 && m21;
        if (!straight && !cross) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        class_1799 reagent1 = straight ? re1 : re2;
        class_1799 class_17993 = reagent2 = straight ? re2 : re1;
        if (reagent1Entity != null) {
            int n = take = reagent1.method_7960() ? 0 : reagent1.method_7947();
            if (take > 0) {
                if (reagent1Stack.method_7947() == take) {
                    reagent1Entity.method_31472();
                } else {
                    reagent1Stack.method_7934(take);
                    reagent1Entity.method_6979(reagent1Stack);
                }
            }
        }
        if (reagent2Entity != null) {
            int n = take = reagent2.method_7960() ? 0 : reagent2.method_7947();
            if (take > 0) {
                if (reagent2Stack.method_7947() == take) {
                    reagent2Entity.method_31472();
                } else {
                    reagent2Stack.method_7934(take);
                    reagent2Entity.method_6979(reagent2Stack);
                }
            }
        }
        ArrayList<class_3545<class_1799, String>> outputs = new ArrayList<class_3545<class_1799, String>>();
        outputs.add(new class_3545((Object)outputStack, (Object)"negative"));
        return outputs;
    }

    @Override
    public boolean canTransmute(class_1799 sourceInput, class_1799 focusInput, class_1799 reagent1Input, class_1799 reagent2Input, class_1799 aequalisInput, TransmutationAltarBlockEntity altar) {
        boolean reagentCheck2;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        boolean reagentCheck1 = this.validStack(re1, reagent1Input) && this.validStack(re2, reagent2Input);
        boolean bl = reagentCheck2 = this.validStack(re1, reagent2Input) && this.validStack(re2, reagent1Input);
        if (!reagentCheck1 && !reagentCheck2) {
            return false;
        }
        if (!this.validCommunalInput(sourceInput)) {
            return false;
        }
        if (!this.validCommunalInput(focusInput)) {
            return false;
        }
        return !sourceInput.method_31574(focusInput.method_7909());
    }

    public boolean validCommunalInput(class_1799 input) {
        for (class_1799 comInput : this.communalInputs) {
            if (!this.validStack(comInput, input)) continue;
            return true;
        }
        return false;
    }

    public List<class_1799> getCommunalInputs() {
        return new ArrayList<class_1799>(this.communalInputs);
    }

    @Override
    public class_1799 getViewStack() {
        return this.viewStack.method_7972();
    }
}

