/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MathUtils;
import net.borisshoes.borislib.utils.ParticleEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_7268;
import net.minecraft.class_7290;
import net.minecraft.class_8104;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ArcanaEffectUtils
extends ParticleEffectUtils {
    public static final double PHI = (1.0 + Math.sqrt(5.0)) / 2.0;

    public static void pulsarBladeShoot(class_3218 world, class_243 p1, class_243 p2, int tick) {
        class_243 diff = p2.method_1020(p1);
        int intervals = (int)(p1.method_1020(p2).method_1033() * 10.0);
        double delta = 0.03;
        double speed = 1.0;
        double portion = 0.5;
        int numTicks = 5;
        int count = 3;
        double dx = diff.field_1352 / (double)intervals;
        double dy = diff.field_1351 / (double)intervals;
        double dz = diff.field_1350 / (double)intervals;
        int upperInt = (int)((double)intervals * (((double)tick + 1.0) / (double)numTicks));
        int lowerInt = (int)Math.max(0.0, (double)upperInt - (double)intervals * portion);
        for (int i = 0; i < intervals; ++i) {
            if (i < lowerInt || i > upperInt) continue;
            double x = p1.field_1352 + dx * (double)i;
            double y = p1.field_1351 + dy * (double)i;
            double z = p1.field_1350 + dz * (double)i;
            float hue = 0.49444443f;
            float sat = 0.8f * (1.0f - (float)i / (float)intervals);
            Color c = Color.getHSBColor(hue, sat, 1.0f);
            class_2390 dust = new class_2390(c.getRGB(), 0.6f);
            ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)dust, (double)x, (double)y, (double)z, (double)delta, (double)delta, (double)delta, (double)speed, (int)count);
        }
        if (upperInt >= intervals) {
            ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)class_2398.field_29643, (double)p2.field_1352, (double)p2.field_1351, (double)p2.field_1350, (double)0.2, (double)0.2, (double)0.2, (double)1.0, (int)10);
        }
        if (tick < numTicks - 1) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.pulsarBladeShoot(world, p1, p2, tick + 1)));
        }
    }

    public static void gravitonMaulSlam(class_3218 world, class_2338 pos, double range, int tick) {
        class_2388 dust = new class_2388(class_2398.field_50248, world.method_8320(pos));
        double r = range / 3.0 * (double)(tick + 1);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)pos.method_46558(), (class_2394)dust, (double)r, (int)36, (int)4, (double)0.1, (double)1.0);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)pos.method_46558().method_1031(0.0, 1.0, 0.0), (class_2394)dust, (double)r, (int)36, (int)4, (double)0.1, (double)1.0, (double)1.0471975511965976);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)pos.method_46558().method_1031(0.0, 2.0, 0.0), (class_2394)dust, (double)r, (int)36, (int)4, (double)0.1, (double)1.0, (double)2.0943951023931953);
        SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_49784, (class_3419)class_3419.field_15248, (float)0.5f, (float)(0.4f + (float)tick * 0.2f));
        if (tick < 3) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(4, () -> ArcanaEffectUtils.gravitonMaulSlam(world, pos, range, tick + 1)));
        }
    }

    public static void gravitonMaulMaelstrom(class_3222 player, int tick) {
        double r;
        class_3218 world = player.method_51469();
        class_243 center = player.method_19538().method_1031(0.0, 0.1, 0.0);
        class_2390 dust = new class_2390(3752, 1.0f);
        class_2390 dust2 = new class_2390(1876, 1.5f);
        int effectiveTick = tick % 60;
        double or = 5.5 * (1.0 - (double)effectiveTick / 60.0);
        double inter = 0.4;
        int num = 5;
        double theta = 0.00185 * (double)effectiveTick * (double)effectiveTick;
        double dt = 0.3141592653589793;
        int times = 5;
        for (int i = 0; i < num && !((r = or - (double)i * inter) <= 0.0); ++i) {
            double dA = Math.PI * 2 / (double)times;
            for (int j = 0; j < times; ++j) {
                double angle = dA * (double)j + (theta + dt * (double)i);
                double x = r * Math.cos(angle) + center.field_1352;
                double z = r * Math.sin(angle) + center.field_1350;
                double y = center.field_1351;
                world.method_65096((class_2394)dust2, x, y, z, 1, 0.1, 0.1, 0.1, 0.01);
            }
        }
        if (tick % 80 == 0) {
            SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)player.method_24515(), (class_3414)class_3417.field_14802, (class_3419)class_3419.field_15248, (float)0.5f, (float)1.6f);
        }
        world.method_65096((class_2394)dust, center.field_1352, center.field_1351 + 0.15, center.field_1350, 60, 2.5, 0.2, 2.5, 0.01);
        world.method_65096((class_2394)class_2398.field_11214, center.field_1352, center.field_1351, center.field_1350, 15, 1.0, 0.5, 1.0, 1.0);
    }

    public static void arcaneNotesFinish(class_3222 player, ArcanaItem arcanaItem) {
        class_3218 world = player.method_51469();
        world.method_65096((class_2394)class_2398.field_11215, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 100, 0.4, 0.8, 0.4, 0.0);
        world.method_65096((class_2394)class_2398.field_11249, player.method_23317(), player.method_23318() + (double)player.method_17682() / 1.5, player.method_23321(), 100, 0.25, 0.6, 0.25, 0.3);
        Integer color = ArcanaRarity.getColor(arcanaItem.getRarity()).method_532();
        class_2390 dust = new class_2390(color == null ? 0xFFFFFF : color, 1.4f);
        world.method_65096((class_2394)dust, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 30, 0.4, 0.8, 0.4, 1.0);
    }

    public static void arcaneNotesAnim(class_3222 player, ArcanaItem arcanaItem, int usageTick) {
        class_3218 world = player.method_51469();
        world.method_65096((class_2394)class_2398.field_11215, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 3, 0.25, 0.6, 0.25, 0.0);
        world.method_14166(player, (class_2394)class_2398.field_11215, false, true, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 5, 0.25, 0.6, 0.25, 1.0);
        Integer color = ArcanaRarity.getColor(arcanaItem.getRarity()).method_532();
        class_2390 dust = new class_2390(color == null ? 0xFFFFFF : color, 0.5f);
        world.method_65096((class_2394)dust, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 4, 0.4, 0.8, 0.4, 1.0);
    }

    public static void enhancedForgingAnim(class_3218 world, class_2338 forgePos, class_1799 stack, double tickRaw, final double speedMod) {
        class_243 center = forgePos.method_46558();
        int tick = (int)tickRaw;
        if (tick < 350) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.enhancedForgingAnim(world, forgePos, stack, tickRaw + 1.0 * speedMod, speedMod)));
        }
        if (tick == 0) {
            final ItemDisplayElement item = new ItemDisplayElement(stack);
            item.setGlowColorOverride(16248151);
            item.setBrightness(new class_8104(15, 15));
            item.setScale((Vector3fc)new Vector3f(0.5f));
            ElementHolder holder = new ElementHolder(){
                int lifeTime;
                {
                    this.lifeTime = (int)(350.0 / speedMod);
                }

                protected void onTick() {
                    super.onTick();
                    if (this.lifeTime-- <= 0) {
                        this.setAttachment(null);
                        this.destroy();
                        return;
                    }
                    if (this.lifeTime < (int)(80.0 / speedMod)) {
                        item.setGlowing(true);
                    }
                    float rotateRate = (float)((double)0.1f * speedMod);
                    float scaleRate = (float)((double)0.01f * speedMod);
                    float translateRate = (float)((double)0.02f * speedMod);
                    for (VirtualElement element : this.getElements()) {
                        if (!(element instanceof ItemDisplayElement)) continue;
                        ItemDisplayElement elem = (ItemDisplayElement)element;
                        elem.setLeftRotation((Quaternionfc)elem.getLeftRotation().rotateY(rotateRate, new Quaternionf()));
                        if (elem.getScale().y() < 1.0f) {
                            elem.setScale((Vector3fc)elem.getScale().add(scaleRate, scaleRate, scaleRate, new Vector3f()));
                        }
                        if (!((double)elem.getTranslation().y() < 1.5)) continue;
                        elem.setTranslation((Vector3fc)elem.getTranslation().add(0.0f, translateRate, 0.0f, new Vector3f()));
                    }
                }
            };
            holder.addElement((VirtualElement)item);
            HolderAttachment attachment = ChunkAttachment.ofTicking((ElementHolder)holder, (class_3218)world, (class_2338)forgePos);
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_14891, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.8f);
        }
        class_2390 yellow = new class_2390(16248151, 0.7f);
        double starTicks = 75.0;
        float i = 0.0f;
        while ((double)i < Math.PI * 2) {
            double radius = (double)tick >= starTicks ? 1.15 : -7.82113805012E-4 * (double)tick * (double)tick + 0.0739918687092 * (double)tick;
            double height = (double)tick >= starTicks ? 2.5 : 2.5 * (double)tick / starTicks;
            float rotation = i - 0.01f * (float)tick;
            class_243 starPos = center.method_1019(new class_243(radius, 0.25 + height, 0.0).method_1024(rotation));
            world.method_65096((class_2394)class_2398.field_29644, starPos.field_1352, starPos.field_1351, starPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if ((double)tick >= starTicks && tick < 320) {
                world.method_65096((class_2394)yellow, starPos.field_1352, starPos.field_1351, starPos.field_1350, 1, 0.1, 0.1, 0.1, 0.0);
            }
            i += 0.7853982f;
        }
        class_243 itemCenter = new class_243(center.field_1352, center.field_1351 + 1.6, center.field_1350);
        if ((double)tick >= starTicks && tick < 300) {
            world.method_65096((class_2394)class_2398.field_48975, center.field_1352, center.field_1351 + 2.5, center.field_1350, 3, 0.2, 0.2, 0.2, 1.0);
            world.method_65096((class_2394)yellow, center.field_1352, center.field_1351 + 2.5, center.field_1350, 3, 0.8, 0.8, 0.8, 0.0);
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)50, (double)speedMod)) {
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_15045, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.8f);
        }
        if (tick >= 120 && tick <= 270 && tick % 19 == 0) {
            ArcanaEffectUtils.animatedLightningBolt((class_3218)world, (class_243)itemCenter, (class_243)MathUtils.randomSpherePoint((class_243)itemCenter, (double)4.0, (double)2.5), (int)8, (double)0.5, (class_2394)class_2398.field_29644, (int)8, (int)1, (double)0.0, (double)0.0, (boolean)false, (int)2, (int)30);
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_6880)class_3417.field_14896, (class_3419)class_3419.field_15245, (float)0.25f, (float)(1.75f + 0.25f * (float)Math.random()));
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)130, (double)speedMod)) {
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15245, (float)0.7f, (float)0.7f);
        }
        if (tick >= 200 && tick <= 280) {
            int count = (int)Math.min(4.0, (double)(tick - 200) * 0.05) + 1;
            world.method_65096((class_2394)class_2398.field_50249, itemCenter.field_1352, itemCenter.field_1351, itemCenter.field_1350, count, 0.2, 0.2, 0.2, 1.0);
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)280, (double)speedMod)) {
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_14905, (class_3419)class_3419.field_15245, (float)1.25f, (float)0.7f);
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)330, (double)speedMod)) {
            world.method_65096((class_2394)class_2398.field_17909, center.field_1352, center.field_1351 + 2.0, center.field_1350, 3, 0.1, 0.1, 0.1, 0.02);
        }
        if (tick % 2 == 0) {
            return;
        }
        if (tick < 300) {
            world.method_65096((class_2394)class_2398.field_11207, center.field_1352, center.field_1351 + 5.5, center.field_1350, 1, 1.5, 1.0, 1.5, 0.0);
        }
        double padScale = tick > 150 ? Math.min(1.0, (double)(350 - tick) / 50.0) : Math.min(1.0, (double)tick / 50.0);
        double L1 = 1.5 * padScale;
        double S1 = 0.5 * padScale;
        int I1 = tick % 4 == 1 ? 10 : 11;
        double D1 = 0.02;
        boolean C1 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L1, -0.4, 0.0), (class_243)center.method_1031(S1, -0.4, S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, L1), (class_243)center.method_1031(S1, -0.4, S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, L1), (class_243)center.method_1031(-S1, -0.4, S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L1, -0.4, 0.0), (class_243)center.method_1031(-S1, -0.4, S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L1, -0.4, 0.0), (class_243)center.method_1031(-S1, -0.4, -S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, -L1), (class_243)center.method_1031(S1, -0.4, -S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, -L1), (class_243)center.method_1031(-S1, -0.4, -S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L1, -0.4, 0.0), (class_243)center.method_1031(S1, -0.4, -S1), (class_2394)yellow, (int)I1, (int)1, (double)0.02, (double)1.0);
        class_2390 blue = new class_2390(7987452, 0.7f);
        double L2 = 1.2 * padScale;
        double S2 = 0.55 * padScale;
        int I2 = tick % 4 == 1 ? 10 : 11;
        double D2 = 0.02;
        boolean C2 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, L2), (class_243)center.method_1031(0.0, -0.4, S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, L2), (class_243)center.method_1031(S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, L2), (class_243)center.method_1031(0.0, -0.4, S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, L2), (class_243)center.method_1031(-S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, -L2), (class_243)center.method_1031(0.0, -0.4, -S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, -L2), (class_243)center.method_1031(S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, -L2), (class_243)center.method_1031(0.0, -0.4, -S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, -L2), (class_243)center.method_1031(-S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        class_2390 white = new class_2390(0xE6FFF6, 0.7f);
        double L3 = 1.8 * padScale;
        double S3 = 1.15 * padScale;
        int I3 = tick % 4 == 1 ? 30 : 31;
        double D3 = 0.02;
        boolean C3 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L3, -0.4, 0.0), (class_243)center.method_1031(-L3, -0.4, 0.0), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, L3), (class_243)center.method_1031(0.0, -0.4, -L3), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(S3, -0.4, S3), (class_243)center.method_1031(-S3, -0.4, -S3), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-S3, -0.4, S3), (class_243)center.method_1031(S3, -0.4, -S3), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
    }

    public static void arcanaCraftingAnim(class_3218 world, class_2338 forgePos, class_1799 stack, double tickRaw, final double speedMod) {
        class_243 center = forgePos.method_46558();
        int tick = (int)tickRaw;
        if (tick < 350) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.arcanaCraftingAnim(world, forgePos, stack, tickRaw + 1.0 * speedMod, speedMod)));
        }
        if (tick == 0) {
            final ItemDisplayElement item = new ItemDisplayElement(stack);
            item.setGlowColorOverride(9700566);
            item.setBrightness(new class_8104(15, 15));
            item.setScale((Vector3fc)new Vector3f(0.5f));
            ElementHolder holder = new ElementHolder(){
                int lifeTime;
                {
                    this.lifeTime = (int)(350.0 / speedMod);
                }

                protected void onTick() {
                    super.onTick();
                    if (this.lifeTime-- <= 0) {
                        this.setAttachment(null);
                        this.destroy();
                        return;
                    }
                    if (this.lifeTime < (int)(80.0 / speedMod)) {
                        item.setGlowing(true);
                    }
                    float rotateRate = (float)((double)0.1f * speedMod);
                    float scaleRate = (float)((double)0.0075f * speedMod);
                    float translateRate = (float)((double)0.02f * speedMod);
                    for (VirtualElement element : this.getElements()) {
                        if (!(element instanceof ItemDisplayElement)) continue;
                        ItemDisplayElement elem = (ItemDisplayElement)element;
                        elem.setLeftRotation((Quaternionfc)elem.getLeftRotation().rotateY(rotateRate, new Quaternionf()));
                        if (elem.getScale().y() < 1.0f) {
                            elem.setScale((Vector3fc)elem.getScale().add(scaleRate, scaleRate, scaleRate, new Vector3f()));
                        }
                        if (!((double)elem.getTranslation().y() < 1.5)) continue;
                        elem.setTranslation((Vector3fc)elem.getTranslation().add(0.0f, translateRate, 0.0f, new Vector3f()));
                    }
                }
            };
            holder.addElement((VirtualElement)item);
            HolderAttachment attachment = ChunkAttachment.ofTicking((ElementHolder)holder, (class_3218)world, (class_2338)forgePos);
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_14891, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.8f);
        }
        class_2390 purple = new class_2390(9700566, 0.7f);
        double starTicks = 75.0;
        float i = 0.0f;
        while ((double)i < Math.PI * 2) {
            double radius = (double)tick >= starTicks ? 1.15 : -7.82113805012E-4 * (double)tick * (double)tick + 0.0739918687092 * (double)tick;
            double height = (double)tick >= starTicks ? 2.5 : 2.5 * (double)tick / starTicks;
            float rotation = i - 0.01f * (float)tick;
            class_243 starPos = center.method_1019(new class_243(radius, 0.25 + height, 0.0).method_1024(rotation));
            world.method_65096((class_2394)class_2398.field_29644, starPos.field_1352, starPos.field_1351, starPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if ((double)tick >= starTicks && tick < 320) {
                world.method_65096((class_2394)purple, starPos.field_1352, starPos.field_1351, starPos.field_1350, 1, 0.1, 0.1, 0.1, 0.0);
            }
            i += 0.7853982f;
        }
        class_243 itemCenter = new class_243(center.field_1352, center.field_1351 + 1.6, center.field_1350);
        if ((double)tick >= starTicks && tick < 300) {
            world.method_65096((class_2394)class_2398.field_11215, center.field_1352, center.field_1351 + 2.5, center.field_1350, 3, 0.2, 0.2, 0.2, 1.0);
            world.method_65096((class_2394)purple, center.field_1352, center.field_1351 + 2.5, center.field_1350, 3, 0.8, 0.8, 0.8, 0.0);
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)50, (double)speedMod)) {
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_15045, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.8f);
        }
        if (tick >= 120 && tick <= 270 && tick % 19 == 0) {
            ArcanaEffectUtils.animatedLightningBolt((class_3218)world, (class_243)itemCenter, (class_243)MathUtils.randomSpherePoint((class_243)itemCenter, (double)4.0, (double)2.5), (int)8, (double)0.5, (class_2394)class_2398.field_29644, (int)8, (int)1, (double)0.0, (double)0.0, (boolean)false, (int)2, (int)30);
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_6880)class_3417.field_14896, (class_3419)class_3419.field_15245, (float)0.25f, (float)(1.75f + 0.25f * (float)Math.random()));
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)130, (double)speedMod)) {
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15245, (float)0.7f, (float)0.7f);
        }
        if (tick >= 200 && tick <= 280) {
            int count = (int)Math.min(4.0, (double)(tick - 200) * 0.05) + 1;
            world.method_65096((class_2394)class_2398.field_50249, itemCenter.field_1352, itemCenter.field_1351, itemCenter.field_1350, count, 0.2, 0.2, 0.2, 1.0);
            world.method_65096((class_2394)class_2398.field_11249, itemCenter.field_1352, itemCenter.field_1351, itemCenter.field_1350, count, 0.2, 0.5, 0.2, 0.05);
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)280, (double)speedMod)) {
            SoundUtils.playSound((class_1937)world, (class_2338)forgePos, (class_3414)class_3417.field_14905, (class_3419)class_3419.field_15245, (float)1.25f, (float)0.7f);
        }
        if (tick == ArcanaEffectUtils.adjustTime((int)330, (double)speedMod)) {
            world.method_65096((class_2394)class_2398.field_17909, center.field_1352, center.field_1351 + 2.0, center.field_1350, 3, 0.1, 0.1, 0.1, 0.02);
            world.method_65096((class_2394)class_2398.field_11249, itemCenter.field_1352, itemCenter.field_1351, itemCenter.field_1350, 100, 0.2, 0.5, 0.2, 0.1);
        }
        if (tick % 2 == 0) {
            return;
        }
        if (tick < 300) {
            world.method_65096((class_2394)class_2398.field_11207, center.field_1352, center.field_1351 + 5.5, center.field_1350, 1, 1.5, 1.0, 1.5, 0.0);
        }
        double padScale = tick > 150 ? Math.min(1.0, (double)(350 - tick) / 50.0) : Math.min(1.0, (double)tick / 50.0);
        double L1 = 1.5 * padScale;
        double S1 = 0.5 * padScale;
        int I1 = tick % 4 == 1 ? 10 : 11;
        double D1 = 0.02;
        boolean C1 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L1, -0.4, 0.0), (class_243)center.method_1031(S1, -0.4, S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, L1), (class_243)center.method_1031(S1, -0.4, S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, L1), (class_243)center.method_1031(-S1, -0.4, S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L1, -0.4, 0.0), (class_243)center.method_1031(-S1, -0.4, S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L1, -0.4, 0.0), (class_243)center.method_1031(-S1, -0.4, -S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, -L1), (class_243)center.method_1031(S1, -0.4, -S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, -L1), (class_243)center.method_1031(-S1, -0.4, -S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L1, -0.4, 0.0), (class_243)center.method_1031(S1, -0.4, -S1), (class_2394)purple, (int)I1, (int)1, (double)0.02, (double)1.0);
        class_2390 blue = new class_2390(7987452, 0.7f);
        double L2 = 1.2 * padScale;
        double S2 = 0.55 * padScale;
        int I2 = tick % 4 == 1 ? 10 : 11;
        double D2 = 0.02;
        boolean C2 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, L2), (class_243)center.method_1031(0.0, -0.4, S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, L2), (class_243)center.method_1031(S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, L2), (class_243)center.method_1031(0.0, -0.4, S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, L2), (class_243)center.method_1031(-S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, -L2), (class_243)center.method_1031(0.0, -0.4, -S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L2, -0.4, -L2), (class_243)center.method_1031(S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, -L2), (class_243)center.method_1031(0.0, -0.4, -S2), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-L2, -0.4, -L2), (class_243)center.method_1031(-S2, -0.4, 0.0), (class_2394)blue, (int)I2, (int)1, (double)0.02, (double)1.0);
        class_2390 white = new class_2390(14277375, 0.7f);
        double L3 = 1.8 * padScale;
        double S3 = 1.15 * padScale;
        int I3 = tick % 4 == 1 ? 30 : 31;
        double D3 = 0.02;
        boolean C3 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(L3, -0.4, 0.0), (class_243)center.method_1031(-L3, -0.4, 0.0), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, L3), (class_243)center.method_1031(0.0, -0.4, -L3), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(S3, -0.4, S3), (class_243)center.method_1031(-S3, -0.4, -S3), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-S3, -0.4, S3), (class_243)center.method_1031(S3, -0.4, -S3), (class_2394)white, (int)I3, (int)1, (double)0.02, (double)1.0);
    }

    public static void ensnaredEffect(class_1309 living, int amplifier, int tick) {
        class_1937 class_19372;
        if (!living.method_5805() || living.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT) == null || !((class_19372 = living.method_37908()) instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        double eHeight = living.method_17682();
        double eWidth = living.method_17681();
        double circleHeight = eHeight * 0.6;
        double circleRadius = eWidth / 1.6;
        class_243 circleCenter = living.method_19538().method_1031(0.0, eHeight / 1.8, 0.0);
        class_2390 purple = new class_2390(10551526, 0.7f);
        int intervals = (int)(15.0 * Math.sqrt(circleRadius * circleRadius + circleHeight * circleHeight));
        double dA = Math.PI * 2 / (double)intervals;
        for (int i = 0; i < intervals; ++i) {
            double angle = dA * (double)i + (double)tick / Math.PI;
            double xOff = circleRadius * Math.cos(angle);
            double zOff = circleRadius * Math.sin(angle);
            double yOff = (xOff + zOff) * 0.3536 * circleHeight / circleRadius;
            world.method_65096((class_2394)purple, xOff + circleCenter.field_1352, yOff + circleCenter.field_1351, zOff + circleCenter.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            world.method_65096((class_2394)purple, xOff + circleCenter.field_1352, -yOff + circleCenter.field_1351, zOff + circleCenter.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (amplifier > 0 && tick % 5 == 0) {
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)circleCenter, (class_2394)class_2398.field_11249, (double)(circleRadius * 1.2), (int)(intervals / 2), (int)1, (double)0.0, (double)0.0);
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)circleCenter.method_1031(0.0, -circleHeight, 0.0), (class_2394)class_2398.field_11249, (double)(circleRadius * 1.2), (int)(intervals / 2), (int)1, (double)0.0, (double)0.0);
        }
        BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.ensnaredEffect(living, amplifier, tick < 40 ? tick + 1 : 0)));
    }

    public static void aequalisTransmuteAnim(class_3218 world, class_243 center, double rawTick, class_241 rotation, final double speedMod, class_1799 input, class_1799 output, class_1799 reagent1, class_1799 reagent2, class_1799 aequalis) {
        class_2390 blue = new class_2390(1232127, 0.7f);
        class_2390 blueSmall = new class_2390(1232127, 0.4f);
        class_2390 purple = new class_2390(10551526, 0.5f);
        class_2390 pink = new class_2390(13828326, 0.8f);
        int tick = (int)rawTick;
        int intBonus = tick % 3;
        int n = output == null || output.method_7960() ? 3 : 4;
        List itemCenters = ArcanaEffectUtils.getCirclePoints((class_243)center, (double)(1.75 + 0.5 * Math.sin(-Math.PI * (double)tick / 60.0) / 30.0), (int)n, (double)((double)(tick * 6) * Math.PI / 500.0));
        if (tick == 0) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14891, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.5f);
            final ItemDisplayElement aequalisElem = new ItemDisplayElement(aequalis);
            aequalisElem.setGlowColorOverride(51450);
            aequalisElem.setBrightness(new class_8104(15, 15));
            aequalisElem.setScale((Vector3fc)new Vector3f(0.5f));
            aequalisElem.setTranslation((Vector3fc)center.method_1020(class_2338.method_49638((class_2374)center).method_46558()).method_46409());
            ItemDisplayElement inputElem = new ItemDisplayElement(input);
            inputElem.setGlowColorOverride(51450);
            inputElem.setBrightness(new class_8104(15, 15));
            inputElem.setScale((Vector3fc)new Vector3f(0.0f));
            ItemDisplayElement reagent1Elem = new ItemDisplayElement(reagent1);
            reagent1Elem.setGlowColorOverride(51450);
            reagent1Elem.setBrightness(new class_8104(15, 15));
            reagent1Elem.setScale((Vector3fc)new Vector3f(0.0f));
            ItemDisplayElement reagent2Elem = new ItemDisplayElement(reagent2);
            reagent2Elem.setGlowColorOverride(51450);
            reagent2Elem.setBrightness(new class_8104(15, 15));
            reagent2Elem.setScale((Vector3fc)new Vector3f(0.0f));
            ElementHolder aequalisHolder = new ElementHolder(){
                int lifeTime;
                {
                    this.lifeTime = (int)(500.0 / speedMod);
                }

                protected void onTick() {
                    super.onTick();
                    if (this.lifeTime-- <= 0) {
                        this.setAttachment(null);
                        this.destroy();
                        return;
                    }
                    if (this.lifeTime < (int)(80.0 / speedMod)) {
                        aequalisElem.setGlowing(true);
                    }
                    float rotateRate = (float)((double)0.1f * speedMod);
                    float scaleRate = (float)((double)0.0075f * speedMod);
                    for (VirtualElement element : this.getElements()) {
                        if (!(element instanceof ItemDisplayElement)) continue;
                        ItemDisplayElement elem = (ItemDisplayElement)element;
                        elem.setLeftRotation((Quaternionfc)elem.getLeftRotation().rotateY(rotateRate, new Quaternionf()));
                        if (!(elem.getScale().y() < 1.0f)) continue;
                        elem.setScale((Vector3fc)elem.getScale().add(scaleRate, scaleRate, scaleRate, new Vector3f()));
                    }
                }
            };
            aequalisHolder.addElement((VirtualElement)aequalisElem);
            ChunkAttachment.ofTicking((ElementHolder)aequalisHolder, (class_3218)world, (class_2338)class_2338.method_49638((class_2374)center));
            ElementHolder inputHolder = ArcanaEffectUtils.makeAequalisItemHolder(inputElem, center, n, 0, speedMod);
            ElementHolder reagent1Holder = ArcanaEffectUtils.makeAequalisItemHolder(reagent1Elem, center, n, 1, speedMod);
            ElementHolder reagent2Holder = ArcanaEffectUtils.makeAequalisItemHolder(reagent2Elem, center, n, 2, speedMod);
            inputHolder.addElement((VirtualElement)inputElem);
            ChunkAttachment.ofTicking((ElementHolder)inputHolder, (class_3218)world, (class_2338)class_2338.method_49638((class_2374)center));
            reagent1Holder.addElement((VirtualElement)reagent1Elem);
            ChunkAttachment.ofTicking((ElementHolder)reagent1Holder, (class_3218)world, (class_2338)class_2338.method_49638((class_2374)center));
            reagent2Holder.addElement((VirtualElement)reagent2Elem);
            ChunkAttachment.ofTicking((ElementHolder)reagent2Holder, (class_3218)world, (class_2338)class_2338.method_49638((class_2374)center));
            if (output != null && !output.method_7960()) {
                ItemDisplayElement outputElem = new ItemDisplayElement(output);
                outputElem.setGlowColorOverride(51450);
                outputElem.setBrightness(new class_8104(15, 15));
                outputElem.setScale((Vector3fc)new Vector3f(0.0f));
                ElementHolder outputHolder = ArcanaEffectUtils.makeAequalisItemHolder(outputElem, center, n, 3, speedMod);
                outputHolder.addElement((VirtualElement)outputElem);
                ChunkAttachment.ofTicking((ElementHolder)outputHolder, (class_3218)world, (class_2338)class_2338.method_49638((class_2374)center));
            }
        }
        double innerSize = tick < 50 ? (double)tick / 100.0 : 0.2 * Math.sin(-Math.PI * (double)tick / 50.0 - 0.25) + 0.45;
        List innerPairs = ArcanaEffectUtils.getIcosahedronPairs(ArcanaEffectUtils.getIcosahedronPoints().stream().map(point -> point.method_31033(-0.55357f).method_1024((float)(rawTick * 2.0 * Math.PI / 500.0)).method_1021(innerSize).method_1019(center)).toList());
        double outerSize = tick < 75 ? (double)(tick * 2) / 75.0 : (tick > 450 ? 15.0 - 0.03 * (double)tick : 0.25 * Math.sin(-Math.PI * (double)tick / 75.0 - 1.5707963267948966) + 1.75);
        List outerPairs = ArcanaEffectUtils.getIcosahedronPairs(ArcanaEffectUtils.getIcosahedronPoints().stream().map(point -> point.method_31033(-0.55357f).method_1024((float)(rawTick * 2.0 * Math.PI / 500.0)).method_1021(outerSize).method_1019(center)).toList());
        for (class_3545 pair : innerPairs) {
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)((class_243)pair.method_15441()), (class_243)((class_243)pair.method_15442()), (class_2394)blueSmall, (int)(5 + intBonus), (int)1, (double)0.0, (double)0.0, (double)1.0);
        }
        if (tick < 490) {
            for (class_3545 pair : outerPairs) {
                ArcanaEffectUtils.line((class_3218)world, null, (class_243)((class_243)pair.method_15441()), (class_243)((class_243)pair.method_15442()), (class_2394)pink, (int)(10 + intBonus), (int)1, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        if (tick > 50) {
            int i = 0;
            double radius = tick < 450 ? 0.5 : 5.0 - 0.01 * (double)tick;
            for (class_243 itemCenter : itemCenters) {
                List<class_243> circlePoints1 = ArcanaEffectUtils.getCirclePoints((class_243)new class_243(0.0, 0.0, 0.0), (double)radius, (int)24, (double)(Math.PI * (double)tick / 30.0)).stream().map(point -> point.method_1037(1.5707964f).method_1024((float)((double)(tick * 6) * Math.PI / 500.0)).method_1019(itemCenter)).toList();
                List<class_243> circlePoints2 = ArcanaEffectUtils.getCirclePoints((class_243)new class_243(0.0, 0.0, 0.0), (double)radius, (int)24, (double)(Math.PI * (double)tick / 30.0)).stream().map(point -> point.method_1037(1.5707964f).method_1024((float)((double)(-tick * 6) * Math.PI / 500.0)).method_1019(itemCenter)).toList();
                double itemDY = 0.5 * Math.sin(Math.PI * (double)tick / 100.0 + (double)i * Math.PI * 2.0 / (double)n);
                for (class_243 circlePoint : circlePoints1) {
                    world.method_65096((class_2394)purple, circlePoint.field_1352, circlePoint.field_1351 + itemDY, circlePoint.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (class_243 circlePoint : circlePoints2) {
                    world.method_65096((class_2394)purple, circlePoint.field_1352, circlePoint.field_1351 + itemDY, circlePoint.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (tick > 120 && tick < 450) {
                    world.method_65096((class_2394)class_2398.field_11249, itemCenter.field_1352, itemCenter.field_1351 + itemDY + 0.1, itemCenter.field_1350, 3, 0.15, 0.15, 0.15, 0.0);
                }
                ++i;
            }
        }
        if (tick > 60 && tick < 450) {
            if (Math.random() < 0.1) {
                ArcanaEffectUtils.animatedLightningBolt((class_3218)world, (class_243)center, (class_243)((class_243)((class_3545)outerPairs.get((int)(Math.random() * (double)outerPairs.size()))).method_15441()), (int)12, (double)0.5, (class_2394)class_2398.field_29644, (int)16, (int)1, (double)0.0, (double)0.0, (boolean)false, (int)0, (int)15);
            }
            if (tick % 6 == 0) {
                world.method_65096((class_2394)class_2398.field_11207, center.field_1352, center.field_1351, center.field_1350, 1, 1.6, 1.6, 1.6, 0.0);
            }
        }
        if (tick % 70 == 20) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_38366, (class_3419)class_3419.field_15245, (float)1.0f, (float)((float)Math.random() * 0.5f + 0.7f));
        }
        if (tick % 100 == 35) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14802, (class_3419)class_3419.field_15245, (float)0.5f, (float)((float)Math.random() * 0.4f + 1.2f));
        }
        if (tick < 500) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.aequalisTransmuteAnim(world, center, rawTick + 1.0 * speedMod, rotation, speedMod, input, output, reagent1, reagent2, aequalis)));
        } else {
            world.method_65096((class_2394)class_2398.field_17909, center.field_1352, center.field_1351, center.field_1350, 5, 0.3, 0.3, 0.3, 0.0);
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_38365, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.8f);
        }
    }

    private static ElementHolder makeAequalisItemHolder(final ItemDisplayElement element, final class_243 center, final int n, final int i, final double speedMod) {
        return new ElementHolder(){
            int lifeTime;
            {
                this.lifeTime = (int)(500.0 / speedMod);
            }

            protected void onTick() {
                super.onTick();
                if (this.lifeTime-- <= 0) {
                    this.setAttachment(null);
                    this.destroy();
                    return;
                }
                if (this.lifeTime < (int)(80.0 / speedMod)) {
                    element.setGlowing(true);
                }
                float rotateRate = (float)((double)0.1f * speedMod);
                float scaleRate = (float)((double)0.0075f * speedMod);
                for (VirtualElement element2 : this.getElements()) {
                    if (!(element2 instanceof ItemDisplayElement)) continue;
                    ItemDisplayElement elem = (ItemDisplayElement)element2;
                    elem.setLeftRotation((Quaternionfc)elem.getLeftRotation().rotateY(rotateRate, new Quaternionf()));
                    if (500 - this.lifeTime > (int)(450.0 / speedMod) && elem.getScale().y() > 0.0f) {
                        elem.setScale((Vector3fc)elem.getScale().add(-scaleRate, -scaleRate, -scaleRate, new Vector3f()));
                    } else if (500 - this.lifeTime > (int)(50.0 / speedMod) && (double)elem.getScale().y() < 0.5) {
                        elem.setScale((Vector3fc)elem.getScale().add(scaleRate, scaleRate, scaleRate, new Vector3f()));
                    }
                    double itemDY = 0.5 * Math.sin(Math.PI * (double)(500 - this.lifeTime) / 100.0 + (double)i * Math.PI * 2.0 / (double)n);
                    elem.setTranslation((Vector3fc)((class_243)ParticleEffectUtils.getCirclePoints((class_243)center, (double)(1.75 + 0.5 * Math.sin(-Math.PI * (double)(500 - this.lifeTime) / 60.0) / 30.0), (int)n, (double)((double)((500 - this.lifeTime) * 6) * Math.PI / 500.0)).get(i)).method_1020(center).method_1031(0.0, itemDY, 0.0).method_1019(center.method_1020(class_2338.method_49638((class_2374)center).method_46558())).method_46409());
                }
            }
        };
    }

    public static void transmutationAltarAnim(class_3218 world, class_243 center, double rawTick, class_2350 direction, double speedMod) {
        class_2390 blue = new class_2390(1232127, 0.7f);
        class_2390 purple = new class_2390(10551526, 0.7f);
        class_2390 pink = new class_2390(13828326, 0.7f);
        class_243 effectCenter = center.method_1031(0.0, 0.6, 0.0);
        int tick = (int)rawTick;
        double theta = Math.PI * (double)tick / 30.0;
        int intBonus = tick % 3;
        int itemCI = 20;
        double itemCR = 0.7;
        double itemOutset = 3.0;
        int nodeCI = 8;
        double nodeCR = 0.25;
        double nodeOutset = 2.2;
        double outerRadius = 4.4;
        double innerRadius = 4.0;
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)effectCenter, (class_2394)pink, (double)(innerRadius * class_3532.method_15350((double)((double)tick / 60.0), (double)0.0, (double)1.0)), (int)125, (int)1, (double)0.0, (double)0.0, (double)theta);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)effectCenter, (class_2394)pink, (double)(outerRadius * class_3532.method_15350((double)((double)tick / 60.0), (double)0.0, (double)1.0)), (int)125, (int)1, (double)0.0, (double)0.0, (double)theta);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)effectCenter, (class_2394)purple, (double)(itemCR * class_3532.method_15350((double)((double)tick / 20.0), (double)0.0, (double)1.0)), (int)itemCI, (int)1, (double)0.0, (double)0.0, (double)theta);
        if (tick > 260) {
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)effectCenter, (class_2394)class_2398.field_11249, (double)((outerRadius + innerRadius) / 2.0), (int)50, (int)1, (double)0.1, (double)0.0, (double)theta);
        }
        float i = 0.0f;
        while ((double)i < Math.PI * 2) {
            if (tick >= 70) {
                class_243 itemCenter = effectCenter.method_1019(new class_243(itemOutset, 0.0, 0.0).method_1024(i));
                ArcanaEffectUtils.circle((class_3218)world, null, (class_243)itemCenter, (class_2394)purple, (double)(itemCR * class_3532.method_15350((double)(((double)tick - 70.0) / 40.0), (double)0.0, (double)1.0)), (int)itemCI, (int)1, (double)0.0, (double)0.0, (double)theta);
                if (tick >= 90) {
                    class_243 centerLine1P1 = effectCenter.method_1019(new class_243((itemCR + 0.1) * 0.71, 0.0, itemCR * 0.71).method_1024(i));
                    class_243 centerLine1P2 = effectCenter.method_1019(new class_243(nodeOutset - nodeCR * 0.71, 0.0, nodeOutset - nodeCR * 0.71).method_1024(i));
                    ArcanaEffectUtils.line((class_3218)world, null, (class_243)centerLine1P1, (class_243)centerLine1P2, (class_2394)blue, (int)(15 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 90.0) / 50.0), (double)0.0, (double)1.0));
                    class_243 centerLine2P1 = effectCenter.method_1019(new class_243(itemCR + 0.1, 0.0, 0.0).method_1024(i));
                    class_243 centerLine2P2 = effectCenter.method_1019(new class_243(itemOutset - itemCR, 0.0, 0.0).method_1024(i));
                    ArcanaEffectUtils.line((class_3218)world, null, (class_243)centerLine2P1, (class_243)centerLine2P2, (class_2394)blue, (int)(10 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 90.0) / 30.0), (double)0.0, (double)1.0));
                    if (tick >= 110) {
                        class_243 crossLine1aP1 = effectCenter.method_1019(new class_243(itemOutset - (itemCR * 0.71 + 0.1), 0.0, itemCR * 0.71 + 0.1).method_1024(i));
                        class_243 crossLine1bP1 = effectCenter.method_1019(new class_243(itemCR * 0.71, 0.0, itemOutset - itemCR * 0.71).method_1024(i));
                        class_243 crossLine1P2 = effectCenter.method_1019(new class_243(itemOutset * 0.5, 0.0, itemOutset * 0.5).method_1024(i));
                        ArcanaEffectUtils.line((class_3218)world, null, (class_243)crossLine1aP1, (class_243)crossLine1P2, (class_2394)blue, (int)(7 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 110.0) / 50.0), (double)0.0, (double)1.0));
                        ArcanaEffectUtils.line((class_3218)world, null, (class_243)crossLine1bP1, (class_243)crossLine1P2, (class_2394)blue, (int)(7 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 110.0) / 50.0), (double)0.0, (double)1.0));
                        class_243 crossLine2P1 = effectCenter.method_1019(new class_243(itemOutset, 0.0, itemCR + 0.1).method_1024(i));
                        class_243 crossLine2P2 = effectCenter.method_1019(new class_243(nodeOutset + nodeCR * 0.71, 0.0, nodeOutset - nodeCR * 0.71).method_1024(i));
                        ArcanaEffectUtils.line((class_3218)world, null, (class_243)crossLine2P1, (class_243)crossLine2P2, (class_2394)blue, (int)(7 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 110.0) / 40.0), (double)0.0, (double)1.0));
                        class_243 crossLine3P1 = effectCenter.method_1019(new class_243(itemCR + 0.1, 0.0, itemOutset).method_1024(i));
                        class_243 crossLine3P2 = effectCenter.method_1019(new class_243(nodeOutset - nodeCR * 0.71, 0.0, nodeOutset + nodeCR * 0.71).method_1024(i));
                        ArcanaEffectUtils.line((class_3218)world, null, (class_243)crossLine3P1, (class_243)crossLine3P2, (class_2394)blue, (int)(7 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 110.0) / 40.0), (double)0.0, (double)1.0));
                        if (tick >= 150) {
                            class_243 nodeCenter = effectCenter.method_1019(new class_243(nodeOutset, 0.0, nodeOutset).method_1024(i));
                            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)nodeCenter, (class_2394)purple, (double)(nodeCR * class_3532.method_15350((double)(((double)tick - 150.0) / 20.0), (double)0.0, (double)1.0)), (int)nodeCI, (int)1, (double)0.0, (double)0.0, (double)theta);
                            class_243 outerLine1P1 = effectCenter.method_1019(new class_243(itemOutset + itemCR + 0.1, 0.0, 0.0).method_1024(i));
                            class_243 outerLine1P2 = effectCenter.method_1019(new class_243(outerRadius - 0.02, 0.0, 0.0).method_1024(i));
                            ArcanaEffectUtils.line((class_3218)world, null, (class_243)outerLine1P1, (class_243)outerLine1P2, (class_2394)blue, (int)(3 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 150.0) / 40.0), (double)0.0, (double)1.0));
                            double outerIZ = 0.5 * (-itemOutset + Math.sqrt(2.0 * outerRadius * outerRadius - itemOutset * itemOutset));
                            double outerIX = outerIZ + itemOutset;
                            class_243 outerLine2P1 = effectCenter.method_1019(new class_243(itemOutset + itemCR * 0.71 + 0.1, 0.0, itemCR * 0.71 + 0.1).method_1024(i));
                            class_243 outerLine2P2 = effectCenter.method_1019(new class_243(outerIX - 0.02, 0.0, outerIZ - 0.02).method_1024(i));
                            ArcanaEffectUtils.line((class_3218)world, null, (class_243)outerLine2P1, (class_243)outerLine2P2, (class_2394)blue, (int)(5 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 150.0) / 40.0), (double)0.0, (double)1.0));
                            class_243 outerLine3P1 = effectCenter.method_1019(new class_243(itemOutset + itemCR * 0.71 + 0.1, 0.0, -(itemCR * 0.71 + 0.1)).method_1024(i));
                            class_243 outerLine3P2 = effectCenter.method_1019(new class_243(outerIX - 0.02, 0.0, -(outerIZ - 0.02)).method_1024(i));
                            ArcanaEffectUtils.line((class_3218)world, null, (class_243)outerLine3P1, (class_243)outerLine3P2, (class_2394)blue, (int)(5 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 150.0) / 40.0), (double)0.0, (double)1.0));
                            if (tick >= 160) {
                                class_243 outerLine4P1 = effectCenter.method_1019(new class_243(nodeOutset + nodeCR * 0.71 + 0.1, 0.0, nodeOutset + nodeCR * 0.71 + 0.1).method_1024(i));
                                class_243 outerLine4P2 = effectCenter.method_1019(new class_243(innerRadius * 0.71 - 0.02, 0.0, innerRadius * 0.71 - 0.02).method_1024(i));
                                ArcanaEffectUtils.line((class_3218)world, null, (class_243)outerLine4P1, (class_243)outerLine4P2, (class_2394)blue, (int)(3 + intBonus), (int)1, (double)0.0, (double)0.0, (double)class_3532.method_15350((double)(((double)tick - 150.0) / 30.0), (double)0.0, (double)1.0));
                                if (tick >= 450) {
                                    class_243 itemSpot = effectCenter.method_1019(new class_243(itemOutset, 0.0, 0.0).method_1024(i));
                                    world.method_65096((class_2394)class_2398.field_11249, itemSpot.field_1352, itemSpot.field_1351, itemSpot.field_1350, 1, 0.15, 0.15, 0.15, 0.0);
                                    world.method_65096((class_2394)class_2398.field_29644, itemSpot.field_1352, itemSpot.field_1351, itemSpot.field_1350, 3, 0.25, 0.25, 0.25, 0.0);
                                    world.method_65096((class_2394)class_2398.field_11207, itemSpot.field_1352, itemSpot.field_1351, itemSpot.field_1350, 1, 0.25, 0.25, 0.25, 0.02);
                                    if (tick == 500) {
                                        world.method_65096((class_2394)class_2398.field_17909, itemSpot.field_1352, itemSpot.field_1351 + 0.25, itemSpot.field_1350, 3, 0.25, 0.25, 0.25, 0.0);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            i += 1.5707964f;
        }
        if (tick > 180) {
            double dA = 0.12566370614359174;
            double angle = dA * (double)tick;
            double x = (outerRadius + innerRadius) / 2.0 * Math.cos(angle) + effectCenter.field_1352;
            double z = (outerRadius + innerRadius) / 2.0 * Math.sin(angle) + effectCenter.field_1350;
            double y = tick > 280 ? effectCenter.field_1351 + 1.0 : effectCenter.field_1351;
            world.method_65096((class_2394)class_2398.field_11249, x, y, z, 12, 0.25, 0.25, 0.25, 0.0);
        }
        if (tick == 0) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14891, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.5f);
        }
        if (tick % 70 == 20) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_38366, (class_3419)class_3419.field_15245, (float)1.0f, (float)((float)Math.random() * 0.5f + 0.7f));
        }
        if (tick % 100 == 35) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14802, (class_3419)class_3419.field_15245, (float)0.5f, (float)((float)Math.random() * 0.4f + 1.2f));
        }
        if (tick < 500) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.transmutationAltarAnim(world, center, rawTick + 1.0 * speedMod, direction, speedMod)));
        }
    }

    public static void craftForge(class_3218 world, class_2338 pos, int tick) {
        class_243 center = pos.method_46558();
        if (tick == 100) {
            world.method_65096((class_2394)class_2398.field_17909, center.field_1352, center.field_1351, center.field_1350, 3, 0.4, 0.4, 0.4, 0.0);
            world.method_65096((class_2394)class_2398.field_29644, center.field_1352, center.field_1351, center.field_1350, 25, 0.6, 0.8, 0.6, 0.0);
            SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_15168, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.8f);
        } else {
            world.method_65096((class_2394)class_2398.field_11207, center.field_1352, center.field_1351, center.field_1350, 1, 0.6, 0.8, 0.6, 0.0);
            world.method_65096((class_2394)class_2398.field_11249, center.field_1352, center.field_1351, center.field_1350, 1, 0.6, 0.8, 0.6, 0.0);
        }
    }

    public static void craftTome(class_3218 world, class_2338 pos, int tick) {
        class_243 center = pos.method_46558();
        if (tick == 100) {
            world.method_65096((class_2394)class_2398.field_17909, center.field_1352, center.field_1351, center.field_1350, 3, 0.4, 0.4, 0.4, 0.0);
            world.method_65096((class_2394)class_2398.field_29644, center.field_1352, center.field_1351, center.field_1350, 25, 0.6, 0.8, 0.6, 0.0);
            SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_15168, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.8f);
        } else {
            world.method_65096((class_2394)class_2398.field_11215, center.field_1352, center.field_1351 + 1.0, center.field_1350, 10, 0.3, 0.3, 0.3, 1.0);
            world.method_65096((class_2394)class_2398.field_11249, center.field_1352, center.field_1351, center.field_1350, 2, 0.6, 0.8, 0.6, 0.0);
        }
    }

    public static void stormcallerAltarAnim(class_3218 world, class_243 center, int tick) {
        double y;
        double z;
        double r;
        double angle;
        double r2;
        int i;
        double or = 5.0 * (1.0 - (double)tick / 100.0);
        double inter = 0.15;
        int num = 5;
        double theta = 0.001885 * (double)tick * (double)tick;
        double dt = 0.3141592653589793;
        int times = 3;
        for (i = 0; i < num && !((r2 = or - (double)i * inter) <= 0.0); ++i) {
            double dA = Math.PI * 2 / (double)times;
            for (int j = 0; j < times; ++j) {
                double angle2 = dA * (double)j + (theta + dt * (double)i);
                double x = r2 * Math.cos(angle2) + center.field_1352;
                double z2 = r2 * Math.sin(angle2) + center.field_1350;
                double y2 = center.field_1351 + 0.6;
                world.method_65096((class_2394)class_2398.field_11244, x, y2, z2, 3, 0.0, 0.0, 0.0, 0.01);
                world.method_65096((class_2394)class_2398.field_18306, x, y2, z2, 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
        for (i = 0; i < 2; ++i) {
            angle = Math.random() * Math.PI * 2.0;
            r = Math.random() * 1.0 + 3.0;
            double x = r * Math.cos(angle) + center.field_1352;
            z = r * Math.sin(angle) + center.field_1350;
            y = center.field_1351 + 4.5;
            world.method_65096((class_2394)class_2398.field_17431, x, y, z, 2, 0.2, 0.2, 0.2, 0.002);
            world.method_65096((class_2394)class_2398.field_18306, x, y, z, 5, 0.3, 0.3, 0.3, 1.0);
        }
        for (i = 0; i < 5; ++i) {
            angle = Math.random() * Math.PI * 2.0;
            r = Math.random() * 1.0 + 3.0;
            double x = r * Math.cos(angle) + center.field_1352;
            z = r * Math.sin(angle) + center.field_1350;
            y = center.field_1351 + 4.5;
            world.method_65096((class_2394)class_2398.field_11204, x, y, z, 4, 0.2, 0.2, 0.2, 0.002);
            world.method_65096((class_2394)class_2398.field_18306, x, y, z, 3, 0.3, 0.3, 0.3, 1.0);
        }
        if (tick < 100) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.stormcallerAltarAnim(world, center, tick + 1)));
        } else {
            class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
            lightning.method_33574(center);
            world.method_8649((class_1297)lightning);
        }
    }

    public static void celestialAltarAnim(class_3218 world, class_243 center, int tick, class_2350 direction) {
        if (tick == 0) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.5f);
        }
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        double theta = 0.06283185307179587 * (double)tick;
        int points = 100;
        class_2390 black = new class_2390(0, 2.0f);
        double blackDelta = tick < 100 || tick > 400 ? 0.05 : 0.4;
        int blackCount = tick < 100 || tick > 400 ? 1 : 4;
        for (int i = 0; i < points; ++i) {
            double y = (double)i / (double)(points - 1);
            double r = Math.sqrt(1.0 - y * y);
            double t = phi * (double)i + theta;
            double x = Math.cos(t) * r;
            double z = Math.sin(t) * r;
            if (y > (double)tick / 100.0 || tick > 400 && y > 1.0 - (double)(tick - 400) / 100.0) continue;
            class_243 point = new class_243(x, y, z);
            point = point.method_1021(5.0).method_1031(center.field_1352, center.field_1351, center.field_1350);
            world.method_65096((class_2394)black, point.field_1352, point.field_1351, point.field_1350, blackCount, blackDelta, blackDelta, blackDelta, 0.0);
        }
        class_2390 sun = new class_2390(13739008, 2.0f);
        class_2390 moon = new class_2390(1470704, 2.0f);
        if (tick > 100) {
            class_243 rotVec;
            if (tick % 3 == 0) {
                world.method_65096((class_2394)class_2398.field_11207, center.field_1352, center.field_1351 + 2.5, center.field_1350, 8, 3.0, 1.5, 3.0, 0.0);
            }
            switch (direction) {
                case field_11035: {
                    class_243 class_2432 = new class_243(-1.0, 1.0, -1.0);
                    break;
                }
                case field_11034: {
                    class_243 class_2432 = new class_243(1.0, 1.0, -1.0);
                    break;
                }
                case field_11039: {
                    class_243 class_2432 = new class_243(-1.0, 1.0, 1.0);
                    break;
                }
                default: {
                    class_243 class_2432 = rotVec = new class_243(1.0, 1.0, 1.0);
                }
            }
            if (tick < 400 && tick % 2 == 0) {
                class_243 celestPos;
                if (tick < 175) {
                    double y = (double)(tick - 100) / 25.0;
                    celestPos = new class_243(2.5, y, -2.5).method_18806(rotVec);
                } else if (tick < 325) {
                    double t = Math.PI * 2 * (double)(tick - 175) / 150.0 - 0.7853981633974483;
                    double x = Math.cos(t) * 2.5;
                    double z = Math.sin(t) * 2.5;
                    celestPos = new class_243(x, 3.0, z).method_18806(rotVec);
                } else {
                    double y = 3.0 - (double)(tick - 325) / 25.0;
                    celestPos = new class_243(2.5, y, -2.5).method_18806(rotVec);
                }
                ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center.method_1019(celestPos), (class_2394)sun, (double)0.5, (int)10, (int)3, (double)0.15, (double)0.0, (double)theta);
                ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center.method_1019(celestPos.method_18805(-1.0, 1.0, -1.0)), (class_2394)moon, (double)0.5, (int)10, (int)3, (double)0.15, (double)0.0, (double)theta);
            }
        }
        if (tick < 500) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.celestialAltarAnim(world, center, tick + 1, direction)));
        }
    }

    public static void starpathAltarAnim(class_3218 world, class_243 center) {
        SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15245, (float)2.0f, (float)0.5f);
        ArcanaEffectUtils.starpathAltarAnim(world, center, 0, new ArrayList<class_3545<class_243, Integer>>(), new ArrayList<class_243>());
    }

    private static void starpathAltarAnim(class_3218 world, class_243 center, int tick, List<class_3545<class_243, Integer>> groundStars, List<class_243> skyStars) {
        double x;
        double r;
        int i;
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        double theta = 0.06283185307179587 * (double)tick;
        int points = 100;
        class_2390 black = new class_2390(0, 2.0f);
        double blackDelta = tick < 100 ? 0.05 : 0.4;
        int blackCount = tick < 100 ? 1 : 4;
        for (i = 0; i < points; ++i) {
            double y = (double)i / (double)(points - 1);
            r = Math.sqrt(1.0 - y * y);
            double t = phi * (double)i + theta;
            x = Math.cos(t) * r;
            double z = Math.sin(t) * r;
            if (y > (double)tick / 100.0) continue;
            class_243 point = new class_243(x, y, z);
            point = point.method_1021(5.0).method_1031(center.field_1352, center.field_1351, center.field_1350);
            world.method_65096((class_2394)black, point.field_1352, point.field_1351, point.field_1350, blackCount, blackDelta, blackDelta, blackDelta, 0.0);
        }
        if (tick >= 100) {
            if (tick % 2 == 0) {
                for (i = 0; i < groundStars.size(); ++i) {
                    class_3545<class_243, Integer> groundStar = groundStars.get(i);
                    class_243 starPos = (class_243)groundStar.method_15442();
                    world.method_65096((class_2394)class_2398.field_11207, starPos.field_1352, starPos.field_1351, starPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    groundStars.set(i, (class_3545<class_243, Integer>)new class_3545((Object)starPos.method_1031(0.0, 0.125, 0.0), (Object)((Integer)groundStar.method_15441() - 1)));
                }
                groundStars.removeIf(p -> (Integer)p.method_15441() <= 0);
                if (groundStars.size() < 8) {
                    for (i = 0; i < 2; ++i) {
                        double t = Math.random() * Math.PI * 2.0;
                        r = Math.random() * 3.0 + 1.0;
                        double x2 = Math.cos(t) * r;
                        double z = Math.sin(t) * r;
                        int lifeTime = (int)(Math.random() * 8.0 + 4.0);
                        groundStars.add((class_3545<class_243, Integer>)new class_3545((Object)new class_243(x2, 0.0, z).method_1031(center.field_1352, center.field_1351 + 0.5, center.field_1350), (Object)lifeTime));
                    }
                }
            }
            if (tick % 3 == 0) {
                for (class_243 skyStar : skyStars) {
                    world.method_65096((class_2394)class_2398.field_11207, skyStar.field_1352, skyStar.field_1351, skyStar.field_1350, 1, 0.05, 0.05, 0.05, 0.0);
                }
            }
            if (skyStars.size() < 30) {
                double starRadius = 4.5;
                for (int i2 = 0; i2 < 30; ++i2) {
                    double t = Math.random() * Math.PI * 2.0;
                    double r2 = Math.random() * starRadius + 0.75;
                    x = Math.cos(t) * r2;
                    double z = Math.sin(t) * r2;
                    double y = Math.sqrt(starRadius * starRadius - r2 * r2);
                    skyStars.add(new class_243(center.field_1352 + x, center.field_1351 + y, center.field_1350 + z));
                }
            }
            if (tick >= 140) {
                class_2390 white = new class_2390(9719495, 0.5f);
                int connections = Math.min(8, (tick - 140) / 30);
                for (int i3 = 0; i3 < connections + 1; ++i3) {
                    ArcanaEffectUtils.line((class_3218)world, null, (class_243)skyStars.get(i3), (class_243)skyStars.get(i3 + 1), (class_2394)white, (int)20, (int)1, (double)0.05, (double)0.0);
                }
                if (tick <= 380 && (tick - 140) % 30 == 0) {
                    SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_23116, (class_3419)class_3419.field_15245, (float)2.0f, (float)(0.5f + (float)connections * 0.2f));
                }
            }
        }
        if (tick == 440) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)center), (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15245, (float)2.0f, (float)1.5f);
        }
        if (tick < 500) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.starpathAltarAnim(world, center, tick + 1, groundStars, skyStars)));
        }
    }

    public static void midnightEnchanterAnim(class_3218 world, class_243 center, int tick) {
        if (tick % 2 == 0) {
            return;
        }
        world.method_65096((class_2394)class_2398.field_11215, center.method_10216(), center.method_10214() + 0.75, center.method_10215(), 5, 0.1, 0.1, 0.1, 1.0);
        class_2390 blue = new class_2390(1232127, 0.7f);
        double L1 = 2.35;
        double S1 = 0.85;
        int I1 = tick % 4 == 1 ? 10 : 11;
        double D1 = 0.02;
        boolean C1 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(2.35, -0.4, 0.0), (class_243)center.method_1031(0.85, -0.4, 0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, 2.35), (class_243)center.method_1031(0.85, -0.4, 0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, 2.35), (class_243)center.method_1031(-0.85, -0.4, 0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-2.35, -0.4, 0.0), (class_243)center.method_1031(-0.85, -0.4, 0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-2.35, -0.4, 0.0), (class_243)center.method_1031(-0.85, -0.4, -0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, -2.35), (class_243)center.method_1031(0.85, -0.4, -0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, -2.35), (class_243)center.method_1031(-0.85, -0.4, -0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(2.35, -0.4, 0.0), (class_243)center.method_1031(0.85, -0.4, -0.85), (class_2394)blue, (int)I1, (int)1, (double)0.02, (double)1.0);
        class_2390 purple = new class_2390(10551526, 0.7f);
        double L2 = 1.4;
        double S2 = 0.6;
        int I2 = tick % 4 == 1 ? 10 : 11;
        double D2 = 0.02;
        boolean C2 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(1.4, -0.4, 1.4), (class_243)center.method_1031(0.0, -0.4, 0.6), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(1.4, -0.4, 1.4), (class_243)center.method_1031(0.6, -0.4, 0.0), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-1.4, -0.4, 1.4), (class_243)center.method_1031(0.0, -0.4, 0.6), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-1.4, -0.4, 1.4), (class_243)center.method_1031(-0.6, -0.4, 0.0), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(1.4, -0.4, -1.4), (class_243)center.method_1031(0.0, -0.4, -0.6), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(1.4, -0.4, -1.4), (class_243)center.method_1031(0.6, -0.4, 0.0), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-1.4, -0.4, -1.4), (class_243)center.method_1031(0.0, -0.4, -0.6), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-1.4, -0.4, -1.4), (class_243)center.method_1031(-0.6, -0.4, 0.0), (class_2394)purple, (int)I2, (int)1, (double)0.02, (double)1.0);
        class_2390 pink = new class_2390(13828326, 0.7f);
        double L3 = 2.0;
        double S3 = 1.15;
        int I3 = tick % 4 == 1 ? 30 : 31;
        double D3 = 0.02;
        boolean C3 = true;
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(2.0, -0.4, 0.0), (class_243)center.method_1031(-2.0, -0.4, 0.0), (class_2394)pink, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(0.0, -0.4, 2.0), (class_243)center.method_1031(0.0, -0.4, -2.0), (class_2394)pink, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(1.15, -0.4, 1.15), (class_243)center.method_1031(-1.15, -0.4, -1.15), (class_2394)pink, (int)I3, (int)1, (double)0.02, (double)1.0);
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)center.method_1031(-1.15, -0.4, 1.15), (class_243)center.method_1031(1.15, -0.4, -1.15), (class_2394)pink, (int)I3, (int)1, (double)0.02, (double)1.0);
    }

    public static void stellarCoreAnim(class_3218 world, class_243 center, int tick, class_2350 direction) {
        if (tick % 2 == 0) {
            return;
        }
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)class_2398.field_11240, (double)1.2, (int)30, (int)2, (double)0.2, (double)0.03, (double)(Math.PI * 2 * (double)tick / 300.0));
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)class_2398.field_11239, (double)1.2, (int)10, (int)2, (double)0.2, (double)0.02, (double)(Math.PI * 2 * (double)tick / 300.0));
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)class_2398.field_29642, (double)0.5, (int)10, (int)2, (double)0.05, (double)0.02, (double)(Math.PI * 2 * (double)tick / 300.0));
        world.method_65096((class_2394)class_2398.field_17431, center.method_10216(), center.method_10214(), center.method_10215(), 1, 0.5, 0.5, 0.5, 0.02);
        class_243 pos = center.method_1020(class_243.method_24954((class_2382)direction.method_62675())).method_1031(0.0, 3.5, 0.0);
        world.method_65096((class_2394)class_2398.field_11239, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.25, 0.05, 0.25, 0.02);
    }

    public static void arcaneSingularityAnim(class_3218 world, class_243 center, int tick, class_2350 direction, double fillPercent) {
        if (tick % 2 == 0) {
            return;
        }
        double L = 300.0;
        double animPercent = (double)tick / L;
        double piPercent = Math.PI * 2 * animPercent;
        class_2390 black = new class_2390(0, 2.0f);
        class_2390 blue = new class_2390(60671, 0.75f);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)black, (double)(0.2 + 0.65 * fillPercent), (int)((int)(20.0 * fillPercent + 5.0)), (int)1, (double)0.025, (double)0.0, (double)(5.0 * piPercent));
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)class_2398.field_11249, (double)(0.5 + 0.85 * fillPercent), (int)((int)(30.0 * fillPercent + 12.0)), (int)1, (double)0.05, (double)0.0, (double)(3.0 * piPercent));
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)blue, (double)(0.4 + 0.75 * fillPercent), (int)((int)(70.0 * fillPercent + 12.0)), (int)1, (double)0.01, (double)0.0, (double)(-3.0 * piPercent));
        world.method_65096((class_2394)class_2398.field_11249, center.method_10216(), center.method_10214() - 1.2, center.method_10215(), 4, 0.3, 0.4, 0.3, 0.0);
        ArrayList<class_243> rods = new ArrayList<class_243>(Arrays.asList(new class_243(0.0, -1.0, 2.0), new class_243(-2.0, -1.0, 0.0), new class_243(0.0, -1.0, -2.0), new class_243(2.0, -1.0, 0.0), new class_243(-1.0, -2.0, -1.0), new class_243(1.0, -2.0, -1.0), new class_243(-1.0, -2.0, 1.0), new class_243(1.0, -2.0, 1.0)));
        rods.remove(direction.method_10161());
        int N = 3;
        double[] R = new double[N];
        for (int i = 0; i < R.length; ++i) {
            R[i] = 0.2 * (1.0 - (animPercent + (double)i / (double)N) % 1.0) + 0.1;
        }
        double W = 4.3;
        for (int i = 0; i < rods.size(); ++i) {
            class_243 pos = center.method_1019((class_243)rods.get(i));
            for (int j = 0; j < R.length; ++j) {
                world.method_65096((class_2394)blue, pos.method_10216() + R[j] * Math.cos(W * (piPercent + (double)j / (double)N)), pos.method_10214() + 1.25 * ((animPercent + (double)j / (double)N) % 1.0), pos.method_10215() + R[j] * Math.sin(W * (piPercent + (double)j / (double)N)), 3, 0.01, 0.01, 0.01, 1.0);
            }
        }
    }

    public static void nulConstructSummon(class_3218 world, class_243 pos, int tick) {
        double r;
        double or = 5.0 * (1.0 - (double)tick / 220.0);
        double inter = 0.15;
        int num = 2;
        double theta = 2.59635756495E-4 * (double)tick * (double)tick;
        double dt = 0.3141592653589793;
        int times = 5;
        for (int i = 0; i < num && !((r = or - (double)i * inter) <= 0.0); ++i) {
            double dA = Math.PI * 2 / (double)times;
            for (int j = 0; j < times; ++j) {
                double angle = dA * (double)j + (theta + dt * (double)i);
                double x = r * Math.cos(angle) + pos.field_1352;
                double z = r * Math.sin(angle) + pos.field_1350;
                double y = pos.field_1351 + 0.6;
                world.method_65096((class_2394)class_2398.field_23114, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
                world.method_65096((class_2394)class_2398.field_22447, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
        world.method_65096((class_2394)class_2398.field_11214, pos.field_1352, pos.field_1351, pos.field_1350, 20, 0.3, 0.3, 0.3, 1.0);
        if (tick < 220) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.nulConstructSummon(world, pos, tick + 1)));
        } else {
            world.method_65096((class_2394)class_2398.field_11249, pos.field_1352, pos.field_1351, pos.field_1350, 150, 1.0, 1.0, 1.0, 0.01);
        }
    }

    public static void exaltedConstructSummon(class_3218 world, class_243 pos, int tick) {
        double r;
        double or = 5.0 * (1.0 - (double)tick / 220.0);
        double inter = 0.15;
        int num = 2;
        double theta = 2.59635756495E-4 * (double)tick * (double)tick;
        double dt = 0.3141592653589793;
        int times = 5;
        for (int i = 0; i < num && !((r = or - (double)i * inter) <= 0.0); ++i) {
            double dA = Math.PI * 2 / (double)times;
            for (int j = 0; j < times; ++j) {
                double angle = dA * (double)j + (theta + dt * (double)i);
                double x = r * Math.cos(angle) + pos.field_1352;
                double z = r * Math.sin(angle) + pos.field_1350;
                double y = pos.field_1351 + 0.6;
                world.method_65096((class_2394)class_2398.field_23114, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
                world.method_65096((class_2394)class_2398.field_22447, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
        world.method_65096((class_2394)class_2398.field_11214, pos.field_1352, pos.field_1351, pos.field_1350, 20, 0.3, 0.3, 0.3, 1.0);
        world.method_65096((class_2394)class_2398.field_11216, pos.field_1352, pos.field_1351 + 0.75, pos.field_1350, 3, 0.3, 0.3, 0.3, 0.03);
        if (tick % 2 == 0) {
            class_2390 dust = new class_2390(16711892, 0.75f);
            class_243 circleCenter = pos.method_1031(0.0, -1.0, 0.0);
            double r2 = 2.5;
            float t = (float)(0.014279966607226332 * (double)tick);
            double sqrt3 = Math.sqrt(3.0);
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)circleCenter, (class_2394)dust, (double)r2, (int)40, (int)1, (double)0.0, (double)1.0);
            class_243[] tri1 = new class_243[]{new class_243(0.0, 0.0, r2), new class_243(-r2 * sqrt3 / 2.0, 0.0, -r2 / 2.0), new class_243(r2 * sqrt3 / 2.0, 0.0, -r2 / 2.0)};
            class_243[] tri2 = new class_243[]{new class_243(0.0, 0.0, -r2), new class_243(-r2 * sqrt3 / 2.0, 0.0, r2 / 2.0), new class_243(r2 * sqrt3 / 2.0, 0.0, r2 / 2.0)};
            for (int i = 0; i < 3; ++i) {
                class_243 p1 = tri1[i].method_1024(t).method_1019(circleCenter);
                class_243 p2 = tri1[(i + 1) % 3].method_1024(t).method_1019(circleCenter);
                class_243 p3 = tri2[i].method_1024(t).method_1019(circleCenter);
                class_243 p4 = tri2[(i + 1) % 3].method_1024(t).method_1019(circleCenter);
                ArcanaEffectUtils.line((class_3218)world, null, (class_243)p1, (class_243)p2, (class_2394)dust, (int)12, (int)1, (double)0.0, (double)1.0);
                ArcanaEffectUtils.line((class_3218)world, null, (class_243)p3, (class_243)p4, (class_2394)dust, (int)12, (int)1, (double)0.0, (double)1.0);
            }
        }
        if (tick < 220) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.exaltedConstructSummon(world, pos, tick + 1)));
        } else {
            world.method_65096((class_2394)class_2398.field_11249, pos.field_1352, pos.field_1351, pos.field_1350, 150, 1.0, 1.0, 1.0, 0.01);
        }
    }

    public static void nulConstructNecroticShroud(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_11237, pos.method_10216(), pos.method_10214() + 1.5, pos.method_10215(), 150, 1.5, 1.5, 1.5, 0.07);
    }

    public static void nulConstructNecroticConversion(class_3218 world, class_243 pos) {
        class_2390 dust = new class_2390(10357061, 0.8f);
        world.method_65096((class_2394)dust, pos.method_10216(), pos.method_10214() + 1.75, pos.method_10215(), 10, 0.75, 1.0, 0.75, 0.03);
    }

    public static void nulConstructReflectiveArmor(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_11207, pos.method_10216(), pos.method_10214() + 1.75, pos.method_10215(), 3, 0.75, 1.0, 0.75, 0.03);
    }

    public static void nulConstructChargeAttack(class_3218 world, class_243 pos, float yaw) {
        double xOff = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        double yOff = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        world.method_65096((class_2394)class_2398.field_11227, pos.method_10216() + 2.0 * xOff, pos.method_10214() + 1.0, pos.method_10215() + 2.0 * yOff, 2, 2.0 * xOff, 0.0, 2.0 * yOff, 0.0);
    }

    public static void nulConstructCurseOfDecay(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_23114, pos.method_10216(), pos.method_10214() + 1.0, pos.method_10215(), 20, 0.5, 1.0, 0.5, 0.07);
    }

    public static void nulConstructReflexiveBlast(class_3218 world, class_243 pos, int calls) {
        double radius = 0.5 + (double)(calls * 4);
        class_2390 dust = new class_2390(3552043, 1.5f);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)pos, (class_2394)dust, (double)radius, (int)((int)(radius * radius + radius * 20.0 + 10.0)), (int)3, (double)0.3, (double)0.05, (double)((double)calls * Math.PI * 2.0 / 5.0));
        if (calls < 5) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.nulConstructReflexiveBlast(world, pos, calls + 1)));
        }
    }

    public static void webOfFireCast(class_3218 world, class_2394 type, class_3222 caster, List<class_1309> hits, double range, int calls) {
        int totalCalls = 15;
        class_243 center = caster.method_19538().method_1031(0.0, (double)caster.method_17682() * 0.25, 0.0);
        if (calls % 2 == 0 && calls < 5) {
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)center, (class_2394)type, (double)range, (int)((int)(10.0 * range)), (int)1, (double)0.05, (double)0.01);
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)center, (class_2394)type, (double)2.0, (int)20, (int)1, (double)0.05, (double)0.01);
            for (class_1309 hit : hits) {
                class_243 hitCircle = new class_243(hit.method_23317(), center.method_10214(), hit.method_23321());
                ArcanaEffectUtils.circle((class_3218)world, null, (class_243)hitCircle, (class_2394)type, (double)hit.method_17681(), (int)12, (int)1, (double)0.0, (double)0.0);
                ArcanaEffectUtils.line((class_3218)world, null, (class_243)center, (class_243)hitCircle, (class_2394)type, (int)((int)(center.method_1022(hitCircle) * 4.0)), (int)1, (double)0.0, (double)0.0);
                for (class_1309 other : hits) {
                    if (other.method_5845().equals(hit.method_5845())) continue;
                    class_243 otherCircle = new class_243(other.method_23317(), center.method_10214(), other.method_23321());
                    ArcanaEffectUtils.line((class_3218)world, null, (class_243)otherCircle, (class_243)hitCircle, (class_2394)type, (int)((int)(otherCircle.method_1022(hitCircle) * 2.5)), (int)1, (double)0.0, (double)0.0);
                }
            }
        }
        for (class_1309 hit : hits) {
            double heightMod = (double)calls / 15.0;
            double height = hit.method_23318() + (double)hit.method_17682() * heightMod;
            double radiusMod = 1.0 - (double)calls / 22.5;
            double radius = (double)hit.method_17681() * 0.75 * radiusMod;
            class_243 circlePos = new class_243(hit.method_23317(), height, hit.method_23321());
            ArcanaEffectUtils.circle((class_3218)world, null, (class_243)circlePos, (class_2394)type, (double)radius, (int)12, (int)1, (double)0.0, (double)0.01);
        }
        if (calls < 15) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.webOfFireCast(world, type, caster, hits, range, calls + 1)));
        }
    }

    public static void pyroblastExplosion(class_3218 world, class_2394 type, class_243 pos, double range, int calls) {
        double radius = 0.5 + (double)calls * (range / 5.0);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)pos, (class_2394)type, (double)radius, (int)((int)(radius * radius + radius * 20.0 + 10.0)), (int)3, (double)0.3, (double)0.05, (double)((double)calls * Math.PI * 2.0 / 5.0));
        if (calls < 5) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.pyroblastExplosion(world, type, pos, range, calls + 1)));
        }
    }

    public static void spawnerInfuser(class_3218 world, class_2338 pos, int duration) {
        for (int i = 0; i < duration; ++i) {
            world.method_65096((class_2394)new class_7290(i * 5), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + class_7268.field_38232 - 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            world.method_65096((class_2394)new class_7290(i * 5 + 2), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + class_7268.field_38232 - 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.method_65096((class_2394)class_2398.field_38002, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.5, (double)pos.method_10260() + 0.5, 5, 0.5, 0.5, 0.5, 0.02);
        world.method_65096((class_2394)class_2398.field_22246, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.5, (double)pos.method_10260() + 0.5, 5, 0.3, 0.3, 0.3, 0.02);
    }

    public static void arcaneFlakArrowDetonate(class_3218 world, class_243 pos, double range, int calls) {
        double radius = 0.5 + (double)calls * (range / 5.0);
        double radius2 = radius * 0.75;
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)pos, (class_2394)class_2398.field_11249, (double)radius, (int)((int)(radius * radius + radius * 10.0 + 10.0)), (int)3, (double)0.3, (double)0.0, (double)0.0);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)pos, (class_2394)class_2398.field_11216, (double)radius2, (int)((int)(radius2 * radius2 + radius2 * 5.0 + 10.0)), (int)3, (double)0.3, (double)0.0, (double)0.0);
        world.method_65096((class_2394)class_2398.field_17909, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 1.0);
        if (calls < 5) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.arcaneFlakArrowDetonate(world, pos, range, calls + 1)));
        }
    }

    public static void gravitonArrowEmit(class_3218 world, class_243 center, List<class_1297> entities) {
        class_2390 dust = new class_2390(3752, 1.0f);
        class_2390 dust2 = new class_2390(1876, 1.5f);
        int count = 30;
        double range = 0.3;
        world.method_65096((class_2394)dust, center.field_1352, center.field_1351, center.field_1350, 300, 1.5, 1.5, 1.5, 0.01);
        world.method_65096((class_2394)class_2398.field_11214, center.field_1352, center.field_1351, center.field_1350, 100, 0.5, 0.5, 0.5, 1.0);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)dust2, (double)0.6, (int)50, (int)2, (double)0.1, (double)0.0, (double)0.0);
        for (class_1297 e : entities) {
            class_243 pos = e.method_19538().method_1031(0.0, (double)(e.method_17682() / 2.0f), 0.0);
            world.method_65096((class_2394)dust, pos.field_1352, pos.field_1351, pos.field_1350, count, range, range, range, 0.01);
        }
    }

    public static void expulsionArrowEmit(class_3218 world, class_243 pos, double range, int calls) {
        class_2390 dust = new class_2390(34270, 1.4f);
        double radius = 0.5 + (double)calls * (range / 5.0);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)pos, (class_2394)dust, (double)radius, (int)((int)(radius * radius + radius * 20.0 + 10.0)), (int)3, (double)0.3, (double)0.05, (double)0.0);
        if (calls < 5) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.expulsionArrowEmit(world, pos, range, calls + 1)));
        }
    }

    public static void smokeArrowEmit(class_3218 world, class_243 pos) {
        if (Math.random() < 0.1) {
            ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)class_2398.field_11237, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (double)0.5, (double)0.5, (double)0.5, (double)0.01, (int)1);
        }
        if (Math.random() < 0.05) {
            ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)class_2398.field_17431, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (double)0.5, (double)0.5, (double)0.5, (double)0.01, (int)1);
        }
    }

    public static void concussionArrowShot(class_3218 world, class_243 pos, double range, int calls) {
        double radius = 0.5 + (double)calls * (range / 5.0);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)pos, (class_2394)class_2398.field_11233, (double)radius, (int)((int)(radius * radius + radius * 20.0 + 10.0)), (int)3, (double)0.3, (double)0.05, (double)0.0);
        if (calls < 5) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.concussionArrowShot(world, pos, range, calls + 1)));
        }
    }

    public static void photonArrowShot(class_3218 world, class_243 p1, class_243 p2, float brightness, int tick) {
        class_243 diff = p2.method_1020(p1);
        int intervals = (int)(p1.method_1020(p2).method_1033() * 10.0);
        double delta = 0.03;
        double speed = 1.0;
        double portion = 0.35;
        int numTicks = 4;
        int count = 3;
        double dx = diff.field_1352 / (double)intervals;
        double dy = diff.field_1351 / (double)intervals;
        double dz = diff.field_1350 / (double)intervals;
        int upperInt = (int)((double)intervals * (((double)tick + 1.0) / (double)numTicks));
        int lowerInt = (int)Math.max(0.0, (double)upperInt - (double)intervals * portion);
        for (int i = 0; i < intervals; ++i) {
            if (i < lowerInt || i > upperInt) continue;
            double x = p1.field_1352 + dx * (double)i;
            double y = p1.field_1351 + dy * (double)i;
            double z = p1.field_1350 + dz * (double)i;
            float hue = (float)i / (float)intervals;
            float trueBrightness = (float)Math.min(1.0, -0.01 * (new class_243(x, y, z).method_1022(p1) - 100.0) + 0.25) * brightness;
            Color c = Color.getHSBColor(hue, 1.0f, trueBrightness);
            class_2390 dust = new class_2390(c.getRGB(), 0.6f);
            ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)dust, (double)x, (double)y, (double)z, (double)delta, (double)delta, (double)delta, (double)speed, (int)count);
        }
        if (upperInt >= intervals) {
            ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)class_2398.field_29643, (double)p2.field_1352, (double)p2.field_1351, (double)p2.field_1350, (double)0.2, (double)0.2, (double)0.2, (double)1.0, (int)10);
        }
        if (tick < numTicks - 1) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.photonArrowShot(world, p1, p2, brightness, tick + 1)));
        }
    }

    public static void tetherArrowEntity(class_3218 world, class_1309 entity, class_3222 player) {
        class_2390 dust = new class_2390(10921354, 0.4f);
        double len = player.method_19538().method_1020(entity.method_19538()).method_1033();
        ArcanaEffectUtils.longDistLine((class_3218)world, (class_243)player.method_19538().method_1031(0.0, (double)(player.method_17682() / 2.0f), 0.0), (class_243)entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0), (class_2394)dust, (int)((int)(20.0 * len)), (int)3, (double)0.03, (double)1.0);
    }

    public static void tetherArrowGrapple(class_3218 world, class_3222 player, class_243 pos) {
        class_2390 dust = new class_2390(10921354, 0.4f);
        double len = player.method_19538().method_1020(pos).method_1033();
        ArcanaEffectUtils.longDistLine((class_3218)world, (class_243)player.method_19538(), (class_243)pos, (class_2394)dust, (int)((int)(20.0 * len)), (int)3, (double)0.03, (double)1.0);
    }

    public static void blinkArrowTp(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351, pos.field_1350, 100, 0.3, 0.5, 0.3, 0.05);
    }

    public static void harnessFly(class_3218 world, class_3222 player, int duration) {
        class_243 pos = player.method_19538();
        world.method_65096((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.3, 0.3, 0.3, 0.05);
        world.method_65096((class_2394)class_2398.field_11213, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.3, 0.3, 0.3, 1.0);
        if (0 < duration) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(2, () -> ArcanaEffectUtils.harnessFly(world, player, duration - 1)));
        }
    }

    public static void harnessStall(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 100, 0.4, 0.6, 0.4, 0.05);
        world.method_65096((class_2394)class_2398.field_11231, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 15, 0.4, 0.6, 0.4, 1.0);
        world.method_65096((class_2394)class_2398.field_17430, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 15, 0.4, 0.6, 0.4, 0.07);
    }

    public static void dowsingRodEmitter(class_3218 world, class_243 pos, int calls, int duration) {
        if (world.method_8320(class_2338.method_49638((class_2374)pos)).method_26204() != class_2246.field_22109) {
            return;
        }
        ArcanaEffectUtils.spawnLongParticle((class_3218)world, (class_2394)class_2398.field_11240, (double)(pos.field_1352 + 0.5), (double)(pos.field_1351 + 0.5), (double)(pos.field_1350 + 0.5), (double)0.4, (double)0.4, (double)0.4, (double)0.05, (int)3);
        if (calls < duration) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(3, () -> ArcanaEffectUtils.dowsingRodEmitter(world, pos, calls + 1, duration)));
        }
    }

    public static void dowsingRodArrow(class_3218 world, class_243 start, class_243 end, int calls) {
        ArcanaEffectUtils.line((class_3218)world, null, (class_243)start, (class_243)end, (class_2394)class_2398.field_11240, (int)8, (int)3, (double)0.08, (double)0.0);
        if (calls < 16) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(5, () -> ArcanaEffectUtils.dowsingRodArrow(world, start, end, calls + 1)));
        }
    }

    public static void shadowGlaiveTp(class_3218 world, class_3222 player) {
        class_243 pos = player.method_19538();
        world.method_65096((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 100, 0.4, 0.4, 0.4, 0.07);
    }

    public static void shulkerCoreLevitate(class_3218 world, class_1657 player, int duration) {
        if (player.method_6112(class_1294.field_5902) == null) {
            return;
        }
        class_243 pos = player.method_19538();
        world.method_65096((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 1, 0.3, 0.3, 0.3, 0.05);
        if (0 < duration) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.shulkerCoreLevitate(world, player, duration - 1)));
        }
    }

    public static void recallTeleportCharge(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_11214, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 20, 0.2, 0.5, 0.2, 1.0);
        world.method_65096((class_2394)class_2398.field_11249, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 2, 0.1, 0.2, 0.1, 1.0);
    }

    public static void recallTeleportCancel(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 150, 0.5, 0.8, 0.5, 0.05);
    }

    public static void recallLocation(class_3218 world, class_243 pos, class_3222 player) {
        ArcanaEffectUtils.circle((class_3218)world, (class_3222)player, (class_243)pos.method_1023(0.0, 0.0, 0.0), (class_2394)class_2398.field_11208, (double)0.5, (int)12, (int)1, (double)0.1, (double)0.0);
        world.method_14166(player, (class_2394)class_2398.field_11249, false, true, pos.field_1352, pos.field_1351, pos.field_1350, 5, 0.15, 0.15, 0.15, 0.0);
    }

    public static void recallTeleport(class_3218 world, class_243 pos) {
        ArcanaEffectUtils.recallTeleport(world, pos, 0);
    }

    private static void recallTeleport(class_3218 world, class_243 pos, int tick) {
        int animLength = 30;
        if (tick < 5) {
            world.method_65096((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 30, 0.1, 0.4, 0.1, 0.2);
            world.method_65096((class_2394)class_2398.field_22447, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 10, 0.6, 0.6, 0.6, 0.2);
        }
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)pos.method_1023(0.0, 0.5, 0.0), (class_2394)class_2398.field_11249, (double)1.0, (int)20, (int)1, (double)0.1, (double)0.0);
        if (tick < animLength) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(1, () -> ArcanaEffectUtils.recallTeleport(world, pos, tick + 1)));
        }
    }

    public static void stasisPearl(class_3218 world, class_243 pos) {
        world.method_65096((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.2, 0.2, 0.2, 0.01);
        world.method_65096((class_2394)class_2398.field_28479, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.15, 0.15, 0.15, 0.0);
    }

    public static void dragonBossTowerCircleInvuln(class_3218 world, class_243 center, int period, int calls) {
        class_2390 dust = new class_2390(9109665, 0.8f);
        class_2390 dust2 = new class_2390(9109665, 1.5f);
        double r = 2.5;
        float t = (float)(Math.PI / ((double)period / 100.0) * (double)calls);
        double sqrt3 = Math.sqrt(3.0);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)center, (class_2394)dust, (double)r, (int)60, (int)1, (double)0.0, (double)1.0);
        class_243[] tri1 = new class_243[]{new class_243(0.0, 0.0, r), new class_243(-r * sqrt3 / 2.0, 0.0, -r / 2.0), new class_243(r * sqrt3 / 2.0, 0.0, -r / 2.0)};
        class_243[] tri2 = new class_243[]{new class_243(0.0, 0.0, -r), new class_243(-r * sqrt3 / 2.0, 0.0, r / 2.0), new class_243(r * sqrt3 / 2.0, 0.0, r / 2.0)};
        for (int i = 0; i < 3; ++i) {
            class_243 p1 = tri1[i].method_1024(t).method_1019(center);
            class_243 p2 = tri1[(i + 1) % 3].method_1024(t).method_1019(center);
            class_243 p3 = tri2[i].method_1024(t).method_1019(center);
            class_243 p4 = tri2[(i + 1) % 3].method_1024(t).method_1019(center);
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)p1, (class_243)p2, (class_2394)dust, (int)20, (int)1, (double)0.0, (double)1.0);
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)p3, (class_243)p4, (class_2394)dust, (int)20, (int)1, (double)0.0, (double)1.0);
        }
        double steps = 60.0;
        double radius = 1.75;
        double height = 5.5;
        int num = 6;
        int concurrent = 4;
        double[][] angles = new double[num][concurrent];
        for (int i = 0; i < angles[0].length; ++i) {
            int invulnAnimTick = Math.floorMod((int)((double)calls - steps * (double)i / (double)concurrent), (int)steps);
            r = -(2.0 * radius / steps) * Math.abs((double)invulnAnimTick - steps / 2.0) + radius;
            for (int j = 0; j < angles.length; ++j) {
                angles[j][i] = -(Math.PI * 2 / (double)angles.length * (double)j + (double)invulnAnimTick / 10.0);
                double x = r * Math.cos(angles[j][i]) + center.field_1352;
                double z = r * Math.sin(angles[j][i]) + center.field_1350;
                double y = height * (double)invulnAnimTick / steps + (center.field_1351 - 1.25);
                world.method_65096((class_2394)dust2, x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
        if (calls < period / 100) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(2, () -> ArcanaEffectUtils.dragonBossTowerCircleInvuln(world, center, period, calls + 1)));
        }
    }

    public static void dragonBossTowerCirclePush(class_3218 world, class_243 center, int period, int calls) {
        class_2390 dust = new class_2390(16711892, 2.0f);
        class_2390 dustLarge = new class_2390(16711892, 3.0f);
        double r = 4.2;
        float t = -((float)(Math.PI / ((double)period / 100.0) * (double)calls + Math.PI));
        double sqrt3 = Math.sqrt(3.0);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)center, (class_2394)dust, (double)r, (int)40, (int)1, (double)0.0, (double)1.0);
        class_243[] tri1 = new class_243[]{new class_243(0.0, 0.0, r), new class_243(-r * sqrt3 / 2.0, 0.0, -r / 2.0), new class_243(r * sqrt3 / 2.0, 0.0, -r / 2.0)};
        class_243[] tri2 = new class_243[]{new class_243(0.0, 0.0, -r), new class_243(-r * sqrt3 / 2.0, 0.0, r / 2.0), new class_243(r * sqrt3 / 2.0, 0.0, r / 2.0)};
        for (int i = 0; i < 3; ++i) {
            class_243 p1 = tri1[i].method_1024(t).method_1019(center);
            class_243 p2 = tri1[(i + 1) % 3].method_1024(t).method_1019(center);
            class_243 p3 = tri2[i].method_1024(t).method_1019(center);
            class_243 p4 = tri2[(i + 1) % 3].method_1024(t).method_1019(center);
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)p1, (class_243)p2, (class_2394)dust, (int)12, (int)1, (double)0.0, (double)1.0);
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)p3, (class_243)p4, (class_2394)dust, (int)12, (int)1, (double)0.0, (double)1.0);
        }
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center.method_1031(0.0, 2.0, 0.0), (class_2394)dustLarge, (double)5.5, (int)25, (int)1, (double)0.0, (double)1.0, (double)(-t));
        if (calls < period / 100) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(2, () -> ArcanaEffectUtils.dragonBossTowerCirclePush(world, center, period, calls + 1)));
        }
    }

    public static void dragonReclaimTowerCircle(class_3218 world, class_243 center, int period, int calls) {
        class_2390 dust = new class_2390(4044031, 1.5f);
        double r = 4.2;
        float t = -((float)(Math.PI / ((double)period / 100.0) * (double)calls + Math.PI));
        double sqrt3 = Math.sqrt(3.0);
        ArcanaEffectUtils.circle((class_3218)world, null, (class_243)center, (class_2394)dust, (double)r, (int)40, (int)1, (double)0.0, (double)1.0);
        class_243[] tri1 = new class_243[]{new class_243(0.0, 0.0, r), new class_243(-r * sqrt3 / 2.0, 0.0, -r / 2.0), new class_243(r * sqrt3 / 2.0, 0.0, -r / 2.0)};
        class_243[] tri2 = new class_243[]{new class_243(0.0, 0.0, -r), new class_243(-r * sqrt3 / 2.0, 0.0, r / 2.0), new class_243(r * sqrt3 / 2.0, 0.0, r / 2.0)};
        for (int i = 0; i < 3; ++i) {
            class_243 p1 = tri1[i].method_1024(t).method_1019(center);
            class_243 p2 = tri1[(i + 1) % 3].method_1024(t).method_1019(center);
            class_243 p3 = tri2[i].method_1024(t).method_1019(center);
            class_243 p4 = tri2[(i + 1) % 3].method_1024(t).method_1019(center);
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)p1, (class_243)p2, (class_2394)dust, (int)16, (int)1, (double)0.0, (double)1.0);
            ArcanaEffectUtils.line((class_3218)world, null, (class_243)p3, (class_243)p4, (class_2394)dust, (int)16, (int)1, (double)0.0, (double)1.0);
        }
        if (calls < period / 100) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(2, () -> ArcanaEffectUtils.dragonReclaimTowerCircle(world, center, period, calls + 1)));
        }
    }

    public static void dragonReclaimTowerShield(class_3218 world, class_243 center, int calls) {
        int period = 15000;
        class_2390 dust = new class_2390(9694975, 1.5f);
        float t = -((float)(Math.PI / ((double)period / 200.0) * (double)calls + Math.PI));
        ArcanaEffectUtils.longDistSphere((class_3218)world, (class_243)center.method_1031(0.0, 2.0, 0.0), (class_2394)dust, (double)5.5, (int)75, (int)1, (double)0.0, (double)1.0, (double)(-t));
        if (calls < period / 200) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(2, () -> ArcanaEffectUtils.dragonReclaimTowerShield(world, center, calls + 1)));
        }
    }

    public static void dragonBossWizardPulse(class_3218 world, class_243 center, int ticks) {
        double radius = (double)ticks / 4.0;
        double theta = 0.3141592653589793;
        class_2390 dust = new class_2390(16711892, (float)radius / 2.0f);
        ArcanaEffectUtils.sphere((class_3218)world, null, (class_243)center, (class_2394)dust, (double)radius, (int)((int)(radius * radius + radius * 10.0 + radius)), (int)1, (double)0.0, (double)1.0, (double)(theta * (double)ticks));
    }
}

