/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaItemContainer;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.LeftClickItem;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1730;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ArcanaItemUtils {
    public static boolean isArcane(class_1799 item) {
        try {
            if (item == null) {
                return false;
            }
            ArcanaItem arcanaItem = (ArcanaItem)ArcanaRegistry.ARCANA_ITEMS.method_63535(class_2960.method_60655((String)"arcananovum", (String)ArcanaItem.getStringProperty(item, "id")));
            return arcanaItem != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isEnergyItem(class_1799 item) {
        if (ArcanaItemUtils.isArcane(item)) {
            return ArcanaItemUtils.identifyItem(item) instanceof EnergyItem;
        }
        return false;
    }

    public static boolean isRunicArrow(class_1799 item) {
        if (ArcanaItemUtils.isArcane(item)) {
            return ArcanaItemUtils.identifyItem(item) instanceof RunicArrow;
        }
        return false;
    }

    public static boolean needsVersionUpdate(class_1799 item) {
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
        if (!ArcanaItemUtils.isArcane(item) || arcanaItem == null) {
            return false;
        }
        try {
            int version = ArcanaItem.getIntProperty(item, "Version");
            return version != 12 + arcanaItem.getItemVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isLeftClickItem(class_1799 item) {
        try {
            if (ArcanaItemUtils.isArcane(item)) {
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                return arcanaItem instanceof LeftClickItem;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static LeftClickItem identifyLeftClickItem(class_1799 item) {
        if (ArcanaItemUtils.isLeftClickItem(item)) {
            return (LeftClickItem)((Object)ArcanaItemUtils.identifyItem(item));
        }
        return null;
    }

    public static ArcanaItem identifyItem(class_1799 item) {
        if (ArcanaItemUtils.isArcane(item)) {
            return (ArcanaItem)ArcanaRegistry.ARCANA_ITEMS.method_63535(class_2960.method_60655((String)"arcananovum", (String)ArcanaItem.getStringProperty(item, "id")));
        }
        return null;
    }

    public static RunicArrow identifyRunicArrow(class_1799 item) {
        if (ArcanaItemUtils.isRunicArrow(item)) {
            return (RunicArrow)ArcanaItemUtils.identifyItem(item);
        }
        return null;
    }

    public static EnergyItem identifyEnergyItem(class_1799 item) {
        if (ArcanaItemUtils.isEnergyItem(item)) {
            return (EnergyItem)ArcanaItemUtils.identifyItem(item);
        }
        return null;
    }

    public static class_3222 findHolder(MinecraftServer server, String uuid) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (ArcanaItemUtils.getHolderStack(player, uuid) == null) continue;
            return player;
        }
        return null;
    }

    public static class_1799 getHolderStack(class_3222 player, String uuid) {
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            String itemUuid;
            ArcanaItem arcanaItem;
            class_1799 item = inv.method_5438(i);
            if (item.method_7960() || (arcanaItem = ArcanaItemUtils.identifyItem(item)) == null || !uuid.equals(itemUuid = ArcanaItem.getUUID(item))) continue;
            return item;
        }
        return null;
    }

    public static List<ArcanaInvItem> getActiveArcanaBlocks(class_3222 player) {
        ArrayList<ArcanaInvItem> arcanaInv = new ArrayList<ArcanaInvItem>();
        for (class_3545 pair2 : ArcanaNovum.ACTIVE_ARCANA_BLOCKS.keySet().stream().filter(pair -> player.method_5845().equals(((ArcanaBlockEntity)pair.method_15441()).getCrafterId()) && ((class_2586)pair.method_15442()).method_11002() && ((class_2586)pair.method_15442()).method_10997().method_8321(((class_2586)pair.method_15442()).method_11016()) == pair.method_15442()).toList()) {
            class_2586 blockEntity = (class_2586)pair2.method_15442();
            ArcanaBlockEntity arcanaBlockEntity = (ArcanaBlockEntity)pair2.method_15441();
            String dim = blockEntity.method_10997().method_27983().method_29177().toString();
            String dimensionName = "Unknown";
            if (dim.equals(class_3218.field_25179.method_29177().toString())) {
                dimensionName = "Overworld";
            } else if (dim.equals(class_3218.field_25180.method_29177().toString())) {
                dimensionName = "Nether";
            } else if (dim.equals(class_3218.field_25181.method_29177().toString())) {
                dimensionName = "End";
            }
            class_2338 pos = blockEntity.method_11016();
            String posStr = " (" + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + ")";
            ArcanaItemContainer worldContainer = new ArcanaItemContainer((class_1263)new class_1277(1), 1, 1000, "World", dimensionName + posStr, 0.25);
            ArcanaInvItem invItem = new ArcanaInvItem(arcanaBlockEntity.getArcanaItem(), 1, arcanaBlockEntity.getAugments(), new ArrayList<ArcanaItemContainer>(List.of(worldContainer)));
            arcanaInv.add(invItem);
        }
        return arcanaInv;
    }

    public static List<ArcanaInvItem> getArcanaInventory(class_3222 player) {
        ArrayList<ArcanaInvItem> arcanaInv = new ArrayList<ArcanaInvItem>();
        class_1661 inv = player.method_31548();
        class_1730 eChest = player.method_7274();
        ArcanaItemUtils.arcanaInvHelper((class_1263)inv, arcanaInv, new ArrayList<ArcanaItemContainer>());
        ArcanaItemUtils.arcanaInvHelper((class_1263)eChest, arcanaInv, new ArrayList<ArcanaItemContainer>(List.of(new ArcanaItemContainer((class_1263)player.method_7274(), player.method_7274().method_5439(), 100, "EC", "Ender Chest", 0.5))));
        arcanaInv.addAll(ArcanaItemUtils.getActiveArcanaBlocks(player));
        return arcanaInv;
    }

    public static void arcanaInvHelper(class_1263 inv, List<ArcanaInvItem> arcanaInv, List<ArcanaItemContainer> containers) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            ArcanaInvItem invItem;
            int contains;
            class_1799 item = inv.method_5438(i);
            if (item.method_7960()) continue;
            boolean isArcane = ArcanaItemUtils.isArcane(item);
            boolean isBox = item.method_31574(class_1802.field_8545) || item.method_31574(class_1802.field_8722) || item.method_31574(class_1802.field_8268) || item.method_31574(class_1802.field_8350) || item.method_31574(class_1802.field_8584) || item.method_31574(class_1802.field_8213) || item.method_31574(class_1802.field_8627) || item.method_31574(class_1802.field_8461) || item.method_31574(class_1802.field_8829) || item.method_31574(class_1802.field_8451) || item.method_31574(class_1802.field_8548) || item.method_31574(class_1802.field_8050) || item.method_31574(class_1802.field_8380) || item.method_31574(class_1802.field_8520) || item.method_31574(class_1802.field_8816) || item.method_31574(class_1802.field_8676) || item.method_31574(class_1802.field_8271);
            boolean isBundle = item.method_57826(class_9334.field_49650);
            if (isBundle && !isArcane) {
                class_9276 bundleComp = (class_9276)item.method_58694(class_9334.field_49650);
                class_1277 bundleInv = new class_1277(bundleComp.method_57426());
                int index = 0;
                for (class_1799 itemStack : bundleComp.method_59708()) {
                    bundleInv.method_5447(index, itemStack);
                    ++index;
                }
                containersCopy = new ArrayList<ArcanaItemContainer>(containers);
                containersCopy.add(new ArcanaItemContainer((class_1263)bundleInv, bundleInv.method_5439(), 5, "BD", "Bundle", 1.0));
                ArcanaItemUtils.arcanaInvHelper((class_1263)bundleInv, arcanaInv, containersCopy);
            } else if (isBox && !isArcane) {
                class_9288 comp = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
                class_2371 shulkerItems = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                comp.method_57492(shulkerItems);
                class_1277 shulkerInv = new class_1277(27);
                for (int j = 0; j < shulkerItems.size(); ++j) {
                    shulkerInv.method_5447(j, (class_1799)shulkerItems.get(j));
                }
                containersCopy = new ArrayList<ArcanaItemContainer>(containers);
                containersCopy.add(new ArcanaItemContainer((class_1263)shulkerInv, shulkerInv.method_5439(), 50, "SB", "Shulker Box", 0.5));
                ArcanaItemUtils.arcanaInvHelper((class_1263)shulkerInv, arcanaInv, containersCopy);
            }
            if (!isArcane) continue;
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
            if (!ArcanaItem.hasProperty(item, "uuid") || ArcanaItem.getUUID(item).equals("00000000-0000-4000-8000-000000000000")) continue;
            if (arcanaItem instanceof ArcanaItemContainer.ArcanaItemContainerHaver) {
                ArcanaItemContainer.ArcanaItemContainerHaver containerHaver = (ArcanaItemContainer.ArcanaItemContainerHaver)((Object)arcanaItem);
                ArrayList<ArcanaItemContainer> containersCopy = new ArrayList<ArcanaItemContainer>(containers);
                ArcanaItemContainer arcanaContainer = containerHaver.getArcanaItemContainer(item);
                containersCopy.add(arcanaContainer);
                ArcanaItemUtils.arcanaInvHelper(arcanaContainer.getInventory(), arcanaInv, containersCopy);
            }
            if ((contains = ArcanaInvItem.invContains(arcanaInv, invItem = new ArcanaInvItem(arcanaItem, item.method_7947(), ArcanaAugments.getAugmentsOnItem(item), containers))) >= 0) {
                arcanaInv.get((int)contains).count += invItem.count;
                arcanaInv.get(contains).addItem(item);
                continue;
            }
            invItem.addItem(item);
            arcanaInv.add(invItem);
        }
    }

    public static int getUsedConcentration(class_3222 player) {
        int concSum = 0;
        List<ArcanaInvItem> arcanaInv = ArcanaItemUtils.getArcanaInventory(player);
        for (ArcanaInvItem arcanaInvItem : arcanaInv) {
            ArcanaItem arcanaItem = arcanaInvItem.item;
            int prefCount = arcanaItem.getPrefItem().method_7947();
            double containerMod = arcanaInvItem.getFocusedConcMod(player);
            concSum += (int)(Math.ceil((double)arcanaInvItem.count / (double)prefCount) * Math.ceil(containerMod * (double)(ArcanaRarity.getConcentration(arcanaItem.getRarity()) + arcanaInvItem.getAugmentConc(player))));
        }
        return concSum;
    }

    public static List<class_5250> getConcBreakdown(class_3222 player) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        List<ArcanaInvItem> arcanaInv = ArcanaItemUtils.getArcanaInventory(player);
        Comparator comparator = (i1, i2) -> {
            int r1 = i1.count * ArcanaRarity.getConcentration(i1.item.getRarity());
            int r2 = i2.count * ArcanaRarity.getConcentration(i2.item.getRarity());
            return (r1 += (int)(10000.0 * i1.getSortMod())) - (r2 += (int)(10000.0 * i2.getSortMod()));
        };
        arcanaInv.sort(comparator);
        for (ArcanaInvItem arcanaInvItem : arcanaInv) {
            ArcanaItem arcanaItem = arcanaInvItem.item;
            int prefCount = arcanaItem.getPrefItem().method_7947();
            double containerMod = arcanaInvItem.getFocusedConcMod(player);
            int multiplier = (int)Math.ceil((double)arcanaInvItem.count / (double)prefCount);
            int itemConc = multiplier * (int)Math.ceil(containerMod * (double)(ArcanaRarity.getConcentration(arcanaItem.getRarity()) + arcanaInvItem.getAugmentConc(player)));
            Object multStr = multiplier > 1 ? " x" + multiplier : "";
            String contStr = arcanaInvItem.getContainerString();
            class_5250 line = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)arcanaItem.getTranslatedName()).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)multStr).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)(" (" + itemConc + ")")).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(" " + contStr)).method_27692(class_124.field_1064));
            list.add(line);
        }
        return list;
    }

    public static int countItemsTakingConc(class_3222 player) {
        List<ArcanaInvItem> arcanaInv = ArcanaItemUtils.getArcanaInventory(player);
        int itemsTakingConc = 0;
        for (ArcanaInvItem arcanaInvItem : arcanaInv) {
            double containerMod;
            ArcanaItem arcanaItem = arcanaInvItem.item;
            int prefCount = arcanaItem.getPrefItem().method_7947();
            int multiplier = (int)Math.ceil((double)arcanaInvItem.count / (double)prefCount);
            int itemConc = multiplier * (int)Math.ceil((containerMod = arcanaInvItem.getFocusedConcMod(player)) * (double)(ArcanaRarity.getConcentration(arcanaItem.getRarity()) + arcanaInvItem.getAugmentConc(player)));
            if (itemConc <= 0) continue;
            itemsTakingConc += multiplier;
        }
        return itemsTakingConc;
    }

    public static boolean hasItemInInventory(class_1657 player, class_1792 itemType) {
        List<class_3545<List<class_1799>, class_1799>> allItems = ArcanaUtils.getAllItems(player);
        for (class_3545<List<class_1799>, class_1799> allItem : allItems) {
            List itemList = (List)allItem.method_15442();
            for (class_1799 item : itemList) {
                if (!item.method_31574(itemType)) continue;
                return true;
            }
        }
        return false;
    }

    public static int countRarityInList(List<String> ids, ArcanaRarity rarity, boolean exclude) {
        int count = 0;
        for (String id : ids) {
            class_2960 identifier = id.contains(":") ? class_2960.method_60654((String)id) : class_2960.method_60655((String)"arcananovum", (String)id);
            if (!ArcanaRegistry.ARCANA_ITEMS.method_10250(identifier) || !(ArcanaItemUtils.getItemFromId(id).getRarity() == rarity ^ exclude)) continue;
            ++count;
        }
        return count;
    }

    public static ArcanaItem getItemFromId(String id) {
        if (id == null) {
            return null;
        }
        class_2960 identifier = id.contains(":") ? class_2960.method_60654((String)id) : class_2960.method_60655((String)"arcananovum", (String)id);
        return (ArcanaItem)ArcanaRegistry.ARCANA_ITEMS.method_63535(identifier);
    }

    public static class ArcanaInvItem {
        private int count;
        public final ArcanaItem item;
        public final String hash;
        private final ArrayList<class_3545<String, class_1799>> stacks;
        private final TreeMap<ArcanaAugment, Integer> augments;
        private final List<ArcanaItemContainer> containers;
        private double concMod;
        private int sortMod;

        public ArcanaInvItem(ArcanaItem item, int count, TreeMap<ArcanaAugment, Integer> augments, List<ArcanaItemContainer> containers) {
            this.count = count;
            this.item = item;
            this.stacks = new ArrayList();
            this.augments = augments;
            this.containers = containers;
            StringBuilder augHash = new StringBuilder();
            for (Map.Entry<ArcanaAugment, Integer> entry : augments.entrySet()) {
                ArcanaAugment aug = entry.getKey();
                int itemLvl = entry.getValue();
                augHash.append(aug.id).append(itemLvl);
            }
            this.concMod = 1.0;
            this.sortMod = 0;
            containers.sort(Comparator.comparing(ArcanaItemContainer::getConcModStr));
            StringBuilder contHash = new StringBuilder();
            for (ArcanaItemContainer container : containers) {
                contHash.append(container.getConcModStr());
                this.concMod *= container.getConcMod();
                this.sortMod += container.getSortMod();
            }
            this.hash = item.getId() + String.valueOf(augHash) + String.valueOf(contHash);
        }

        public static int invContains(List<ArcanaInvItem> inv, ArcanaInvItem invItem) {
            for (int i = 0; i < inv.size(); ++i) {
                ArcanaInvItem arcanaInvItem = inv.get(i);
                if (!arcanaInvItem.hash.equals(invItem.hash)) continue;
                return i;
            }
            return -1;
        }

        public void addItem(class_1799 stack) {
            this.stacks.add((class_3545<String, class_1799>)new class_3545((Object)ArcanaItem.getUUID(stack), (Object)stack));
        }

        public ArrayList<class_3545<String, class_1799>> getStacks() {
            return this.stacks;
        }

        public int getCount() {
            return this.count;
        }

        public double getConcMod() {
            return this.concMod;
        }

        public double getSortMod() {
            return this.sortMod;
        }

        public int getAugmentConc(class_3222 player) {
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
            int adaptability = profile.getAugmentLevel(ArcanaAugments.ADAPTABILITY.id);
            int augmentConc = 0;
            for (Map.Entry<ArcanaAugment, Integer> entry : this.augments.entrySet()) {
                ArcanaAugment aug = entry.getKey();
                int itemLvl = entry.getValue();
                int profileLvl = profile.getAugmentLevel(aug.id);
                augmentConc += Math.max(0, itemLvl - profileLvl);
            }
            return Math.max(0, augmentConc - adaptability);
        }

        public double getFocusedConcMod(class_3222 player) {
            block7: {
                int focus;
                block6: {
                    IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
                    focus = profile.getAugmentLevel(ArcanaAugments.FOCUS.id);
                    if (focus == 1) {
                        boolean isEChest = false;
                        boolean isShulker = false;
                        for (ArcanaItemContainer container : this.containers) {
                            if (container.getContainerName().equals("Ender Chest")) {
                                isEChest = true;
                                continue;
                            }
                            if (!container.getContainerName().equals("Shulker Box")) continue;
                            isShulker = true;
                        }
                        return isShulker && isEChest ? 0.0 : this.getConcMod();
                    }
                    if (focus != 2) break block6;
                    for (ArcanaItemContainer container : this.containers) {
                        if (!container.getContainerName().equals("Ender Chest")) continue;
                        return 0.0;
                    }
                    break block7;
                }
                if (focus != 3) break block7;
                for (ArcanaItemContainer container : this.containers) {
                    if (container.getContainerName().equals("Ender Chest")) {
                        return 0.0;
                    }
                    if (!container.getContainerName().equals("Shulker Box")) continue;
                    return 0.0;
                }
            }
            return this.getConcMod();
        }

        public String getShortContainerString() {
            if (this.containers.isEmpty()) {
                return "Inv";
            }
            StringBuilder str = new StringBuilder();
            for (ArcanaItemContainer container : this.containers) {
                str.append(container.getConcModStr()).append("+");
            }
            return str.substring(0, str.length() - 1);
        }

        public String getContainerString() {
            if (this.containers.isEmpty()) {
                return "";
            }
            StringBuilder str = new StringBuilder("[");
            for (ArcanaItemContainer container : this.containers) {
                str.append(container.getContainerName()).append(" + ");
            }
            if (str.length() > 30) {
                return "[" + this.getShortContainerString() + "]";
            }
            return str.substring(0, str.length() - 3) + "]";
        }

        public TreeMap<ArcanaAugment, Integer> getAugments() {
            return this.augments;
        }
    }
}

