/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2588;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    public List<IConfigValue> values;
    private final File file;
    private final Logger logger;

    public ConfigUtils(File file, Logger logger, List<IConfigValue> values) {
        this.file = file;
        this.logger = logger;
        this.values = values;
        this.read();
        this.save();
    }

    public void read() {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));){
            this.logger.debug("Reading Arcana Novum config...");
            for (IConfigValue value2 : this.values) {
                value2.value = value2.defaultValue;
            }
            while (input.ready()) {
                char firstChar;
                String configLine = input.readLine();
                String trimmed = configLine.trim();
                if (trimmed.isEmpty() || (firstChar = trimmed.charAt(0)) == '!' || firstChar == '#' || !configLine.contains("=")) continue;
                int splitIndex = configLine.indexOf(61);
                String valueName = configLine.substring(0, splitIndex).strip();
                String valueValue = configLine.substring(splitIndex + 1).strip();
                for (IConfigValue value3 : this.values) {
                    if (!valueName.equals(value3.name)) continue;
                    Object defaultValue = value3.defaultValue;
                    try {
                        value3.value = value3.getFromString(valueValue);
                    }
                    catch (Exception e) {
                        value3.value = defaultValue;
                    }
                }
            }
        }
        catch (FileNotFoundException ignored) {
            this.logger.debug("Initialising Arcana Novum config...");
            this.values.forEach(value -> {
                value.value = value.defaultValue;
            });
        }
        catch (IOException e) {
            this.logger.fatal("Failed to load Arcana Novum config file!");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.fatal("Failed to parse Arcana Novum config");
            e.printStackTrace();
        }
    }

    public void save() {
        this.logger.debug("Updating Arcana Novum config...");
        try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.file)));){
            output.write("# Arcana Novum Configuration File | " + String.valueOf(new Date()));
            output.newLine();
            output.newLine();
            for (IConfigValue value : this.values) {
                if (value.comment != null) {
                    output.write("# " + value.comment);
                    output.newLine();
                }
                output.write(value.name + " = " + String.valueOf(value.value));
                output.newLine();
            }
        }
        catch (IOException e) {
            this.logger.fatal("Failed to save Arcana Novum config file!");
            e.printStackTrace();
        }
    }

    public LiteralArgumentBuilder<class_2168> generateCommand() {
        LiteralArgumentBuilder out = (LiteralArgumentBuilder)class_2170.method_9247((String)"arcana").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(4))).executes(ctx -> {
            this.values.stream().filter(v -> v.command != null).forEach(value -> ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.getterText, null, (Object[])new String[]{String.valueOf(value.value.toString())})), false));
            return 1;
        }));
        this.values.stream().filter(v -> v.command != null).forEach(value -> out.then(class_2170.method_9247((String)"config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)value.name).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.getterText, null, (Object[])new String[]{String.valueOf(value.value.toString())})), false);
            return 1;
        })).then(class_2170.method_9244((String)value.name, value.getArgumentType()).suggests(value::getSuggestions).executes(ctx -> {
            value.value = value.parseArgumentValue((CommandContext<class_2168>)ctx);
            ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.setterText, null, (Object[])new String[]{String.valueOf(value.value.toString())})), true);
            this.save();
            return 1;
        })))));
        return out;
    }

    public Object getValue(String name) {
        return this.values.stream().filter(value -> value.name.equals(name)).findFirst().map(iConfigValue -> iConfigValue.value).orElse(null);
    }

    public static <K extends Enum<K>> CompletableFuture<Suggestions> getEnumSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder, Class<K> enumClass) {
        HashSet<String> options = new HashSet<String>();
        for (Enum k : EnumSet.allOf(enumClass)) {
            options.add(((class_3542)k).method_15434());
        }
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static <K extends Enum<K>> K parseEnum(String string, Class<K> enumClass) {
        Optional<Enum> opt = EnumSet.allOf(enumClass).stream().filter(en -> ((class_3542)en).method_15434().equals(string)).findFirst();
        return (K)((Enum)opt.orElse(null));
    }

    public static abstract class IConfigValue<T> {
        protected final T defaultValue;
        protected final String name;
        protected final String comment;
        protected final Command command;
        protected T value;

        public IConfigValue(@NotNull String name, T defaultValue, @Nullable String comment, @Nullable Command command) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.comment = comment;
            this.command = command;
        }

        public String getName() {
            return this.name;
        }

        public abstract T getFromString(String var1);

        public abstract ArgumentType<?> getArgumentType();

        public abstract T parseArgumentValue(CommandContext<class_2168> var1);

        public abstract CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> var1, SuggestionsBuilder var2);
    }

    public static class Command {
        protected String setterText;
        protected String getterText;
        protected String errorText;

        public Command(String getterText, String setterText, @Nullable String errorText) {
            this.getterText = getterText;
            this.setterText = setterText;
            this.errorText = errorText;
        }

        public Command(String getterText, String setterText) {
            this(getterText, setterText, null);
        }
    }

    public static class EnumConfigValue<K extends Enum<K>>
    extends IConfigValue<K> {
        protected final K defaultValue;
        private final Class<K> typeClass;

        public EnumConfigValue(@NotNull String name, K defaultValue, @Nullable String comment, @Nullable Command command, Class<K> typeClass) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
            this.typeClass = typeClass;
        }

        public EnumConfigValue(@NotNull String name, K defaultValue, @Nullable Command command, Class<K> typeClass) {
            this(name, defaultValue, null, command, typeClass);
        }

        @Override
        public K getFromString(String value) {
            for (Enum k : EnumSet.allOf(this.typeClass)) {
                if (!((class_3542)k).method_15434().equalsIgnoreCase(value)) continue;
                return (K)k;
            }
            throw new IllegalArgumentException("Could not map " + value + " to enum " + this.typeClass.getName());
        }

        @Override
        public ArgumentType<String> getArgumentType() {
            return StringArgumentType.string();
        }

        @Override
        public K parseArgumentValue(CommandContext<class_2168> ctx) {
            String parsedString = StringArgumentType.getString(ctx, (String)this.name);
            return Enum.valueOf(this.typeClass, parsedString);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            HashSet<String> options = new HashSet<String>();
            for (Enum k : EnumSet.allOf(this.typeClass)) {
                options.add(((class_3542)k).method_15434());
            }
            String start = builder.getRemaining().toLowerCase(Locale.ROOT);
            options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }

    public static class StringConfigValue
    extends IConfigValue<String> {
        protected final String defaultValue;
        protected final String[] options;

        public StringConfigValue(@NotNull String name, String defaultValue, @Nullable String comment, @Nullable Command command, String ... options) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
            this.options = options;
        }

        @Override
        public String getFromString(String value) {
            return value;
        }

        @Override
        public ArgumentType<String> getArgumentType() {
            return StringArgumentType.greedyString();
        }

        @Override
        public String parseArgumentValue(CommandContext<class_2168> ctx) {
            return StringArgumentType.getString(ctx, (String)this.name);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            String start = builder.getRemaining().toLowerCase(Locale.ROOT);
            Arrays.stream(this.options).filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }

    public static class BooleanConfigValue
    extends IConfigValue<Boolean> {
        protected final boolean defaultValue;

        public BooleanConfigValue(@NotNull String name, boolean defaultValue, @Nullable String comment, @Nullable Command command) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
        }

        @Override
        public Boolean getFromString(String value) {
            return Boolean.parseBoolean(value);
        }

        @Override
        public ArgumentType<Boolean> getArgumentType() {
            return BoolArgumentType.bool();
        }

        @Override
        public Boolean parseArgumentValue(CommandContext<class_2168> ctx) {
            return BoolArgumentType.getBool(ctx, (String)this.name);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            HashSet<String> options = new HashSet<String>();
            options.add("true");
            options.add("false");
            String start = builder.getRemaining().toLowerCase(Locale.ROOT);
            options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }

    public static class IntegerConfigValue
    extends IConfigValue<Integer> {
        protected final int defaultValue;
        private final IntLimits limits;

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable String comment, @Nullable Command command) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
            this.limits = limits;
        }

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable Command command) {
            this(name, defaultValue, limits, null, command);
        }

        @Override
        public Integer getFromString(String value) {
            return Integer.parseInt(value);
        }

        @Override
        public ArgumentType<Integer> getArgumentType() {
            return IntegerArgumentType.integer((int)this.limits.min, (int)this.limits.max);
        }

        @Override
        public Integer parseArgumentValue(CommandContext<class_2168> ctx) {
            return IntegerArgumentType.getInteger(ctx, (String)this.name);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            if (this.limits.max - this.limits.min < 10000) {
                String start = builder.getRemaining().toLowerCase(Locale.ROOT);
                HashSet<String> nums = new HashSet<String>();
                for (int i = this.limits.min; i <= this.limits.max; ++i) {
                    nums.add(String.valueOf(i));
                }
                nums.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.buildFuture();
        }

        public static class IntLimits {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;

            public IntLimits() {
            }

            public IntLimits(int min) {
                this.min = min;
            }

            public IntLimits(int min, int max) {
                this.min = min;
                this.max = max;
            }
        }
    }
}

