/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TreeNode<T> {
    private final T data;
    private Set<TreeNode<T>> children;
    private TreeNode<T> parent;

    public TreeNode(T data, Set<TreeNode<T>> children, @Nullable TreeNode<T> parent) {
        this.data = data;
        this.children = children;
        this.parent = parent;
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Set<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void addChild(TreeNode<T> child) {
        this.children.add(child);
    }

    public void removeChild(TreeNode<T> child) {
        this.children.remove(child);
    }

    public TreeNode<?> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public T getData() {
        return this.data;
    }

    public int countAllDescendants() {
        int count = 0;
        ArrayList<TreeNode<T>> nodes = new ArrayList<TreeNode<T>>(this.children);
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            nodes.addAll(((TreeNode)iter.next()).children);
            iter.remove();
            ++count;
        }
        return count;
    }

    public List<TreeNode<T>> getAllLeaves(List<TreeNode<T>> list) {
        if (this.isLeaf()) {
            list.add(this);
        } else {
            for (TreeNode<T> child : this.children) {
                child.getAllLeaves(list);
            }
        }
        return list;
    }

    public List<TreeNode<T>> getAllNodes(List<TreeNode<T>> list) {
        list.add(this);
        for (TreeNode<T> child : this.children) {
            child.getAllNodes(list);
        }
        return list;
    }
}

