/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.achievements;

import java.util.ArrayList;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public abstract class ArcanaAchievement {
    public final String name;
    public final String id;
    public final int type;
    private boolean acquired;
    private final class_1799 displayItem;
    private final ArcanaItem arcanaItem;
    private final String[] description;
    public final int xpReward;
    public final int pointsReward;

    protected ArcanaAchievement(String name, String id, int type, class_1799 displayItem, ArcanaItem arcanaItem, int xpReward, int pointsReward, String[] description) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.displayItem = displayItem;
        this.arcanaItem = arcanaItem;
        this.description = description;
        this.xpReward = xpReward;
        this.pointsReward = pointsReward;
        this.acquired = false;
    }

    public String getTranslationKey() {
        return "achievement.arcananovum.name." + this.id;
    }

    public class_5250 getTranslatedName() {
        return class_2561.method_48321((String)this.getTranslationKey(), (String)this.name);
    }

    protected void setAcquired(boolean acquired) {
        this.acquired = acquired;
    }

    public boolean isAcquired() {
        return this.acquired;
    }

    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public ArcanaItem getArcanaItem() {
        return this.arcanaItem;
    }

    public String[] getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public abstract class_2487 toNbt();

    public abstract ArcanaAchievement fromNbt(String var1, class_2487 var2);

    public abstract class_5250[] getStatusDisplay(class_3222 var1);

    public abstract ArcanaAchievement makeNew();

    public void announceAcquired(class_3222 player) {
        StringBuilder descriptionText = new StringBuilder();
        for (String d : this.description) {
            descriptionText.append("\n").append(d);
        }
        MinecraftServer server = player.method_5682();
        if (server != null) {
            ArrayList<class_5250> msgs = new ArrayList<class_5250>();
            if (this.id.equals(ArcanaAchievements.ALL_ACHIEVEMENTS.id)) {
                msgs.add(class_2561.method_43470((String)"=============================================").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076}));
                msgs.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"=== ").method_27695(new class_124[]{class_124.field_1051, class_124.field_1067, class_124.field_1074})).method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has mastered all Arcana Achievements and became ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"[").method_10852((class_2561)this.getTranslatedName()).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)this.getTranslatedName().method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)descriptionText.toString()).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("\n" + LevelUtils.readableInt(this.xpReward))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" XP").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)("" + this.pointsReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" Skill Points").method_27692(class_124.field_1062))))).method_10977(class_124.field_1062).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"!!!").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" ===").method_27695(new class_124[]{class_124.field_1051, class_124.field_1067, class_124.field_1074})));
                msgs.add(class_2561.method_43470((String)"=============================================").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076}));
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15195, (float)1.0f, (float)1.0f);
            } else if (this.pointsReward >= 5) {
                msgs.add(class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has made the Arcana Achievement ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"[").method_10852((class_2561)this.getTranslatedName()).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)this.getTranslatedName().method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)descriptionText.toString()).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("\n" + LevelUtils.readableInt(this.xpReward))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" XP").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)("" + this.pointsReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" Skill Points").method_27692(class_124.field_1062))))).method_10977(class_124.field_1062).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"!!!").method_27692(class_124.field_1064)));
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15195, (float)1.0f, (float)1.0f);
            } else {
                msgs.add(class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has made the Arcana Achievement ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"[").method_10852((class_2561)this.getTranslatedName()).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)this.getTranslatedName().method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)descriptionText.toString()).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("\n" + LevelUtils.readableInt(this.xpReward))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" XP").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)("" + this.pointsReward)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" Skill Points").method_27692(class_124.field_1062))))).method_10977(class_124.field_1075))).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1076)));
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14709, (float)1.0f, (float)1.0f);
            }
            if (ArcanaConfig.getBoolean(ArcanaRegistry.ANNOUNCE_ACHIEVEMENTS)) {
                for (class_5250 msg : msgs) {
                    server.method_3760().method_43514((class_2561)msg, false);
                }
            } else {
                for (class_5250 msg : msgs) {
                    player.method_7353((class_2561)msg, false);
                }
            }
        }
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        profile.addXP(this.xpReward);
        boolean abyssCheck = true;
        for (ArcanaAchievement achievement : ArcanaAchievements.registry.values()) {
            if (ArcanaAchievements.excludedAchievements.contains(achievement) || profile.hasAcheivement(achievement.getArcanaItem().getId(), achievement.id)) continue;
            abyssCheck = false;
            break;
        }
        if (abyssCheck) {
            for (ArcanaAchievement achievement : ArcanaAchievements.excludedAchievements) {
                ArcanaAchievements.grant(player, achievement.id);
            }
        }
    }
}

