/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.ContinuumAnchor;
import net.borisshoes.arcananovum.callbacks.XPLoginCallback;
import net.borisshoes.arcananovum.callbacks.login.AnchorTimeLoginCallback;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.ExoticMatter;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.callbacks.LoginCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ContinuumAnchorBlockEntity
extends class_2621
implements PolymerObject,
ArcanaBlockEntity,
class_1278,
class_1265 {
    private static final double[] anchorEfficiency = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.5};
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private boolean synthetic;
    private String customName;
    private int fuel;
    private boolean active;
    private class_1277 inventory = new class_1277(this.method_5439());

    public ContinuumAnchorBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.CONTINUUM_ANCHOR_BLOCK_ENTITY, pos, state);
        this.inventory.method_5489((class_1265)this);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, boolean synthetic, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.synthetic = synthetic;
        this.customName = customName == null ? "" : customName;
        this.fuel = 0;
        this.active = false;
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    public class_1799 getFuelStack() {
        return this.inventory.method_5438(0);
    }

    public int getFuel() {
        return this.fuel;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.CONTINUUM_ANCHOR;
    }

    public boolean interact(class_1657 player, class_1799 stack) {
        if (!this.inventory.method_5442() && stack.method_7960()) {
            this.fuel = 0;
            class_1799 returnStack = this.getFuelStack().method_7972();
            this.inventory.method_5447(0, class_1799.field_8037);
            this.method_5431();
            if (!player.method_7270(returnStack)) {
                class_1542 itemEntity = player.method_7328(returnStack, false);
                if (itemEntity == null) {
                    return true;
                }
                itemEntity.method_6975();
                itemEntity.method_48349(player.method_5667());
            }
            return true;
        }
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
        if (this.inventory.method_5442() && arcanaItem instanceof ExoticMatter) {
            ExoticMatter matter = (ExoticMatter)arcanaItem;
            this.fuel = matter.getEnergy(stack);
            this.inventory.method_5491(stack.method_7972());
            player.method_31548().method_7378(stack);
            this.method_5431();
            return true;
        }
        return false;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof ContinuumAnchorBlockEntity) {
            ContinuumAnchorBlockEntity anchor = (ContinuumAnchorBlockEntity)e;
            anchor.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (serverWorld.method_8503().method_3780() % 5 == 0) {
            boolean prevActive = this.active;
            boolean bl = this.active = !serverWorld.method_49803(this.field_11867) && this.fuel > 0;
            if (this.fuel <= 0 && !this.inventory.method_5442()) {
                this.inventory.method_5448();
            }
            if (this.active && serverWorld.method_8503().method_3780() % 20 == 0) {
                int lvl = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.TEMPORAL_RELATIVITY.id);
                if (Math.random() >= anchorEfficiency[lvl]) {
                    this.fuel = Math.max(0, this.fuel - 1);
                    ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(this.getFuelStack());
                    if (arcanaItem instanceof ExoticMatter) {
                        ExoticMatter matter = (ExoticMatter)arcanaItem;
                        matter.setFuel(this.getFuelStack(), this.fuel);
                        this.method_5431();
                    }
                }
                if (this.crafterId != null && !this.crafterId.isEmpty()) {
                    class_3222 player = serverWorld.method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)this.crafterId));
                    if (player == null) {
                        BorisLib.addLoginCallback((LoginCallback)new AnchorTimeLoginCallback(serverWorld.method_8503(), this.crafterId, 1));
                        if (serverWorld.method_8503().method_3780() % 1200 == 0) {
                            BorisLib.addLoginCallback((LoginCallback)new XPLoginCallback(serverWorld.method_8503(), this.crafterId, ArcanaConfig.getInt(ArcanaRegistry.CONTINUUM_ANCHOR_PER_MINUTE)));
                        }
                    } else {
                        ArcanaAchievements.progress(player, ArcanaAchievements.TIMEY_WIMEY.id, 1);
                        if (serverWorld.method_8503().method_3780() % 1200 == 0) {
                            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CONTINUUM_ANCHOR_PER_MINUTE));
                        }
                    }
                }
            }
            int fuelMarks = (int)Math.min(Math.ceil(4.0 * (double)this.fuel / 600000.0), 4.0);
            class_2680 blockState = (class_2680)((class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)ContinuumAnchor.ContinuumAnchorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active))).method_11657((class_2769)ContinuumAnchor.ContinuumAnchorBlock.CHARGES, (Comparable)Integer.valueOf(fuelMarks));
            this.field_11863.method_8652(this.field_11867, blockState, 3);
            if (prevActive && !this.active) {
                ArcanaNovum.removeActiveAnchor(serverWorld, this.field_11867);
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.field_11867, (class_6880.class_6883)class_3417.field_23117, (class_3419)class_3419.field_15245, (float)1.0f, (float)1.5f);
            } else if (!prevActive && this.active) {
                ArcanaNovum.addActiveAnchor(serverWorld, this.field_11867);
                SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.field_11867, (class_3414)class_3417.field_23116, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.7f);
                ContinuumAnchor.loadChunks(serverWorld, new class_1923(this.field_11867));
            }
            this.method_5431();
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.active) {
            ContinuumAnchor.loadChunks(serverWorld, new class_1923(this.field_11867));
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ArcanaNovum.removeActiveAnchor(serverWorld, pos);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.synthetic = view.method_71433("synthetic", false);
        this.fuel = view.method_71424("fuel", 0);
        this.active = view.method_71433("active", false);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
        this.inventory = new class_1277(this.method_5439());
        if (!this.method_54871(view)) {
            class_1262.method_5429((class_11368)view, (class_2371)this.inventory.method_54454());
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71472("synthetic", this.synthetic);
        view.method_71465("fuel", this.fuel);
        view.method_71472("active", this.active);
        if (!this.method_54872(view)) {
            class_1262.method_5426((class_11372)view, (class_2371)this.inventory.method_54454());
        }
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"Continuum Anchor");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory.method_54454();
    }

    protected void method_11281(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.method_5447(i, (class_1799)list.get(i));
        }
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public int method_5439() {
        return 1;
    }

    public void method_5453(class_1263 sender) {
    }
}

