/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltar;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.altars.StarpathAltarGui;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.SpawnPile;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;

public class StarpathAltarBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    public static final class_1792 COST = class_1802.field_8449;
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private boolean synthetic;
    private String customName;
    private int cooldown;
    private class_2338 targetCoords;
    private Map<String, class_2338> savedTargets;
    private int activeTicks;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.STARPATH_ALTAR)).getMultiblock();

    public StarpathAltarBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.STARPATH_ALTAR_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, boolean synthetic, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.synthetic = synthetic;
        this.customName = customName == null ? "" : customName;
        this.targetCoords = this.method_11016().method_25503();
        this.activeTicks = 0;
        this.savedTargets = new HashMap<String, class_2338>();
        this.resetCooldown();
    }

    public Map<String, class_2338> getSavedTargets() {
        return this.savedTargets;
    }

    public void openGui(class_3222 player) {
        if (this.isActive()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"You cannot access an active Altar").method_27692(class_124.field_1061));
            return;
        }
        StarpathAltarGui gui = new StarpathAltarGui(player, this);
        gui.build();
        gui.open();
    }

    private void teleport(@Nullable class_3222 player) {
        int i;
        ArrayList<Object> locations;
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_238 teleportBox = new class_238(this.method_11016().method_10069(0, 2, 0)).method_1009(5.0, 2.0, 5.0);
        List targets = this.method_10997().method_8390(class_1309.class, teleportBox, e -> true);
        int tries = 0;
        int range = 4;
        int height = 2;
        do {
            locations = SpawnPile.makeSpawnLocations(targets.size(), range, this.getTargetCoords().method_10264() + height, serverWorld, this.getTargetCoords());
            ++range;
            height += 16;
        } while (locations.size() != targets.size() && ++tries < 5);
        if (locations.size() != targets.size()) {
            for (class_1309 target : targets) {
                if (!(target instanceof class_3222)) continue;
                class_3222 targetPlayer = (class_3222)target;
                targetPlayer.method_7353((class_2561)class_2561.method_43470((String)"The teleport goes awry, everyone is shunted uncontrollably!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
            }
            locations = new ArrayList();
            for (i = 0; i < targets.size(); ++i) {
                locations.add(this.getTargetCoords());
            }
        }
        for (i = 0; i < targets.size(); ++i) {
            class_1321 tameable;
            class_1309 target;
            target = (class_1309)targets.get(i);
            class_2338 location = (class_2338)locations.get(i);
            target.method_5731(new class_5454(serverWorld, location.method_46558(), class_243.field_1353, target.method_36454(), target.method_36455(), class_5454.field_52247));
            ArcanaEffectUtils.recallTeleport(serverWorld, target.method_19538());
            if (target instanceof class_3222) {
                class_3222 p = (class_3222)target;
                if (Math.sqrt(this.method_11016().method_10262((class_2382)this.getTargetCoords())) >= 100000.0) {
                    ArcanaAchievements.grant(p, ArcanaAchievements.FAR_FROM_HOME.id);
                }
            }
            if (player == null || (!(target instanceof class_1321) || !(tameable = (class_1321)target).method_6171((class_1309)player)) && (!(target instanceof class_3222) || target == player) || !targets.contains(player)) continue;
            ArcanaAchievements.grant(player, ArcanaAchievements.ADVENTURING_PARTY.id);
        }
        SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.getTargetCoords(), (class_3414)class_3417.field_14716, (class_3419)class_3419.field_15245, (float)2.0f, (float)1.5f);
    }

    public boolean startTeleport(@Nullable class_3222 player) {
        class_1657 crafter;
        class_1937 class_19372;
        if (this.getCooldown() > 0 || !((class_19372 = this.method_10997()) instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (player == null && this.getCrafterId() != null && (crafter = serverWorld.method_18470(AlgoUtils.getUUID((String)this.getCrafterId()))) instanceof class_3222) {
            player = (class_3222)crafter;
        }
        @Nullable class_3222 finalPlayer = player;
        this.setActiveTicks(500);
        this.resetCooldown();
        ArcanaEffectUtils.starpathAltarAnim(serverWorld, this.method_11016().method_46558());
        BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(500, () -> {
            this.teleport(finalPlayer);
            if (finalPlayer != null) {
                ArcanaNovum.data((class_1657)finalPlayer).addXP(ArcanaConfig.getInt(ArcanaRegistry.STARPATH_ALTAR_ACTIVATE));
            }
        }));
        return true;
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof StarpathAltarBlockEntity) {
            StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)e;
            altar.tick();
        }
    }

    public int calculateCost() {
        class_2338.class_2339 origin = this.method_11016().method_25503();
        class_2338.class_2339 target = this.targetCoords.method_25503();
        int multiplier = ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.ASTRAL_PATHFINDER.id);
        int blocksPerUnit = 64 * (1 << multiplier);
        return Math.max(1, (int)(Math.sqrt(origin.method_10262((class_2382)target)) / (double)blocksPerUnit));
    }

    @Override
    public boolean isAssembled() {
        return this.multiblock.matches(this.getMultiblockCheck());
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.STARPATH_ALTAR)).getCheckOffset()), null);
    }

    private void tick() {
        boolean shouldBeActivatable;
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.isAssembled() && this.cooldown > 0) {
            --this.cooldown;
        }
        boolean isActive = this.isActive();
        for (class_2338 blockPos : class_2338.method_25996((class_2338)this.field_11867, (int)4, (int)0, (int)4)) {
            class_2680 state = this.field_11863.method_8320(blockPos);
            if (!state.method_27852(class_2246.field_37570) && !blockPos.equals((Object)this.field_11867) || (Boolean)state.method_11654((class_2769)class_2741.field_37651) == isActive) continue;
            this.field_11863.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_37651, (Comparable)Boolean.valueOf(isActive)), 3);
        }
        if (isActive) {
            --this.activeTicks;
        }
        this.method_5431();
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.isAssembled()) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE).orElse(false);
        boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
        if (activatable ^ shouldBeActivatable) {
            serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
        }
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public void setActiveTicks(int ticks) {
        this.activeTicks = ticks;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            boolean shouldBeActivatable;
            class_3218 serverWorld = (class_3218)class_19372;
            boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE).orElse(false);
            boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
            if (activatable ^ shouldBeActivatable) {
                serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)StarpathAltar.StarpathAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
            }
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void resetCooldown() {
        this.cooldown = 36000 - ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.CONSTELLATION_DRIFT.id) * 6000;
    }

    public void setTargetCoords(class_2338 pos) {
        this.targetCoords = pos.method_25503();
    }

    public void setTargetCoords(int x, int y, int z) {
        this.targetCoords = new class_2338(x, y, z);
    }

    public class_2338 getTargetCoords() {
        if (this.targetCoords == null) {
            this.targetCoords = this.method_11016();
        }
        return this.targetCoords;
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.STARPATH_ALTAR;
    }

    public class_2499 writeTargets() {
        if (this.savedTargets != null) {
            class_2499 targetList = new class_2499();
            for (Map.Entry<String, class_2338> entry : this.savedTargets.entrySet()) {
                class_2487 target = new class_2487();
                target.method_10582("name", entry.getKey());
                target.method_10569("x", entry.getValue().method_10263());
                target.method_10569("y", entry.getValue().method_10264());
                target.method_10569("z", entry.getValue().method_10260());
                targetList.add((Object)target);
            }
            return targetList;
        }
        return new class_2499();
    }

    public void readTargets(class_2499 targetList) {
        this.savedTargets = new HashMap<String, class_2338>();
        for (class_2520 e : targetList) {
            class_2487 target = (class_2487)e;
            this.savedTargets.put(target.method_68564("name", ""), new class_2338(target.method_68083("x", 0), target.method_68083("y", 0), target.method_68083("z", 0)));
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.synthetic = view.method_71433("synthetic", false);
        this.cooldown = view.method_71424("cooldown", 0);
        this.targetCoords = this.method_11016();
        view.method_71426("target", class_2338.field_25064).ifPresent(data -> {
            this.targetCoords = data;
        });
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
        view.method_71426("targets", StarpathTargets.CODEC).ifPresent(targets -> {
            this.savedTargets = targets.targets();
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71472("synthetic", this.synthetic);
        view.method_71465("cooldown", this.cooldown);
        view.method_71477("target", class_2338.field_25064, (Object)this.targetCoords);
        view.method_71477("targets", StarpathTargets.CODEC, (Object)new StarpathTargets(this.savedTargets));
    }

    public record StarpathTargets(Map<String, class_2338> targets) {
        private static final Codec<TargetEntry> ENTRY_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("name").forGetter(TargetEntry::name), (App)Codec.INT.fieldOf("x").forGetter(TargetEntry::x), (App)Codec.INT.fieldOf("y").forGetter(TargetEntry::y), (App)Codec.INT.fieldOf("z").forGetter(TargetEntry::z)).apply((Applicative)i, TargetEntry::new));
        public static final Codec<StarpathTargets> CODEC = ENTRY_CODEC.listOf().xmap(list -> {
            HashMap<String, class_2338> map = new HashMap<String, class_2338>();
            for (TargetEntry e : list) {
                map.put(e.name(), new class_2338(e.x(), e.y(), e.z()));
            }
            return new StarpathTargets(map);
        }, sp -> {
            ArrayList out = new ArrayList(sp.targets.size());
            sp.targets.forEach((name, pos) -> out.add(new TargetEntry((String)name, pos.method_10263(), pos.method_10264(), pos.method_10260())));
            return out;
        });

        public StarpathTargets {
            if (targets == null) {
                targets = new HashMap<String, class_2338>();
            }
        }

        private record TargetEntry(String name, int x, int y, int z) {
        }
    }
}

