/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.altars;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StormcallerAltar;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.altars.StormcallerAltarGui;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class StormcallerAltarBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    public static final int[] DURATIONS = new int[]{-1, 2, 4, 6, 8, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60};
    public static final class_3545<class_1792, Integer> COST = new class_3545((Object)class_1802.field_8603, (Object)1);
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private boolean synthetic;
    private String customName;
    private int cooldown;
    private int mode = 0;
    private int duration = 0;
    private boolean active;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.STORMCALLER_ALTAR)).getMultiblock();

    public StormcallerAltarBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.STORMCALLER_ALTAR_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, boolean synthetic, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.synthetic = synthetic;
        this.customName = customName == null ? "" : customName;
        this.mode = 0;
        this.duration = 0;
        this.resetCooldown();
    }

    private void changeWeather(@Nullable class_3222 player) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int duration = this.getDuration();
        int mode = this.getMode();
        SoundUtils.playSound((class_1937)serverWorld, (class_2338)this.method_11016(), (class_3414)class_3417.field_14981, (class_3419)class_3419.field_15245, (float)1.0f, (float)0.5f);
        int dur = DURATIONS[duration];
        switch (mode) {
            case 0: {
                int n;
                if (dur == -1) {
                    n = class_3218.field_41749.method_35008(serverWorld.method_8409());
                    break;
                }
                n = dur * 3600;
                break;
            }
            case 1: {
                int n;
                if (dur == -1) {
                    n = class_3218.field_41750.method_35008(serverWorld.method_8409());
                    break;
                }
                n = dur * 1200;
                break;
            }
            case 2: {
                int n;
                if (dur == -1) {
                    n = class_3218.field_41751.method_35008(serverWorld.method_8409());
                    break;
                }
                n = dur * 600;
                break;
            }
            default: {
                int n = dur = dur;
            }
        }
        if (mode == 0 && serverWorld.method_8419() && player != null) {
            ArcanaAchievements.grant(player, ArcanaAchievements.COME_AGAIN_RAIN.id);
        }
        serverWorld.method_27910(mode == 0 ? dur : 0, mode >= 1 ? dur : 0, mode >= 1, mode == 2);
        this.field_11863.method_43276((class_6880)class_5712.field_28174, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        this.setActive(false);
    }

    public boolean startWeatherChange(@Nullable class_3222 player) {
        class_1657 crafter;
        class_1937 class_19372;
        if (this.getCooldown() > 0 || !((class_19372 = this.method_10997()) instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (player == null && this.getCrafterId() != null && (crafter = serverWorld.method_18470(AlgoUtils.getUUID((String)this.getCrafterId()))) instanceof class_3222) {
            player = (class_3222)crafter;
        }
        @Nullable class_3222 finalPlayer = player;
        this.resetCooldown();
        this.setActive(true);
        ArcanaEffectUtils.stormcallerAltarAnim(serverWorld, this.method_11016().method_46558(), 0);
        BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(100, () -> {
            this.changeWeather(finalPlayer);
            if (finalPlayer != null) {
                ArcanaNovum.data((class_1657)finalPlayer).addXP(ArcanaConfig.getInt(ArcanaRegistry.STORMCALLER_ALTAR_ACTIVATE));
            }
        }));
        return true;
    }

    public void openGui(class_3222 player) {
        if (this.active) {
            player.method_64398((class_2561)class_2561.method_43470((String)"You cannot access an active Altar").method_27692(class_124.field_1061));
            return;
        }
        StormcallerAltarGui gui = new StormcallerAltarGui(player, this);
        gui.build();
        gui.open();
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof StormcallerAltarBlockEntity) {
            StormcallerAltarBlockEntity altar = (StormcallerAltarBlockEntity)e;
            altar.tick();
        }
    }

    @Override
    public boolean isAssembled() {
        return this.multiblock.matches(this.getMultiblockCheck());
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.STORMCALLER_ALTAR)).getCheckOffset()), null);
    }

    private void tick() {
        boolean shouldBeActivatable;
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.isAssembled() && this.cooldown > 0) {
            --this.cooldown;
            this.method_5431();
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.isAssembled()) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
        boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)StormcallerAltar.StormcallerAltarBlock.ACTIVATABLE).orElse(false);
        boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
        if (activatable ^ shouldBeActivatable) {
            serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)StormcallerAltar.StormcallerAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            boolean shouldBeActivatable;
            class_3218 serverWorld = (class_3218)class_19372;
            boolean activatable = serverWorld.method_8320(this.field_11867).method_28500((class_2769)StormcallerAltar.StormcallerAltarBlock.ACTIVATABLE).orElse(false);
            boolean bl = shouldBeActivatable = this.cooldown <= 0 && this.isAssembled() && !this.isActive();
            if (activatable ^ shouldBeActivatable) {
                serverWorld.method_8652(this.field_11867, (class_2680)serverWorld.method_8320(this.field_11867).method_11657((class_2769)StormcallerAltar.StormcallerAltarBlock.ACTIVATABLE, (Comparable)Boolean.valueOf(shouldBeActivatable)), 2);
            }
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void resetCooldown() {
        this.cooldown = 36000 - ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.CLOUD_SEEDING.id) * 6000;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.STORMCALLER_ALTAR;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.synthetic = view.method_71433("synthetic", false);
        this.cooldown = view.method_71424("cooldown", 0);
        this.mode = view.method_71424("mode", 0);
        this.duration = view.method_71424("duration", 0);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71472("synthetic", this.synthetic);
        view.method_71465("cooldown", this.cooldown);
        view.method_71465("mode", this.mode);
        view.method_71465("duration", this.duration);
    }
}

