/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.RadiantFletcheryBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class RadiantFletchery
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "radiant_fletchery";
    private Multiblock multiblock;

    public RadiantFletchery() {
        this.id = ID;
        this.name = "Radiant Fletchery";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.FORGE};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_16310;
        this.block = new RadiantFletcheryBlock(class_4970.class_2251.method_9637().method_9629(2.5f, 1200.0f).method_9626(class_2498.field_11547));
        this.item = new RadiantFletcheryItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.radiant_fletchery", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.ADVANCEMENT_SHOOT_ARROW, ResearchTasks.ADVANCEMENT_OL_BETSY, ResearchTasks.OBTAIN_TIPPED_ARROW, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.ADVANCEMENT_BREW_POTION, ResearchTasks.UNLOCK_STARLIGHT_FORGE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" addon to the ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Fletchery ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"enables ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"efficient ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"creation of ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"tipped arrows").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Fletchery ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"also ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"unlocks ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"the ability to make ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        this.addForgeLore(lore);
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-1, -1, -1);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8183, 24);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8601, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8301, 8);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_16310, 8);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Radiant Fletchery").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nI have yet to put my Runic Matrix to good use. Fortunately, this might be my chance. The Matrix should be able to take on the effect of potions to boost the amount of Tipped Arrows I can make from a single ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Radiant Fletchery").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\npotion. The Arrows themselves could make an excellent candidate for use of the Matrix once I master more of its capabilities. Perhaps if I make an arrow out of a Matrix it could activate powerful effects upon hitting a target.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Radiant Fletchery").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nThe Fletchery boosts the amount of Tipped Arrows made per potion, as well as allowing non-lingering potions to be used.\n\nThe Fletchery also unlocks a host of Archery related recipes for the Starlight Forge.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class RadiantFletcheryBlock
    extends ArcanaPolymerBlockEntity {
        public RadiantFletcheryBlock(class_4970.class_2251 settings) {
            super(RadiantFletchery.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_16331.method_9564();
        }

        @Nullable
        public static RadiantFletcheryBlockEntity getEntity(class_1937 world, class_2338 pos) {
            RadiantFletcheryBlockEntity fletchery;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof RadiantFletcheryBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof RadiantFletcheryBlockEntity ? (fletchery = (RadiantFletcheryBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new RadiantFletcheryBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return RadiantFletcheryBlock.method_31618(type, ArcanaRegistry.RADIANT_FLETCHERY_BLOCK_ENTITY, RadiantFletcheryBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            RadiantFletcheryBlockEntity fletchery = (RadiantFletcheryBlockEntity)world.method_8321(pos);
            if (fletchery != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (fletchery.isAssembled()) {
                    if (StarlightForge.findActiveForge(player.method_51469(), pos) == null) {
                        player.method_64398((class_2561)class_2561.method_43470((String)"The Fletchery must be within the range of an active Starlight Forge"));
                    } else {
                        fletchery.openGui(player);
                        player.method_7357().method_62835(playerEntity.method_6047(), 1);
                        player.method_7357().method_62835(playerEntity.method_6079(), 1);
                    }
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    RadiantFletchery.this.multiblock.displayStructure(fletchery.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof RadiantFletcheryBlockEntity) {
                RadiantFletcheryBlockEntity fletchery = (RadiantFletcheryBlockEntity)entity;
                RadiantFletcheryBlock.initializeArcanaBlock(stack, fletchery);
            }
        }
    }

    public class RadiantFletcheryItem
    extends ArcanaPolymerBlockItem {
        public RadiantFletcheryItem(class_2248 block) {
            super(RadiantFletchery.this.getThis(), block, RadiantFletchery.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return RadiantFletchery.this.prefItem;
        }
    }
}

