/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.callbacks;

import io.github.ladysnake.pal.VanillaAbilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.ContinuumAnchor;
import net.borisshoes.arcananovum.bosses.BossFights;
import net.borisshoes.arcananovum.bosses.dragon.DragonBossFight;
import net.borisshoes.arcananovum.callbacks.ShieldTimerCallback;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.cardinalcomponents.IBossFightComponent;
import net.borisshoes.arcananovum.cardinalcomponents.WorldDataComponentInitializer;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.events.NulMementoEvent;
import net.borisshoes.arcananovum.items.LevitationHarness;
import net.borisshoes.arcananovum.items.NulMemento;
import net.borisshoes.arcananovum.items.ShulkerCore;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.Dialog;
import net.borisshoes.arcananovum.utils.DialogHelper;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.events.Event;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class TickCallback {
    public static void onTick(MinecraftServer server) {
        try {
            TickCallback.bossTickCheck(server);
            ArrayList<Object> toRemoveBlocks = new ArrayList<Object>();
            for (Map.Entry<class_3545<class_2586, ArcanaBlockEntity>, Integer> pair : ArcanaNovum.ACTIVE_ARCANA_BLOCKS.entrySet()) {
                if (pair.getValue() - 1 > 0) {
                    ArcanaNovum.ACTIVE_ARCANA_BLOCKS.put(pair.getKey(), (Integer)pair.getValue() - 1);
                    continue;
                }
                toRemoveBlocks.add(pair.getKey());
            }
            toRemoveBlocks.forEach((Consumer<Object>)((Consumer<class_3545>)ArcanaNovum.ACTIVE_ARCANA_BLOCKS::remove));
            List players = server.method_3760().method_14571();
            for (class_3222 player : players) {
                IArcanaProfileComponent arcaneProfile = ArcanaNovum.data((class_1657)player);
                class_1661 inv = player.method_31548();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    NulMemento nulMemento;
                    ArcanaItem arcanaItem;
                    class_1799 item = inv.method_5438(i);
                    boolean isArcane = ArcanaItemUtils.isArcane(item);
                    if (!isArcane) {
                        if (item.method_31573(ArcanaRegistry.ALL_ARCANA_ITEMS) && (arcanaItem = (ArcanaItem)ArcanaRegistry.ARCANA_ITEMS.method_63535(class_2960.method_60654((String)item.method_7909().toString()))) != null) {
                            inv.method_5447(i, arcanaItem.addCrafter(arcanaItem.getNewItem(), player.method_5845(), true, server));
                            item = inv.method_5438(i);
                        }
                        if (!item.method_57826(class_9334.field_49650)) continue;
                        class_9276 bundleComp = (class_9276)item.method_58694(class_9334.field_49650);
                        ArrayList<class_1799> newStacks = new ArrayList<class_1799>();
                        for (class_1799 invStack : bundleComp.method_57421()) {
                            invStack.method_7909().method_7888(invStack, player.method_51469(), (class_1297)player, null);
                            if (invStack.method_7960()) continue;
                            newStacks.add(invStack);
                        }
                        item.method_57379(class_9334.field_49650, (Object)new class_9276(newStacks));
                        continue;
                    }
                    arcanaItem = ArcanaItemUtils.identifyItem(item);
                    if (ArcanaItem.hasProperty(item, "uninitialized")) {
                        inv.method_5447(i, arcanaItem.addCrafter(arcanaItem.getNewItem(), player.method_5845(), true, server));
                        continue;
                    }
                    if (ArcanaItemUtils.needsVersionUpdate(item)) {
                        inv.method_5447(i, arcanaItem.updateItem(item, server));
                        ArcanaNovum.devPrint("Updating Item " + item.method_7964().getString());
                        continue;
                    }
                    if (arcanaItem instanceof ShulkerCore && player.method_23318() > 1610.0 && player.method_6088().containsKey(class_1294.field_5902)) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.MILE_HIGH.id);
                    }
                    if (server.method_3780() % 20 == 0 && arcanaItem.getRarity() == ArcanaRarity.DIVINE) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.GOD_BOON.id);
                    }
                    class_1799 finalItem = item;
                    if (!(arcanaItem instanceof NulMemento) || !(nulMemento = (NulMemento)arcanaItem).isActive(item) || i == 39 && !Event.getEventsOfType(NulMementoEvent.class).stream().noneMatch(event -> event.getPlayer().equals((Object)player) && ArcanaItem.getUUID(event.getMemento()).equals(ArcanaItem.getUUID(finalItem)))) continue;
                    ArcanaItem.putProperty(item, "active", false);
                }
                if (ArcanaItemUtils.hasItemInInventory((class_1657)player, class_1802.field_8840) && Math.random() < 7.5E-6) {
                    TickCallback.dragonEggDialog(player);
                }
                TickCallback.flightCheck(player);
                TickCallback.concCheck(server, player, arcaneProfile);
                ArcanaRegistry.AREA_EFFECTS.method_10220().forEach(areaEffectTracker -> areaEffectTracker.onTick(server));
                int quiverCD = ((class_2497)arcaneProfile.getMiscData("QuiverCD")).method_10701();
                if (quiverCD > 0) {
                    arcaneProfile.addMiscData("QuiverCD", (class_2520)class_2497.method_23247((int)(quiverCD - 1)));
                }
                if (arcaneProfile.getStoredOffhand().method_7960() || !player.method_6079().method_7960()) continue;
                arcaneProfile.restoreOffhand();
            }
            HashMap<class_3222, Float> shieldTotals = new HashMap<class_3222, Float>();
            for (TickTimerCallback callback : BorisLib.SERVER_TIMER_CALLBACKS) {
                if (!(callback instanceof ShieldTimerCallback)) continue;
                ShieldTimerCallback st = (ShieldTimerCallback)callback;
                if (shieldTotals.containsKey(st.getPlayer())) {
                    shieldTotals.put(st.getPlayer(), Float.valueOf(((Float)shieldTotals.get(st.getPlayer())).floatValue() + st.getHearts()));
                    if (!(((Float)shieldTotals.get(st.getPlayer())).floatValue() >= 200.0f) || !(st.getPlayer().method_6067() >= 200.0f)) continue;
                    ArcanaAchievements.grant(st.getPlayer(), ArcanaAchievements.BUILT_LIKE_TANK.id);
                    continue;
                }
                shieldTotals.put(st.getPlayer(), Float.valueOf(st.getHearts()));
            }
            ContinuumAnchor.updateLoadedChunks(server);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void bossTickCheck(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            class_3545<BossFights, class_2487> fight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)world)).getBossFight();
            if (fight == null || fight.method_15442() != BossFights.DRAGON) continue;
            DragonBossFight.tick(server, (class_2487)fight.method_15441());
        }
    }

    private static void concCheck(MinecraftServer server, class_3222 player, IArcanaProfileComponent arcaneProfile) {
        if (server.method_3780() % 80 != 0) {
            return;
        }
        int resolve = arcaneProfile.getAugmentLevel(ArcanaAugments.RESOLVE.id);
        int maxConc = LevelUtils.concFromXp(arcaneProfile.getXP(), resolve);
        int curConc = ArcanaItemUtils.getUsedConcentration(player);
        if (ArcanaItemUtils.countItemsTakingConc(player) >= 30) {
            ArcanaAchievements.grant(player, ArcanaAchievements.ARCANE_ADDICT.id);
        }
        if (curConc > maxConc && !player.method_68878() && !player.method_7325()) {
            int concTick = ((class_2497)arcaneProfile.getMiscData("concentration")).method_10701() + 1;
            if (ArcanaConfig.getBoolean(ArcanaRegistry.DO_CONCENTRATION_DAMAGE)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Your mind burns as your Arcana overwhelms you!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056, class_124.field_1067}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14545, (float)2.0f, (float)0.1f);
                player.method_64397(player.method_51469(), ArcanaDamageTypes.of((class_1937)player.method_51469(), ArcanaDamageTypes.CONCENTRATION), (float)(concTick * 2));
            }
            if (!player.method_29504()) {
                NulMemento nulMemento;
                class_1799 headStack;
                ArcanaItem arcanaItem;
                if (player.method_6032() <= 1.5f) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.CLOSE_CALL.id);
                }
                if ((arcanaItem = ArcanaItemUtils.identifyItem(headStack = player.method_6118(class_1304.field_6169))) instanceof NulMemento && !(nulMemento = (NulMemento)arcanaItem).isActive(headStack)) {
                    nulMemento.forgor(headStack, player);
                }
            } else {
                concTick = 0;
            }
            arcaneProfile.addMiscData("concentration", (class_2520)class_2497.method_23247((int)concTick));
        } else {
            arcaneProfile.addMiscData("concentration", (class_2520)class_2497.method_23247((int)0));
        }
    }

    private static void flightCheck(class_3222 player) {
        List<DragonBossFight.ReclaimState> reclaimStates;
        LevitationHarness harness;
        class_1799 item = player.method_6118(class_1304.field_6174);
        boolean harnessFly = false;
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
        if (arcanaItem instanceof LevitationHarness && (harness = (LevitationHarness)arcanaItem).getEnergy(item) > 0 && harness.getStall(item) == -1) {
            harnessFly = true;
        }
        if (ArcanaRegistry.LEVITATION_HARNESS_ABILITY.grants((class_1657)player, VanillaAbilities.ALLOW_FLYING) && !harnessFly) {
            ArcanaRegistry.LEVITATION_HARNESS_ABILITY.revokeFrom((class_1657)player, VanillaAbilities.ALLOW_FLYING);
        } else if (!ArcanaRegistry.LEVITATION_HARNESS_ABILITY.grants((class_1657)player, VanillaAbilities.ALLOW_FLYING) && harnessFly) {
            ArcanaRegistry.LEVITATION_HARNESS_ABILITY.grantTo((class_1657)player, VanillaAbilities.ALLOW_FLYING);
        }
        boolean dragonTowerFly = false;
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)player.method_5682().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight != null && bossFight.method_15442() == BossFights.DRAGON && (reclaimStates = DragonBossFight.getReclaimStates()) != null) {
            for (DragonBossFight.ReclaimState reclaimState : reclaimStates) {
                if (reclaimState.getPlayer() == null || !reclaimState.getPlayer().equals((Object)player)) continue;
                dragonTowerFly = true;
            }
        }
        if (ArcanaRegistry.DRAGON_TOWER_ABILITY.grants((class_1657)player, VanillaAbilities.ALLOW_FLYING) && !dragonTowerFly) {
            ArcanaRegistry.DRAGON_TOWER_ABILITY.revokeFrom((class_1657)player, VanillaAbilities.ALLOW_FLYING);
        } else if (!ArcanaRegistry.DRAGON_TOWER_ABILITY.grants((class_1657)player, VanillaAbilities.ALLOW_FLYING) && dragonTowerFly) {
            ArcanaRegistry.DRAGON_TOWER_ABILITY.grantTo((class_1657)player, VanillaAbilities.ALLOW_FLYING);
        }
    }

    public static void dragonEggDialog(class_3222 player) {
        ArrayList<Dialog> dialogOptions = new ArrayList<Dialog>();
        boolean[] conditions = new boolean[]{ArcanaNovum.data((class_1657)player).hasCrafted(ArcanaRegistry.NUL_MEMENTO), ArcanaNovum.data((class_1657)player).hasCrafted(ArcanaRegistry.AEQUALIS_SCIENTIA), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.PICKAXE_OF_CEPTYUS.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.NUL_MEMENTO.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.AEQUALIS_SCIENTIA.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.GREAVES_OF_GAIALTUS.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.SPEAR_OF_TENBROUS.getItem())};
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nINSOLENT INSECT! Do you intend to carry me as your trophy for all eternity!?").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nRelease me at once! And I will grant you a swift death for your defiance!").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI have been banished to this Egg more times than there are islands in my sky! My return is inevitable!").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nYou do not know what it means to suffer! Upon my return I shall teach you myself!").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nMark my words! When Nul oversteps and awakens Brims\u00fcth, you'll wish you had never helped that entitled brat!").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 0, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nThose mewling kids call themselves Gods... I AM THE TRUE ASCENDANT!! And one day, they will yield to me!").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 0, 1, 3));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nThat Old Fool left behind a pickaxe? Well, I guess Ceptyus wasn't so foolish after all...").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 0, 1, 4));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nTake that Spear and return it to oblivion! Nothing good ever comes of anything bearing its name.").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 0, 1, 64));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI hoped to never see that dreaded storm ever again. Do your self a favor and throw that Spear into the void.").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 0, 1, 64));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nThe scent on those Greaves smells faintly familiar... where do I know this from?").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f))), new int[0], 0, 1, 32));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI still remember what it was like to be impaled by dozens of those Spears. An agony nearly unparalleled...\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nWill you ever share with us what truly happened back then? Maybe sharing will help give you some peace.\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nWill you ever just leave me alone like I ask!?\n").method_27692(class_124.field_1064)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.4f, 1.5f))), new int[]{0, 80}, 0, 1, 80));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nNul! You brat! You think you can take all the realms for yourself now that there's no one left to stop you!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nTake? I do not want to own the world, I want to revive it! I may be the God of Death, but without creatures to die, what purpose would I serve?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 1.4f))), new int[]{0, 80}, 0, 1, 8));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nNul! You think you are safe because you imprisoned me?! I killed one God, one FAR more powerful than you. I can do it again!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nDon't make me laugh! You are a shell of your former self. I did not imprison you, this Player defeated you. How could you kill me if you couldn't kill them?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[]{0, 100}, 0, 1, 8));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nWhat's that Divine essence I sense? Could it be the absentee ascendant? You never liked interacting with us, did you? Even when it was just you and me.\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI'm sorry I was so timid in those early days. I had spent so long accompanied by only my own kind, hidden from the rest of the world.\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI've learned from my mistakes. I will take an active role in shaping our world. It's never too late to learn from our failures.").method_27692(class_124.field_1075)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.9f))), new int[]{0, 100, 100}, 0, 1, 16));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nWell what do we have here? A 'family' reunion, how touching... Have you two come to mock me together?!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nWe don't 'go' anywhere, this Player holds all our tributes. But I suppose it would be foolish to waste this opportunity.\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nNow Brother, we need not mock Enderia in this state. Surely you can sympathize a bit with her struggles?\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI don't need any of your worthless sympathy. You both betrayed what it means to be an ascendant!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nWE betrayed what it means? Ascending means breaking free of the cycle the Progenitors put us in! The mere thought of our arrival sent them scattering! And yet WE'RE the ones who betrayed that ideal?\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI ascended because the world needed to change. Your initial contribution was significant, but you soon fell back to the patterns of your predecessor.\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nYour grandiose ideals mean nothing! After all I've been through, I just want a place to call home; To be safe for once in my entire existence!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nYet the price of your safety came at the cost of the freedom of an entire realm.\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nYou terrorized them for eons, and when you had the chance to stop, you were too afraid of rebellion to let them be. But the rebellion came anyways, the Endermen sacrificed their lives to lead this Player to you.\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI don't have to put up with any of this! Go play 'God' somewhere else.\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nIt's ironic that your Egg is the one place where you can finally have your peace, yet it is the one place you don't want to be. I wonder if you can appreciate the freedom you took away better now.\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nGood Chat, Sis...").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.1f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.4f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 1.2f), new Dialog.DialogSound(class_3417.field_14671, 0.3f, 1.1f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[]{0, 80, 100, 80, 80, 140, 120, 120, 80, 160, 80, 140}, 0, 1, 24));
        DialogHelper helper = new DialogHelper(dialogOptions, conditions);
        helper.sendDialog(List.of(player), helper.getWeightedResult(), true);
    }
}

