/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Optional;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.gui.altars.TransmutationAltarRecipeGui;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class TransmutationAltarGui
extends SimpleGui {
    private final TransmutationAltarBlockEntity blockEntity;

    public TransmutationAltarGui(class_3917<?> type, class_3222 player, TransmutationAltarBlockEntity blockEntity) {
        super(type, player, false);
        this.blockEntity = blockEntity;
        this.setTitle((class_2561)class_2561.method_43470((String)"Transmutation Altar"));
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        class_1937 class_19372;
        if (index == 2) {
            TransmutationAltarRecipeGui recipeGui = new TransmutationAltarRecipeGui(this.player, this, Optional.of(this.blockEntity));
            recipeGui.buildRecipeListGui();
            recipeGui.open();
        } else if (index == 4 && (class_19372 = this.blockEntity.method_10997()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.blockEntity.getCooldown() <= 0) {
                if (this.blockEntity.checkTransmute() != null) {
                    this.blockEntity.startTransmute(this.player);
                } else {
                    this.player.method_64398((class_2561)class_2561.method_43470((String)"No Transmutation Items Found").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                }
                this.close();
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"The Altar is on Cooldown").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                this.close();
            }
        }
        return true;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive()) {
            this.close();
        }
        this.buildMenuGui();
    }

    public void buildMenuGui() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)51450)).setName((class_2561)class_2561.method_43470((String)"Transmutation Altar").method_27692(class_124.field_1078)));
        }
        GuiElementBuilder cooldownItem = new GuiElementBuilder(class_1802.field_8557).hideDefaultTooltip();
        if (this.blockEntity.getCooldown() <= 0) {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Ready").method_27692(class_124.field_1075)));
        } else {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Recharging").method_27692(class_124.field_1078)));
            cooldownItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.blockEntity.getCooldown() / 20 + " Seconds")).method_27692(class_124.field_1064))));
        }
        this.setSlot(0, (GuiElementBuilderInterface)cooldownItem);
        GuiElementBuilder recipeItem = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)ArcanaRegistry.TRANSMUTATION_BOOK)).hideDefaultTooltip();
        recipeItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Transmutation Recipes").method_27692(class_124.field_1062)));
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to view all Transmutation Recipes").method_27692(class_124.field_1078))));
        this.setSlot(2, (GuiElementBuilderInterface)recipeItem);
        GuiElementBuilder activateItem = new GuiElementBuilder(class_1802.field_8477);
        activateItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Activate Altar").method_27692(class_124.field_1076)));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to begin a Transmutation").method_27692(class_124.field_1064))));
        this.setSlot(4, (GuiElementBuilderInterface)activateItem);
    }

    public void close() {
        super.close();
    }
}

