/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.starlightforge;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.gui.VirtualInventoryGui;
import net.borisshoes.arcananovum.gui.arcanetome.CompendiumEntry;
import net.borisshoes.arcananovum.gui.arcanetome.LoreGui;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.starlightforge.EnhancedForgingGui;
import net.borisshoes.arcananovum.gui.starlightforge.StarlightForgeInventoryListener;
import net.borisshoes.arcananovum.items.ArcaneTome;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ExplainRecipe;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class StarlightForgeGui
extends VirtualInventoryGui<class_1277> {
    private final StarlightForgeBlockEntity blockEntity;
    private final class_1937 world;
    private StarlightForgeInventoryListener listener;
    private static final int[] FORGE_SLOTS = new int[]{1, 2, 3, 10, 11, 12, 19, 20, 21};
    private static final int[] SKILLED_POINTS = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 12, 15};
    private int mode;
    private final TomeGui.CompendiumSettings settings;

    public StarlightForgeGui(class_3917<?> type, class_3222 player, StarlightForgeBlockEntity blockEntity, class_1937 world, int mode, @Nullable TomeGui.CompendiumSettings settings) {
        super(type, player, false);
        this.blockEntity = blockEntity;
        this.world = world;
        this.mode = mode;
        if (settings == null) {
            int skillLvl = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.SKILLED.id);
            int resourceLvl = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.RESOURCEFUL.id);
            this.settings = new TomeGui.CompendiumSettings(skillLvl, resourceLvl);
        } else {
            this.settings = settings;
        }
        this.inventory = new class_1277(25);
        this.listener = new StarlightForgeInventoryListener(this, blockEntity, world, mode);
        ((class_1277)this.inventory).method_5489((class_1265)this.listener);
    }

    public int getMode() {
        return this.mode;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (this.mode == 0) {
            if (index == 1) {
                this.blockEntity.openGui(2, this.player, "", this.settings);
            } else if (index == 3) {
                this.blockEntity.openGui(1, this.player, "", this.settings);
            }
        } else if (this.mode == 1) {
            class_1799 item;
            if (index == 7) {
                MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                this.blockEntity.openGui(4, this.player, "", this.settings);
            } else if (index == 25 && ArcanaItemUtils.isArcane(item = this.getSlot(index).getItemStack())) {
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                ArcanaRecipe recipe = arcanaItem.getRecipe();
                if (!ArcanaNovum.data((class_1657)this.player).hasResearched(arcanaItem)) {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You must research this item first!").method_27692(class_124.field_1061), false);
                    return false;
                }
                boolean canApplySkilled = this.getSkilledOptions(arcanaItem, this.player).entrySet().stream().anyMatch(entry -> (Integer)entry.getValue() > 0);
                if (canApplySkilled) {
                    this.buildSkilledGui(arcanaItem.getId());
                } else {
                    class_1799 newArcanaItem = arcanaItem.addCrafter(arcanaItem.forgeItem(this.inventory, this.blockEntity), this.player.method_5845(), false, this.player.method_5682());
                    this.forgeItem(arcanaItem, newArcanaItem, recipe, null, type == ClickType.MOUSE_LEFT_SHIFT);
                }
            }
        } else if (this.mode == 2) {
            if (index == 15) {
                class_1799 stack = this.listener.getEnhancedStack(this.inventory);
                if (!stack.method_7960()) {
                    this.listener.setUpdating();
                    class_2371<class_1799> remainders = this.listener.getRemainders(this.inventory);
                    class_2371 ingredients = class_2371.method_10211();
                    for (int i = 0; i < ((class_1277)this.inventory).method_5439(); ++i) {
                        if (i < 9) {
                            ingredients.add((Object)((class_1277)this.inventory).method_5434(i, 1));
                            continue;
                        }
                        ((class_1277)this.inventory).method_5447(i, class_1799.field_8037);
                    }
                    MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
                    EnhancedForgingGui efg = new EnhancedForgingGui(this.player, this.blockEntity, stack, (class_2371<class_1799>)ingredients, remainders);
                    efg.buildGui();
                    efg.open();
                }
            } else if (index == 17) {
                BookElementBuilder bookBuilder = StarlightForgeGui.getGuideBook();
                LoreGui loreGui = new LoreGui(this.player, bookBuilder, null, null, null);
                loreGui.open();
                MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
            }
        } else if (this.mode == 3) {
            class_1799 ingredStack;
            ArcanaItem arcanaItem1;
            class_1799 item = this.getSlot(25).getItemStack();
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
            if (arcanaItem == null) {
                return false;
            }
            if (index == 7) {
                this.blockEntity.openGui(4, this.player, "", this.settings);
            } else if (index == 43) {
                this.blockEntity.openGui(1, this.player, arcanaItem.getId(), this.settings);
            } else if (index > 9 && index < 36 && (index % 9 == 1 || index % 9 == 2 || index % 9 == 3 || index % 9 == 4 || index % 9 == 5) && (arcanaItem1 = ArcanaItemUtils.identifyItem(ingredStack = this.getSlot(index).getItemStack())) != null) {
                this.blockEntity.openGui(3, this.player, arcanaItem1.getId(), this.settings);
            }
        } else if (this.mode == 4) {
            if (index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8) {
                class_1799 item = this.getSlot(index).getItemStack();
                if (!item.method_7960()) {
                    ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
                    if (arcanaItem == null) {
                        return false;
                    }
                    if (ArcanaNovum.data((class_1657)this.player).hasResearched(arcanaItem)) {
                        if (arcanaItem.getRecipe() != null) {
                            this.blockEntity.openGui(3, this.player, arcanaItem.getId(), this.settings);
                        } else {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"You Cannot Craft This Item").method_27692(class_124.field_1061), false);
                        }
                    } else {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You must research this item first!").method_27692(class_124.field_1061), false);
                    }
                }
            } else if (index == 0) {
                boolean shiftLeft;
                boolean backwards = type == ClickType.MOUSE_RIGHT;
                boolean bl = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                if (shiftLeft) {
                    this.settings.setSortType(TomeGui.TomeSort.RECOMMENDED);
                } else {
                    this.settings.setSortType(TomeGui.TomeSort.cycleSort(this.settings.getSortType(), backwards));
                }
                TomeGui.buildCompendiumGui(this, this.player, this.settings);
            } else if (index == 8) {
                boolean shiftLeft;
                boolean backwards = type == ClickType.MOUSE_RIGHT;
                boolean bl = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
                if (shiftLeft) {
                    this.settings.setFilterType(TomeGui.TomeFilter.NONE);
                } else {
                    this.settings.setFilterType(TomeGui.TomeFilter.cycleFilter(this.settings.getFilterType(), backwards));
                }
                List<CompendiumEntry> items = TomeGui.sortedFilteredEntryList(this.settings, this.player);
                int numPages = (int)Math.ceil((double)items.size() / 28.0);
                if (this.settings.getPage() > numPages) {
                    this.settings.setPage(numPages);
                }
                TomeGui.buildCompendiumGui(this, this.player, this.settings);
            } else if (index == 45) {
                if (this.settings.getPage() > 1) {
                    this.settings.setPage(this.settings.getPage() - 1);
                    TomeGui.buildCompendiumGui(this, this.player, this.settings);
                }
            } else if (index == 53) {
                List<CompendiumEntry> items = TomeGui.sortedFilteredEntryList(this.settings, this.player);
                int numPages = (int)Math.ceil((double)items.size() / 28.0);
                if (this.settings.getPage() < numPages) {
                    this.settings.setPage(this.settings.getPage() + 1);
                    TomeGui.buildCompendiumGui(this, this.player, this.settings);
                }
            }
        } else if (this.mode == 5) {
            class_1799 item = this.getSlot(4).getItemStack();
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
            if (index >= 19 && index <= 25 && arcanaItem != null) {
                List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
                int[] augmentSlots = TomeGui.DYNAMIC_SLOTS[augments.size()];
                ArcanaAugment augment = null;
                for (int i = 0; i < augmentSlots.length; ++i) {
                    if (index != 19 + augmentSlots[i]) continue;
                    augment = augments.get(i);
                    break;
                }
                if (augment != null) {
                    int applicableLevel = this.getSkilledOptions(arcanaItem, this.player).getOrDefault(augment, 0);
                    if (applicableLevel <= 0) {
                        this.player.method_7353((class_2561)class_2561.method_43470((String)"You cannot apply this Augment!").method_27692(class_124.field_1061), false);
                        return true;
                    }
                    ArcanaRecipe recipe = arcanaItem.getRecipe();
                    class_1799 newArcanaItem = arcanaItem.addCrafter(arcanaItem.forgeItem(this.inventory, this.blockEntity), this.player.method_5845(), false, this.player.method_5682());
                    this.forgeItem(arcanaItem, newArcanaItem, recipe, (class_3545<ArcanaAugment, Integer>)new class_3545((Object)augment, (Object)applicableLevel), type == ClickType.MOUSE_LEFT_SHIFT);
                    this.close();
                }
            } else if (index == 40 && arcanaItem != null) {
                ArcanaRecipe recipe = arcanaItem.getRecipe();
                class_1799 newArcanaItem = arcanaItem.addCrafter(arcanaItem.forgeItem(this.inventory, this.blockEntity), this.player.method_5845(), false, this.player.method_5682());
                this.forgeItem(arcanaItem, newArcanaItem, recipe, null, type == ClickType.MOUSE_LEFT_SHIFT);
            }
        }
        return true;
    }

    private void forgeItem(ArcanaItem arcanaItem, class_1799 newArcanaItem, ArcanaRecipe recipe, @Nullable class_3545<ArcanaAugment, Integer> skillPair, boolean fastAnim) {
        class_1937 class_19372 = this.blockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        if (skillPair != null && (Integer)skillPair.method_15441() > 0) {
            ArcanaAugments.applyAugment(newArcanaItem, ((ArcanaAugment)skillPair.method_15442()).id, (Integer)skillPair.method_15441(), false);
        }
        arcanaItem.buildItemLore(newArcanaItem, this.player.method_5682());
        class_1799[][] ingredients = new class_1799[5][5];
        for (int i = 0; i < ((class_1277)this.inventory).method_5439(); ++i) {
            ingredients[i / 5][i % 5] = ((class_1277)this.inventory).method_5438(i);
        }
        class_1799[][] remainders = recipe.getRemainders(ingredients, this.blockEntity, this.settings.resourceLvl);
        for (int i = 0; i < ((class_1277)this.inventory).method_5439(); ++i) {
            ((class_1277)this.inventory).method_5447(i, remainders[i / 5][i % 5]);
        }
        ArcanaEffectUtils.arcanaCraftingAnim(world, this.blockEntity.method_11016(), newArcanaItem, 0.0, fastAnim ? 1.75 : 1.0);
        BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(fastAnim ? 200 : 350, () -> {
            if (!ArcanaNovum.data((class_1657)this.player).addCrafted(newArcanaItem) && !(arcanaItem instanceof ArcaneTome)) {
                ArcanaNovum.data((class_1657)this.player).addXP(ArcanaRarity.getCraftXp(arcanaItem.getRarity()));
            }
            if (arcanaItem.getRarity() != ArcanaRarity.MUNDANE) {
                ArcanaAchievements.grant(this.player, ArcanaAchievements.INTRO_ARCANA.id);
                ArcanaAchievements.progress(this.player, ArcanaAchievements.INTERMEDIATE_ARTIFICE.id, 1);
            }
            if (arcanaItem.getRarity() == ArcanaRarity.SOVEREIGN) {
                ArcanaAchievements.grant(this.player, ArcanaAchievements.ARTIFICIAL_DIVINITY.id);
            }
            if (recipe.getForgeRequirement().needsFletchery()) {
                ArcanaAchievements.setCondition(this.player, ArcanaAchievements.OVERLY_EQUIPPED_ARCHER.id, arcanaItem.getNameString(), true);
            }
            class_243 pos = this.blockEntity.method_11016().method_46558().method_1031(0.0, 2.0, 0.0);
            class_1264.method_5449((class_1937)world, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)newArcanaItem);
        }));
        if (fastAnim) {
            this.close();
            this.blockEntity.openGui(4, this.player, arcanaItem.getId(), this.settings);
        } else {
            this.close();
        }
    }

    private HashMap<ArcanaAugment, Integer> getSkilledOptions(ArcanaItem arcanaItem, class_3222 player) {
        List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
        HashMap<ArcanaAugment, Integer> options = new HashMap<ArcanaAugment, Integer>();
        if (this.settings.skillLvl == 0) {
            return options;
        }
        ArcanaRarity maxRarity = ArcanaAugments.SKILLED.getTiers()[this.settings.skillLvl - 1];
        for (ArcanaAugment augment : augments) {
            ArcanaRarity[] tiers = augment.getTiers();
            int skillPoints = SKILLED_POINTS[this.settings.skillLvl];
            int applicableLevel = 0;
            int sumCost = 0;
            int unlockedLevel = ArcanaNovum.data((class_1657)player).getAugmentLevel(augment.id);
            for (ArcanaRarity tier : tiers) {
                if ((sumCost += tier.rarity + 1) > skillPoints || applicableLevel + 1 > unlockedLevel || tier.rarity > maxRarity.rarity) break;
                ++applicableLevel;
            }
            options.put(augment, applicableLevel);
        }
        return options;
    }

    public void buildForgeGui() {
        int i;
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            this.clearSlot(i2);
            if (i2 % 9 < 4) {
                this.setSlot(i2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)7996617)).setName((class_2561)class_2561.method_43470((String)"Place Recipe Here >").method_27692(class_124.field_1064)));
                continue;
            }
            if (i2 % 9 == 4) {
                this.setSlot(i2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT, (int)7996617)).setName((class_2561)class_2561.method_43470((String)"< Place Recipe Here").method_27692(class_124.field_1064)));
                continue;
            }
            this.setSlot(i2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        }
        GuiElementBuilder bookItem = new GuiElementBuilder(class_1802.field_8361);
        bookItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Read About Stardust Infusion").method_27692(class_124.field_1060)));
        this.setSlot(17, (GuiElementBuilderInterface)bookItem);
        GuiElementBuilder craftingItem = new GuiElementBuilder(class_1802.field_8465);
        craftingItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1075)));
        craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to forge an item once a recipe is loaded!").method_27692(class_124.field_1062))));
        craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1062))));
        craftingItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This slot will show an item once a valid recipe is loaded.").method_27692(class_124.field_1076))));
        this.setSlot(15, (GuiElementBuilderInterface)craftingItem);
        for (i = 0; i < FORGE_SLOTS.length; ++i) {
            this.setSlot(FORGE_SLOTS[i], (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
        }
        for (i = 0; i < FORGE_SLOTS.length; ++i) {
            this.setSlotRedirect(FORGE_SLOTS[i], new class_1735(this.inventory, i, 0, 0));
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"Forge Equipment"));
    }

    public void buildMenuGui() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)7996617)).setName((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1064)));
        }
        GuiElementBuilder equipmentItem = new GuiElementBuilder(class_1802.field_8058).hideDefaultTooltip();
        equipmentItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forge Equipment").method_27692(class_124.field_1075)));
        this.setSlot(1, (GuiElementBuilderInterface)equipmentItem);
        GuiElementBuilder arcanaItem = new GuiElementBuilder(class_1802.field_8301);
        arcanaItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forge Arcana Items").method_27692(class_124.field_1076)));
        this.setSlot(3, (GuiElementBuilderInterface)arcanaItem);
        this.setTitle((class_2561)class_2561.method_43470((String)"Starlight Forge"));
    }

    /*
     * WARNING - void declaration
     */
    public void buildCraftingGui(String itemId) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (i % 9 == 0 || i % 9 == 6) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i % 9 == 8) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i % 9 != 7) continue;
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)7996617)).hideTooltip());
        }
        this.setSlot(17, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(35, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(15, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(33, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(7, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).hideTooltip());
        this.setSlot(43, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).hideTooltip());
        GuiElementBuilder book = new GuiElementBuilder(class_1802.field_8465).hideDefaultTooltip();
        book.setName((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1064));
        book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to forge an Arcana Item once a recipe is loaded!").method_27692(class_124.field_1076))));
        book.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"to view an Arcana Item Recipe").method_27692(class_124.field_1076))));
        this.setSlot(7, (GuiElementBuilderInterface)book);
        GuiElementBuilder table = new GuiElementBuilder(class_1802.field_8465).hideDefaultTooltip();
        table.setName((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1064));
        table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to forge an Arcana Item once a recipe is loaded!").method_27692(class_124.field_1076))));
        table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"This slot will show an Arcana Item once a valid recipe is loaded.").method_27695(new class_124[]{class_124.field_1056, class_124.field_1075})));
        this.setSlot(25, (GuiElementBuilderInterface)table);
        for (int i = 0; i < 25; ++i) {
            this.setSlot(TomeGui.CRAFTING_SLOTS[i], (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
        }
        boolean collect = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.MYSTIC_COLLECTION.id) >= 1;
        ArrayList<class_1263> inventories = collect ? this.blockEntity.getIngredientInventories() : new ArrayList<class_1263>();
        for (int i = 0; i < 25; ++i) {
            this.setSlotRedirect(TomeGui.CRAFTING_SLOTS[i], new class_1735(this.inventory, i, 0, 0));
        }
        if (itemId != null && !itemId.isEmpty()) {
            ArcanaRecipe recipe = ArcanaItemUtils.getItemFromId(itemId).getRecipe();
            ArcanaIngredient[][] ingredients = recipe.getIngredients();
            class_1661 playerInventory = this.player.method_31548();
            for (int i = 0; i < 25; ++i) {
                boolean bl;
                void var12_18;
                ArcanaIngredient ingredient = ingredients[i / 5][i % 5];
                if (ingredient.ingredientAsStack().method_7960()) continue;
                ArrayList<class_1799> matchingStacks = new ArrayList<class_1799>();
                boolean bl2 = false;
                while (var12_18 < playerInventory.method_5439()) {
                    class_1799 invSlot = playerInventory.method_5438((int)var12_18);
                    if (!invSlot.method_7960() && ingredient.validStackIgnoreCount(invSlot)) {
                        matchingStacks.add(invSlot);
                    }
                    ++var12_18;
                }
                for (class_1263 inventory : inventories) {
                    for (int j = 0; j < inventory.method_5439(); ++j) {
                        class_1799 invSlot = inventory.method_5438(j);
                        if (invSlot.method_7960() || !ingredient.validStackIgnoreCount(invSlot)) continue;
                        matchingStacks.add(invSlot);
                    }
                }
                matchingStacks.sort(Comparator.comparingInt(class_1799::method_7947));
                boolean bl3 = false;
                ArrayList<class_1799> neededStacks = new ArrayList<class_1799>();
                Iterator j = matchingStacks.iterator();
                while (j.hasNext()) {
                    class_1799 outerStack = (class_1799)j.next();
                    neededStacks.clear();
                    int remaining = ingredient.getCount() - outerStack.method_7947();
                    neededStacks.add(outerStack);
                    Iterator iterator = matchingStacks.iterator();
                    while (iterator.hasNext()) {
                        class_1799 innerStack = (class_1799)iterator.next();
                        if (!class_1799.method_31577((class_1799)outerStack, (class_1799)innerStack) || innerStack == outerStack) continue;
                        if (remaining <= 0) break;
                        remaining -= innerStack.method_7947();
                        neededStacks.add(innerStack);
                    }
                    if (remaining > 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                int remaining = ingredient.getCount();
                class_1799 totalStack = null;
                for (class_1799 neededStack : neededStacks) {
                    int toRemove = Math.min(remaining, neededStack.method_7947());
                    if (toRemove <= 0) continue;
                    if (totalStack == null) {
                        totalStack = neededStack.method_7971(toRemove);
                        remaining -= totalStack.method_7947();
                        continue;
                    }
                    class_1799 removed = neededStack.method_7971(toRemove);
                    remaining -= removed.method_7947();
                    totalStack.method_7933(removed.method_7947());
                }
                ((class_1277)this.inventory).method_5447(i, totalStack);
            }
            recipe.getForgeRequirement().forgeMeetsRequirement(this.blockEntity, true, this.player);
            HashMap<String, class_3545<Integer, class_1799>> ingredList = recipe.getIngredientList();
            GuiElementBuilder recipeList = new GuiElementBuilder(class_1802.field_8407).hideDefaultTooltip();
            recipeList.setName((class_2561)class_2561.method_43470((String)"Total Ingredients").method_27692(class_124.field_1064));
            recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"-----------------------").method_27692(class_124.field_1076)));
            for (Map.Entry entry : ingredList.entrySet()) {
                class_5250 ingredStr = TomeGui.getIngredStr(entry);
                recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_2561)ingredStr));
            }
            recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            int slotCount = 0;
            for (ArcanaItem item : recipe.getForgeRequirementList()) {
                GuiElementBuilder reqItem = GuiElementBuilder.from((class_1799)item.getPrefItemNoLore()).hideDefaultTooltip().glow();
                class_5250 req = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Requires").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1064)).method_10852((class_2561)item.getTranslatedName().method_27692(class_124.field_1075));
                recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_2561)req));
                reqItem.setName((class_2561)req);
                this.setSlot(slotCount, (GuiElementBuilderInterface)reqItem);
                slotCount += 9;
            }
            if (!recipe.getForgeRequirementList().isEmpty()) {
                recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            }
            recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Does not include item data").method_27695(new class_124[]{class_124.field_1056, class_124.field_1064})));
            this.setSlot(43, (GuiElementBuilderInterface)recipeList);
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"Forge Items"));
    }

    public void buildRecipeGui(String id) {
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        if (arcanaItem == null) {
            this.close();
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            if (i % 9 == 0 || i % 9 == 6) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i % 9 == 8) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT, (int)7996617)).hideTooltip());
                continue;
            }
            if (i % 9 != 7) continue;
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)7996617)).hideTooltip());
        }
        this.setSlot(17, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(35, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(15, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(33, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)7996617)).hideTooltip());
        this.setSlot(7, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).hideTooltip());
        this.setSlot(43, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).hideTooltip());
        GuiElementBuilder returnBook = new GuiElementBuilder(class_1802.field_8361);
        returnBook.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)));
        returnBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to return to the Arcana Items page").method_27692(class_124.field_1076))));
        this.setSlot(7, (GuiElementBuilderInterface)returnBook);
        ArcanaRecipe recipe = arcanaItem.getRecipe();
        this.setSlot(25, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)arcanaItem.getPrefItem()).glow());
        ArcanaIngredient[][] ingredients = recipe.getIngredients();
        for (int i = 0; i < 25; ++i) {
            class_1799 ingredient = ingredients[i / 5][i % 5].ingredientAsStack();
            GuiElementBuilder craftingElement = GuiElementBuilder.from((class_1799)ingredient);
            if (ArcanaItemUtils.isArcane(ingredient)) {
                craftingElement.glow();
            }
            this.setSlot(TomeGui.CRAFTING_SLOTS[i], (GuiElementBuilderInterface)craftingElement);
        }
        HashMap<String, class_3545<Integer, class_1799>> ingredList = recipe.getIngredientList();
        if (!(recipe instanceof ExplainRecipe)) {
            boolean collect = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.MYSTIC_COLLECTION.id) >= 1;
            ArrayList<class_1263> inventories = collect ? this.blockEntity.getIngredientInventories() : new ArrayList<class_1263>();
            class_1661 class_16612 = this.player.method_31548();
            HashMap<String, Integer> ingredCounts = new HashMap<String, Integer>();
            for (int i = 0; i < 25; ++i) {
                ArcanaIngredient ingredient = ingredients[i / 5][i % 5];
                if (ingredient.ingredientAsStack().method_7960() || ingredCounts.containsKey(ingredient.getName())) continue;
                HashSet<class_1799> matchingStacks = new HashSet<class_1799>();
                for (int j = 0; j < class_16612.method_5439(); ++j) {
                    class_1799 invSlot = class_16612.method_5438(j);
                    if (invSlot.method_7960() || !ingredient.validStackIgnoreCount(invSlot)) continue;
                    matchingStacks.add(invSlot);
                }
                Iterator j = inventories.iterator();
                while (j.hasNext()) {
                    class_1263 inventory = (class_1263)j.next();
                    for (int j2 = 0; j2 < inventory.method_5439(); ++j2) {
                        class_1799 invSlot = inventory.method_5438(j2);
                        if (invSlot.method_7960() || !ingredient.validStackIgnoreCount(invSlot)) continue;
                        matchingStacks.add(invSlot);
                    }
                }
                int totalCount = 0;
                for (class_1799 matchingStack : matchingStacks) {
                    totalCount += matchingStack.method_7947();
                }
                ingredCounts.put(ingredient.getName(), totalCount);
            }
            GuiElementBuilder table = new GuiElementBuilder(class_1802.field_8465).hideDefaultTooltip();
            table.setName((class_2561)class_2561.method_43470((String)"Forge Item").method_27692(class_124.field_1064));
            table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click Here").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to forge this item!").method_27692(class_124.field_1076))));
            table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"-----------------------").method_27692(class_124.field_1076)));
            for (String key : ingredList.keySet()) {
                int foundCount = (Integer)ingredCounts.get(key);
                int neededCount = (Integer)ingredList.get(key).method_15442();
                class_5250 text = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(foundCount >= neededCount ? "\u2714 " : "\u2718 ")).method_27692(foundCount >= neededCount ? class_124.field_1060 : class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)key).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(foundCount)).method_27692(foundCount >= neededCount ? class_124.field_1060 : class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" / ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)LevelUtils.readableInt(neededCount)).method_27692(foundCount >= neededCount ? class_124.field_1060 : class_124.field_1061));
                table.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)text));
            }
            this.setSlot(43, (GuiElementBuilderInterface)table);
        }
        GuiElementBuilder recipeList = new GuiElementBuilder(class_1802.field_8407).hideDefaultTooltip();
        recipeList.setName((class_2561)class_2561.method_43470((String)"Total Ingredients").method_27692(class_124.field_1064));
        recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"-----------------------").method_27692(class_124.field_1076)));
        for (Map.Entry entry : ingredList.entrySet()) {
            class_5250 ingredStr = TomeGui.getIngredStr(entry);
            recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_2561)ingredStr));
        }
        recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        int slotCount = 0;
        for (ArcanaItem item : recipe.getForgeRequirementList()) {
            GuiElementBuilder reqItem = GuiElementBuilder.from((class_1799)item.getPrefItemNoLore()).hideDefaultTooltip().glow();
            class_5250 req = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Requires").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" a ").method_27692(class_124.field_1064)).method_10852((class_2561)item.getTranslatedName().method_27692(class_124.field_1075));
            recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_2561)req));
            reqItem.setName((class_2561)req);
            this.setSlot(slotCount, (GuiElementBuilderInterface)reqItem);
            slotCount += 9;
        }
        if (!recipe.getForgeRequirementList().isEmpty()) {
            recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        }
        recipeList.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Does not include item data").method_27695(new class_124[]{class_124.field_1056, class_124.field_1064})));
        this.setSlot(26, (GuiElementBuilderInterface)recipeList);
        this.setTitle((class_2561)class_2561.method_43470((String)"Recipe for ").method_10852((class_2561)arcanaItem.getTranslatedName()));
    }

    public void buildSkilledGui(String id) {
        this.mode = 5;
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)this.player);
        if (arcanaItem == null) {
            this.close();
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            if (i >= 19 && i <= 25) {
                this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)0xDBDBDB)).setName((class_2561)class_2561.method_43470((String)"")).hideTooltip());
                continue;
            }
            this.setSlot(i, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)7996617)).setName((class_2561)class_2561.method_43470((String)"Select an Augment to apply it").method_27692(class_124.field_1064)));
        }
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        this.setSlot(4, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)arcanaItem.getPrefItem()).glow());
        List<ArcanaAugment> augments = ArcanaAugments.getAugmentsForItem(arcanaItem);
        int[] augmentSlots = TomeGui.DYNAMIC_SLOTS[augments.size()];
        for (int i = 0; i < augmentSlots.length; ++i) {
            ArcanaAugment augment = augments.get(i);
            int augmentLvl = profile.getAugmentLevel(augment.id);
            GuiElementBuilder augmentItem1 = GuiElementBuilder.from((class_1799)augment.getDisplayItem());
            class_5250 name = augment.getTranslatedName().method_27692(class_124.field_1064);
            if (augmentLvl > 0) {
                name.method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" (Level ")).method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)("" + augmentLvl))).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)")")).method_27692(class_124.field_1078));
            } else {
                name.method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" (")).method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)"LOCKED")).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)")")).method_27692(class_124.field_1078));
            }
            augmentItem1.hideDefaultTooltip().setName((class_2561)name).addLoreLine((class_2561)TextUtils.removeItalics((class_5250)augment.getTierDisplay()));
            int applicableLevel = this.getSkilledOptions(arcanaItem, this.player).getOrDefault(augment, 0);
            for (String s : augment.getDescription()) {
                augmentItem1.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)s).method_27692(class_124.field_1080)));
            }
            augmentItem1.addLoreLine((class_2561)class_2561.method_43470((String)""));
            if (applicableLevel > 0) {
                augmentItem1.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to apply ").method_27692(class_124.field_1064)).method_10852((class_2561)augment.getTranslatedName().method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" at Level ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)("" + applicableLevel)).method_27692(class_124.field_1076))));
            } else {
                augmentItem1.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"You cannot apply this Augment").method_27692(class_124.field_1061)));
            }
            if (augmentLvl > 0) {
                augmentItem1.glow();
            }
            this.setSlot(19 + augmentSlots[i], (GuiElementBuilderInterface)augmentItem1);
        }
        GuiElementBuilder cancel = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CANCEL)).hideDefaultTooltip();
        cancel.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forgo Augmentation").method_27692(class_124.field_1061)));
        cancel.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"No Augmentations will be applied").method_27692(class_124.field_1064))));
        this.setSlot(40, (GuiElementBuilderInterface)cancel);
        this.setTitle((class_2561)class_2561.method_43470((String)"Skilled Augmentation Selection"));
    }

    public static BookElementBuilder getGuideBook() {
        BookElementBuilder book = new BookElementBuilder();
        ArrayList<class_5250> pages = new ArrayList<class_5250>();
        pages.add(class_2561.method_43470((String)"   Stardust Infusion\n-------------------\nThe Starlight Forge has the capability to create equipment that is considerably stronger than equipment made in a crafting table. This is done through the use of Stardust, a material I discovered that comes from salvaging enchanted equipment").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"   Stardust Infusion\n-------------------\nin a Stellar Core. \nWhen attempting to forge a new piece of equipment the Forge displays a vision of celestial bodies in Astral Space. Using Stardust I can manipulate the vision to cause the celestial entities to interact and give rise to new ").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"   Stardust Infusion\n-------------------\nstars. Each of the objects interacts uniquely with the others, and their layout changes each time I forge something.\nThe more stars that are present at the end of the vision, the more powerful the infusion results. ").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"   Infused Equipment\n-------------------\nBased on my results, different equipment experiences different types of enhancements.\n\nAll equipment seems to have a significant buff in its durability, taking up to 50% more time before it breaks.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"      Infused Tools\n-------------------\nTools that undergo infusion gain an increase to their harvesting capabilities, putting them on par with tools that have already undergone high levels of enchantment. However, enchanting infused tools only gives marginal gains.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"    Infused Weapons\n-------------------\nWeapons that undergo infusion become lighter to wield and sharper. The strikes can deal up to 5 additional damage. The quickened strikes only manifests at higher infusion rates, but can increase the rate of attack by up to 0.5 strikes per second.").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Infused Armor\n-------------------\nArmor is where Stardust really seems to shine. I have catalogued up to 4 unique effects of infusion on armor, ranging from increasing its base armor, its toughness, its resistance to knockback and even increasing constitution").method_27692(class_124.field_1074));
        pages.add(class_2561.method_43470((String)"     Infused Armor\n-------------------\nArmor can receive up to 5 extra points of protection and toughness as well as up to an additional 20% chance to mitigate knockback.\nAt extremely high levels of infusion, this armor has shown to boost my health by up to 2.5 hearts each.").method_27692(class_124.field_1074));
        pages.forEach(arg_0 -> ((BookElementBuilder)book).addPage(arg_0));
        book.setAuthor("Arcana Novum");
        book.setTitle("Stardust Infusion");
        return book;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled()) {
            this.close();
        }
        super.onTick();
    }

    @Override
    public void onClose() {
        if (this.mode == 3) {
            this.blockEntity.openGui(4, this.player, "", this.settings);
        } else if (this.mode == 4) {
            this.blockEntity.openGui(1, this.player, "", this.settings);
        }
        MinecraftUtils.returnItems((class_1263)this.inventory, (class_1657)this.player);
    }

    public void close() {
        super.close();
    }
}

