/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.brainjar.BrainJarGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9280;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class BrainJar
extends EnergyItem {
    public static final String ID = "brain_jar";
    public static final int[] capacities = new int[]{1000000, 2000000, 4000000, 6000000, 8000000, 10000000};
    private static final class_1792 textureItem = class_1802.field_27019;

    public BrainJar() {
        this.id = ID;
        this.name = "Brain in a Jar";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8470;
        this.item = new BrainJarItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.brain_jar", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1060});
        this.researchTasks = new class_5321[]{ResearchTasks.USE_ENDER_CHEST, ResearchTasks.BREAK_SCULK, ResearchTasks.LEVEL_100, ResearchTasks.ACTIVATE_MENDING, ResearchTasks.OBTAIN_BOTTLES_OF_ENCHANTING, ResearchTasks.OBTAIN_ZOMBIE_HEAD, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.UNLOCK_TWILIGHT_ANVIL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        BrainJar.putProperty(stack, "active", false);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"zombie").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" has more aptitude for storing ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"knowledge").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" than most mobs.").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Containing its ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"brain").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" in a jar could serve as ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"XP storage").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It should also be capable of activating the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"mending").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" enchantment.").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to deposit or withdraw ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"XP").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to toggle ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Mending").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" interaction.").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)""));
        boolean mending = itemStack != null && BrainJar.getBooleanProperty(itemStack, "active");
        int xp = itemStack != null ? this.getEnergy(itemStack) : 0;
        class_5250 mendText = mending ? class_2561.method_43470((String)"ON").method_27692(class_124.field_1077) : class_2561.method_43470((String)"OFF").method_27692(class_124.field_1061);
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(LevelUtils.readableInt(xp) + " XP Stored - Mending ")).method_27692(class_124.field_1060)).method_10852((class_2561)mendText));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int capLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.UNENDING_WISDOM.id));
        return capacities[capLvl];
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = BrainJar.getBooleanProperty(stack, "active");
        class_1799 newStack = super.updateItem(stack, server);
        BrainJar.putProperty(newStack, "active", active);
        return this.buildItemLore(newStack, server);
    }

    public void openGui(class_1657 playerEntity, class_1799 stack) {
        if (!(playerEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerEntity;
        BrainJarGui gui = new BrainJarGui(class_3917.field_17337, player, this, stack);
        gui.makeGui();
        gui.open();
    }

    public void toggleMending(BrainJarGui gui, class_3222 player, class_1799 stack) {
        boolean active = !BrainJar.getBooleanProperty(stack, "active");
        BrainJar.putProperty(stack, "active", active);
        this.buildItemLore(stack, player.method_5682());
        gui.makeGui();
    }

    public void withdrawXP(class_3222 player, class_1799 stack, boolean single, BrainJarGui gui) {
        if (single) {
            int xpToTake = Math.min(LevelUtils.vanillaLevelToTotalXp(player.field_7520 + 1) - player.field_7495, this.getEnergy(stack));
            this.addEnergy(stack, -xpToTake);
            player.method_7255(xpToTake);
        } else {
            player.method_7255(this.getEnergy(stack));
            this.setEnergy(stack, 0);
        }
        gui.makeGui();
        this.buildItemLore(stack, player.method_5682());
    }

    public void depositXP(class_3222 player, class_1799 stack, boolean single, BrainJarGui gui) {
        int xpToStore;
        if (single) {
            int xpDiff = player.field_7495 - LevelUtils.vanillaLevelToTotalXp(player.field_7520);
            xpToStore = xpDiff == 0 ? player.field_7495 - LevelUtils.vanillaLevelToTotalXp(player.field_7520 - 1) : xpDiff;
            xpToStore = Math.min(xpToStore, this.getMaxEnergy(stack) - this.getEnergy(stack));
        } else {
            xpToStore = Math.min(player.field_7495, this.getMaxEnergy(stack) - this.getEnergy(stack));
        }
        this.addEnergy(stack, xpToStore);
        player.method_7255(-xpToStore);
        if (xpToStore > 0 && this.getEnergy(stack) >= this.getMaxEnergy(stack)) {
            ArcanaAchievements.grant(player, ArcanaAchievements.BREAK_BANK.id);
        }
        gui.makeGui();
        this.buildItemLore(stack, player.method_5682());
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Brain in a Jar").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nZombies seem to have a higher level of intelligence compared to other mobs. Their brains also seem capable of storing knowledge over time, similar to you and me.\nIf I can expand their capacity for ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Brain in a Jar").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), class_2561.method_43470((String)"\nknowledge using the storage capabilities of Ender Chests, it should hold enough XP for practical use.\n\nThere should also be a way to incorporate the use of the Mending enchantment to have direct access to the storage.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Brain in a Jar").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), class_2561.method_43470((String)"\nUse the Brain in a Jar to open its internal storage, where you can deposit or withdraw XP.\n \nSneak Use to toggle the Jar\u2019s Mending interaction.\n\nThe Jar can store 1 million XP Points.\n").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8466, 4);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8287, 8);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_37523, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9101), 1));
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_37525, 8);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8470, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withEnchanter());
    }

    public class BrainJarItem
    extends ArcanaPolymerItem {
        public BrainJarItem() {
            super(BrainJar.this.getThis());
        }

        @Override
        public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
            if (PolymerResourcePackUtils.hasMainPack((class_3222)context.getPlayer())) {
                return textureItem;
            }
            return super.getPolymerItem(itemStack, context);
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            ArrayList<String> stringList = new ArrayList<String>();
            if (active) {
                stringList.add("on");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return BrainJar.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean active = ArcanaItem.getBooleanProperty(stack, "active");
            if (active && BrainJar.this.getEnergy(stack) != 0) {
                class_1661 inv = player.method_31548();
                for (int i = 0; i < inv.method_5439() && BrainJar.this.getEnergy(stack) != 0; ++i) {
                    boolean hasMending;
                    class_1799 tool = inv.method_5438(i);
                    if (tool.method_7960() || !tool.method_7942() || !(hasMending = class_1890.method_60142((class_1799)tool, (class_9331)class_9701.field_51652))) continue;
                    int durability = tool.method_7919();
                    int repairAmount = (int)Math.ceil((double)class_1890.method_60168((class_3218)player.method_51469(), (class_1799)tool, (int)1) * (1.0 + 0.5 * (double)Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.TRADE_SCHOOL.id))));
                    if (durability <= 0 || !tool.method_7963()) continue;
                    int newDura = class_3532.method_15340((int)(durability - repairAmount), (int)0, (int)Integer.MAX_VALUE);
                    ArcanaAchievements.progress(player, ArcanaAchievements.CERTIFIED_REPAIR.id, durability - newDura);
                    BrainJar.this.addEnergy(stack, -1);
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.BRAIN_JAR_MEND_PER_XP));
                    BrainJar.this.buildItemLore(stack, player.method_5682());
                    tool.method_7974(newDura);
                }
            }
            if (world.method_8503().method_3780() % 1200 == 0 && BrainJar.this.getEnergy(stack) < BrainJar.this.getMaxEnergy(stack)) {
                double interestRate = 0.002 * (double)Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.KNOWLEDGE_BANK.id));
                int beforeEnergy = BrainJar.this.getEnergy(stack);
                BrainJar.this.addEnergy(stack, (int)(interestRate * (double)beforeEnergy));
                if (beforeEnergy < BrainJar.this.getMaxEnergy(stack) && BrainJar.this.getEnergy(stack) >= BrainJar.this.getMaxEnergy(stack)) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.BREAK_BANK.id);
                }
                BrainJar.this.buildItemLore(stack, player.method_5682());
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            if (playerEntity.method_5715()) {
                boolean active = !ArcanaItem.getBooleanProperty(stack, "active");
                ArcanaItem.putProperty(stack, "active", active);
                if (active) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Jar's Experience Mends").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14627, (float)0.5f, (float)1.3f);
                } else {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Jar's Experience Withdraws").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14627, (float)0.5f, (float)0.7f);
                }
            } else {
                BrainJar.this.openGui(playerEntity, stack);
            }
            return class_1269.field_52422;
        }

        public class_1269 method_7884(class_1838 context) {
            class_1657 playerEntity = context.method_8036();
            class_1799 stack = context.method_8041();
            BrainJar.this.openGui(playerEntity, stack);
            return class_1269.field_52422;
        }
    }
}

