/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class PearlOfRecall
extends EnergyItem {
    public static final String ID = "pearl_of_recall";
    public static final String HEAT_TAG = "heat";
    public static final String LOCATION_TAG = "location";
    public static final int[] cdReduction = new int[]{0, 60, 120, 240, 360, 480};

    public PearlOfRecall() {
        this.id = ID;
        this.name = "Pearl of Recall";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.initEnergy = 600;
        this.vanillaItem = class_1802.field_8449;
        this.item = new PearlOfRecallItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.pearl_of_recall", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TEMPORAL_MOMENT, ResearchTasks.ADVANCEMENT_USE_LODESTONE, ResearchTasks.USE_ENDER_PEARL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        PearlOfRecall.putProperty(stack, HEAT_TAG, 0);
        class_2487 locTag = new class_2487();
        locTag.method_10582("dim", "unattuned");
        PearlOfRecall.putProperty(stack, LOCATION_TAG, (class_2520)locTag);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"An ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Ender Pearl").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" whose ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"moment ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"activation ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"was ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"frozen ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"for later use.").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It requires the ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"flowing of time").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"recharge ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"it.").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to set its ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"location ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"teleport ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"to its ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"set point").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)""));
        if (itemStack == null) {
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Location - ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Unbound").method_27692(class_124.field_1080)));
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Charged - ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"100%").method_27695(new class_124[]{class_124.field_1067, class_124.field_1078})));
        } else {
            String dimensionName;
            class_124 dimColor;
            class_2487 locNbt = PearlOfRecall.getCompoundProperty(itemStack, LOCATION_TAG);
            String dim = locNbt.method_68564("dim", "");
            int x = (int)locNbt.method_68563("x", 0.0);
            int y = (int)locNbt.method_68563("y", 0.0);
            int z = (int)locNbt.method_68563("z", 0.0);
            if (dim.equals(class_3218.field_25179.method_29177().toString())) {
                dimColor = class_124.field_1060;
                dimensionName = "Overworld";
            } else if (dim.equals(class_3218.field_25180.method_29177().toString())) {
                dimColor = class_124.field_1061;
                dimensionName = "The Nether";
            } else if (dim.equals(class_3218.field_25181.method_29177().toString())) {
                dimColor = class_124.field_1054;
                dimensionName = "The End";
            } else {
                dimColor = class_124.field_1075;
                dimensionName = dim;
            }
            if (!dim.equals("unattuned")) {
                String location = dimensionName + " (" + x + "," + y + "," + z + ")";
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Location - ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)location).method_27692(dimColor)));
            } else {
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Location - ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Unbound").method_27692(class_124.field_1080)));
            }
            int charge = this.getEnergy(itemStack) * 100 / this.getMaxEnergy(itemStack);
            String charging = charge == 100 ? "Charged" : "Charging";
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(charging + " - ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)(charge + "%")).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078})));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int cdLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.RECALL_ACCELERATION.id));
        return 600 - cdReduction[cdLvl];
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2487 locNbt = PearlOfRecall.getCompoundProperty(stack, LOCATION_TAG).method_10553();
        int heat = PearlOfRecall.getIntProperty(stack, HEAT_TAG);
        class_1799 newItem = super.updateItem(stack, server);
        PearlOfRecall.putProperty(newItem, LOCATION_TAG, (class_2520)locNbt);
        PearlOfRecall.putProperty(newItem, HEAT_TAG, heat);
        return this.buildItemLore(newItem, server);
    }

    private void teleport(class_1799 item, class_3222 player) {
        class_2487 locNbt = PearlOfRecall.getCompoundProperty(item, LOCATION_TAG);
        String dim = locNbt.method_68564("dim", "");
        double x = locNbt.method_68563("x", 0.0);
        double y = locNbt.method_68563("y", 0.0);
        double z = locNbt.method_68563("z", 0.0);
        float yaw = locNbt.method_66563("yaw", 0.0f);
        float pitch = locNbt.method_66563("pitch", 0.0f);
        class_3218 to = player.method_51469();
        for (class_3218 w : player.method_5682().method_3738()) {
            if (!w.method_27983().method_29177().toString().equals(dim)) continue;
            to = w;
            break;
        }
        player.method_61275(new class_5454(to, new class_243(x, y, z), class_243.field_1353, yaw, pitch, class_5454.field_52247));
        this.setEnergy(item, 0);
        if (to.method_27983().method_29177().toString().equals("minecraft:the_nether")) {
            ArcanaAchievements.grant(player, ArcanaAchievements.BACK_TO_HELL.id);
        }
        if (to.method_27983().method_29177().toString().equals("minecraft:the_end")) {
            ArcanaAchievements.grant(player, ArcanaAchievements.ASCENDING_TO_HEAVEN.id);
        }
        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14716, (float)1.0f, (float)2.0f);
        ArcanaEffectUtils.recallTeleport(to, player.method_19538());
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8634, 8);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8695, 8);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8557, 8);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8449, 4);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_23256, 1, true);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8137, 1);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.TEMPORAL_MOMENT, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, l, m, l, c}, {b, g, l, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Pearl of Recall").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nBy freezing an Ender Pearl in time as it activates, I can keep the frozen Pearl with me and unfreeze it when I need to recall myself to where I froze it. I can even use it multiple times after a recharge.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Pearl of Recall").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nUsing the Pearl sets its Recall point.\n\nUsing the Pearl again starts to unfreeze the Pearl in time.\n \nTaking damage resets the process and requires more recharging.\n\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Pearl of Recall").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nAfter using the Pearl, it takes a while to resync to the timeline before use again.").method_27692(class_124.field_1074)));
        return list;
    }

    public class PearlOfRecallItem
    extends ArcanaPolymerItem {
        public PearlOfRecallItem() {
            super(PearlOfRecall.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            ArrayList<String> stringList = new ArrayList<String>();
            if (PearlOfRecall.this.getEnergy(itemStack) < PearlOfRecall.this.getMaxEnergy(itemStack)) {
                stringList.add("cooldown");
            } else {
                stringList.add("charged");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return PearlOfRecall.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_3218 serverWorld;
            block13: {
                block12: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block12;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block13;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            int heat = ArcanaItem.getIntProperty(stack, PearlOfRecall.HEAT_TAG);
            if (heat == 100) {
                PearlOfRecall.this.teleport(stack, player);
                ArcanaItem.putProperty(stack, PearlOfRecall.HEAT_TAG, 0);
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.PEARL_OF_RECALL_USE));
            } else if (heat > 0) {
                ArcanaItem.putProperty(stack, PearlOfRecall.HEAT_TAG, heat + 1);
                ArcanaEffectUtils.recallTeleportCharge(serverWorld, player.method_19538());
            } else if (heat == -1) {
                ArcanaEffectUtils.recallTeleportCancel(serverWorld, player.method_19538());
                SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)player.method_24515(), (class_3414)class_3417.field_14797, (class_3419)class_3419.field_15248, (float)8.0f, (float)0.8f);
                ArcanaItem.putProperty(stack, PearlOfRecall.HEAT_TAG, 0);
                PearlOfRecall.this.setEnergy(stack, (int)((double)PearlOfRecall.this.getMaxEnergy(stack) * 0.75));
            }
            if (class_1799.method_31577((class_1799)stack, (class_1799)player.method_6047()) || class_1799.method_31577((class_1799)stack, (class_1799)player.method_6079())) {
                class_2487 locNbt = ArcanaItem.getCompoundProperty(stack, PearlOfRecall.LOCATION_TAG);
                String dim = locNbt.method_68564("dim", "");
                double x = locNbt.method_68563("x", 0.0);
                double y = locNbt.method_68563("y", 0.0);
                double z = locNbt.method_68563("z", 0.0);
                class_243 loc = new class_243(x, y, z);
                if (player.method_51469().method_27983().method_29177().toString().equals(dim) && player.method_19538().method_1022(loc) < 30.0) {
                    ArcanaEffectUtils.recallLocation(serverWorld, loc, player);
                }
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                PearlOfRecall.this.addEnergy(stack, 1);
                PearlOfRecall.this.buildItemLore(stack, world.method_8503());
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            boolean canClear;
            class_1799 item = playerEntity.method_5998(hand);
            boolean bl = canClear = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.CHRONO_TEAR.id) >= 1;
            if (playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                class_2487 locNbt = ArcanaItem.getCompoundProperty(item, PearlOfRecall.LOCATION_TAG);
                String dim = locNbt.method_68564("dim", "");
                if (!canClear || !player.method_5715()) {
                    if (dim.equals("unattuned")) {
                        locNbt.method_10582("dim", playerEntity.method_37908().method_27983().method_29177().toString());
                        locNbt.method_10549("x", playerEntity.method_19538().field_1352);
                        locNbt.method_10549("y", playerEntity.method_19538().field_1351);
                        locNbt.method_10549("z", playerEntity.method_19538().field_1350);
                        locNbt.method_10548("yaw", playerEntity.method_36454());
                        locNbt.method_10548("pitch", playerEntity.method_36455());
                        ArcanaItem.putProperty(item, PearlOfRecall.LOCATION_TAG, (class_2520)locNbt);
                        PearlOfRecall.this.buildItemLore(item, playerEntity.method_5682());
                    } else {
                        int curEnergy = PearlOfRecall.this.getEnergy(item);
                        if (curEnergy >= PearlOfRecall.this.getMaxEnergy(item)) {
                            ArcanaItem.putProperty(item, PearlOfRecall.HEAT_TAG, 1);
                            SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)player.method_24515(), (class_3414)class_3417.field_14669, (class_3419)class_3419.field_15248, (float)1.0f, (float)1.0f);
                        } else {
                            playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Pearl Recharging: " + curEnergy * 100 / PearlOfRecall.this.getMaxEnergy(item) + "%")).method_27692(class_124.field_1062), true);
                            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                        }
                    }
                } else if (!dim.equals("unattuned")) {
                    locNbt = new class_2487();
                    locNbt.method_10582("dim", "unattuned");
                    ArcanaItem.putProperty(item, PearlOfRecall.LOCATION_TAG, (class_2520)locNbt);
                    PearlOfRecall.this.buildItemLore(item, playerEntity.method_5682());
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"Saved Location Cleared").method_27692(class_124.field_1062), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_6880.class_6883)class_3417.field_23117, (float)1.0f, (float)0.7f);
                }
            }
            return class_1269.field_52422;
        }
    }
}

