/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.OverflowingQuiver;
import net.borisshoes.arcananovum.items.RunicBow;
import net.borisshoes.arcananovum.items.RunicQuiver;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.DataFixer;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2371;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public abstract class QuiverItem
extends ArcanaItem {
    public static final String ARROWS_TAG = "arrows";
    public static final String QUIVER_SLOT_TAG = "QuiverSlot";
    public static final String QUIVER_ID_TAG = "QuiverId";
    public static final String QUIVER_CD_TAG = "QuiverCD";
    public static final String RUNIC_INV_ID_TAG = "runicInvId";
    public static final String ARROW_INV_ID_TAG = "arrowInvId";
    public static final String RUNIC_INV_SLOT_TAG = "runicInvSlot";
    public static final String ARROW_INV_SLOT_TAG = "arrowInvSlot";
    public static final int size = 9;
    protected class_124 color;

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        if (QuiverItem.getIntProperty(stack, "Version") <= 12) {
            class_2499 arrowsList = QuiverItem.getListProperty(stack, ARROWS_TAG).method_10612();
            stack.method_57379(class_9334.field_49622, (Object)DataFixer.nbtListToComponent(arrowsList, server));
            QuiverItem.removeProperty(stack, ARROWS_TAG);
        }
        class_1799 newStack = super.updateItem(stack, server);
        return this.buildItemLore(newStack, server);
    }

    public class_124 getColor() {
        return this.color;
    }

    protected abstract int getRefillMod(class_1799 var1);

    protected abstract double getEfficiencyMod(class_1799 var1);

    protected void refillArrow(class_3222 player, class_1799 item) {
        class_9288 arrows = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        ArrayList<class_1799> eligible = new ArrayList<class_1799>();
        for (class_1799 stack : arrows.method_59714()) {
            if (stack.method_7947() >= stack.method_7914() || class_1890.method_58117((class_1799)stack)) continue;
            eligible.add(stack);
        }
        if (eligible.isEmpty()) {
            return;
        }
        ((class_1799)eligible.get((int)(Math.random() * (double)eligible.size()))).method_7933(1);
        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.QUIVER_REFILL));
        if (this instanceof OverflowingQuiver) {
            ArcanaAchievements.progress(player, ArcanaAchievements.SPARE_STOCK.id, 1);
        } else if (this instanceof RunicQuiver) {
            ArcanaAchievements.progress(player, ArcanaAchievements.UNLIMITED_STOCK.id, 1);
        }
        this.buildItemLore(item, player.method_5682());
    }

    public boolean shootArrow(class_1799 item, int slot, class_3222 player, class_1799 bow) {
        class_9288 arrowComp = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        boolean runic = ArcanaItemUtils.identifyItem(bow) instanceof RunicBow || bow.method_31574(ArcanaRegistry.ALCHEMICAL_ARBALEST.getItem()) && ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.RUNIC_ARBALEST.id) >= 1;
        class_2371 arrows = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        arrowComp.method_57492(arrows);
        class_1799 stack = (class_1799)arrows.get(slot);
        if (stack.method_7960()) {
            return false;
        }
        int count = stack.method_7947();
        if (class_1890.method_8225((class_6880)MinecraftUtils.getEnchantment((class_5321)class_1893.field_9125), (class_1799)bow) > 0 && item.method_31574(class_1802.field_8107)) {
            return true;
        }
        if (Math.random() >= this.getEfficiencyMod(item)) {
            --count;
        }
        if (count == 0) {
            arrows.set(slot, (Object)class_1799.field_8037);
            QuiverItem.switchArrowOption(player, runic, true);
        } else {
            stack.method_7939(count);
        }
        class_1661 inv = player.method_31548();
        player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), 45, inv.method_5438(40)));
        item.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)arrows));
        this.buildItemLore(item, player.method_5682());
        return true;
    }

    public static class_3545<String, Integer> getArrowOption(class_3222 player, boolean runic, boolean display) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        String invId = profile.getMiscData(runic ? RUNIC_INV_ID_TAG : ARROW_INV_ID_TAG).method_68658().orElse("");
        int invSlot = ((class_2497)profile.getMiscData(runic ? RUNIC_INV_SLOT_TAG : ARROW_INV_SLOT_TAG)).method_10701();
        List<class_3545<String, Integer>> options = QuiverItem.getArrowOptions(player, runic);
        if (options.isEmpty()) {
            return null;
        }
        for (class_3545<String, Integer> option : options) {
            if (!invId.equals(option.method_15442()) || invSlot != (Integer)option.method_15441()) continue;
            return option;
        }
        return QuiverItem.switchArrowOption(player, runic, display);
    }

    public static class_3545<String, Integer> switchArrowOption(class_3222 player, boolean runic, boolean display) {
        class_3545<String, Integer> option;
        int add;
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        String invId = profile.getMiscData(runic ? RUNIC_INV_ID_TAG : ARROW_INV_ID_TAG).method_68658().orElse("");
        int invSlot = ((class_2497)profile.getMiscData(runic ? RUNIC_INV_SLOT_TAG : ARROW_INV_SLOT_TAG)).method_10701();
        List<class_3545<String, Integer>> options = QuiverItem.getArrowOptions(player, runic);
        if (options.isEmpty()) {
            return null;
        }
        int ind = 0;
        boolean found = false;
        for (class_3545<String, Integer> option2 : options) {
            if (invId.equals(option2.method_15442()) && invSlot == (Integer)option2.method_15441()) {
                found = true;
                break;
            }
            ++ind;
        }
        int n = add = player.method_5715() ? -1 : 1;
        if (found) {
            if ((ind = (ind + add) % options.size()) < 0) {
                ind = options.size() + ind;
            }
            option = options.get(ind);
        } else {
            option = options.get(0);
        }
        profile.addMiscData(runic ? RUNIC_INV_ID_TAG : ARROW_INV_ID_TAG, (class_2520)class_2519.method_23256((String)((String)option.method_15442())));
        profile.addMiscData(runic ? RUNIC_INV_SLOT_TAG : ARROW_INV_SLOT_TAG, (class_2520)class_2497.method_23247((int)((Integer)option.method_15441())));
        QuiverItem.getArrowStack(player, runic, display);
        return option;
    }

    public static class_1799 getArrowStack(class_3222 player, boolean runic, boolean display) {
        Predicate PROJECTILES;
        class_3545<String, Integer> option = QuiverItem.getArrowOption(player, runic, display);
        Predicate predicate = PROJECTILES = runic ? RunicBow.RunicBowItem.RUNIC_BOW_PROJECTILES : class_1811.field_18281;
        if (option == null) {
            if (display) {
                player.method_7353((class_2561)class_2561.method_43470((String)"No Arrows Available").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
            }
            return null;
        }
        String invId = (String)option.method_15442();
        int invSlot = (Integer)option.method_15441();
        class_1661 inv = player.method_31548();
        if (invId.equals("inventory")) {
            class_1799 stack = inv.method_5438(invSlot);
            if (PROJECTILES.test(stack)) {
                if (display) {
                    class_2561 name = stack.method_7964();
                    ArcanaItem arcanaArrow = ArcanaItemUtils.identifyItem(stack);
                    if (arcanaArrow instanceof RunicArrow) {
                        RunicArrow runicArrow = (RunicArrow)arcanaArrow;
                        name = runicArrow.getArrowName(stack);
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Switched Arrows To: ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)name.method_27661().method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)(" (" + stack.method_7947() + ")")).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})), true);
                }
                return stack;
            }
            ArcanaNovum.log(2, "Quiver Error Occurred, this shouldn't be possible! Player: " + player.method_5476().getString());
            return null;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            ArcanaItem arcanaItem;
            class_1799 item = inv.method_5438(i);
            if (item.method_7960() || (arcanaItem = ArcanaItemUtils.identifyItem(item)) == null || !QuiverItem.getUUID(item).equals(invId)) continue;
            if (arcanaItem instanceof RunicQuiver) {
                RunicQuiver quiver = (RunicQuiver)arcanaItem;
                class_1799 stack = quiver.getArrow(item, invSlot);
                if (display) {
                    class_2561 name = stack.method_7964();
                    ArcanaItem arcanaArrow = ArcanaItemUtils.identifyItem(stack);
                    if (arcanaArrow instanceof RunicArrow) {
                        RunicArrow runicArrow = (RunicArrow)arcanaArrow;
                        name = runicArrow.getArrowName(stack);
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Switched Arrows To: ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056})).method_10852((class_2561)name.method_27661().method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)(" (" + stack.method_7947() + ")")).method_27695(new class_124[]{class_124.field_1076, class_124.field_1056})), true);
                }
                return stack;
            }
            if (arcanaItem instanceof OverflowingQuiver) {
                OverflowingQuiver quiver = (OverflowingQuiver)arcanaItem;
                class_1799 stack = quiver.getArrow(item, invSlot);
                if (display) {
                    class_2561 name = stack.method_7964();
                    ArcanaItem arcanaArrow = ArcanaItemUtils.identifyItem(stack);
                    if (arcanaArrow instanceof RunicArrow) {
                        RunicArrow runicArrow = (RunicArrow)arcanaArrow;
                        name = runicArrow.getArrowName(stack);
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Switched Arrows To: ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056})).method_10852((class_2561)name.method_27661().method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)(" (" + stack.method_7947() + ")")).method_27695(new class_124[]{class_124.field_1062, class_124.field_1056})), true);
                }
                return stack;
            }
            ArcanaNovum.log(2, "Quiver Error Occurred, this shouldn't be possible! Player: " + player.method_5476().getString());
            return null;
        }
        ArcanaNovum.log(2, "Quiver Error Occurred, this shouldn't be possible! Player: " + player.method_5476().getString());
        return null;
    }

    public static List<class_3545<String, Integer>> getArrowOptions(class_3222 player, boolean runic) {
        ArrayList<class_3545<String, Integer>> options = new ArrayList<class_3545<String, Integer>>();
        Predicate PROJECTILES = runic ? RunicBow.RunicBowItem.RUNIC_BOW_PROJECTILES : class_1811.field_18281;
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 item = inv.method_5438(i);
            if (item.method_7960()) continue;
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(item);
            if (arcanaItem instanceof RunicQuiver) {
                RunicQuiver quiver = (RunicQuiver)arcanaItem;
                arrowComp = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
                arrows = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
                arrowComp.method_57492(arrows);
                for (j = 0; j < arrows.size(); ++j) {
                    arrow = (class_1799)arrows.get(j);
                    if (arrow.method_7960() || ArcanaItemUtils.isRunicArrow(arrow) && !runic) continue;
                    options.add((class_3545<String, Integer>)new class_3545((Object)QuiverItem.getUUID(item), (Object)j));
                }
            } else if (arcanaItem instanceof OverflowingQuiver) {
                OverflowingQuiver quiver = (OverflowingQuiver)arcanaItem;
                arrowComp = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
                arrows = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
                arrowComp.method_57492(arrows);
                for (j = 0; j < arrows.size(); ++j) {
                    arrow = (class_1799)arrows.get(j);
                    if (arrow.method_7960()) continue;
                    options.add((class_3545<String, Integer>)new class_3545((Object)QuiverItem.getUUID(item), (Object)j));
                }
            }
            if (!PROJECTILES.test(item) || !runic && arcanaItem instanceof RunicArrow) continue;
            options.add((class_3545<String, Integer>)new class_3545((Object)"inventory", (Object)i));
        }
        return options;
    }

    public class_1799 getArrow(class_1799 quiver, int slot) {
        class_9288 arrowComp = (class_9288)quiver.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        class_2371 arrows = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        arrowComp.method_57492(arrows);
        class_1799 arrow = (class_1799)arrows.get(slot);
        if (arrow.method_7960()) {
            return null;
        }
        QuiverItem.putProperty(arrow, QUIVER_SLOT_TAG, slot);
        QuiverItem.putProperty(arrow, QUIVER_ID_TAG, QuiverItem.getUUID(quiver));
        return arrow;
    }

    public static void decreaseQuiver(class_1799 bow, class_1799 arrow, class_1657 playerEntity) {
        if (!(playerEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerEntity;
        if (QuiverItem.hasProperty(arrow, QUIVER_SLOT_TAG) && QuiverItem.hasProperty(arrow, QUIVER_ID_TAG)) {
            String quiverId = QuiverItem.getStringProperty(arrow, QUIVER_ID_TAG);
            int slot = QuiverItem.getIntProperty(arrow, QUIVER_SLOT_TAG);
            boolean isInvArrow = quiverId.equals("inventory");
            class_1661 inv = playerEntity.method_31548();
            if (isInvArrow) {
                class_1799 arrowStack = inv.method_5438(slot);
                arrowStack.method_7934(1);
                if (arrowStack.method_7960()) {
                    playerEntity.method_31548().method_7378(arrowStack);
                }
            } else {
                for (int invSlot = 0; invSlot < inv.method_5439(); ++invSlot) {
                    ArcanaItem arcanaItem;
                    class_1799 item = inv.method_5438(invSlot);
                    if (item.method_7960() || !((arcanaItem = ArcanaItemUtils.identifyItem(item)) instanceof QuiverItem)) continue;
                    QuiverItem quiver = (QuiverItem)arcanaItem;
                    if (!QuiverItem.getUUID(item).equals(quiverId)) continue;
                    quiver.shootArrow(item, slot, player, bow);
                    return;
                }
            }
        }
    }
}

