/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.callbacks.ShieldTimerCallback;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10707;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_8103;
import net.minecraft.class_9304;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ShieldOfFortitude
extends ArcanaItem {
    public static final String ID = "shield_of_fortitude";
    public static final class_2960 EFFECT_ID = class_2960.method_60655((String)"arcananovum", (String)"shield_of_fortitude");

    public ShieldOfFortitude() {
        this.id = ID;
        this.name = "Shield of Fortitude";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_8255;
        this.item = new ShieldOfFortitudeItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.shield_of_fortitude", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.EFFECT_ABSORPTION, ResearchTasks.ADVANCEMENT_DEFLECT_ARROW, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This shield is ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"overflowing").method_27695(new class_124[]{class_124.field_1056, class_124.field_1076})).method_10852((class_2561)class_2561.method_43470((String)" with powerful ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"defensive magic").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Your will for ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"protection").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" becomes a tangible ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"fortitude").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Damage").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" blocked").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" becomes ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"absorption hearts").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" and the shield is ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"unbreakable").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_9307 patterns = (class_9307)stack.method_58694(class_9334.field_49619);
        class_1767 color = (class_1767)stack.method_58694(class_9334.field_49620);
        class_1799 newStack = super.updateItem(stack, server);
        if (patterns != null) {
            stack.method_57379(class_9334.field_49619, (Object)patterns);
        }
        if (color != null) {
            stack.method_57379(class_9334.field_49620, (Object)color);
        }
        return this.buildItemLore(newStack, server);
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 shieldStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        if (shieldStack.method_7942()) {
            class_1890.method_57530((class_1799)newArcanaItem, (class_9304)shieldStack.method_58657());
        }
        class_9307 patterns = (class_9307)shieldStack.method_58694(class_9334.field_49619);
        class_1767 color = (class_1767)shieldStack.method_58694(class_9334.field_49620);
        if (color != null) {
            newArcanaItem.method_57379(class_9334.field_49620, (Object)color);
        }
        if (patterns != null) {
            newArcanaItem.method_57379(class_9334.field_49619, (Object)patterns);
        }
        return newArcanaItem;
    }

    public void shieldBlock(class_1309 entity, class_1799 item, double amount) {
        float maxAbs = 10 + 2 * Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.SHIELD_OF_FAITH.id));
        float curAbs = entity.method_6067();
        float addedAbs = (float)Math.min((double)maxAbs, amount * 0.5);
        int duration = 200 + 100 * Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.SHIELD_OF_RESILIENCE.id));
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            BorisLib.addTickTimerCallback((TickTimerCallback)new ShieldTimerCallback(duration, item, player, addedAbs));
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15119, (float)1.0f, (float)1.8f);
        }
        MinecraftUtils.addMaxAbsorption((class_1309)entity, (class_2960)EFFECT_ID, (double)addedAbs);
        entity.method_6073(curAbs + addedAbs);
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Shield of Fortitude").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Shield is my attempt at pouring Arcana into a fully defensive item. The Netherite and obsidian reinforced Shield absorbs the energy of impacts and reconfigures it into a fortification barrier ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Shield of Fortitude").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\naround myself by invoking all four basic protection enchantments and mimicking the effect of golden apples.\n\nHalf of all damage blocked by the Shield becomes an absorption barrier lasting 10 seconds.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Shield of Fortitude").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nDisabling the Shield with an axe causes the absorption barrier to shatter prematurely.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 32);
        ArcanaIngredient r = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9095), 4));
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8463, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9107), 4));
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9111), 4));
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8255, 1, true);
        ArcanaIngredient n = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9096), 4));
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, l, m, n, c}, {b, g, r, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore().withEnchanter());
    }

    public class ShieldOfFortitudeItem
    extends ArcanaPolymerItem {
        public ShieldOfFortitudeItem() {
            super(ShieldOfFortitude.this.getThis(), ShieldOfFortitude.this.getEquipmentArcanaItemComponents().method_64194(class_1304.field_6171).method_57349(class_9334.field_56396, (Object)new class_10707(0.25f, 1.0f, List.of(new class_10707.class_10708(90.0f, Optional.empty(), 0.0f, 1.0f)), new class_10707.class_10709(3.0f, 1.0f, 1.0f), Optional.of(class_8103.field_56242), Optional.of(class_3417.field_15150), Optional.of(class_3417.field_15239))).method_57349(class_9334.field_56399, (Object)class_3417.field_15239).method_57349(class_9334.field_49619, (Object)class_9307.field_49404));
        }

        public class_1799 method_7854() {
            return ShieldOfFortitude.this.prefItem;
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 stack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (stack.method_57826(class_9334.field_49620) && !stack.method_57826(class_9334.field_49631)) {
                stack.method_57379(class_9334.field_49631, (Object)TextUtils.removeItalics((class_2561)this.method_7864(stack)));
            }
            return stack;
        }
    }
}

