/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.NulConstructEntity;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ConcussionArrows
extends RunicArrow {
    public static final String ID = "concussion_arrows";

    public ConcussionArrows() {
        this.id = ID;
        this.name = "Concussion Arrows";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new ConcussionArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.concussion_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.KILL_SQUID, ResearchTasks.ADVANCEMENT_DRAGON_BREATH, ResearchTasks.EFFECT_BLINDNESS, ResearchTasks.EFFECT_WEAKNESS, ResearchTasks.USE_FIREWORK};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Concussion Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" concuss ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"entities ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"near where the arrow ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"impacts").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        int lvl = arrow.getAugment(ArcanaAugments.SHELLSHOCK.id);
        this.concuss((class_1665)arrow, arrow.method_37908(), entityHitResult.method_17784(), lvl);
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        int lvl = arrow.getAugment(ArcanaAugments.SHELLSHOCK.id);
        this.concuss((class_1665)arrow, arrow.method_37908(), blockHitResult.method_17784(), lvl);
    }

    private void concuss(class_1665 arrow, class_1937 world, class_243 pos, int levelBoost) {
        class_238 rangeBox = new class_238(pos.field_1352 + 10.0, pos.field_1351 + 10.0, pos.field_1350 + 10.0, pos.field_1352 - 10.0, pos.field_1351 - 10.0, pos.field_1350 - 10.0);
        float range = (float)class_3532.method_15350((double)(arrow.method_18798().method_1033() * 2.5), (double)1.0, (double)6.0);
        List entities = world.method_8333(null, rangeBox, e -> !e.method_7325() && e.method_5707(pos) < (double)(range * range) && e instanceof class_1309);
        float percent = (1.0f + (float)levelBoost * 0.75f) * range / 6.0f;
        int mobsHit = 0;
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 e2 = (class_1309)entity;
            if (entity instanceof class_1510 || entity instanceof class_1528 || entity instanceof NulConstructEntity) continue;
            if (e2 instanceof class_1308) {
                ++mobsHit;
            }
            class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, (int)(25.0f * percent), 2, false, false, true);
            class_1293 nausea = new class_1293(class_1294.field_5916, (int)(120.0f * percent), 0, false, false, true);
            class_1293 slow = new class_1293(class_1294.field_5909, (int)(40.0f * percent), 4, false, false, true);
            class_1293 slow2 = new class_1293(class_1294.field_5909, (int)(120.0f * percent), 2, false, false, true);
            class_1293 fatigue = new class_1293(class_1294.field_5901, (int)(80.0f * percent), 2 + levelBoost, false, false, true);
            class_1293 weakness = new class_1293(class_1294.field_5911, (int)(120.0f * percent), 1 + levelBoost, false, false, true);
            e2.method_6092(blind);
            e2.method_6092(nausea);
            e2.method_6092(slow);
            e2.method_6092(slow2);
            e2.method_6092(fatigue);
            e2.method_6092(weakness);
            if (!(world instanceof class_3218)) continue;
            class_3218 serverWorld = (class_3218)world;
            if (!(e2 instanceof class_1308)) continue;
            class_1308 mob = (class_1308)e2;
            mob.method_5977(true);
            BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(100, () -> {
                if (mob.method_5805()) {
                    mob.method_5977(false);
                }
            }));
        }
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            if (mobsHit >= 10) {
                ArcanaAchievements.grant(player, ArcanaAchievements.SHOCK_AWE.id);
            }
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)pos), (class_3414)class_3417.field_15188, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.8f);
            ArcanaEffectUtils.concussionArrowShot(serverWorld, pos, range, 0);
        }
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8150, 1).withPotions(class_1847.field_8976);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_28410, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8794, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8150, 1).withPotions(class_1847.field_8970);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, i, a}, {k, h, m, h, k}, {a, i, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Concussion Arrows").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Runic Matrix has been configured to unleash a plethora of unpleasant effects at the area of impact. Anyone caught in its range will have a hard time doing anything for a few seconds after being hit.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class ConcussionArrowsItem
    extends ArcanaPolymerArrowItem {
        public ConcussionArrowsItem() {
            super(ConcussionArrows.this.getThis(), ConcussionArrows.this.getArcanaArrowItemComponents(14391821));
        }

        public class_1799 method_7854() {
            return ConcussionArrows.this.prefItem;
        }
    }
}

