/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class GravitonArrows
extends RunicArrow {
    public static final String ID = "graviton_arrows";

    public GravitonArrows() {
        this.id = ID;
        this.name = "Graviton Arrows";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new GravitonArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.graviton_arrows", (String)this.name).method_27692(class_124.field_1067).method_54663(1387734);
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.ADVANCEMENT_DRAGON_BREATH, ResearchTasks.EFFECT_SLOWNESS};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Graviton Arrows:").method_27692(class_124.field_1067).method_54663(1387734));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" attract").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" entities").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" near the area of ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"impact").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A hit ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"entity").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" is ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"not affected").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        class_1937 class_19372 = arrow.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            int duration = (int)class_3532.method_15350((double)(arrow.method_18798().method_1033() * 7.0), (double)2.0, (double)20.0);
            double range = 3 + arrow.getAugment(ArcanaAugments.GRAVITY_WELL.id);
            this.gravitonPulse((class_1665)arrow, serverWorld, null, entityHitResult.method_17782(), duration, range, 0);
        }
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        class_1937 class_19372 = arrow.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            int duration = (int)class_3532.method_15350((double)(arrow.method_18798().method_1033() * 7.0), (double)2.0, (double)20.0);
            double range = 3 + arrow.getAugment(ArcanaAugments.GRAVITY_WELL.id);
            this.gravitonPulse((class_1665)arrow, serverWorld, blockHitResult.method_17784(), null, duration, range, 0);
        }
    }

    private void gravitonPulse(class_1665 arrow, class_3218 world, @Nullable class_243 start, @Nullable class_1297 entity, int duration, double range, int calls) {
        if (start == null && entity == null) {
            return;
        }
        class_243 pos = entity == null ? start : entity.method_19538();
        int mobsHit = 0;
        class_238 rangeBox = new class_238(pos.field_1352 + 8.0, pos.field_1351 + 8.0, pos.field_1350 + 8.0, pos.field_1352 - 8.0, pos.field_1351 - 8.0, pos.field_1350 - 8.0);
        List entities = world.method_8333(entity, rangeBox, e -> !e.method_7325() && e.method_5707(pos) < 2.0 * range * range && !(e instanceof class_1665));
        for (class_1297 entity1 : entities) {
            class_243 diff = entity1.method_19538().method_1020(pos);
            double multiplier = class_3532.method_15350((double)(diff.method_1033() * 0.2), (double)0.03, (double)2.0);
            class_243 motion = diff.method_1031(0.0, 0.0, 0.0).method_1029().method_1021(-multiplier);
            entity1.method_18800(motion.field_1352, motion.field_1351, motion.field_1350);
            if (entity1 instanceof class_3222) {
                class_3222 player = (class_3222)entity1;
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
            }
            if (!(entity1 instanceof class_1309)) continue;
            class_1309 e2 = (class_1309)entity1;
            if (e2 instanceof class_1308) {
                ++mobsHit;
            }
            int amp = (int)(5.0 - diff.method_1033());
            class_1293 slowness = new class_1293(class_1294.field_5909, 20, amp, false, false, true);
            e2.method_6092(slowness);
        }
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            if (mobsHit >= 10) {
                ArcanaAchievements.grant(player, ArcanaAchievements.BRING_TOGETHER.id);
            }
        }
        ArcanaEffectUtils.gravitonArrowEmit(world, pos, entities);
        if (calls % 10 == 1) {
            SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)pos), (class_3414)class_3417.field_14802, (class_3419)class_3419.field_15248, (float)0.5f, (float)1.6f);
        }
        if (calls < duration) {
            BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(5, () -> this.gravitonPulse(arrow, world, pos, entity, duration, range, calls + 1)));
        }
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8150, 1).withPotions(class_1847.field_8976);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8786, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, g, a}, {c, h, m, h, c}, {a, g, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Graviton Arrows").method_27692(class_124.field_1067).method_54663(1387734), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Runic Matrix amplifies gravity at a single point, drawing in everything nearby. Once at the center, things have a hard time leaving. Great for setting up a combo shot.").method_27692(class_124.field_1074)));
        return list;
    }

    public class GravitonArrowsItem
    extends ArcanaPolymerArrowItem {
        public GravitonArrowsItem() {
            super(GravitonArrows.this.getThis(), GravitonArrows.this.getArcanaArrowItemComponents(869887));
        }

        public class_1799 method_7854() {
            return GravitonArrows.this.prefItem;
        }
    }
}

