/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.areaeffects.AreaEffectTracker;
import net.borisshoes.arcananovum.areaeffects.SmokeArrowAreaEffectTracker;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class SmokeArrows
extends RunicArrow {
    public static final String ID = "smoke_arrows";

    public SmokeArrows() {
        this.id = ID;
        this.name = "Smoke Arrows";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new SmokeArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.smoke_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1063});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.KILL_SQUID, ResearchTasks.USE_CAMPFIRE, ResearchTasks.ADVANCEMENT_DRAGON_BREATH, ResearchTasks.EFFECT_BLINDNESS, ResearchTasks.EFFECT_WEAKNESS};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Smoke Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1063}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" emit ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"smoke").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" particles near where they land.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Smoke").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" gives ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"blindness").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"weakness").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" to those inside it.").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        class_1937 class_19372 = arrow.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            float range = (float)class_3532.method_15350((double)(arrow.method_18798().method_1033() * 0.8), (double)0.3, (double)2.5);
            int gasLvl = arrow.getAugment(ArcanaAugments.TEAR_GAS.id);
            ((AreaEffectTracker)ArcanaRegistry.AREA_EFFECTS.method_63535(ArcanaRegistry.SMOKE_ARROW_AREA_EFFECT_TRACKER.getId())).addSource(SmokeArrowAreaEffectTracker.source(arrow.method_24921(), entityHitResult.method_17782(), null, null, range, gasLvl));
        }
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        class_1937 class_19372 = arrow.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            float range = (float)class_3532.method_15350((double)(arrow.method_18798().method_1033() * 0.8), (double)0.3, (double)2.5);
            int gasLvl = arrow.getAugment(ArcanaAugments.TEAR_GAS.id);
            ((AreaEffectTracker)ArcanaRegistry.AREA_EFFECTS.method_63535(ArcanaRegistry.SMOKE_ARROW_AREA_EFFECT_TRACKER.getId())).addSource(SmokeArrowAreaEffectTracker.source(arrow.method_24921(), null, blockHitResult.method_17777(), serverWorld, range, gasLvl));
        }
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_17346, 12);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_28410, 12);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8794, 12);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8150, 1).withPotions(class_1847.field_8970);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, i, a}, {k, h, m, h, k}, {a, i, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Smoke Arrows").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Runic Matrix has been configured to summon copious amounts of smoke. Those inside will have trouble seeing and even breathing, making it harder to land a solid blow.").method_27692(class_124.field_1074)));
        return list;
    }

    public class SmokeArrowsItem
    extends ArcanaPolymerArrowItem {
        public SmokeArrowsItem() {
            super(SmokeArrows.this.getThis(), SmokeArrows.this.getArcanaArrowItemComponents(0x696969));
        }

        public class_1799 method_7854() {
            return SmokeArrows.this.prefItem;
        }
    }
}

