/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.areaeffects.AftershockAreaEffectTracker;
import net.borisshoes.arcananovum.areaeffects.AreaEffectTracker;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1438;
import net.minecraft.class_1538;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class StormArrows
extends RunicArrow {
    public static final String ID = "storm_arrows";
    private static final double[] stormChance = new double[]{0.1, 0.2, 0.4, 0.6, 0.8, 1.0};

    public StormArrows() {
        this.id = ID;
        this.name = "Storm Arrows";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new StormArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.storm_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1080});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.ADVANCEMENT_LIGHTNING_ROD_WITH_VILLAGER_NO_FIRE, ResearchTasks.OBTAIN_LIGHTNING_ROD};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Storm Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" channel ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"lightning ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"from the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"clouds ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"above.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Only a ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"small chance").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to work when not ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"raining").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        int stableLvl = arrow.getAugment(ArcanaAugments.STORM_STABILIZATION.id);
        int chainLvl = arrow.getAugment(ArcanaAugments.CHAIN_LIGHTNING.id);
        int shockLvl = arrow.getAugment(ArcanaAugments.AFTERSHOCK.id);
        this.strike((class_1665)arrow, entityHitResult.method_17784(), stableLvl, shockLvl);
        if (chainLvl > 0) {
            this.chainLightning((class_1665)arrow, entityHitResult.method_17782(), chainLvl);
        }
        entityHitResult.method_17782().field_6008 = 1;
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        int stableLvl = arrow.getAugment(ArcanaAugments.STORM_STABILIZATION.id);
        int shockLvl = arrow.getAugment(ArcanaAugments.AFTERSHOCK.id);
        this.strike((class_1665)arrow, blockHitResult.method_17784(), stableLvl, shockLvl);
    }

    private void strike(class_1665 arrow, class_243 pos, int stableLevel, int shockLvl) {
        class_1937 world = arrow.method_37908();
        if (arrow.method_7443() && (world.method_8419() || world.method_8546() || Math.random() < stormChance[stableLevel])) {
            class_1538 lightning = new class_1538(class_1299.field_6112, arrow.method_37908());
            lightning.method_33574(pos);
            world.method_8649((class_1297)lightning);
            class_1297 class_12972 = arrow.method_24921();
            if (class_12972 instanceof class_3222) {
                class_3222 player = (class_3222)class_12972;
                BorisLib.addTickTimerCallback((class_3218)player.method_51469(), (TickTimerCallback)new GenericTimer(2, () -> {
                    if (lightning.method_37221().anyMatch(e -> e instanceof class_1438)) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.SHOCK_THERAPY.id);
                    }
                }));
            }
            if (shockLvl > 0 && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                ((AreaEffectTracker)ArcanaRegistry.AREA_EFFECTS.method_63535(ArcanaRegistry.AFTERSHOCK_AREA_EFFECT_TRACKER.getId())).addSource(AftershockAreaEffectTracker.source(arrow.method_24921(), class_2338.method_49638((class_2374)pos), serverWorld, shockLvl));
                SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)pos), (class_6880)class_3417.field_14896, (class_3419)class_3419.field_15248, (float)0.2f, (float)1.0f);
            }
        }
    }

    private void chainLightning(class_1665 arrow, class_1297 hitEntity, int lvl) {
        class_1937 class_19372 = arrow.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_243 pos = hitEntity.method_19538();
        double range = 5.0;
        class_238 rangeBox = new class_238(pos.field_1352 + 8.0, pos.field_1351 + 8.0, pos.field_1350 + 8.0, pos.field_1352 - 8.0, pos.field_1351 - 8.0, pos.field_1350 - 8.0);
        List entities = world.method_8333(arrow.method_24921(), rangeBox, e -> !e.method_7325() && e.method_5707(pos) < range * range && !(e instanceof class_1665));
        ArrayList<class_1309> hits = new ArrayList<class_1309>();
        if (hitEntity instanceof class_1309) {
            class_1309 le = (class_1309)hitEntity;
            hits.add(le);
        }
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 e2 = (class_1309)entity;
            if (hits.size() >= lvl + 1) continue;
            if (!hits.isEmpty()) {
                class_1309 lastHit = (class_1309)hits.get(hits.size() - 1);
                double dist = lastHit.method_19538().method_1022(e2.method_19538());
                if (world instanceof class_3218) {
                    class_3218 serverWorld = world;
                    ArcanaEffectUtils.line((class_3218)serverWorld, null, (class_243)lastHit.method_19538().method_1031(0.0, (double)(lastHit.method_17682() / 2.0f), 0.0), (class_243)e2.method_19538().method_1031(0.0, (double)(e2.method_17682() / 2.0f), 0.0), (class_2394)class_2398.field_29643, (int)((int)(dist * 8.0)), (int)2, (double)0.05, (double)0.05);
                }
            }
            class_1282 source = ArcanaDamageTypes.of((class_1937)world, ArcanaDamageTypes.ARCANE_LIGHTNING, (class_1297)arrow, arrow.method_24921());
            e2.field_6008 = 1;
            e2.method_64397(world, source, 6.0f);
            hits.add(e2);
        }
        SoundUtils.playSound((class_1937)world, (class_2338)class_2338.method_49638((class_2374)pos), (class_6880)class_3417.field_14896, (class_3419)class_3419.field_15248, (float)0.1f, (float)2.0f);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_27051, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9117), 1));
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, g, a}, {c, h, m, h, c}, {a, g, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Storm Arrows").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe Channeling enchantment requires a storm to use. Throwing a bit of Arcana into it seems to charge the air enough to mimic a storm, although it isn\u2019t always successful in doing so.").method_27692(class_124.field_1074)));
        return list;
    }

    public class StormArrowsItem
    extends ArcanaPolymerArrowItem {
        public StormArrowsItem() {
            super(StormArrows.this.getThis(), StormArrows.this.getArcanaArrowItemComponents(12040354));
        }

        public class_1799 method_7854() {
            return StormArrows.this.prefItem;
        }
    }
}

