/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class TetherArrows
extends RunicArrow {
    public static final String ID = "tether_arrows";

    public TetherArrows() {
        this.id = ID;
        this.name = "Tether Arrows";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new TetherArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.tether_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1080});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.RIPTIDE_TRIDENT, ResearchTasks.FISH_MOB, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Tether Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"pull").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" you to a block like a ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"grappling hook").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"They will also ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"pull").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" a hit ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"entity ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"towards you.").method_27692(class_124.field_1075)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        if (arrow.getData().method_68566("severed", false)) {
            return;
        }
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_12972 = entityHitResult.method_17782();
            if (class_12972 instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                class_243 hitPos = entityHitResult.method_17784();
                BorisLib.addTickTimerCallback((class_3218)player.method_51469(), (TickTimerCallback)new GenericTimer(1, () -> {
                    class_243 motion = player.method_19538().method_1020(hitPos);
                    class_243 horizBoost = motion.method_18805(1.0, 0.0, 1.0).method_1029().method_1021(1.5);
                    motion = motion.method_1019(horizBoost);
                    double verticalMotion = motion.field_1351 < -3.0 ? (player.method_23318() - entity.method_23318()) * 0.3 : this.velFromHeight(motion.field_1351) / 20.0;
                    class_243 velocity = new class_243(this.velFromLength(motion.field_1352) * 2.0 / 9.0, verticalMotion, this.velFromLength(motion.field_1350) * 2.0 / 9.0);
                    entity.method_18799(velocity);
                    if (entity instanceof class_3222) {
                        class_3222 targetPlayer = (class_3222)entity;
                        targetPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)targetPlayer));
                    }
                    ArcanaEffectUtils.tetherArrowEntity(player.method_51469(), entity, player);
                    SoundUtils.playSound((class_1937)arrow.method_37908(), (class_2338)player.method_24515(), (class_6880)class_3417.field_14606, (class_3419)class_3419.field_15248, (float)0.8f, (float)0.6f);
                }));
            }
        }
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        if (arrow.getData().method_68566("severed", false)) {
            return;
        }
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_243 hitPos = blockHitResult.method_17784();
            class_243 motion = hitPos.method_1020(player.method_19538());
            class_243 horizBoost = motion.method_18805(1.0, 0.0, 1.0).method_1029().method_1021(1.5);
            class_243 velocity = new class_243(this.velFromLength(motion.field_1352) * 2.0 / 9.0, this.velFromHeight(motion.field_1351) / 20.0, this.velFromLength(motion.field_1350) * 2.0 / 9.0);
            player.method_18799(velocity);
            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
            ArcanaEffectUtils.tetherArrowGrapple(player.method_51469(), player, blockHitResult.method_17784());
            SoundUtils.playSound((class_1937)arrow.method_37908(), (class_2338)player.method_24515(), (class_6880)class_3417.field_14806, (class_3419)class_3419.field_15248, (float)0.8f, (float)0.6f);
            if (motion.field_1351 >= 12.0) {
                ArcanaAchievements.progress(player, ArcanaAchievements.SPIDERMAN.id, 1);
            }
        }
    }

    private double velFromLength(double d) {
        double a = 0.96;
        return -20.0 * d * Math.log(a);
    }

    private double velFromHeight(double h) {
        double a = 0.98;
        double b = 0.08;
        if (h < 0.0) {
            h = 0.0;
        }
        if (h < 1.0) {
            h += 0.5;
        } else if (h > 1.0) {
            h += 1.5;
        }
        double exp = -Math.pow(a, h / (a * b) - h / b);
        double n = 20.0 * a * b * (this.lambertNeg(exp / Math.E) + 1.0);
        return n / (a - 1.0);
    }

    private double appx1(double x, double y) {
        return x - (x * Math.exp(x) - y) / ((x + 1.0) * Math.exp(x));
    }

    private double appx2(double x, double y) {
        return this.appx1(this.appx1(this.appx1(this.appx1(this.appx1(this.appx1(this.appx1(this.appx1(x, y), y), y), y), y), y), y), y);
    }

    private double lambertNeg(double y) {
        return y > -0.36787944117144233 ? (y > 0.0 ? 0.0 : this.appx2(this.appx2(this.appx2(this.appx2(this.appx2(this.appx2(this.appx2(this.appx2(-2.0, y), y), y), y), y), y), y), y)) : 0.0;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8276, 32);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9104), 3));
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8998);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, i, a}, {c, h, m, h, c}, {a, i, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Tether Arrows").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThrough precise kinematic equations formed on the Matrix, these Arrows should form the perfect tether to pull me to the location I shoot. It can also pull creatures towards me.").method_27692(class_124.field_1074)));
        return list;
    }

    public class TetherArrowsItem
    extends ArcanaPolymerArrowItem {
        public TetherArrowsItem() {
            super(TetherArrows.this.getThis(), TetherArrows.this.getArcanaArrowItemComponents(0xA3A3A3));
        }

        public class_1799 method_7854() {
            return TetherArrows.this.prefItem;
        }
    }
}

