/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2279;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2421;
import net.minecraft.class_2513;
import net.minecraft.class_2523;
import net.minecraft.class_2526;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3830;
import net.minecraft.class_4538;
import net.minecraft.class_4865;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5543;
import net.minecraft.class_5812;
import net.minecraft.class_5819;
import net.minecraft.class_7110;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class WildGrowthCharm
extends ArcanaItem {
    public static final String ID = "wild_growth_charm";
    public static final String HARVEST_TAG = "harvest";
    private static final int[] RATES = new int[]{10, 7, 5, 3, 2};

    public WildGrowthCharm() {
        this.id = ID;
        this.name = "Charm of Wild Growth";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS, TomeGui.TomeFilter.CHARMS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_17540;
        this.item = new WildGrowthCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.wild_growth_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1060});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TEMPORAL_MOMENT, ResearchTasks.ADVANCEMENT_BREED_AN_ANIMAL, ResearchTasks.ADVANCEMENT_PLANT_ANY_SNIFFER_SEED, ResearchTasks.ADVANCEMENT_PLANT_SEED, ResearchTasks.ADVANCEMENT_OBTAIN_NETHERITE_HOE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        WildGrowthCharm.putProperty(stack, "active", false);
        WildGrowthCharm.putProperty(stack, HARVEST_TAG, false);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"charm").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" smells of a ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"cool").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" spring").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" breeze.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Nearby ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"plants").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"animals").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" seem to be").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" invigorated").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" by its ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"proximity").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" the ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"to toggle ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"its ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"effect").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_16998, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_17538, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_17498, 16);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_17539, 16);
        ArcanaIngredient e = new ArcanaIngredient(class_1802.field_8179, 16);
        ArcanaIngredient f = new ArcanaIngredient(class_1802.field_17537, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_42695, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8242, 8);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_17517, 16);
        ArcanaIngredient j = new ArcanaIngredient(class_1802.field_42688, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_17523, 16);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.TEMPORAL_MOMENT, 1);
        ArcanaIngredient o = new ArcanaIngredient(class_1802.field_8648, 16);
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_17536, 16);
        ArcanaIngredient q = new ArcanaIngredient(class_1802.field_17516, 16);
        ArcanaIngredient s = new ArcanaIngredient(class_1802.field_43192, 16);
        ArcanaIngredient t = new ArcanaIngredient(class_1802.field_17540, 16);
        ArcanaIngredient u = new ArcanaIngredient(class_1802.field_8567, 16);
        ArcanaIngredient v = new ArcanaIngredient(class_1802.field_17535, 16);
        ArcanaIngredient w = new ArcanaIngredient(class_1802.field_17531, 16);
        ArcanaIngredient x = new ArcanaIngredient(class_1802.field_37508, 16);
        ArcanaIngredient y = new ArcanaIngredient(class_1802.field_28659, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, e}, {f, g, h, i, j}, {k, h, m, h, o}, {p, q, h, s, t}, {u, v, w, x, y}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n     Wild Growth").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nLiving things constantly grow and change with time. It should be possible to accelerate this process in all organisms as long as adequate nutrients are supplied with a \n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n     Wild Growth").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), class_2561.method_43470((String)"\nfew temporal tricks.\n\nThe Charm causes nearby animals and plants to grow faster.\nThe Charm also causes animals to breed periodically.\n\nSneak Using toggles the Charm\u2019s effect.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class WildGrowthCharmItem
    extends ArcanaPolymerItem {
        public WildGrowthCharmItem() {
            super(WildGrowthCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            ArrayList<String> stringList = new ArrayList<String>();
            if (active) {
                stringList.add("on");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return WildGrowthCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_3218 serverWorld;
            block28: {
                block27: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block27;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block28;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            try {
                boolean active = ArcanaItem.getBooleanProperty(stack, "active");
                boolean harvest = ArcanaItem.getBooleanProperty(stack, WildGrowthCharm.HARVEST_TAG);
                int fertLvl = Math.max(ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.FERTILIZATION.id), 0);
                int tickTime = RATES[fertLvl];
                if (active && !world.field_9236 && player.method_5682().method_3780() % tickTime == 0) {
                    boolean bloom = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.CHARM_OF_BLOOMING.id) >= 1;
                    int reaping = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.REAPING.id);
                    int count = 0;
                    for (class_2338 blockPos : class_2338.method_34848((class_5819)player.method_59922(), (int)100, (class_2338)player.method_24515(), (int)4)) {
                        class_2302 crop;
                        class_2680 state = world.method_8320(blockPos);
                        class_2248 block = state.method_26204();
                        if (count >= 2) break;
                        ++count;
                        if (block instanceof class_2526) {
                            --count;
                        } else if (block instanceof class_2523 || block instanceof class_2421 || block instanceof class_2266 || block instanceof class_2279 || block instanceof class_5812 || block instanceof class_5543) {
                            state.method_26199(player.method_51469(), blockPos, world.method_8409());
                            world.method_20290(1505, blockPos, 15);
                        } else if ((block instanceof class_4865 || block instanceof class_2302 || block instanceof class_2282 || block instanceof class_2513 || block instanceof class_3830) && class_1752.method_7720((class_1799)new class_1799((class_1935)class_1802.field_8324, 64), (class_1937)world, (class_2338)blockPos)) {
                            world.method_20290(1505, blockPos, 15);
                            class_2248 class_22482 = world.method_8320(blockPos).method_26204();
                            if (class_22482 instanceof class_2302 && (crop = (class_2302)class_22482).method_9825(world.method_8320(blockPos))) {
                                ArcanaAchievements.progress(player, ArcanaAchievements.BOUNTIFUL_HARVEST.id, 1);
                                ArcanaNovum.data((class_1657)player).addXP(reaping >= 2 && harvest ? ArcanaConfig.getInt(ArcanaRegistry.WILD_GROWTH_CHARM_PER_REAPED_CROP) : ArcanaConfig.getInt(ArcanaRegistry.WILD_GROWTH_CHARM_PER_MATURE_CROP));
                            }
                        } else if (bloom && class_1752.method_7720((class_1799)new class_1799((class_1935)class_1802.field_8324, 64), (class_1937)world, (class_2338)blockPos)) {
                            world.method_20290(1505, blockPos, 15);
                        } else if (bloom && class_1752.method_7719((class_1799)new class_1799((class_1935)class_1802.field_8324, 64), (class_1937)world, (class_2338)blockPos, (class_2350)class_2350.method_10162((class_5819)player.method_59922()))) {
                            world.method_20290(1505, blockPos, 15);
                        } else {
                            --count;
                        }
                        if (reaping < 1 || !harvest) continue;
                        if (block instanceof class_2302 && (crop = (class_2302)block).method_9825(world.method_8320(blockPos))) {
                            world.method_8651(blockPos, true, (class_1297)player);
                            if (reaping < 2 || !crop.method_9558(world.method_8320(blockPos.method_10074()), (class_4538)world, blockPos)) continue;
                            world.method_8501(blockPos, block.method_9564());
                            continue;
                        }
                        if (!(block instanceof class_2421)) continue;
                        class_2421 wart = (class_2421)block;
                        if ((Integer)world.method_8320(blockPos).method_11654((class_2769)class_2421.field_11306) != 3) continue;
                        world.method_8651(blockPos, true, (class_1297)player);
                        if (reaping < 2 || !wart.method_9558(world.method_8320(blockPos.method_10074()), (class_4538)world, blockPos)) continue;
                        world.method_8501(blockPos, block.method_9564());
                    }
                    List animals = world.method_8333((class_1297)player, player.method_5829().method_1014(5.0), e -> e instanceof class_1429 || e instanceof class_7110);
                    Collections.shuffle(animals);
                    for (class_1297 a : animals) {
                        if (a instanceof class_1429) {
                            class_1429 animal = (class_1429)a;
                            int i = animal.method_5618();
                            if (!animal.method_37908().field_9236 && i == 0 && animal.method_6482()) {
                                animal.method_6480((class_1657)player);
                                break;
                            }
                            if (!animal.method_6109()) continue;
                            animal.method_5620(class_1429.method_41321((int)(-i)), true);
                            serverWorld.method_65096((class_2394)class_2398.field_17741, animal.method_23317(), animal.method_23318() + (double)animal.method_17682() * 0.5, animal.method_23321(), 3, 0.2, 0.2, 0.2, 1.0);
                            break;
                        }
                        if (!(a instanceof class_7110)) continue;
                        class_7110 tadpole = (class_7110)a;
                        tadpole.method_41392(class_1296.method_41321((int)tadpole.method_41398()));
                        serverWorld.method_65096((class_2394)class_2398.field_17741, tadpole.method_23317(), tadpole.method_23318() + (double)tadpole.method_17682() * 0.5, tadpole.method_23321(), 3, 0.2, 0.2, 0.2, 1.0);
                        break;
                    }
                    if (animals.stream().filter(e -> {
                        class_1429 animal;
                        return e instanceof class_1429 && (animal = (class_1429)e).method_6109();
                    }).count() >= 5L) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.THEY_GROW_UP_SO_FAST.id);
                    }
                    if (count >= 2) {
                        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.WILD_GROWTH_CHARM_PASSIVE));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            boolean active = ArcanaItem.getBooleanProperty(stack, "active");
            boolean harvest = ArcanaItem.getBooleanProperty(stack, WildGrowthCharm.HARVEST_TAG);
            int reaping = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.REAPING.id);
            if (playerEntity.method_5715()) {
                if (reaping > 0 && hand == class_1268.field_5810) {
                    harvest = !harvest;
                    ArcanaItem.putProperty(stack, WildGrowthCharm.HARVEST_TAG, harvest);
                    if (harvest) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Charm Begins to Reap").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14653, (float)0.7f, (float)0.7f);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Charm Ceases Reaping").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_33433, (float)2.0f, (float)0.5f);
                    }
                } else {
                    active = !active;
                    ArcanaItem.putProperty(stack, "active", active);
                    if (active) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Charm Begins to Bloom").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14653, (float)0.7f, (float)0.7f);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Charm Recedes").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_33433, (float)2.0f, (float)0.5f);
                    }
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }

        public class_1269 method_7884(class_1838 context) {
            class_1657 playerEntity = context.method_8036();
            class_1937 world = context.method_8045();
            class_2338 blockPos = context.method_8037();
            class_2338 blockPos2 = blockPos.method_10093(context.method_8038());
            class_1799 stack = context.method_8041();
            if (playerEntity != null && playerEntity.method_5715() && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                boolean active = ArcanaItem.getBooleanProperty(stack, "active");
                active = !active;
                ArcanaItem.putProperty(stack, "active", active);
                if (active) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Charm Begins to Bloom").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14653, (float)0.7f, (float)0.7f);
                } else {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Charm Recedes").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_33433, (float)2.0f, (float)0.5f);
                }
                return class_1269.field_52422;
            }
            if (ArcanaAugments.getAugmentOnItem(context.method_8041(), ArcanaAugments.CHARM_OF_BLOOMING.id) < 1) {
                return class_1269.field_5811;
            }
            if (class_1752.method_7720((class_1799)new class_1799((class_1935)class_1802.field_8324, 64), (class_1937)world, (class_2338)blockPos)) {
                if (!world.field_9236) {
                    world.method_20290(1505, blockPos, 15);
                }
                return class_1269.field_52422;
            }
            class_2680 blockState = world.method_8320(blockPos);
            boolean bl = blockState.method_26206((class_1922)world, blockPos, context.method_8038());
            if (bl && class_1752.method_7719((class_1799)new class_1799((class_1935)class_1802.field_8324, 64), (class_1937)world, (class_2338)blockPos2, (class_2350)context.method_8038())) {
                if (!world.field_9236) {
                    world.method_20290(1505, blockPos2, 15);
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
    }
}

