/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.normal;

import java.util.ArrayList;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.NormalPolymerItem;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import xyz.nucleoid.packettweaker.PacketContext;

public class ArcaneNotesItem
extends NormalPolymerItem {
    public static final String UNLOCK_ID_TAG = "research_id";
    public static final String AUTHOR_TAG = "author";
    public static final String COST_TAG = "paper_cost";

    public ArcaneNotesItem(String id, class_1792.class_1793 settings) {
        super(id, settings);
    }

    public static class_1799 buildLore(class_1799 stack) {
        if (!stack.method_31574(ArcanaRegistry.ARCANE_NOTES)) {
            return stack;
        }
        ArrayList<class_5250> loreText = new ArrayList<class_5250>();
        String id = ArcanaItem.getStringProperty(stack, UNLOCK_ID_TAG);
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        if (arcanaItem != null) {
            loreText.add(class_2561.method_43470((String)"").method_10852((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Contains notes for the ").method_27692(class_124.field_1064))).method_10852((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43471((String)arcanaItem.getItem().method_7876()).method_27692(ArcanaRarity.getColor(arcanaItem.getRarity())))));
            String author = ArcanaItem.getStringProperty(stack, AUTHOR_TAG);
            if (!author.isEmpty()) {
                loreText.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Scribed by ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056})).method_10852((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)author).method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}))));
            }
        }
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreText, loreText));
        return stack;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        String id = ArcanaItem.getStringProperty(stack, UNLOCK_ID_TAG);
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        if (arcanaItem != null && user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            ArcanaEffectUtils.arcaneNotesAnim(player, arcanaItem, remainingUseTicks);
            int maxUseTime = this.method_7881(stack, user);
            boolean alreadyUnlocked = ArcanaNovum.data((class_1657)player).hasResearched(arcanaItem);
            if (alreadyUnlocked) {
                float pitch = 1.0f + (float)(maxUseTime - remainingUseTicks) / (float)maxUseTime;
                if (remainingUseTicks % 8 == 0) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_40971, (float)2.0f, (float)pitch);
                } else if (remainingUseTicks % 4 == 0) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_40974, (float)2.0f, (float)pitch);
                }
            } else if (remainingUseTicks % 7 == 0) {
                float pitch = 0.7f + 1.3f * ((float)(maxUseTime - remainingUseTicks) / (float)maxUseTime);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_17481, (float)1.0f, (float)pitch);
            }
        }
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (ArcanaItem.hasProperty(itemStack, UNLOCK_ID_TAG)) {
            user.method_6019(hand);
            return class_1269.field_21466;
        }
        return super.method_7836(world, user, hand);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return ArcanaItem.hasProperty(stack, UNLOCK_ID_TAG) ? 120 : 0;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        String id = ArcanaItem.getStringProperty(stack, UNLOCK_ID_TAG);
        ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
        if (arcanaItem != null && user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            boolean alreadyUnlocked = ArcanaNovum.data((class_1657)player).hasResearched(arcanaItem);
            if (alreadyUnlocked) {
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_28560, (float)2.0f, (float)0.6f);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15119, (float)1.0f, (float)0.5f);
                class_1799 paper = new class_1799((class_1935)ArcanaRarity.getArcanePaper(arcanaItem.getRarity()));
                int cost = ArcanaItem.getIntProperty(stack, COST_TAG);
                if (cost != 0) {
                    paper.method_7939(cost);
                } else {
                    paper.method_7939(player.method_59922().method_39332(5, 24));
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaRarity.getCraftXp(arcanaItem.getRarity()));
                }
                MinecraftUtils.returnItems((class_1263)new class_1277(new class_1799[]{paper}), (class_1657)player);
            } else {
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15119, (float)2.0f, (float)0.8f);
                ArcanaNovum.data((class_1657)player).addResearchedItem(arcanaItem.getId());
            }
            ArcanaEffectUtils.arcaneNotesFinish(player, arcanaItem);
        }
        if (!user.method_56992()) {
            stack.method_7934(1);
        }
        return stack;
    }

    @Override
    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        return class_1802.field_8529;
    }
}

