/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.mixins;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.items.ArcaneTome;
import net.borisshoes.arcananovum.items.BinaryBlades;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public class ItemEntityMixin {
    @Inject(method={"setStack"}, at={@At(value="HEAD")})
    private void arcananovum_destroyFake(class_1799 stack, CallbackInfo ci) {
        class_1542 itemEntity = (class_1542)this;
        if (BinaryBlades.isFakeBlade(stack)) {
            itemEntity.method_31472();
        }
        if (ArcanaItem.hasProperty(stack, "split")) {
            ArcanaItem.putProperty(stack, "split", false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void arcananovum_worldDetection(CallbackInfo ci) {
        class_1542 itemEntity = (class_1542)this;
        class_1799 stack = itemEntity.method_6983();
        class_1937 world = itemEntity.method_37908();
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
        class_1937 class_19372 = itemEntity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (arcanaItem instanceof Soulstone) {
            class_2680 state;
            boolean hasAnnihilation;
            boolean bl = hasAnnihilation = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SOUL_ANNIHILATION.id) > 0;
            if (hasAnnihilation && (state = world.method_8320(itemEntity.method_24515())).method_27852(class_2246.field_22089) && !Soulstone.getType(stack).equals("unattuned")) {
                itemEntity.method_6979(Soulstone.setUnattuned(stack));
                SoundUtils.soulSounds((class_3218)serverWorld, (class_2338)itemEntity.method_24515(), (int)30, (int)20);
                serverWorld.method_65096((class_2394)class_2398.field_23114, itemEntity.method_23317(), itemEntity.method_23318() + 0.125, itemEntity.method_23321(), 100, 0.25, 0.25, 0.25, 0.07);
            }
        } else if (arcanaItem instanceof ArcaneTome) {
            class_2338 smithPos;
            class_2680 state;
            int craftTick = 0;
            if (ArcanaItem.hasProperty(stack, "forgeCraftTick")) {
                craftTick = ArcanaItem.getIntProperty(stack, "forgeCraftTick");
            }
            List otherEntities = world.method_18023((class_5575)class_1299.field_6052, itemEntity.method_5829().method_1014(1.25), e -> !e.method_5667().equals(itemEntity.method_5667()) && !ArcanaItemUtils.isArcane(e.method_6983()));
            boolean proceed = false;
            class_1542 gappleEntity = null;
            for (Object other : otherEntities) {
                class_1799 otherStack = other.method_6983();
                if (!otherStack.method_31574(class_1802.field_8367)) continue;
                proceed = true;
                gappleEntity = other;
                break;
            }
            long timeOfDay = serverWorld.method_8532();
            int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
            int curTime = (int)(timeOfDay % 24000L);
            int curPhase = day % 8;
            if (curPhase != 4 || curTime < 14000 || curTime > 22000) {
                proceed = false;
            }
            if (!(state = world.method_8320(smithPos = class_2338.method_49638((class_2374)itemEntity.method_19538().method_1031(0.0, -0.25, 0.0)))).method_27852(class_2246.field_16329)) {
                proceed = false;
            }
            ArcanaItem forgeItem = ArcanaRegistry.STARLIGHT_FORGE;
            String playerId = forgeItem.getCrafter(stack);
            class_3222 player = serverWorld.method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)playerId));
            if (player != null && !ArcanaNovum.data((class_1657)player).hasResearched(forgeItem)) {
                proceed = false;
            }
            if (proceed) {
                if (++craftTick == 100) {
                    serverWorld.method_8652(smithPos, ((ArcanaBlock)ArcanaRegistry.STARLIGHT_FORGE).getBlock().method_9564(), 3);
                    class_2586 blockEntity = serverWorld.method_8321(smithPos);
                    if (blockEntity instanceof StarlightForgeBlockEntity) {
                        class_1799 gappleStack;
                        StarlightForgeBlockEntity forge = (StarlightForgeBlockEntity)blockEntity;
                        class_1799 newForgeStack = forgeItem.addCrafter(forgeItem.getNewItem(), playerId, false, serverWorld.method_8503());
                        ArcanaPolymerBlockEntity.initializeArcanaBlock(newForgeStack, forge);
                        if (player != null && !ArcanaNovum.data((class_1657)player).addCrafted(newForgeStack)) {
                            ArcanaNovum.data((class_1657)player).addXP(ArcanaRarity.getCraftXp(forgeItem.getRarity()));
                        }
                        if ((gappleStack = gappleEntity.method_6983()).method_7947() == 1) {
                            gappleEntity.method_31472();
                        } else {
                            gappleStack.method_7934(1);
                            gappleEntity.method_6979(gappleStack);
                        }
                    }
                    ArcanaItem.removeProperty(stack, "forgeCraftTick");
                } else {
                    ArcanaItem.putProperty(stack, "forgeCraftTick", craftTick);
                }
                ArcanaEffectUtils.craftForge(serverWorld, smithPos, craftTick);
            } else {
                ArcanaItem.removeProperty(stack, "forgeCraftTick");
            }
            itemEntity.method_6979(stack);
        }
        if (!ArcanaItemUtils.isArcane(stack) && stack.method_31574(ArcanaRegistry.MUNDANE_ARCANE_PAPER)) {
            boolean proceed = false;
            class_1542 eyeEntity = null;
            class_2338 enchantPos = class_2338.method_49638((class_2374)itemEntity.method_19538().method_1031(0.0, -0.25, 0.0));
            class_2680 state = world.method_8320(enchantPos);
            if (state.method_27852(class_2246.field_10485)) {
                List otherEntities = world.method_18023((class_5575)class_1299.field_6052, itemEntity.method_5829().method_1014(1.25), e -> !e.method_5667().equals(itemEntity.method_5667()) && !ArcanaItemUtils.isArcane(e.method_6983()));
                for (class_1542 other : otherEntities) {
                    class_1799 otherStack = other.method_6983();
                    if (!otherStack.method_31574(class_1802.field_8449)) continue;
                    proceed = true;
                    eyeEntity = other;
                    break;
                }
            }
            if (proceed && stack.method_7947() >= 4) {
                int craftTick = 0;
                if (ArcanaItem.hasProperty(stack, "tomeCraftTick")) {
                    craftTick = ArcanaItem.getIntProperty(stack, "tomeCraftTick");
                }
                if (++craftTick == 100) {
                    class_1799 eyeStack;
                    class_1799 tomeStack = ArcanaRegistry.ARCANE_TOME.getNewItem();
                    class_1657 tomeCrafter = serverWorld.method_18459(itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), 50.0, false);
                    class_1297 curPhase = itemEntity.method_24921();
                    if (curPhase instanceof class_1657) {
                        class_1657 stackOwner;
                        tomeCrafter = stackOwner = (class_1657)curPhase;
                    }
                    if (tomeCrafter != null) {
                        IArcanaProfileComponent profile = ArcanaNovum.data(tomeCrafter);
                        if (!profile.addCrafted(tomeStack = ArcanaRegistry.ARCANE_TOME.addCrafter(tomeStack, tomeCrafter.method_5845(), false, itemEntity.method_5682()))) {
                            profile.addXP(ArcanaRarity.getFirstCraftXp(ArcanaRegistry.ARCANE_TOME.getRarity()));
                        }
                        profile.addResearchedItem(ArcanaRegistry.ARCANE_TOME.getId());
                    }
                    if ((eyeStack = eyeEntity.method_6983()).method_7947() == 1) {
                        eyeEntity.method_31472();
                    } else {
                        eyeStack.method_7934(1);
                        eyeEntity.method_6979(eyeStack);
                    }
                    if (stack.method_7947() <= 4) {
                        itemEntity.method_31472();
                    } else {
                        stack.method_7934(4);
                        itemEntity.method_6979(stack);
                    }
                    class_1542 tomeEntity = new class_1542(world, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), tomeStack);
                    tomeEntity.method_6982(40);
                    if (tomeCrafter != null) {
                        tomeEntity.method_48349(tomeCrafter.method_5667());
                    }
                    float f = world.field_9229.method_43057() * 0.1f;
                    float g = world.field_9229.method_43057() * ((float)Math.PI * 2);
                    tomeEntity.method_18800((double)(-class_3532.method_15374((float)g) * f), (double)0.2f, (double)(class_3532.method_15362((float)g) * f));
                    world.method_8649((class_1297)tomeEntity);
                    ArcanaItem.removeProperty(stack, "tomeCraftTick");
                } else {
                    ArcanaItem.putProperty(stack, "tomeCraftTick", craftTick);
                }
                ArcanaEffectUtils.craftTome(serverWorld, enchantPos, craftTick);
            } else {
                ArcanaItem.removeProperty(stack, "tomeCraftTick");
            }
            itemEntity.method_6979(stack);
        }
        if (!ArcanaItemUtils.isArcane(stack) && stack.method_31574(class_1802.field_8281) && itemEntity.method_5799()) {
            List otherEntities = world.method_18023((class_5575)class_1299.field_6052, itemEntity.method_5829().method_1014(1.25), e -> !e.method_5667().equals(itemEntity.method_5667()) && e.method_5799() && !ArcanaItemUtils.isArcane(e.method_6983()));
            boolean create = false;
            for (class_1542 other : otherEntities) {
                class_1799 otherStack = other.method_6983();
                int count = otherStack.method_7947();
                if (otherStack.method_31574(class_1802.field_8601) && count >= 4) {
                    if (count == 4) {
                        other.method_31472();
                    } else {
                        otherStack.method_7934(4);
                        other.method_6979(otherStack);
                    }
                    create = true;
                    break;
                }
                if (!otherStack.method_31574(class_1802.field_8725) || count < 16) continue;
                if (count == 16) {
                    other.method_31472();
                } else {
                    otherStack.method_7934(16);
                    other.method_6979(otherStack);
                }
                create = true;
                break;
            }
            if (create) {
                class_1799 cObby = new class_1799((class_1935)class_1802.field_22421);
                cObby.method_7939(1);
                class_1542 cryingObby = new class_1542(world, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), cObby);
                cryingObby.method_6982(40);
                float f = world.field_9229.method_43057() * 0.1f;
                float g = world.field_9229.method_43057() * ((float)Math.PI * 2);
                cryingObby.method_18800((double)(-class_3532.method_15374((float)g) * f), (double)0.2f, (double)(class_3532.method_15362((float)g) * f));
                world.method_8649((class_1297)cryingObby);
                if (stack.method_7947() == 1) {
                    itemEntity.method_31472();
                } else {
                    stack.method_7934(1);
                    itemEntity.method_6979(stack);
                }
            }
        }
    }

    @Inject(method={"onPlayerCollision"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;insertStack(Lnet/minecraft/item/ItemStack;)Z", shift=At.Shift.BEFORE)})
    private void arcananovum_removeCraftData(class_1657 player, CallbackInfo ci, @Local LocalRef<class_1799> itemStackRef) {
        class_1799 stack = (class_1799)itemStackRef.get();
        if (stack.method_31574(ArcanaRegistry.MUNDANE_ARCANE_PAPER)) {
            ArcanaItem.removeProperty(stack, "tomeCraftTick");
            itemStackRef.set((Object)stack);
        }
        if (stack.method_31574(ArcanaRegistry.ARCANE_TOME.getItem())) {
            ArcanaItem.removeProperty(stack, "forgeCraftTick");
            itemStackRef.set((Object)stack);
        }
    }
}

