/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.mixins;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.callbacks.EntityKilledCallback;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.entities.StasisPearlEntity;
import net.borisshoes.arcananovum.items.SojournerBoots;
import net.borisshoes.arcananovum.research.EffectResearchTask;
import net.borisshoes.arcananovum.research.ResearchTask;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.minecraft.class_10182;
import net.minecraft.class_11368;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1433;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2709;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public class ServerPlayerMixin {
    @Inject(method={"readEnderPearl"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;addEnderPearlTicket(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/ChunkPos;)J")})
    private void arcananovum_readStasisPearl(class_11368 view, CallbackInfo ci, @Local class_1297 entity) {
        if (entity instanceof StasisPearlEntity) {
            StasisPearlEntity stasisPearl = (StasisPearlEntity)entity;
            stasisPearl.resyncHolder();
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;onKilledBy(Lnet/minecraft/entity/LivingEntity;)V")})
    private void arcananovum_onEntityKilledOther(class_1282 damageSource, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        EntityKilledCallback.killedEntity(player.method_51469(), damageSource, damageSource.method_5529(), (class_1309)player);
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void arcananovum_restoreOffhandOnDeath(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        ArcanaNovum.data((class_1657)player).restoreOffhand();
    }

    @Inject(method={"increaseTravelMotionStats"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;increaseStat(Lnet/minecraft/util/Identifier;I)V", ordinal=0)})
    private void arcananovum_swimStats(double deltaX, double deltaY, double deltaZ, CallbackInfo ci) {
        int i;
        class_3222 player = (class_3222)this;
        boolean hasCetacea = ArcanaUtils.getArcanaItemsWithAug((class_1657)player, ArcanaRegistry.CETACEA_CHARM, null, 0).stream().anyMatch(stack -> ArcanaItem.getBooleanProperty(stack, "active"));
        if (hasCetacea && (i = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f)) > 0) {
            ArcanaAchievements.progress(player, ArcanaAchievements.OCEAN_MIGRATION.id, i);
            class_1309 entity = player.method_51469().method_64391(class_1433.class, class_4051.method_36626().method_18418(10.0).method_36627(), (class_1309)player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1014(20.0));
            if (entity != null) {
                ArcanaAchievements.progress(player, ArcanaAchievements.CEPHALOS_IN_A_POD.id, i);
            }
        }
    }

    @Inject(method={"increaseTravelMotionStats"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;isSprinting()Z", shift=At.Shift.BEFORE)})
    private void arcananovum_onGroundMove(double dx, double dy, double dz, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        class_1799 bootsItem = player.method_6118(class_1304.field_6166);
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(bootsItem);
        if (arcanaItem instanceof SojournerBoots) {
            SojournerBoots boots = (SojournerBoots)arcanaItem;
            if (player.method_5624()) {
                int i = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                ArcanaAchievements.progress(player, ArcanaAchievements.PHEIDIPPIDES.id, i);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;tickFallStartPos()V", shift=At.Shift.BEFORE)})
    private void arcananovum_ensnarementMovement(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (player.method_6112(ArcanaRegistry.ENSNAREMENT_EFFECT) != null) {
            player.method_5784(class_1313.field_6305, player.method_18798());
            player.field_13987.method_14360(new class_10182(player.method_19538(), player.method_18798(), 0.0f, 0.0f), class_2709.method_11744((int)24));
        }
    }

    @Inject(method={"onStatusEffectApplied"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancement/criterion/EffectsChangedCriterion;trigger(Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/entity/Entity;)V")})
    private void arcananovum_effectApplied(class_1293 effect, class_1297 source, CallbackInfo ci) {
        for (Map.Entry entry : ResearchTasks.RESEARCH_TASKS.method_29722()) {
            ResearchTask task = (ResearchTask)entry.getValue();
            if (!(task instanceof EffectResearchTask)) continue;
            EffectResearchTask effectTask = (EffectResearchTask)task;
            if (effect.method_5579() != effectTask.getEffect()) continue;
            class_3222 player = (class_3222)this;
            ArcanaNovum.data((class_1657)player).setResearchTask((class_5321<ResearchTask>)((class_5321)entry.getKey()), true);
        }
    }

    @Inject(method={"teleportTo"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;getLevelProperties()Lnet/minecraft/world/WorldProperties;")})
    private void arcananovum_teleportDimensionChange(class_5454 teleportTarget, CallbackInfoReturnable<class_1297> cir) {
        class_3222 player = (class_3222)this;
        ArcanaNovum.data((class_1657)player).setResearchTask(ResearchTasks.DIMENSION_TRAVEL, true);
    }
}

