/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.transmutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.AequalisScientia;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class AequalisSkillTransmutationRecipe
extends TransmutationRecipe {
    public AequalisSkillTransmutationRecipe(String name) {
        super(name, new class_1799((class_1935)ArcanaRegistry.STARDUST, 64), new class_1799((class_1935)ArcanaRegistry.NEBULOUS_ESSENCE, 64));
    }

    @Override
    public List<class_1799> doTransmutation(class_1799 positiveInput, class_1799 negativeInput, class_1799 reagent1, class_1799 reagent2, class_1799 aequalisInput, class_3222 player) {
        return List.of(positiveInput, negativeInput, reagent1, reagent2, aequalisInput);
    }

    private class_3545<ArrayList<class_3545<ArcanaAugment, Integer>>, Integer> getCanSell(List<ArcanaAugment> item1Augments, ArcanaItem otherItem, IArcanaProfileComponent profile) {
        ArrayList<class_3545> canSell = new ArrayList<class_3545>();
        int sellingPower = 0;
        for (ArcanaAugment i1aug : item1Augments) {
            int curLvl;
            boolean linked = false;
            List<ArcanaAugment> linkedAugments = ArcanaAugments.getLinkedAugments(i1aug.id);
            for (ArcanaAugment linkedAugment : linkedAugments) {
                if (!linkedAugment.getArcanaItem().getId().equals(otherItem.getId())) continue;
                linked = true;
                break;
            }
            if (linked || (curLvl = profile.getAugmentLevel(i1aug.id)) <= 0) continue;
            canSell.add(new class_3545((Object)i1aug, (Object)curLvl));
            for (int i = 1; i <= i1aug.getTiers().length; ++i) {
                sellingPower += i1aug.getTiers()[i - 1].rarity + 1;
            }
        }
        Collections.shuffle(canSell);
        return new class_3545(canSell, (Object)sellingPower);
    }

    @Override
    public List<class_3545<class_1799, String>> doTransmutation(class_1542 input1Entity, class_1542 input2Entity, class_1542 reagent1Entity, class_1542 reagent2Entity, class_1542 aequalisEntity, TransmutationAltarBlockEntity altar, class_3222 player) {
        int take;
        class_1799 reagent2;
        boolean cross;
        class_1799 aequalisStack;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        class_1799 input1Stack = input1Entity != null ? input1Entity.method_6983() : class_1799.field_8037;
        class_1799 input2Stack = input2Entity != null ? input2Entity.method_6983() : class_1799.field_8037;
        class_1799 reagent1Stack = reagent1Entity != null ? reagent1Entity.method_6983() : class_1799.field_8037;
        class_1799 reagent2Stack = reagent2Entity != null ? reagent2Entity.method_6983() : class_1799.field_8037;
        class_1799 class_17992 = aequalisStack = aequalisEntity != null ? aequalisEntity.method_6983() : class_1799.field_8037;
        if (!this.canTransmute(input1Stack, input2Stack, reagent1Stack, reagent2Stack, aequalisStack, altar)) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        ArcanaItem arcanaItem1 = ArcanaItemUtils.identifyItem(input1Stack);
        ArcanaItem arcanaItem2 = ArcanaItemUtils.identifyItem(input2Stack);
        ArcanaItem aequalis = ArcanaItemUtils.identifyItem(aequalisStack);
        try {
            class_3222 asPlayer = altar.method_10997().method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)aequalis.getCrafter(aequalisStack)));
            if (asPlayer == null) {
                return new ArrayList<class_3545<class_1799, String>>();
            }
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)asPlayer);
            List<ArcanaAugment> item1Augments = ArcanaAugments.getAugmentsForItem(arcanaItem1);
            List<ArcanaAugment> item2Augments = ArcanaAugments.getAugmentsForItem(arcanaItem2);
            int sellingPower = 0;
            int liquidated = 0;
            int cycles = 0;
            block2: while (cycles < 100) {
                ++cycles;
                ArrayList<class_3545> canBuy = new ArrayList<class_3545>();
                int cheapestBuy = Integer.MAX_VALUE;
                for (ArcanaAugment i2aug : item2Augments) {
                    int maxLvl = i2aug.getTiers().length;
                    int curLvl = profile.getAugmentLevel(i2aug.id);
                    boolean linked = false;
                    List<ArcanaAugment> linkedAugments = ArcanaAugments.getLinkedAugments(i2aug.id);
                    for (ArcanaAugment linkedAugment : linkedAugments) {
                        if (!linkedAugment.getArcanaItem().getId().equals(arcanaItem1.getId())) continue;
                        linked = true;
                        break;
                    }
                    if (linked || curLvl >= maxLvl) continue;
                    canBuy.add(new class_3545((Object)i2aug, (Object)(curLvl + 1)));
                    if (i2aug.getTiers()[curLvl].rarity + 1 >= cheapestBuy) continue;
                    cheapestBuy = i2aug.getTiers()[curLvl].rarity + 1;
                }
                Collections.shuffle(canBuy);
                class_3545<ArrayList<class_3545<ArcanaAugment, Integer>>, Integer> canSellRet = this.getCanSell(item1Augments, arcanaItem2, profile);
                ArrayList canSell = (ArrayList)canSellRet.method_15442();
                sellingPower = (Integer)canSellRet.method_15441();
                if (cheapestBuy > sellingPower + liquidated) break;
                for (class_3545 buyPair : canBuy) {
                    ArcanaAugment buyAug = (ArcanaAugment)buyPair.method_15442();
                    int buyLvl = (Integer)buyPair.method_15441();
                    int cost = buyAug.getTiers()[buyLvl - 1].rarity + 1;
                    if (cost > sellingPower + liquidated) continue;
                    boolean cantSell = false;
                    while (cost > liquidated) {
                        class_3545 toSell = (class_3545)canSell.getFirst();
                        ArcanaAugment sellAug = (ArcanaAugment)toSell.method_15442();
                        int sellLvl = (Integer)toSell.method_15441();
                        profile.setAugmentLevel(sellAug.id, sellLvl - 1);
                        liquidated += sellAug.getTiers()[sellLvl - 1].rarity + 1;
                        canSellRet = this.getCanSell(item1Augments, arcanaItem2, profile);
                        canSell = (ArrayList)canSellRet.method_15442();
                        if (!canSell.isEmpty()) continue;
                        cantSell = true;
                        break;
                    }
                    if (cantSell) continue;
                    profile.setAugmentLevel(buyAug.id, buyLvl);
                    liquidated -= buyAug.getTiers()[buyLvl - 1].rarity + 1;
                    continue block2;
                }
            }
            if (arcanaItem1.getId().equals(arcanaItem2.getId())) {
                ArcanaAchievements.grant(asPlayer, ArcanaAchievements.QUESTIONABLE_EXCHANGE.id);
            }
        }
        catch (Exception e) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        if (aequalisEntity != null) {
            boolean timeless = ArcanaAugments.getAugmentOnItem(aequalisStack, ArcanaAugments.TIMELESS_WISDOM.id) > 0;
            int uses = ArcanaItem.getIntProperty(aequalisStack, "uses");
            if (!timeless && uses <= 1) {
                aequalisEntity.method_31472();
            } else if (!timeless) {
                ArcanaItem.putProperty(aequalisStack, "uses", uses - 1);
                ArcanaRegistry.AEQUALIS_SCIENTIA.buildItemLore(aequalisStack, ArcanaNovum.SERVER);
                aequalisEntity.method_6979(aequalisStack);
            }
        }
        boolean m11 = this.validStack(re1, reagent1Stack);
        boolean m22 = this.validStack(re2, reagent2Stack);
        boolean m12 = this.validStack(re1, reagent2Stack);
        boolean m21 = this.validStack(re2, reagent1Stack);
        boolean straight = m11 && m22;
        boolean bl = cross = !straight && m12 && m21;
        if (!straight && !cross) {
            return new ArrayList<class_3545<class_1799, String>>();
        }
        class_1799 reagent1 = straight ? re1 : re2;
        class_1799 class_17993 = reagent2 = straight ? re2 : re1;
        if (reagent1Entity != null) {
            int n = take = reagent1.method_7960() ? 0 : reagent1.method_7947();
            if (take > 0) {
                if (reagent1Stack.method_7947() == take) {
                    reagent1Entity.method_31472();
                } else {
                    reagent1Stack.method_7934(take);
                    reagent1Entity.method_6979(reagent1Stack);
                }
            }
        }
        if (reagent2Entity != null) {
            int n = take = reagent2.method_7960() ? 0 : reagent2.method_7947();
            if (take > 0) {
                if (reagent2Stack.method_7947() == take) {
                    reagent2Entity.method_31472();
                } else {
                    reagent2Stack.method_7934(take);
                    reagent2Entity.method_6979(reagent2Stack);
                }
            }
        }
        if (player != null) {
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.AEQUALIS_SCIENTIA_SKILL_TRANSMUTE));
        }
        return new ArrayList<class_3545<class_1799, String>>();
    }

    @Override
    public boolean canTransmute(class_1799 input1, class_1799 input2, class_1799 reagent1Input, class_1799 reagent2Input, class_1799 aequalisInput, TransmutationAltarBlockEntity altar) {
        boolean matrixCheck;
        boolean reagentCheck2;
        int bargainLvl = ArcanaAugments.getAugmentFromMap(altar.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        class_1799 re1 = this.getBargainReagent(this.reagent1, bargainLvl);
        class_1799 re2 = this.getBargainReagent(this.reagent2, bargainLvl);
        boolean reagentCheck1 = this.validStack(re1, reagent1Input) && this.validStack(re2, reagent2Input);
        boolean bl = reagentCheck2 = this.validStack(re1, reagent2Input) && this.validStack(re2, reagent1Input);
        if (!reagentCheck1 && !reagentCheck2) {
            return false;
        }
        boolean arcanaItemCheck = ArcanaItemUtils.isArcane(input1) && ArcanaItemUtils.isArcane(input2);
        boolean bl2 = matrixCheck = !input1.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem()) && !input2.method_31574(ArcanaRegistry.CATALYTIC_MATRIX.getItem());
        if (!arcanaItemCheck || !matrixCheck) {
            return false;
        }
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(aequalisInput);
        if (!(arcanaItem instanceof AequalisScientia)) {
            return false;
        }
        AequalisScientia as = (AequalisScientia)arcanaItem;
        try {
            class_3222 player = altar.method_10997().method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)as.getCrafter(aequalisInput)));
            if (player != null) {
                return ArcanaNovum.data((class_1657)player).hasResearched(ArcanaRegistry.AEQUALIS_SCIENTIA);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public class_1799 getViewStack() {
        return ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItemNoLore().method_46651(1);
    }
}

