/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9424;

public class EnhancedStatUtils {
    public static String ENHANCED_STAT_TAG = "stardust_enhanced";

    public static boolean isItemEnhanceable(class_1799 stack) {
        return stack.method_31573(class_3489.field_48303) || stack.method_31573(class_3489.field_48305) || stack.method_31573(class_3489.field_42611) || stack.method_31573(class_3489.field_42612) || stack.method_57826(class_9334.field_50077) || stack.method_57826(class_9334.field_50072);
    }

    public static double generatePercentile(int stars) {
        double random = Math.random();
        double uncapped = 0.2 * (double)(stars + 1) * random * random + 0.1 * (double)stars;
        return Math.min(1.0, uncapped);
    }

    public static double getPercentile(class_1799 stack) {
        if (ArcanaItem.hasProperty(stack, ENHANCED_STAT_TAG)) {
            return ArcanaItem.getDoubleProperty(stack, ENHANCED_STAT_TAG);
        }
        return 0.0;
    }

    public static void stripEnhancements(class_1799 stack, boolean removeTag) {
        if (!EnhancedStatUtils.isEnhanced(stack)) {
            return;
        }
        class_9285 modifiers = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        ArrayList<class_9285.class_9287> attributeList = new ArrayList<class_9285.class_9287>();
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            class_6880 attribute = entry.comp_2395();
            class_1322 modifier = entry.comp_2396();
            class_9274 slot = entry.comp_2397();
            if (modifier.comp_2447().toString().contains(ENHANCED_STAT_TAG)) continue;
            attributeList.add(entry);
        }
        if (stack.method_57826(class_9334.field_50077)) {
            class_9424 comp = (class_9424)stack.method_7909().method_7854().method_58694(class_9334.field_50077);
            ArrayList<class_9424.class_9425> newRules = new ArrayList<class_9424.class_9425>();
            for (class_9424.class_9425 rule : comp.comp_2498()) {
                if (rule.comp_2502().isPresent()) {
                    float newSpeed = ((Float)rule.comp_2502().get()).floatValue();
                    newRules.add(new class_9424.class_9425(rule.comp_2501(), Optional.of(Float.valueOf(newSpeed)), rule.comp_2503()));
                    continue;
                }
                newRules.add(rule);
            }
            class_9424 newComp = new class_9424(newRules, comp.comp_2499(), comp.comp_2500(), comp.comp_3480());
            stack.method_57379(class_9334.field_50077, (Object)newComp);
        }
        if (stack.method_57826(class_9334.field_50072)) {
            int maxDamage = stack.method_7909().method_7854().method_7936();
            stack.method_57379(class_9334.field_50072, (Object)maxDamage);
        }
        class_9285 newComponent = new class_9285(attributeList);
        stack.method_57379(class_9334.field_49636, (Object)newComponent);
        if (removeTag) {
            ArcanaItem.removeProperty(stack, ENHANCED_STAT_TAG);
        }
        if (!ArcanaItemUtils.isArcane(stack)) {
            class_9290 lore = (class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
            ArrayList<class_2561> lines = new ArrayList<class_2561>();
            ArrayList<class_2561> styledLines = new ArrayList<class_2561>();
            for (class_2561 line : lore.comp_2400()) {
                if (line.getString().contains("Stardust Infusion: ")) continue;
                lines.add(line);
            }
            for (class_2561 line : lore.comp_2401()) {
                if (line.getString().contains("Stardust Infusion: ")) continue;
                styledLines.add(line);
            }
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lines, styledLines));
        } else {
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
            arcanaItem.buildItemLore(stack, ArcanaNovum.SERVER);
        }
    }

    public static void enhanceItem(class_1799 stack, double percentile) {
        class_9285 modifiers = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        ArrayList<class_9285.class_9287> attributeList = new ArrayList<class_9285.class_9287>();
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            class_6880 attribute = entry.comp_2395();
            class_1322 modifier = entry.comp_2396();
            class_9274 slot = entry.comp_2397();
            if (modifier.comp_2447().toString().contains(ENHANCED_STAT_TAG)) continue;
            attributeList.add(entry);
        }
        boolean enhanced = false;
        if (stack.method_31573(class_3489.field_48303) && stack.method_57826(class_9334.field_54196)) {
            class_10192 equipComp = (class_10192)stack.method_58694(class_9334.field_54196);
            double newArmor = 5.0 * percentile;
            double newToughness = 5.0 * percentile;
            double newKbRes = 0.15 * percentile;
            double maxHpBoost = percentile >= 0.95 ? percentile * 5.0 : 0.0;
            String stat_tag = ENHANCED_STAT_TAG + "_" + equipComp.comp_3174().method_5923();
            attributeList.add(new class_9285.class_9287(class_5134.field_23724, new class_1322(class_2960.method_60655((String)"arcananovum", (String)stat_tag), newArmor, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)equipComp.comp_3174())));
            attributeList.add(new class_9285.class_9287(class_5134.field_23725, new class_1322(class_2960.method_60655((String)"arcananovum", (String)stat_tag), newToughness, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)equipComp.comp_3174())));
            attributeList.add(new class_9285.class_9287(class_5134.field_23718, new class_1322(class_2960.method_60655((String)"arcananovum", (String)stat_tag), newKbRes, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)equipComp.comp_3174())));
            attributeList.add(new class_9285.class_9287(class_5134.field_23716, new class_1322(class_2960.method_60655((String)"arcananovum", (String)stat_tag), maxHpBoost, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)equipComp.comp_3174())));
            enhanced = true;
        }
        if (stack.method_31573(class_3489.field_48305) || stack.method_31573(class_3489.field_42611) || stack.method_31573(class_3489.field_42612)) {
            double newAttackSpeed = percentile >= 0.5 ? 0.5 * (2.0 * percentile - 1.0) : 0.0;
            double newAttackDamage = 5.0 * percentile;
            attributeList.add(new class_9285.class_9287(class_5134.field_23721, new class_1322(class_2960.method_60655((String)"arcananovum", (String)ENHANCED_STAT_TAG), newAttackDamage, class_1322.class_1323.field_6328), class_9274.field_49217));
            attributeList.add(new class_9285.class_9287(class_5134.field_23723, new class_1322(class_2960.method_60655((String)"arcananovum", (String)ENHANCED_STAT_TAG), newAttackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217));
            enhanced = true;
        }
        if (stack.method_57826(class_9334.field_50077)) {
            double speedBuff = 1.0 + 1.25 * percentile * percentile;
            class_9424 comp = (class_9424)stack.method_7909().method_7854().method_58694(class_9334.field_50077);
            ArrayList<class_9424.class_9425> newRules = new ArrayList<class_9424.class_9425>();
            for (class_9424.class_9425 rule : comp.comp_2498()) {
                if (rule.comp_2502().isPresent()) {
                    float newSpeed = Math.min(Float.MAX_VALUE, (float)(((double)((Float)rule.comp_2502().get()).floatValue() + 4.0 * percentile) * speedBuff));
                    newRules.add(new class_9424.class_9425(rule.comp_2501(), Optional.of(Float.valueOf(newSpeed)), rule.comp_2503()));
                    continue;
                }
                newRules.add(rule);
            }
            class_9424 newComp = new class_9424(newRules, comp.comp_2499(), comp.comp_2500(), comp.comp_3480());
            stack.method_57379(class_9334.field_50077, (Object)newComp);
            enhanced = true;
        }
        if (stack.method_57826(class_9334.field_50072)) {
            double durabilityBuff = 1.0 + 0.5 * percentile * percentile;
            int maxDamage = stack.method_7909().method_7854().method_7936();
            stack.method_57379(class_9334.field_50072, (Object)((int)((double)maxDamage * durabilityBuff)));
            enhanced = true;
        }
        if (enhanced) {
            class_9285 newComponent = new class_9285(attributeList);
            stack.method_57379(class_9334.field_49636, (Object)newComponent);
            ArcanaItem.putProperty(stack, ENHANCED_STAT_TAG, percentile);
            if (!ArcanaItemUtils.isArcane(stack)) {
                class_9290 lore = (class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
                ArrayList<Object> lines = new ArrayList<Object>();
                ArrayList<Object> styledLines = new ArrayList<Object>();
                for (class_2561 line : lore.comp_2400()) {
                    if (line.getString().contains("Stardust Infusion: ")) continue;
                    lines.add(line);
                }
                for (class_2561 line : lore.comp_2401()) {
                    if (line.getString().contains("Stardust Infusion: ")) continue;
                    styledLines.add(line);
                }
                DecimalFormat df = new DecimalFormat("#0.00");
                df.setRoundingMode(RoundingMode.DOWN);
                class_5250 line = TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Stardust Infusion: ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(df.format(percentile * 100.0) + "%")).method_27692(class_124.field_1065)));
                lines.add(line);
                styledLines.add(line);
                stack.method_57379(class_9334.field_49632, (Object)new class_9290(lines, styledLines));
            } else {
                ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
                arcanaItem.buildItemLore(stack, ArcanaNovum.SERVER);
            }
        }
    }

    public static boolean isEnhanced(class_1799 stack) {
        return ArcanaItem.hasProperty(stack, ENHANCED_STAT_TAG);
    }

    public static double combineStats(double p1, double p2) {
        double max = Math.max(p1, p2);
        double min = Math.min(p1, p2);
        double magic = 0.07;
        double increased = max + min * (2.0 * magic / (max * max + magic));
        return Math.min(1.0, increased);
    }
}

