/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import java.util.ArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class SpawnPile {
    double x;
    double z;

    public SpawnPile(double x, double z) {
        this.x = x;
        this.z = z;
    }

    double getDistance(SpawnPile other) {
        double d = this.x - other.x;
        double e = this.z - other.z;
        return Math.sqrt(d * d + e * e);
    }

    void normalize() {
        double d = this.absolute();
        this.x /= d;
        this.z /= d;
    }

    double absolute() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public void subtract(SpawnPile other) {
        this.x -= other.x;
        this.z -= other.z;
    }

    public boolean clamp(double minX, double minZ, double maxX, double maxZ) {
        boolean bl = false;
        if (this.x < minX) {
            this.x = minX;
            bl = true;
        } else if (this.x > maxX) {
            this.x = maxX;
            bl = true;
        }
        if (this.z < minZ) {
            this.z = minZ;
            bl = true;
        } else if (this.z > maxZ) {
            this.z = maxZ;
            bl = true;
        }
        return bl;
    }

    public static int getSurfaceY(class_1922 blockView, int maxY, int x, int z) {
        class_2338.class_2339 mutable = new class_2338.class_2339((double)x, (double)(maxY + 1), (double)z);
        boolean bl = blockView.method_8320((class_2338)mutable).method_26215();
        mutable.method_10098(class_2350.field_11033);
        boolean bl2 = blockView.method_8320((class_2338)mutable).method_26215();
        while (mutable.method_10264() > blockView.method_31607()) {
            mutable.method_10098(class_2350.field_11033);
            boolean bl3 = blockView.method_8320((class_2338)mutable).method_26215();
            if (!bl3 && bl2 && bl) {
                return mutable.method_10264() + 1;
            }
            bl = bl2;
            bl2 = bl3;
        }
        return maxY + 1;
    }

    private static class_2338 getEntitySpawnPos(class_1937 world, class_1299<?> entityType, int x, int z, boolean ignoreRestrictions) {
        int i = world.method_31600();
        class_2338.class_2339 mutable = new class_2338.class_2339(x, i, z);
        if (world.method_8597().comp_643()) {
            do {
                mutable.method_10098(class_2350.field_11033);
            } while (!world.method_8320((class_2338)mutable).method_26215());
        }
        do {
            mutable.method_10098(class_2350.field_11033);
        } while (world.method_8320((class_2338)mutable).method_26215() && mutable.method_10264() > world.method_31607());
        mutable.method_10098(class_2350.field_11036);
        if (ignoreRestrictions) {
            return mutable.method_10062();
        }
        return class_1317.method_6159(entityType).method_56553((class_4538)world, mutable.method_10062());
    }

    public static ArrayList<class_2338> makeSpawnLocations(int num, int range, class_3218 world, class_1299<?> entityType, class_2338 center) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (int i = 0; i < num; ++i) {
            int z;
            int x;
            class_2338 entitySpawnPos;
            int tries = 0;
            while (Math.abs((entitySpawnPos = SpawnPile.getEntitySpawnPos((class_1937)world, entityType, x = center.method_10263() + (int)(Math.random() * (double)range * 2.0 - (double)range), z = center.method_10260() + (int)(Math.random() * (double)range * 2.0 - (double)range), true)).method_10264() - center.method_10264()) > range && ++tries < 10000) {
            }
            positions.add(entitySpawnPos);
        }
        return positions;
    }

    public int getY(class_1922 blockView, int maxY) {
        class_2338.class_2339 mutable = new class_2338.class_2339(this.x, (double)(maxY + 1), this.z);
        boolean bl = blockView.method_8320((class_2338)mutable).method_26215();
        mutable.method_10098(class_2350.field_11033);
        boolean bl2 = blockView.method_8320((class_2338)mutable).method_26215();
        while (mutable.method_10264() > blockView.method_31607()) {
            mutable.method_10098(class_2350.field_11033);
            boolean bl3 = blockView.method_8320((class_2338)mutable).method_26215();
            if (!bl3 && bl2 && bl) {
                return mutable.method_10264() + 1;
            }
            bl = bl2;
            bl2 = bl3;
        }
        return maxY + 1;
    }

    public boolean isSafe(class_1922 world, int maxY) {
        class_2338 blockPos = class_2338.method_49637((double)this.x, (double)(this.getY(world, maxY) - 1), (double)this.z);
        class_2680 blockState = world.method_8320(blockPos);
        class_3610 fluidState = world.method_8316(blockPos);
        boolean invalid = blockState.method_27852(class_2246.field_10606) || blockState.method_27852(class_2246.field_16999) || blockState.method_27852(class_2246.field_10029) || blockState.method_27852(class_2246.field_27879) || blockState.method_26164(class_3481.field_24459) || class_14.method_57082((class_2680)blockState);
        return blockPos.method_10264() < maxY && fluidState.method_15769() && !invalid;
    }

    public void setPileLocation(class_5819 random, double minX, double minZ, double maxX, double maxZ) {
        this.x = class_3532.method_15366((class_5819)random, (double)minX, (double)maxX);
        this.z = class_3532.method_15366((class_5819)random, (double)minZ, (double)maxZ);
    }

    public static ArrayList<class_2338> makeSpawnLocations(int num, int range, class_3218 world) {
        return SpawnPile.makeSpawnLocations(num, range, world, new class_2338(0, 0, 0));
    }

    public static ArrayList<class_2338> makeSpawnLocations(int num, int range, class_3218 world, class_2338 center) {
        return SpawnPile.makeSpawnLocations(num, range, 128, world, center);
    }

    public static ArrayList<class_2338> makeSpawnLocations(int num, int range, int maxY, class_3218 world, class_2338 center) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (int i = 0; i < num; ++i) {
            int z;
            int x;
            SpawnPile pile;
            int tries = 0;
            while (!(pile = new SpawnPile(x = center.method_10263() + (int)(Math.random() * (double)range * 2.0 - (double)range), z = center.method_10260() + (int)(Math.random() * (double)range * 2.0 - (double)range))).isSafe((class_1922)world, maxY) && ++tries < 10000) {
            }
            positions.add(class_2338.method_49637((double)pile.x, (double)pile.getY((class_1922)world, maxY), (double)pile.z));
        }
        return positions;
    }
}

