/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.bosses.BossFight;
import net.borisshoes.arcananovum.bosses.BossFights;
import net.borisshoes.arcananovum.bosses.dragon.DragonBossFight;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.cardinalcomponents.IBossFightComponent;
import net.borisshoes.arcananovum.cardinalcomponents.WorldDataComponentInitializer;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.gui.arcanetome.LoreGui;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.cache.CacheGui;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.callbacks.ItemReturnTimerCallback;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.TextUtils;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ArcanaCommands {
    public static int openGuideBook(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        if (!source.method_43737() || source.method_44023() == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Command must be executed by a player"), false);
            return -1;
        }
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        BookElementBuilder bookBuilder = TomeGui.getGuideBook();
        LoreGui loreGui = new LoreGui(player, bookBuilder, null, TomeGui.TomeMode.NONE, null);
        loreGui.open();
        return 1;
    }

    public static int skillpointsCommand(CommandContext<class_2168> ctx, Collection<class_3222> targets, int amount, boolean set) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            for (class_3222 player : targets) {
                IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
                class_2497 pointsEle = (class_2497)profile.getMiscData("adminSkillPoints");
                int oldPoints = pointsEle == null ? 0 : pointsEle.method_10701();
                int newPoints = set ? amount : amount + oldPoints;
                profile.addMiscData("adminSkillPoints", (class_2520)class_2497.method_23247((int)newPoints));
            }
            if (targets.size() == 1 && set) {
                source.method_9226(() -> class_2561.method_43470((String)("Set Bonus Skill Points to " + amount + " for ")).method_27692(class_124.field_1076).method_10852(((class_3222)targets.iterator().next()).method_5476()), true);
            } else if (targets.size() == 1 && !set) {
                source.method_9226(() -> class_2561.method_43470((String)("Gave " + amount + " Bonus Skill Points to ")).method_27692(class_124.field_1076).method_10852(((class_3222)targets.iterator().next()).method_5476()), true);
            } else if (targets.size() != 1 && set) {
                source.method_9226(() -> class_2561.method_43470((String)("Set Bonus Skill Points to " + amount + " for " + targets.size() + " players")).method_27692(class_124.field_1076), true);
            } else if (targets.size() != 1 && !set) {
                source.method_9226(() -> class_2561.method_43470((String)("Gave " + amount + " Bonus Skill Points to " + targets.size() + " players")).method_27692(class_124.field_1076), true);
            }
            return targets.size();
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int skillpointsCommandQuery(CommandContext<class_2168> ctx, class_3222 target) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)target);
            class_2497 pointsEle = (class_2497)profile.getMiscData("adminSkillPoints");
            int adminPoints = pointsEle == null ? 0 : pointsEle.method_10701();
            class_5250 feedback = class_2561.method_43470((String)"").method_10852(target.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(adminPoints)).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" Bonus Skill Points").method_27692(class_124.field_1076));
            source.method_9226(() -> feedback, false);
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int xpCommand(CommandContext<class_2168> ctx, Collection<? extends class_3222> targets, int amount, boolean set, boolean points) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            for (class_3222 class_32222 : targets) {
                int newAmount;
                IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)class_32222);
                int oldValue = points ? profile.getXP() : profile.getLevel();
                int n = newAmount = set ? Math.max(amount, 0) : Math.max(oldValue + amount, 0);
                if (points) {
                    profile.setXP(newAmount);
                    continue;
                }
                newAmount = Math.max(newAmount, 1);
                profile.setXP(LevelUtils.levelToTotalXp(newAmount));
            }
            if (targets.size() == 1 && set && points) {
                source.method_9226(() -> class_2561.method_43470((String)("Set Arcana XP to " + amount + " for ")).method_27692(class_124.field_1076).method_10852(((class_3222)targets.iterator().next()).method_5476()), true);
            } else if (targets.size() == 1 && set && !points) {
                source.method_9226(() -> class_2561.method_43470((String)("Set Arcana Level to " + amount + " for ")).method_27692(class_124.field_1076).method_10852(((class_3222)targets.iterator().next()).method_5476()), true);
            } else if (targets.size() == 1 && !set && points) {
                source.method_9226(() -> class_2561.method_43470((String)("Gave " + amount + " Arcana XP to ")).method_27692(class_124.field_1076).method_10852(((class_3222)targets.iterator().next()).method_5476()), true);
            } else if (targets.size() == 1 && !set && !points) {
                source.method_9226(() -> class_2561.method_43470((String)("Gave " + amount + " Arcana Levels to ")).method_27692(class_124.field_1076).method_10852(((class_3222)targets.iterator().next()).method_5476()), true);
            } else if (targets.size() != 1 && set && points) {
                source.method_9226(() -> class_2561.method_43470((String)("Set Arcana XP to " + amount + " for " + targets.size() + " players")).method_27692(class_124.field_1076), true);
            } else if (targets.size() != 1 && set && !points) {
                source.method_9226(() -> class_2561.method_43470((String)("Set Arcana Level to " + amount + " for " + targets.size() + " players")).method_27692(class_124.field_1076), true);
            } else if (targets.size() != 1 && !set && points) {
                source.method_9226(() -> class_2561.method_43470((String)("Gave " + amount + " Arcana XP to " + targets.size() + " players")).method_27692(class_124.field_1076), true);
            } else if (targets.size() != 1 && !set && !points) {
                source.method_9226(() -> class_2561.method_43470((String)("Gave " + amount + " Arcana Levels to " + targets.size() + " players")).method_27692(class_124.field_1076), true);
            }
            return targets.size();
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int uuidCommand(CommandContext<class_2168> ctx, class_3222 player) {
        class_2168 source = (class_2168)ctx.getSource();
        ArrayList<class_5250> response = new ArrayList<class_5250>();
        ArrayList<class_5250> response2 = new ArrayList<class_5250>();
        HashSet<String> uuids = new HashSet<String>();
        int count = 0;
        List<ArcanaItemUtils.ArcanaInvItem> arcanaInv = ArcanaItemUtils.getArcanaInventory(player);
        for (ArcanaItemUtils.ArcanaInvItem invItem : arcanaInv) {
            ArcanaItem arcanaItem = invItem.item;
            for (class_3545<String, class_1799> pair : invItem.getStacks()) {
                String uuid = (String)pair.method_15442();
                class_1799 stack = (class_1799)pair.method_15441();
                ++count;
                String storage = invItem.getShortContainerString();
                class_5250 feedback = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"(").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)storage).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)") ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1076)).method_10852((class_2561)arcanaItem.getTranslatedName().method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"] ID: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)uuid).method_27692(class_124.field_1064));
                response.add(feedback.method_27694(s -> s.method_10949((class_2568)new class_2568.class_10612(stack)).method_10958((class_2558)new class_2558.class_10606(uuid))));
                if (uuids.add(uuid) && invItem.getStacks().size() >= invItem.getCount() / arcanaItem.getPrefItem().method_7947()) continue;
                class_5250 duplicateWarning = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Duplicate: ").method_27692(class_124.field_1061)).method_10852((class_2561)arcanaItem.getTranslatedName().method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" ID: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)uuid).method_27692(class_124.field_1064));
                response2.add(duplicateWarning);
            }
        }
        class_5250 feedback = class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(count)).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" items.").method_27692(class_124.field_1076));
        source.method_9226(() -> class_2561.method_43470((String)""), false);
        source.method_9226(() -> feedback, false);
        source.method_9226(() -> class_2561.method_43470((String)"================================").method_27692(class_124.field_1076), false);
        for (class_5250 r : response) {
            source.method_9226(() -> r, false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"================================").method_27692(class_124.field_1076), false);
        for (class_5250 r : response2) {
            source.method_9226(() -> r, false);
        }
        return count;
    }

    public static int getBookData(CommandContext<class_2168> objectCommandContext) {
        return 0;
    }

    public static int xpCommandQuery(CommandContext<class_2168> ctx, class_3222 target) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)target);
            class_5250 feedback = class_2561.method_43470((String)"").method_10852(target.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(profile.getLevel())).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" levels (").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(LevelUtils.getCurLevelXp(profile.getXP()) + "/" + LevelUtils.nextLevelNewXp(profile.getLevel()))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"). ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(profile.getXP())).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" Total XP").method_27692(class_124.field_1076));
            source.method_9226(() -> feedback, false);
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int getItemData(CommandContext<class_2168> objectCommandContext, String name) {
        return 0;
    }

    public static int makeCraftingRecipe(CommandContext<class_2168> objectCommandContext) {
        return 0;
    }

    public static int testCommand(CommandContext<class_2168> ctx) {
        return 0;
    }

    public static int testCommand(CommandContext<class_2168> objectCommandContext, int num) {
        return 0;
    }

    public static int cacheCommand(CommandContext<class_2168> objectCommandContext) {
        try {
            class_2168 source = (class_2168)objectCommandContext.getSource();
            class_3222 player = source.method_9207();
            CacheGui gui = new CacheGui(player);
            gui.buildCompendiumGui();
            gui.open();
            return 0;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static CompletableFuture<Suggestions> getItemSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        HashSet items = new HashSet();
        ArcanaRegistry.ARCANA_ITEMS.method_42021().forEach(key -> items.add(key.method_29177().method_12832()));
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> getResearchSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        HashSet<String> items = new HashSet<String>();
        ArcanaRegistry.ARCANA_ITEMS.method_42021().forEach(key -> items.add(key.method_29177().method_12832()));
        items.add("all");
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> getAchievementSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        Set<String> items = ArcanaAchievements.registry.keySet();
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> getAugmentSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        ArcanaItem arcanaItem;
        class_2168 src = (class_2168)context.getSource();
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (src.method_43737() && src.method_44023() != null) {
            class_1799 handItem = src.method_44023().method_6047();
            arcanaItem = ArcanaItemUtils.identifyItem(handItem);
        } else {
            arcanaItem = null;
        }
        Set<String> augments = ArcanaAugments.registry.keySet();
        if (arcanaItem != null) {
            augments = augments.stream().filter(s -> ArcanaAugments.registry.get(s).getArcanaItem().getId().equals(arcanaItem.getId())).collect(Collectors.toSet());
        }
        augments.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static int setAugment(CommandContext<class_2168> ctx, String id, int level, class_3222 player) {
        try {
            ArcanaAugment augment;
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737() && player == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must specify player, or run command as a player"));
                return -1;
            }
            if (player == null && src.method_44023() != null) {
                player = src.method_44023();
            }
            if ((augment = ArcanaAugments.registry.get(id)) == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"That is not a valid Augment"));
                return -1;
            }
            if (level < 0 || level > augment.getTiers().length) {
                src.method_9213((class_2561)class_2561.method_43470((String)("Level out of bounds (0-" + augment.getTiers().length + ")")));
                return -1;
            }
            if (level == 0) {
                ArcanaNovum.data((class_1657)player).removeAugment(id);
                src.method_45068((class_2561)class_2561.method_43470((String)"Successfully removed ").method_10852((class_2561)augment.getTranslatedName()).method_27693(" from ").method_10852(player.method_5476()));
            } else {
                ArcanaNovum.data((class_1657)player).setAugmentLevel(id, level);
                src.method_45068((class_2561)class_2561.method_43470((String)"Successfully set ").method_10852((class_2561)augment.getTranslatedName()).method_27693(" to level " + level + " for ").method_10852(player.method_5476()));
            }
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int enhanceCommand(CommandContext<class_2168> ctx, double percentage, class_3222 player) {
        try {
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737() && player == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must specify player, or run command as a player"));
                return -1;
            }
            if (player == null && src.method_44023() != null) {
                player = src.method_44023();
            }
            class_1799 handItem = player.method_6047();
            if (percentage > 100.0 || percentage < 0.0) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Percentage out of bounds 0.0 - 100.0"));
                return -1;
            }
            if (!EnhancedStatUtils.isItemEnhanceable(handItem)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Player is not holding a valid infusion item"));
                return -1;
            }
            if (percentage == 0.0) {
                EnhancedStatUtils.stripEnhancements(handItem, true);
            } else {
                EnhancedStatUtils.enhanceItem(handItem, percentage / 100.0);
            }
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int applyAugment(CommandContext<class_2168> ctx, String id, int level, class_3222 player) {
        try {
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737() && player == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must specify player, or run command as a player"));
                return -1;
            }
            if (player == null && src.method_44023() != null) {
                player = src.method_44023();
            }
            ArcanaAugment augment = ArcanaAugments.registry.get(id);
            class_1799 handItem = player.method_6047();
            ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(handItem);
            if (augment == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"That is not a valid Augment"));
                return -1;
            }
            if (level < 1 || level > augment.getTiers().length) {
                src.method_9213((class_2561)class_2561.method_43470((String)("Level out of bounds (1-" + augment.getTiers().length + ")")));
                return -1;
            }
            if (arcanaItem == null || !arcanaItem.getId().equals(augment.getArcanaItem().getId())) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Player is not holding a valid Arcana Item"));
                return -1;
            }
            if (ArcanaAugments.isIncompatible(handItem, id)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"This augment is incompatible with existing augments"));
                return -1;
            }
            if (ArcanaAugments.applyAugment(handItem, id, level, false)) {
                src.method_45068((class_2561)class_2561.method_43470((String)"Successfully applied ").method_10852((class_2561)augment.getTranslatedName()).method_27693(" at level " + level + " for ").method_10852(player.method_5476()));
                return 1;
            }
            src.method_9213((class_2561)class_2561.method_43470((String)"Couldn't apply augment (Cannot downgrade existing augments)"));
            return -1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int setResearch(CommandContext<class_2168> ctx, String id, boolean grant, Collection<class_3222> targets) {
        try {
            class_5250 itemName;
            class_2168 source = (class_2168)ctx.getSource();
            ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
            boolean isAll = id.equals("all");
            if (arcanaItem == null && !isAll) {
                source.method_9213((class_2561)class_2561.method_43470((String)"That is not a valid item id"));
                return -1;
            }
            ArrayList<ArcanaItem> items = new ArrayList<ArcanaItem>();
            if (isAll) {
                ArcanaRegistry.ARCANA_ITEMS.method_29722().forEach(entry -> items.add((ArcanaItem)entry.getValue()));
            } else {
                items.add(arcanaItem);
            }
            for (class_3222 player : targets) {
                if (grant) {
                    for (ArcanaItem item : items) {
                        ArcanaNovum.data((class_1657)player).addResearchedItem(item.getId());
                    }
                    continue;
                }
                for (ArcanaItem item : items) {
                    ArcanaNovum.data((class_1657)player).removeResearchedItem(item.getId());
                }
            }
            class_5250 feedback = class_2561.method_43470((String)"");
            class_5250 class_52502 = itemName = isAll ? class_2561.method_43470((String)"All Arcana Items") : arcanaItem.getTranslatedName();
            if (grant) {
                feedback.method_10852((class_2561)class_2561.method_43470((String)"Added Research for [").method_27692(class_124.field_1076));
                feedback.method_10852((class_2561)itemName.method_27692(class_124.field_1075));
                feedback.method_10852((class_2561)class_2561.method_43470((String)"] to ").method_27692(class_124.field_1076));
            } else {
                feedback.method_10852((class_2561)class_2561.method_43470((String)"Removed Research for [").method_27692(class_124.field_1076));
                feedback.method_10852((class_2561)itemName.method_27692(class_124.field_1075));
                feedback.method_10852((class_2561)class_2561.method_43470((String)"] from ").method_27692(class_124.field_1076));
            }
            if (targets.size() == 1) {
                feedback.method_10852(targets.iterator().next().method_5476());
            } else {
                feedback.method_10852((class_2561)class_2561.method_43470((String)(targets.size() + " players")).method_27692(class_124.field_1076));
            }
            source.method_9226(() -> feedback, true);
            return targets.size();
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int getResearch(CommandContext<class_2168> ctx, String id, class_3222 target) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)target);
            ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
            if (arcanaItem == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"That is not a valid item id"));
                return -1;
            }
            boolean researched = profile.hasResearched(arcanaItem);
            class_5250 feedback = class_2561.method_43470((String)"").method_10852((class_2561)target.method_5476().method_27661()).method_10852((class_2561)class_2561.method_43470((String)(researched ? " has researched [" : " has NOT researched [")).method_27692(class_124.field_1076)).method_10852((class_2561)arcanaItem.getTranslatedName().method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1076));
            source.method_9226(() -> feedback, false);
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int setAchievement(CommandContext<class_2168> ctx, String id, boolean grant, Collection<class_3222> targets) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            ArcanaAchievement achievement = ArcanaAchievements.registry.get(id);
            if (achievement == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"That is not a valid Achievement"));
                return -1;
            }
            for (class_3222 player : targets) {
                if (grant) {
                    ArcanaAchievements.grant(player, id);
                    continue;
                }
                ArcanaAchievements.revoke(player, id);
            }
            class_5250 feedback = class_2561.method_43470((String)"");
            if (grant) {
                feedback.method_10852((class_2561)class_2561.method_43470((String)"Granted Achievement [").method_27692(class_124.field_1076));
                feedback.method_10852((class_2561)achievement.getTranslatedName().method_27692(class_124.field_1075));
                feedback.method_10852((class_2561)class_2561.method_43470((String)"] to ").method_27692(class_124.field_1076));
            } else {
                feedback.method_10852((class_2561)class_2561.method_43470((String)"Revoked Achievement [").method_27692(class_124.field_1076));
                feedback.method_10852((class_2561)achievement.getTranslatedName().method_27692(class_124.field_1075));
                feedback.method_10852((class_2561)class_2561.method_43470((String)"] from ").method_27692(class_124.field_1076));
            }
            if (targets.size() == 1) {
                feedback.method_10852(targets.iterator().next().method_5476());
            } else {
                feedback.method_10852((class_2561)class_2561.method_43470((String)(targets.size() + " players")).method_27692(class_124.field_1076));
            }
            source.method_9226(() -> feedback, true);
            return targets.size();
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int getAchievement(CommandContext<class_2168> ctx, String id, class_3222 target) {
        try {
            class_2168 source = (class_2168)ctx.getSource();
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)target);
            ArcanaAchievement baseAch = ArcanaAchievements.registry.get(id);
            if (baseAch == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"That is not a valid Achievement"));
                return -1;
            }
            ArcanaAchievement profAchieve = profile.getAchievement(baseAch.getArcanaItem().getId(), id);
            ArcanaAchievement achieve = profAchieve == null ? baseAch : profAchieve;
            class_5250[] response = achieve.getStatusDisplay(target);
            class_5250 header = class_2561.method_43470((String)"").method_10852((class_2561)target.method_5476().method_27661().method_27693("'s")).method_10852((class_2561)class_2561.method_43470((String)" progress towards [").method_27692(class_124.field_1076)).method_10852((class_2561)achieve.getTranslatedName().method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"]: ").method_27692(class_124.field_1076));
            source.method_9226(() -> header, false);
            if (response == null) {
                return 0;
            }
            for (class_5250 mutableText : response) {
                source.method_9226(() -> mutableText, false);
            }
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return 0;
        }
    }

    public static int createItems(class_2168 source, String id, Collection<class_3222> targets) {
        try {
            ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
            if (arcanaItem == null) {
                source.method_45068((class_2561)class_2561.method_43470((String)("Invalid Arcana Item ID: " + id)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                return 0;
            }
            for (class_3222 target : targets) {
                class_1799 item = arcanaItem.addCrafter(arcanaItem.getNewItem(), target.method_5845(), 1, source.method_9211());
                if (item == null) {
                    source.method_45068((class_2561)class_2561.method_43470((String)"No Preferred Item Found For: ").method_10852((class_2561)arcanaItem.getTranslatedName()).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                    return 0;
                }
                String uuid = ArcanaItem.getUUID(item);
                source.method_45068((class_2561)class_2561.method_43470((String)"Generated New: ").method_10852((class_2561)arcanaItem.getTranslatedName()).method_10852((class_2561)class_2561.method_43470((String)(" with UUID " + uuid))).method_27692(class_124.field_1060));
                BorisLib.addTickTimerCallback((TickTimerCallback)new ItemReturnTimerCallback(item, target, 0));
            }
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int createItem(class_2168 source, String id) throws CommandSyntaxException {
        try {
            ArcanaItem arcanaItem = ArcanaItemUtils.getItemFromId(id);
            if (arcanaItem == null) {
                source.method_45068((class_2561)class_2561.method_43470((String)("Invalid Arcana Item ID: " + id)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                return 0;
            }
            class_1799 item = arcanaItem.addCrafter(arcanaItem.getNewItem(), source.method_9207().method_5845(), 1, source.method_9211());
            if (item == null) {
                source.method_45068((class_2561)class_2561.method_43470((String)"No Preferred Item Found For: ").method_10852((class_2561)arcanaItem.getTranslatedName()).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                return 0;
            }
            String uuid = ArcanaItem.getUUID(item);
            source.method_45068((class_2561)class_2561.method_43470((String)"Generated New: ").method_10852((class_2561)arcanaItem.getTranslatedName()).method_10852((class_2561)class_2561.method_43470((String)(" with UUID " + uuid))).method_27692(class_124.field_1060));
            BorisLib.addTickTimerCallback((TickTimerCallback)new ItemReturnTimerCallback(item, source.method_9207(), 0));
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int showItem(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737() || source.method_44023() == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Command must be executed by a player"), false);
            return -1;
        }
        class_3222 player = source.method_44023();
        if (!ArcanaItemUtils.isArcane(player.method_6047())) {
            source.method_9226(() -> class_2561.method_43470((String)"You can only show off Arcana Items"), false);
            return -1;
        }
        class_5250 message = class_2561.method_43470((String)"").method_10852(player.method_55423()).method_10852((class_2561)class_2561.method_43470((String)" is showing off their ").method_27692(class_124.field_1076)).method_10852(player.method_6047().method_7954());
        for (class_3222 other : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            other.method_64398((class_2561)message);
        }
        return 0;
    }

    public static int startDragonBoss(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9226(() -> class_2561.method_43470((String)"Command must be executed by a player"), false);
            return -1;
        }
        for (class_3218 world : source.method_9211().method_3738()) {
            if (((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)world)).getBossFight() == null) continue;
            source.method_9226(() -> class_2561.method_43470((String)"A Boss Fight is Currently Active"), false);
            return -1;
        }
        class_3222 player = source.method_44023();
        return DragonBossFight.prepBoss(player);
    }

    public static int abortBoss(CommandContext<class_2168> context) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)server.method_3847(class_1937.field_25181))).getBossFight();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Aborting Boss Fight"), true);
        if (bossFight == null) {
            return BossFight.cleanBoss(server);
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            return DragonBossFight.abortBoss(server);
        }
        return 0;
    }

    public static int cleanBoss(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"Cleaned Boss Data"), true);
        return BossFight.cleanBoss(source.method_9211());
    }

    public static int bossStatus(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)source.method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            return DragonBossFight.bossStatus(source.method_9211(), (class_2168)context.getSource());
        }
        return -1;
    }

    public static int bossResetAbilities(CommandContext<class_2168> context, boolean doAbility) {
        class_2168 source = (class_2168)context.getSource();
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)source.method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            return DragonBossFight.resetDragonAbilities(source.method_9211(), (class_2168)context.getSource(), doAbility);
        }
        return -1;
    }

    public static int bossForceLairAction(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)source.method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            return DragonBossFight.forceLairAction(source.method_9211(), (class_2168)context.getSource());
        }
        return -1;
    }

    public static int bossForcePlayerCount(CommandContext<class_2168> context, int playerCount) {
        class_2168 source = (class_2168)context.getSource();
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)source.method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            DragonBossFight.setForcedPlayerCount(((class_2168)context.getSource()).method_9211(), playerCount);
            return 1;
        }
        return -1;
    }

    public static int testBoss(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        return 0;
    }

    public static int bossTeleport(CommandContext<class_2168> context, class_3222 player, boolean all) {
        class_2168 source = (class_2168)context.getSource();
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)source.method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            if (all) {
                List players = source.method_9211().method_3760().method_14571();
                for (class_3222 p : players) {
                    DragonBossFight.teleportPlayer(p, true);
                }
            } else {
                DragonBossFight.teleportPlayer(player, ((class_2168)context.getSource()).method_9259(2));
            }
            return 0;
        }
        return -1;
    }

    public static int announceBoss(class_2168 source, String time) {
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)source.method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            return DragonBossFight.announceBoss(source.method_9211(), (class_2487)bossFight.method_15441(), time);
        }
        return -1;
    }

    public static int beginBoss(CommandContext<class_2168> context) {
        class_3545<BossFights, class_2487> bossFight = ((IBossFightComponent)WorldDataComponentInitializer.BOSS_FIGHT.get((Object)((class_2168)context.getSource()).method_9211().method_3847(class_1937.field_25181))).getBossFight();
        if (bossFight == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No Boss Fight Active"), false);
            return -1;
        }
        if (bossFight.method_15442() == BossFights.DRAGON) {
            return DragonBossFight.beginBoss(((class_2168)context.getSource()).method_9211(), (class_2487)bossFight.method_15441());
        }
        return -1;
    }

    public static int setItemName(CommandContext<class_2168> ctx, String name) {
        try {
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must run command as a player"));
                return -1;
            }
            class_3222 player = src.method_44023();
            class_1799 handItem = player.method_6047();
            handItem.method_57379(class_9334.field_50239, (Object)TextUtils.parseString((String)name));
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int getItemName(CommandContext<class_2168> ctx) {
        try {
            String feedback;
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must run command as a player"));
                return -1;
            }
            class_3222 player = src.method_44023();
            class_1799 handItem = player.method_6047();
            String copyText = feedback = TextUtils.textToString((class_2561)handItem.method_7964());
            src.method_9226(() -> class_2561.method_43470((String)feedback).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to Copy Data"))).method_10958((class_2558)new class_2558.class_10606(copyText))), false);
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int setItemLore(CommandContext<class_2168> ctx, int index, String lore) {
        try {
            class_9290 newLore;
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must run command as a player"));
                return -1;
            }
            class_3222 player = src.method_44023();
            class_1799 handItem = player.method_6047();
            class_9290 loreComp = (class_9290)handItem.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
            List lines = loreComp.comp_2401();
            if (index < 0) {
                newLore = loreComp.method_57499((class_2561)TextUtils.removeItalics((class_5250)TextUtils.parseString((String)lore)));
            } else if (index < lines.size()) {
                lines.set(index, TextUtils.removeItalics((class_5250)TextUtils.parseString((String)lore)));
                newLore = new class_9290(lines);
            } else {
                int blankLines = index - lines.size();
                for (int i = 0; i < blankLines; ++i) {
                    lines.add(class_2561.method_43470((String)""));
                }
                lines.add(TextUtils.removeItalics((class_5250)TextUtils.parseString((String)lore)));
                newLore = new class_9290(lines);
            }
            handItem.method_57379(class_9334.field_49632, (Object)newLore);
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int getItemLore(CommandContext<class_2168> ctx, int index) {
        try {
            String feedback;
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must run command as a player"));
                return -1;
            }
            class_3222 player = src.method_44023();
            class_1799 handItem = player.method_6047();
            class_9290 loreComp = (class_9290)handItem.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
            List lines = loreComp.comp_2401();
            if (index < 0 || index >= lines.size()) {
                return 0;
            }
            String copyText = feedback = TextUtils.textToString((class_2561)((class_2561)lines.get(index)));
            src.method_9226(() -> class_2561.method_43470((String)feedback).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to Copy Data"))).method_10958((class_2558)new class_2558.class_10606(copyText))), false);
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int removeItemLore(CommandContext<class_2168> ctx, int index) {
        try {
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must run command as a player"));
                return -1;
            }
            class_3222 player = src.method_44023();
            class_1799 handItem = player.method_6047();
            class_9290 loreComp = (class_9290)handItem.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
            List lines = loreComp.comp_2401();
            if (index < 0 || index >= lines.size()) {
                return 0;
            }
            lines.remove(index);
            handItem.method_57379(class_9334.field_49632, (Object)new class_9290(lines));
            return 1;
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int placedBlocks(CommandContext<class_2168> ctx, class_3222 player) {
        try {
            class_2168 src = (class_2168)ctx.getSource();
            ArrayList<class_5250> blocks = new ArrayList<class_5250>();
            for (class_3545 pair2 : ArcanaNovum.ACTIVE_ARCANA_BLOCKS.keySet().stream().filter(pair -> player.method_5845().equals(((ArcanaBlockEntity)pair.method_15441()).getCrafterId()) && ((class_2586)pair.method_15442()).method_11002() && ((class_2586)pair.method_15442()).method_10997().method_8321(((class_2586)pair.method_15442()).method_11016()) == pair.method_15442()).toList()) {
                class_2586 blockEntity = (class_2586)pair2.method_15442();
                ArcanaBlockEntity arcanaBlockEntity = (ArcanaBlockEntity)pair2.method_15441();
                String dim = blockEntity.method_10997().method_27983().method_29177().toString();
                class_5250 dimensionName = class_2561.method_43470((String)"Unknown").method_27692(class_124.field_1080);
                if (dim.equals(class_3218.field_25179.method_29177().toString())) {
                    dimensionName = class_2561.method_43470((String)"The Overworld").method_27692(class_124.field_1060);
                } else if (dim.equals(class_3218.field_25180.method_29177().toString())) {
                    dimensionName = class_2561.method_43470((String)"The Nether").method_27692(class_124.field_1061);
                } else if (dim.equals(class_3218.field_25181.method_29177().toString())) {
                    dimensionName = class_2561.method_43470((String)"The End").method_27692(class_124.field_1064);
                }
                class_2338 pos = blockEntity.method_11016();
                String posStr = pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
                class_5250 blockText = class_2561.method_43470((String)"").method_10852(arcanaBlockEntity.getArcanaItem().getDisplayName()).method_10852((class_2561)class_2561.method_43470((String)" in ").method_27692(class_124.field_1076)).method_10852((class_2561)dimensionName).method_10852((class_2561)class_2561.method_43470((String)" at (").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)posStr).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1076));
                blocks.add(blockText);
            }
            class_5250 feedback = class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(blocks.size())).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" placed Arcana Blocks.").method_27692(class_124.field_1076));
            src.method_9226(() -> class_2561.method_43470((String)""), false);
            src.method_9226(() -> feedback, false);
            src.method_9226(() -> class_2561.method_43470((String)"================================").method_27692(class_124.field_1076), false);
            for (class_5250 r : blocks) {
                src.method_9226(() -> r, false);
            }
            return blocks.size();
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    public static int placedBlocks(CommandContext<class_2168> ctx) {
        try {
            class_2168 src = (class_2168)ctx.getSource();
            if (!src.method_43737()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Must run command as a player"));
                return -1;
            }
            return ArcanaCommands.placedBlocks(ctx, src.method_44023());
        }
        catch (Exception e) {
            ArcanaNovum.log(2, e.toString());
            return -1;
        }
    }

    private static /* synthetic */ class_2583 lambda$makeCraftingRecipe$29(String path, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10606(path));
    }

    private static /* synthetic */ Optional lambda$makeCraftingRecipe$28(ModContainer container) {
        return container.findPath("data/arcananovum/datagen/");
    }

    private static /* synthetic */ class_2583 lambda$getItemData$27(String path, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10606(path));
    }

    private static /* synthetic */ Optional lambda$getItemData$26(ModContainer container) {
        return container.findPath("data/arcananovum/datagen/");
    }

    private static /* synthetic */ Optional lambda$getItemData$25(ModContainer container) {
        return container.findPath("data/arcananovum/datagen/new_item_template.txt");
    }

    private static /* synthetic */ class_2583 lambda$getBookData$23(String path, class_2583 s) {
        return s.method_10958((class_2558)new class_2558.class_10606(path));
    }

    private static /* synthetic */ void lambda$getBookData$22(BookElementBuilder bookBuilder, List list) {
        bookBuilder.addPage(list.toArray(new class_2561[0]));
    }

    private static /* synthetic */ Optional lambda$getBookData$21(ModContainer container) {
        return container.findPath("data/arcananovum/datagen/");
    }
}

