/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.callbacks.BlockAttackCallback;
import net.borisshoes.arcananovum.callbacks.BlockBreakCallback;
import net.borisshoes.arcananovum.callbacks.CommandRegisterCallback;
import net.borisshoes.arcananovum.callbacks.EntityAttackCallback;
import net.borisshoes.arcananovum.callbacks.EntityLoadCallbacks;
import net.borisshoes.arcananovum.callbacks.EntityUseCallback;
import net.borisshoes.arcananovum.callbacks.PlayerConnectionCallback;
import net.borisshoes.arcananovum.callbacks.PlayerDeathCallback;
import net.borisshoes.arcananovum.callbacks.ServerStartedCallback;
import net.borisshoes.arcananovum.callbacks.ServerStartingCallback;
import net.borisshoes.arcananovum.callbacks.TickCallback;
import net.borisshoes.arcananovum.callbacks.WorldTickCallback;
import net.borisshoes.arcananovum.cardinalcomponents.IAnchorsComponent;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.cardinalcomponents.PlayerComponentInitializer;
import net.borisshoes.arcananovum.cardinalcomponents.WorldDataComponentInitializer;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.gui.VirtualInventoryGui;
import net.borisshoes.arcananovum.utils.ConfigUtils;
import net.borisshoes.borislib.utils.ItemModDataHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArcanaNovum
implements ModInitializer,
ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Arcana Novum");
    public static final HashMap<class_3218, Long2IntOpenHashMap> ANCHOR_CHUNKS = new HashMap();
    public static final HashMap<class_3545<class_2586, ArcanaBlockEntity>, Integer> ACTIVE_ARCANA_BLOCKS = new HashMap();
    public static final HashMap<String, List<UUID>> PLAYER_ACHIEVEMENT_TRACKER = new HashMap();
    public static final HashMap<UUID, Integer> PLAYER_XP_TRACKER = new HashMap();
    public static final List<UUID> TOTEM_KILL_LIST = new ArrayList<UUID>();
    public static final HashMap<VirtualInventoryGui<?>, class_3222> VIRTUAL_INVENTORY_GUIS = new HashMap();
    public static MinecraftServer SERVER = null;
    public static final boolean DEV_MODE = false;
    private static final String CONFIG_NAME = "ArcanaNovum.properties";
    public static final String MOD_ID = "arcananovum";
    public static final String BLANK_UUID = "00000000-0000-4000-8000-000000000000";
    public static final ItemModDataHandler ITEM_DATA = new ItemModDataHandler("arcananovum");
    public static ConfigUtils CONFIG;
    public static int DEBUG_VALUE;

    public void onInitialize() {
        CONFIG = new ConfigUtils(FabricLoader.getInstance().getConfigDir().resolve(CONFIG_NAME).toFile(), LOGGER, ArcanaRegistry.CONFIG_SETTINGS.method_10220().map(ArcanaConfig.ConfigSetting::makeConfigValue).collect(Collectors.toList()));
        ArcanaRegistry.initialize();
        ServerTickEvents.END_WORLD_TICK.register(WorldTickCallback::onWorldTick);
        ServerTickEvents.END_SERVER_TICK.register(TickCallback::onTick);
        UseEntityCallback.EVENT.register(EntityUseCallback::useEntity);
        AttackBlockCallback.EVENT.register(BlockAttackCallback::attackBlock);
        PlayerBlockBreakEvents.BEFORE.register(BlockBreakCallback::breakBlock);
        AttackEntityCallback.EVENT.register(EntityAttackCallback::attackEntity);
        ServerPlayConnectionEvents.JOIN.register(PlayerConnectionCallback::onPlayerJoin);
        ServerPlayConnectionEvents.DISCONNECT.register(PlayerConnectionCallback::onPlayerLeave);
        CommandRegistrationCallback.EVENT.register(CommandRegisterCallback::registerCommands);
        ServerEntityEvents.ENTITY_LOAD.register(EntityLoadCallbacks::loadEntity);
        ServerEntityEvents.ENTITY_UNLOAD.register(EntityLoadCallbacks::unloadEntity);
        ServerPlayerEvents.AFTER_RESPAWN.register(PlayerDeathCallback::afterRespawn);
        ServerPlayerEvents.COPY_FROM.register(PlayerDeathCallback::onPlayerCopy);
        ServerLifecycleEvents.SERVER_STARTING.register(ServerStartingCallback::serverStarting);
        ServerLifecycleEvents.SERVER_STARTED.register(ServerStartedCallback::serverStarted);
        LOGGER.info("Arcana Surges Through The World!");
    }

    public void onInitializeClient() {
        LOGGER.info("Arcana Surges Through Your Client!");
    }

    public static boolean addActiveAnchor(class_3218 world, class_2338 pos) {
        return ((IAnchorsComponent)WorldDataComponentInitializer.ACTIVE_ANCHORS.get((Object)world)).addAnchor(pos);
    }

    public static boolean removeActiveAnchor(class_3218 targetWorld, class_2338 pos) {
        return ((IAnchorsComponent)WorldDataComponentInitializer.ACTIVE_ANCHORS.get((Object)targetWorld)).removeAnchor(pos);
    }

    public static boolean addActiveBlock(class_3545<class_2586, ArcanaBlockEntity> pair) {
        List<class_3545> existing = ACTIVE_ARCANA_BLOCKS.keySet().stream().filter(p -> ((ArcanaBlockEntity)p.method_15441()).getUuid().equals(((ArcanaBlockEntity)pair.method_15441()).getUuid())).toList();
        existing.forEach(ACTIVE_ARCANA_BLOCKS::remove);
        ACTIVE_ARCANA_BLOCKS.put(pair, 30);
        return existing.isEmpty();
    }

    public static IArcanaProfileComponent data(class_1657 player) {
        if (player == null) {
            return null;
        }
        try {
            return (IArcanaProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
        }
        catch (Exception e) {
            ArcanaNovum.log(3, "Failed to get Arcane Profile for " + player.method_5820() + " (" + player.method_5845() + ")");
            ArcanaNovum.log(3, e.toString());
            return null;
        }
    }

    public static void devPrint(String msg) {
    }

    public static void log(int level, String msg) {
        switch (level) {
            case 0: {
                LOGGER.info(msg);
                break;
            }
            case 1: {
                LOGGER.warn(msg);
                break;
            }
            case 2: {
                LOGGER.error(msg);
                break;
            }
            case 3: {
                LOGGER.fatal(msg);
                break;
            }
            default: {
                LOGGER.debug(msg);
            }
        }
    }

    static {
        DEBUG_VALUE = 0;
    }
}

