/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.achievements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ConditionalsAchievement
extends ArcanaAchievement {
    private final HashMap<String, Boolean> conditions = new HashMap();

    public ConditionalsAchievement(String name, String id, class_1799 displayItem, ArcanaItem arcanaItem, int xpReward, int pointsReward, String[] description, String[] conditions) {
        super(name, id, 2, displayItem, arcanaItem, xpReward, pointsReward, description);
        for (String cond : conditions) {
            this.conditions.put(cond, false);
        }
        this.setAcquired(false);
    }

    protected boolean setCondition(String cond, boolean set) {
        boolean had = this.isAcquired();
        if (this.conditions.containsKey(cond)) {
            this.conditions.put(cond, set);
        }
        this.setAcquired(this.conditions.values().stream().allMatch(b -> b));
        return this.isAcquired() && !had;
    }

    public HashMap<String, Boolean> getConditions() {
        return this.conditions;
    }

    @Override
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("acquired", this.isAcquired());
        nbt.method_10582("name", this.name);
        nbt.method_10569("type", this.type);
        class_2487 condsTag = new class_2487();
        for (Map.Entry<String, Boolean> entry : this.conditions.entrySet()) {
            condsTag.method_10556(entry.getKey(), entry.getValue().booleanValue());
        }
        nbt.method_10566("conditions", (class_2520)condsTag);
        return nbt;
    }

    @Override
    public ConditionalsAchievement fromNbt(String id, class_2487 nbt) {
        ConditionalsAchievement ach = (ConditionalsAchievement)ArcanaAchievements.registry.get(id).makeNew();
        ach.conditions.clear();
        ach.setAcquired(nbt.method_68566("acquired", false));
        class_2487 condsTag = nbt.method_68568("conditions");
        for (String key : condsTag.method_10541()) {
            ach.conditions.put(key, condsTag.method_68566(key, false));
        }
        return ach;
    }

    @Override
    public class_5250[] getStatusDisplay(class_3222 player) {
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        ConditionalsAchievement achievement = (ConditionalsAchievement)profile.getAchievement(this.getArcanaItem().getId(), this.id);
        if (achievement != null && achievement.isAcquired()) {
            return new class_5250[]{class_2561.method_43470((String)"Achieved!").method_27692(class_124.field_1075)};
        }
        ArrayList<class_5250> missing = new ArrayList<class_5250>();
        missing.add(class_2561.method_43470((String)"Missing:").method_27692(class_124.field_1062));
        if (achievement == null) {
            for (String cond : this.conditions.keySet()) {
                missing.add(class_2561.method_43470((String)cond).method_27692(class_124.field_1075));
            }
        } else {
            for (String cond : this.conditions.keySet()) {
                if (achievement.getConditions().get(cond).booleanValue()) continue;
                missing.add(class_2561.method_43470((String)cond).method_27692(class_124.field_1075));
            }
        }
        return missing.toArray(new class_5250[0]);
    }

    @Override
    public ConditionalsAchievement makeNew() {
        return new ConditionalsAchievement(this.name, this.id, this.getDisplayItem(), this.getArcanaItem(), this.xpReward, this.pointsReward, this.getDescription(), this.conditions.keySet().toArray(new String[0]));
    }
}

