/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.areaeffects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.areaeffects.AreaEffectSource;
import net.borisshoes.arcananovum.areaeffects.AreaEffectTracker;
import net.borisshoes.arcananovum.effects.DamageAmpEffect;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AlchemicalArrowAreaEffectTracker
extends AreaEffectTracker {
    private final List<AlchemicalArrowSource> sources = new ArrayList<AlchemicalArrowSource>();

    public AlchemicalArrowAreaEffectTracker() {
        super("alchemical_arrow");
    }

    @Override
    public void onTick(MinecraftServer server) {
        if (this.sources.isEmpty()) {
            return;
        }
        for (class_3218 world : server.method_3738()) {
            HashMap<class_2338, List> affectedBlocks = new HashMap<class_2338, List>();
            HashMap<class_1297, List> affectedEntities = new HashMap<class_1297, List>();
            for (AlchemicalArrowSource alchemicalArrowSource : this.sources) {
                for (class_2338 affectedBlock : alchemicalArrowSource.getAffectedBlocks(world)) {
                    if (affectedBlocks.containsKey(affectedBlock)) {
                        ((List)affectedBlocks.get(affectedBlock)).addAll(alchemicalArrowSource.getEffects().stream().map(e -> new class_3545(e, (Object)source)).toList());
                        continue;
                    }
                    affectedBlocks.put(affectedBlock, alchemicalArrowSource.getEffects().stream().map(e -> new class_3545(e, (Object)source)).collect(Collectors.toCollection(ArrayList::new)));
                }
                for (class_1297 affectedEntity : alchemicalArrowSource.getAffectedEntities(world)) {
                    if (affectedEntities.containsKey(affectedEntity)) {
                        ((List)affectedEntities.get(affectedEntity)).addAll(alchemicalArrowSource.getEffects().stream().map(e -> new class_3545(e, (Object)source)).toList());
                        continue;
                    }
                    affectedEntities.put(affectedEntity, alchemicalArrowSource.getEffects().stream().map(e -> new class_3545(e, (Object)source)).collect(Collectors.toCollection(ArrayList::new)));
                }
            }
            for (Map.Entry entry : affectedEntities.entrySet()) {
                class_1297 entity = (class_1297)entry.getKey();
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                List effects = (List)entry.getValue();
                HashMap<class_1291, class_3545> instantEffects = new HashMap<class_1291, class_3545>();
                for (class_3545 class_35452 : effects) {
                    class_1293 effect = (class_1293)class_35452.method_15442();
                    AlchemicalArrowSource source = (AlchemicalArrowSource)class_35452.method_15441();
                    if (((class_1291)effect.method_5579().comp_349()).method_5561() && server.method_3780() % 20 == 0) {
                        if (instantEffects.containsKey(effect.method_5579().comp_349())) {
                            if (effect.method_5578() <= (Integer)((class_3545)instantEffects.get(effect.method_5579().comp_349())).method_15442()) continue;
                            instantEffects.put((class_1291)effect.method_5579().comp_349(), new class_3545((Object)effect.method_5578(), (Object)source));
                            continue;
                        }
                        instantEffects.put((class_1291)effect.method_5579().comp_349(), new class_3545((Object)effect.method_5578(), (Object)source));
                        continue;
                    }
                    if (((class_1291)effect.method_5579().comp_349()).method_5561()) continue;
                    source.applyEffect(world, living, effect);
                }
                for (Map.Entry entry2 : instantEffects.entrySet()) {
                    ((AlchemicalArrowSource)((class_3545)entry2.getValue()).method_15441()).applyEffect(world, living, new class_1293(class_7923.field_41174.method_47983((Object)((class_1291)entry2.getKey())), 1, ((Integer)((class_3545)entry2.getValue()).method_15442()).intValue()));
                }
            }
            for (Map.Entry entry : affectedBlocks.entrySet()) {
                class_2338 pos = (class_2338)entry.getKey();
                List effects = (List)entry.getValue();
                int random = (int)(Math.random() * (double)effects.size());
                if (!(Math.random() < 0.03)) continue;
                class_2390 dust = new class_2390(((class_1291)((class_1293)((class_3545)effects.get(random)).method_15442()).method_5579().comp_349()).method_5556(), 1.2f);
                world.method_65096((class_2394)dust, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1, 0.5, 0.5, 0.5, 0.0);
            }
        }
        this.sources.removeIf(AlchemicalArrowSource::age);
    }

    @Override
    public void addSource(AreaEffectSource source) {
        if (source instanceof AlchemicalArrowSource) {
            AlchemicalArrowSource arrowSource = (AlchemicalArrowSource)source;
            this.sources.add(arrowSource);
        }
    }

    public static AlchemicalArrowSource source(@Nullable class_1297 contributor, class_2338 sourceBlock, class_3218 blockWorld, double range, int level, List<class_1293> effects) {
        return new AlchemicalArrowSource(sourceBlock, blockWorld, range, level, effects, contributor);
    }

    public static class AlchemicalArrowSource
    extends AreaEffectSource {
        private final class_2338 sourceBlock;
        private final class_3218 blockWorld;
        private final double range;
        private final int level;
        private final List<class_1293> effects;
        private int age;
        private final int duration;
        private final class_1297 contributor;

        private AlchemicalArrowSource(class_2338 sourceBlock, class_3218 blockWorld, double range, int level, List<class_1293> effects, @Nullable class_1297 contributor) {
            this.sourceBlock = sourceBlock;
            this.blockWorld = blockWorld;
            this.range = range;
            this.level = level;
            this.effects = new ArrayList<class_1293>();
            this.effects.addAll(effects);
            this.contributor = contributor;
            this.age = 0;
            this.duration = 200;
        }

        public class_1937 getSourceWorld() {
            return this.blockWorld;
        }

        public class_2338 getBlockPos() {
            return this.sourceBlock;
        }

        public boolean age() {
            ++this.age;
            return this.age >= this.duration;
        }

        public int getLevel() {
            return this.level;
        }

        public class_1297 getContributor() {
            return this.contributor;
        }

        public List<class_1293> getEffects() {
            return this.effects;
        }

        public void applyEffect(class_3218 world, class_1309 entity, class_1293 effect) {
            class_1297 class_12972;
            if (!world.method_27983().method_29177().toString().equals(this.blockWorld.method_27983().method_29177().toString())) {
                return;
            }
            class_1293 existing = entity.method_6112(effect.method_5579());
            if (existing != null && existing.method_5578() >= effect.method_5578()) {
                return;
            }
            boolean applied = entity.method_37222(new class_1293(effect), this.contributor);
            if (applied && effect.method_5579() == ArcanaRegistry.DAMAGE_AMP_EFFECT && (class_12972 = this.contributor) instanceof class_1309) {
                class_1309 applier = (class_1309)class_12972;
                DamageAmpEffect.AMP_TRACKER.put(entity, applier);
            }
        }

        @Override
        public List<class_2338> getAffectedBlocks(class_3218 world) {
            class_3218 thisWorld;
            class_1937 class_19372 = this.getSourceWorld();
            if (class_19372 instanceof class_3218 && (thisWorld = (class_3218)class_19372).method_27983().method_29177().toString().equals(world.method_27983().method_29177().toString())) {
                ArrayList<class_2338> blocks = new ArrayList<class_2338>();
                for (class_2338 block : class_2338.method_25996((class_2338)this.getBlockPos(), (int)((int)this.range + 4), (int)((int)this.range + 4), (int)((int)this.range + 4))) {
                    if (!(block.method_46558().method_1022(this.getBlockPos().method_46558()) <= this.range + 0.4)) continue;
                    blocks.add((class_2338)block.method_25503());
                }
                return blocks;
            }
            return new ArrayList<class_2338>();
        }

        @Override
        public List<class_1297> getAffectedEntities(class_3218 world) {
            class_3218 thisWorld;
            class_1937 class_19372 = this.getSourceWorld();
            if (class_19372 instanceof class_3218 && (thisWorld = (class_3218)class_19372).method_27983().method_29177().toString().equals(world.method_27983().method_29177().toString())) {
                class_2338 blockPos = this.getBlockPos();
                class_238 rangeBox = class_238.method_29968((class_243)blockPos.method_46558()).method_1014(this.range + 4.0);
                return world.method_8333(null, rangeBox, e -> !e.method_7325() && e.method_5707(blockPos.method_46558()) < this.range * this.range && e instanceof class_1309);
            }
            return new ArrayList<class_1297>();
        }

        @Override
        public int getDuration() {
            return this.duration;
        }
    }
}

