/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.MidnightEnchanterBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class MidnightEnchanter
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "midnight_enchanter";
    private Multiblock multiblock;

    public MidnightEnchanter() {
        this.id = ID;
        this.name = "Midnight Enchanter";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.FORGE};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8657;
        this.block = new MidnightEnchanterBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16020).method_9629(5.0f, 1200.0f).method_29292().method_9631(state -> 7));
        this.item = new MidnightEnchanterItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.midnight_enchanter", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_ENCHANT_ITEM, ResearchTasks.OBTAIN_BOTTLES_OF_ENCHANTING, ResearchTasks.ADVANCEMENT_READ_POWER_OF_CHISELED_BOOKSHELF, ResearchTasks.ADVANCEMENT_OBTAIN_CRYING_OBSIDIAN, ResearchTasks.UNLOCK_STARLIGHT_FORGE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" addon to the ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Normal ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Enchanting Tables").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" are ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"unpredictable ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"inconsistent").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Table ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"not only enables ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"precise control ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"of ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"enchantments").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"...").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It also allows for ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"enchantments ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"to be ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"removed ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"placed ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"onto ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"books").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Enchantments ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"can also be ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"broken down").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" into ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Nebulous Essence").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1078)));
        this.addForgeLore(lore);
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-2, -1, -2);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 24);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9111), 4));
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9097), 3));
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9113), 1));
        ArcanaIngredient f = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9131), 5));
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8287, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8055, 12);
        ArcanaIngredient j = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_38223), 3));
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9119), 3));
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8657, 16);
        ArcanaIngredient o = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_23071), 3));
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9101), 1));
        ArcanaIngredient t = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9129), 4));
        ArcanaIngredient v = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9118), 5));
        ArcanaIngredient w = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9110), 3));
        ArcanaIngredient x = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9109), 1));
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {f, g, h, g, j}, {k, h, m, h, o}, {p, g, h, g, t}, {a, v, w, x, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Midnight Enchanter").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nEnchanting tables are an old design. It only scratches the surface of how Arcana can be bound to equipment, and relies too much on random environmental fluctuations. If my predictive equations ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Midnight Enchanter").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nare correct, I should be able to cancel out the noise in the enchantment matrix and reduce Enchantment Arcana to a pure form, after which it can take any shape of my choosing.\n\nThe Enchanter allows").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Midnight Enchanter").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\ndisenchanting of items to gain Nebulous Essence, which can be spent to choose exact enchantments to place on items. The Enchanter also gives access to normally unavailable enchantments.").method_27692(class_124.field_1074)));
        return list;
    }

    public class MidnightEnchanterBlock
    extends ArcanaPolymerBlockEntity {
        public MidnightEnchanterBlock(class_4970.class_2251 settings) {
            super(MidnightEnchanter.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_10485.method_9564();
        }

        @Nullable
        public static MidnightEnchanterBlockEntity getEntity(class_1937 world, class_2338 pos) {
            MidnightEnchanterBlockEntity enchanter;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof MidnightEnchanterBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof MidnightEnchanterBlockEntity ? (enchanter = (MidnightEnchanterBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new MidnightEnchanterBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return MidnightEnchanterBlock.method_31618(type, ArcanaRegistry.MIDNIGHT_ENCHANTER_BLOCK_ENTITY, MidnightEnchanterBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            MidnightEnchanterBlockEntity enchanter = (MidnightEnchanterBlockEntity)world.method_8321(pos);
            if (enchanter != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (enchanter.isAssembled()) {
                    if (StarlightForge.findActiveForge(player.method_51469(), pos) == null) {
                        player.method_64398((class_2561)class_2561.method_43470((String)"The Enchanter must be within the range of an active Starlight Forge"));
                    } else if (enchanter.hasBooks()) {
                        enchanter.openGui(player);
                    } else {
                        player.method_64398((class_2561)class_2561.method_43470((String)"The Enchanter needs at least 20 bookshelves nearby"));
                    }
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    MidnightEnchanter.this.multiblock.displayStructure(enchanter.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof MidnightEnchanterBlockEntity) {
                MidnightEnchanterBlockEntity enchanter = (MidnightEnchanterBlockEntity)entity;
                MidnightEnchanterBlock.initializeArcanaBlock(stack, enchanter);
            }
        }
    }

    public class MidnightEnchanterItem
    extends ArcanaPolymerBlockItem {
        public MidnightEnchanterItem(class_2248 block) {
            super(MidnightEnchanter.this.getThis(), block, MidnightEnchanter.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return MidnightEnchanter.this.prefItem;
        }
    }
}

