/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ExplainIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ExplainRecipe;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class StarlightForge
extends ArcanaBlock
implements MultiblockCore {
    public static final String SEED_USES_TAG = "seedUses";
    public static final String ID = "starlight_forge";
    private Multiblock multiblock;

    public StarlightForge() {
        this.id = ID;
        this.name = "Starlight Forge";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.FORGE};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_16308;
        this.block = new StarlightForgeBlock(class_4970.class_2251.method_9637().method_9629(2.5f, 1200.0f).method_9626(class_2498.field_11547));
        this.item = new StarlightForgeItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.starlight_forge", (String)this.name).method_27692(class_124.field_1067).method_54663(0xFF99FF);
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_ARCANE_TOME, ResearchTasks.OBTAIN_ENCHANTED_GOLDEN_APPLE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        StarlightForge.putProperty(stack, SEED_USES_TAG, 0);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"With the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"stars ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"as your witness...").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Your ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"journey ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"of ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"forging ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"new ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Arcana ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"begins!").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" lets you craft ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"enhanced equipment").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" acts as a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"hub ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"for other ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structures").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        this.addForgeLore(lore);
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-1, -1, -1);
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    public static StarlightForgeBlockEntity findActiveForge(class_3218 world, class_2338 searchingPos) {
        class_2338 range = new class_2338(15, 8, 15);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)searchingPos.method_10081((class_2382)range), (class_2338)searchingPos.method_10059((class_2382)range))) {
            StarlightForgeBlockEntity forge;
            class_2586 be = world.method_8321(blockPos);
            if (!(be instanceof StarlightForgeBlockEntity) || !(forge = (StarlightForgeBlockEntity)be).isAssembled()) continue;
            class_2338 offset = blockPos.method_10059((class_2382)searchingPos);
            class_2338 forgeRange = forge.getForgeRange();
            if (Math.abs(offset.method_10263()) > forgeRange.method_10263() || Math.abs(offset.method_10264()) > forgeRange.method_10264() || Math.abs(offset.method_10260()) > forgeRange.method_10260()) continue;
            return forge;
        }
        return null;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ExplainIngredient a = new ExplainIngredient(GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918), 1, "", false).withName((class_2561)class_2561.method_43470((String)"In World Recipe").method_27692(class_124.field_1078)).withLore(List.of(class_2561.method_43470((String)"Do this in the World").method_27692(class_124.field_1064)));
        ExplainIngredient s = new ExplainIngredient(class_1802.field_16308, 1, "Smithing Table").withName((class_2561)class_2561.method_43470((String)"Smithing Table").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080})).withLore(List.of(class_2561.method_43470((String)"Place a Smithing Table in the World").method_27692(class_124.field_1064)));
        ExplainIngredient m = new ExplainIngredient(class_1802.field_8305, 1, "", false).withName((class_2561)class_2561.method_43470((String)"Night of a New Moon").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080})).withLore(List.of(class_2561.method_43470((String)"Follow this Recipe under the darkness of a New Moon").method_27692(class_124.field_1064)));
        ExplainIngredient g = new ExplainIngredient(class_1802.field_8367, 1, "Enchanted Golden Apple").withName((class_2561)class_2561.method_43470((String)"Enchanted Golden Apple").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065})).withLore(List.of(class_2561.method_43470((String)"Place the apple upon the Smithing Table.").method_27692(class_124.field_1064)));
        ExplainIngredient t = new ExplainIngredient(ArcanaRegistry.ARCANE_TOME.getItem(), 1, "Tome of Arcana Novum").withName((class_2561)class_2561.method_43470((String)"Tome of Arcana Novum").method_27695(new class_124[]{class_124.field_1067, class_124.field_1062})).withLore(List.of(class_2561.method_43470((String)"Place the Tome upon the Smithing Table.").method_27692(class_124.field_1064)));
        ExplainIngredient[][] ingredients = new ExplainIngredient[][]{{m, a, a, a, a}, {a, a, t, a, a}, {a, a, g, a, a}, {a, a, s, a, a}, {a, a, a, a, a}};
        return new ExplainRecipe(ingredients);
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Starlight Forge").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nEnchanted Golden Apples are a unique arcane artifact that I have discovered. Modern replicants do not seem to hold the same caliber of properties. My latest theories of Arcana suggest that the magic ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Starlight Forge").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nof this land is far more versatile than the old scholars believed. I just need something to kickstart my new field of research. It is possible that I can use some energy from starlight to transfer the ancient enchantment of a ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Starlight Forge").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\nGolden Apple. If I am to be successful in my research, I will need a forge\u2026\n\nThe Starlight Forge allows the creation of infused weapons, tools, and armor.\n\nIt creates a 17x11x17 workspace that can ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Starlight Forge").method_27692(class_124.field_1067).method_54663(0xFF99FF), class_2561.method_43470((String)"\ninteract with additions to the forge that can be crafted as I advance my research.").method_27692(class_124.field_1074)));
        return list;
    }

    public class StarlightForgeBlock
    extends ArcanaPolymerBlockEntity {
        public StarlightForgeBlock(class_4970.class_2251 settings) {
            super(StarlightForge.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return class_2246.field_16329.method_9564();
        }

        @Nullable
        public static StarlightForgeBlockEntity getEntity(class_1937 world, class_2338 pos) {
            StarlightForgeBlockEntity forge;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof StarlightForgeBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof StarlightForgeBlockEntity ? (forge = (StarlightForgeBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new StarlightForgeBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return StarlightForgeBlock.method_31618(type, ArcanaRegistry.STARLIGHT_FORGE_BLOCK_ENTITY, StarlightForgeBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            StarlightForgeBlockEntity forge = (StarlightForgeBlockEntity)world.method_8321(pos);
            if (forge != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (forge.isAssembled()) {
                    forge.openGui(0, player, "", null);
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    StarlightForge.this.multiblock.displayStructure(forge.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof StarlightForgeBlockEntity) {
                StarlightForgeBlockEntity forge = (StarlightForgeBlockEntity)entity;
                StarlightForgeBlock.initializeArcanaBlock(stack, forge);
                forge.setSeedUses(ArcanaItem.getIntProperty(stack, StarlightForge.SEED_USES_TAG));
            }
        }
    }

    public class StarlightForgeItem
    extends ArcanaPolymerBlockItem {
        public StarlightForgeItem(class_2248 block) {
            super(StarlightForge.this.getThis(), block, StarlightForge.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return StarlightForge.this.prefItem;
        }
    }
}

