/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import eu.pb4.polymer.core.api.utils.PolymerObject;
import java.util.ArrayList;
import java.util.TreeMap;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularityBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.starlightforge.StarlightForgeGui;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3719;
import net.minecraft.class_3917;
import net.minecraft.class_5285;
import org.jetbrains.annotations.Nullable;

public class StarlightForgeBlockEntity
extends class_2586
implements PolymerObject,
ArcanaBlockEntity {
    private TreeMap<ArcanaAugment, Integer> augments;
    private String crafterId;
    private String uuid;
    private int origin;
    private String customName;
    private final Multiblock multiblock = ((MultiblockCore)((Object)ArcanaRegistry.STARLIGHT_FORGE)).getMultiblock();
    private boolean assembled;
    private int seedUses;

    public StarlightForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(ArcanaRegistry.STARLIGHT_FORGE_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void initialize(TreeMap<ArcanaAugment, Integer> augments, String crafterId, String uuid, int origin, @Nullable String customName) {
        this.augments = augments;
        this.crafterId = crafterId;
        this.uuid = uuid;
        this.origin = origin;
        this.customName = customName == null ? "" : customName;
        this.assembled = false;
    }

    public void setSeedUses(int uses) {
        this.seedUses = uses;
    }

    public int getSeedUses() {
        return this.seedUses;
    }

    public void openGui(int screen, class_3222 player, String data, @Nullable TomeGui.CompendiumSettings settings) {
        StarlightForgeGui gui = null;
        if (screen == 0) {
            gui = new StarlightForgeGui(class_3917.field_17337, player, this, this.field_11863, screen, settings);
            gui.buildMenuGui();
        } else if (screen == 1) {
            gui = new StarlightForgeGui(class_3917.field_18667, player, this, this.field_11863, screen, settings);
            gui.buildCraftingGui(data);
        } else if (screen == 2) {
            gui = new StarlightForgeGui(class_3917.field_17326, player, this, this.field_11863, screen, settings);
            gui.buildForgeGui();
        } else if (screen == 3) {
            gui = new StarlightForgeGui(class_3917.field_18667, player, this, this.field_11863, screen, settings);
            gui.buildRecipeGui(data);
        } else if (screen == 4) {
            gui = new StarlightForgeGui(class_3917.field_17327, player, this, this.field_11863, screen, settings);
            TomeGui.buildCompendiumGui(gui, player, settings);
        } else if (screen == 5) {
            gui = new StarlightForgeGui(class_3917.field_18667, player, this, this.field_11863, screen, settings);
            gui.buildSkilledGui(data);
        }
        if (gui != null) {
            gui.open();
        }
    }

    public static <E extends class_2586> void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, E e) {
        if (e instanceof StarlightForgeBlockEntity) {
            StarlightForgeBlockEntity forge = (StarlightForgeBlockEntity)e;
            forge.tick();
        }
    }

    private void tick() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (serverWorld.method_8503().method_3780() % 10 == 0) {
            this.assembled = this.multiblock.matches(this.getMultiblockCheck());
        }
        if (serverWorld.method_8503().method_3780() % 100 == 0) {
            class_3222 player;
            boolean hasAll = true;
            if (this.getForgeAddition(serverWorld, ArcanaRegistry.RADIANT_FLETCHERY_BLOCK_ENTITY) == null) {
                hasAll = false;
            }
            if (this.getForgeAddition(serverWorld, ArcanaRegistry.TWILIGHT_ANVIL_BLOCK_ENTITY) == null) {
                hasAll = false;
            }
            if (this.getForgeAddition(serverWorld, ArcanaRegistry.MIDNIGHT_ENCHANTER_BLOCK_ENTITY) == null) {
                hasAll = false;
            }
            if (this.getForgeAddition(serverWorld, ArcanaRegistry.STELLAR_CORE_BLOCK_ENTITY) == null) {
                hasAll = false;
            }
            if (this.getForgeAddition(serverWorld, ArcanaRegistry.ARCANE_SINGULARITY_BLOCK_ENTITY) == null) {
                hasAll = false;
            }
            if (hasAll && this.crafterId != null && !this.crafterId.isEmpty() && (player = serverWorld.method_8503().method_3760().method_14602(AlgoUtils.getUUID((String)this.crafterId))) != null) {
                ArcanaAchievements.grant(player, ArcanaAchievements.NIDAVELLIR.id);
            }
        }
        if (serverWorld.method_8503().method_3780() % 20 == 0 && this.assembled) {
            ArcanaNovum.addActiveBlock((class_3545<class_2586, ArcanaBlockEntity>)new class_3545((Object)this, (Object)this));
        }
    }

    public class_2338 getForgeRange() {
        return ArcanaAugments.getAugmentFromMap(this.augments, ArcanaAugments.STELLAR_RANGE.id) >= 1 ? new class_2338(15, 8, 15) : new class_2338(8, 5, 8);
    }

    public ArcanaBlockEntity getForgeAddition(class_3218 world, class_2591<? extends class_2586> additionBlockEntity) {
        class_2338 range = this.getForgeRange();
        for (class_2338 blockPos : class_2338.method_10097((class_2338)this.field_11867.method_10081((class_2382)range), (class_2338)this.field_11867.method_10059((class_2382)range))) {
            ArcanaBlockEntity arcanaBlock;
            class_2586 be = additionBlockEntity.method_24182((class_1922)world, blockPos);
            if (!(be instanceof ArcanaBlockEntity) || !(arcanaBlock = (ArcanaBlockEntity)be).isAssembled()) continue;
            return arcanaBlock;
        }
        return null;
    }

    public ArrayList<class_1263> getIngredientInventories() {
        ArrayList<class_1263> invs = new ArrayList<class_1263>();
        class_2338 range = this.getForgeRange();
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return invs;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        for (class_2338 blockPos : class_2338.method_10097((class_2338)this.field_11867.method_10081((class_2382)range), (class_2338)this.field_11867.method_10059((class_2382)range))) {
            ArcaneSingularityBlockEntity singularity;
            class_2586 be = serverWorld.method_8321(blockPos);
            class_2680 state = serverWorld.method_8320(blockPos);
            if (be instanceof class_2595) {
                class_2595 chestBe = (class_2595)be;
                if (invs.contains(chestBe)) continue;
                invs.add((class_1263)chestBe);
                continue;
            }
            if (be instanceof class_3719) {
                class_3719 barrelBe = (class_3719)be;
                if (invs.contains(barrelBe)) continue;
                invs.add((class_1263)barrelBe);
                continue;
            }
            if (be instanceof class_2627) {
                class_2627 shulkerBox = (class_2627)be;
                if (invs.contains(shulkerBox)) continue;
                invs.add((class_1263)shulkerBox);
                continue;
            }
            if (!(be instanceof ArcaneSingularityBlockEntity) || invs.contains(singularity = (ArcaneSingularityBlockEntity)be)) continue;
            invs.add((class_1263)singularity);
        }
        return invs;
    }

    @Override
    public boolean isAssembled() {
        return this.assembled;
    }

    public Multiblock.MultiblockCheck getMultiblockCheck() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return new Multiblock.MultiblockCheck(serverWorld, this.field_11867, serverWorld.method_8320(this.field_11867), new class_2338(((MultiblockCore)((Object)ArcanaRegistry.STARLIGHT_FORGE)).getCheckOffset()), null);
    }

    @Override
    public TreeMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public String getCrafterId() {
        return this.crafterId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public int getOrigin() {
        return this.origin;
    }

    @Override
    public String getCustomArcanaName() {
        return this.customName;
    }

    @Override
    public ArcanaItem getArcanaItem() {
        return ArcanaRegistry.STARLIGHT_FORGE;
    }

    public int getStartingValue() {
        return 40;
    }

    public int getPlanetCount() {
        int planetCount = 2;
        if (ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.MOONLIT_FORGE.id) >= 1) {
            long timeOfDay = this.field_11863.method_8532();
            int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
            int curPhase = day % 8;
            int influence = Math.abs(-curPhase + 4);
            if (influence == 0) {
                planetCount = 3;
            } else if (influence == 1) {
                planetCount = 3;
            } else if (influence == 2) {
                planetCount = 2;
            } else if (influence == 3) {
                planetCount = 1;
            } else if (influence == 4) {
                planetCount = 0;
            }
        }
        return planetCount;
    }

    public int getStarCount() {
        int starCount = 2;
        if (ArcanaAugments.getAugmentFromMap(this.getAugments(), ArcanaAugments.MOONLIT_FORGE.id) >= 1) {
            long timeOfDay = this.field_11863.method_8532();
            int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
            int curPhase = day % 8;
            int influence = Math.abs(-curPhase + 4);
            if (influence == 0) {
                starCount = 0;
            } else if (influence == 1) {
                starCount = 1;
            } else if (influence == 2) {
                starCount = 3;
            } else if (influence == 3) {
                starCount = 4;
            } else if (influence == 4) {
                starCount = 5;
            }
        }
        return starCount;
    }

    public long getSeed() {
        return class_5285.method_46720((String)(this.uuid + this.seedUses)).orElse(class_5285.method_46721());
    }

    public void addSeedUse() {
        ++this.seedUses;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.uuid = view.method_71428("arcanaUuid", "");
        this.crafterId = view.method_71428("crafterId", "");
        this.customName = view.method_71428("customName", "");
        this.origin = view.method_71424("synthetic", 0);
        this.seedUses = view.method_71424("seedUses", 0);
        this.augments = new TreeMap();
        view.method_71426("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC).ifPresent(data -> {
            this.augments = data;
        });
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71477("arcanaAugments", ArcanaAugments.AugmentData.AUGMENT_MAP_CODEC, this.augments);
        view.method_71469("arcanaUuid", this.uuid == null ? "" : this.uuid);
        view.method_71469("crafterId", this.crafterId == null ? "" : this.crafterId);
        view.method_71469("customName", this.customName == null ? "" : this.customName);
        view.method_71465("synthetic", this.origin);
        view.method_71465("seedUses", this.seedUses);
    }
}

