/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.blocks.forge.StellarCoreBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class StellarCore
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "stellar_core";
    private Multiblock multiblock;
    public static Map<class_1792, class_1799> MOLTEN_CORE_ITEMS = Map.ofEntries(Map.entry(class_1802.field_33400, new class_1799((class_1935)class_1802.field_8620, 2)), Map.entry(class_1802.field_33401, new class_1799((class_1935)class_1802.field_27022, 2)), Map.entry(class_1802.field_33402, new class_1799((class_1935)class_1802.field_8695, 2)), Map.entry(class_1802.field_33505, new class_1799((class_1935)class_1802.field_8773, 2)), Map.entry(class_1802.field_33506, new class_1799((class_1935)class_1802.field_27071, 2)), Map.entry(class_1802.field_33507, new class_1799((class_1935)class_1802.field_8494, 2)), Map.entry(class_1802.field_23140, new class_1799((class_1935)class_1802.field_8695, 2)), Map.entry(class_1802.field_8858, new class_1799((class_1935)class_1802.field_8280, 2)), Map.entry(class_1802.field_8200, new class_1799((class_1935)class_1802.field_8280, 2)), Map.entry(class_1802.field_22019, new class_1799((class_1935)class_1802.field_22021, 1)));

    public StellarCore() {
        this.id = ID;
        this.name = "Stellar Core";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.FORGE};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_16306;
        this.block = new StellarCoreBlock(class_4970.class_2251.method_9637().method_29292().method_9629(3.5f, 1200.0f).method_9631(StellarCoreBlock::getLightLevel).method_9626(class_2498.field_11533));
        this.item = new StellarCoreItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.stellar_core", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TWILIGHT_ANVIL, ResearchTasks.UNLOCK_STARLIGHT_FORGE, ResearchTasks.OBTAIN_BLAST_FURNACE, ResearchTasks.OBTAIN_NETHERITE_INGOT};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" addon to the ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The core of a ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"star ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"contained to ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"melt ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"even the ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"strongest ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"materials.").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Stellar Core").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" lets you ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"melt ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"down ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"equipment ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"for salvage.").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Enchantments ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"on salvaged ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"equipment ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"become ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Stardust").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        this.addForgeLore(lore);
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-2, -1, -4);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_22421, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8281, 32);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8183, 32);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_16306, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Stellar Core").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nSo often I find my storage plagued with decrepit armor. A furnace is far too crude to extract any worthwhile material, and it can\u2019t even get close to hot enough to melt Diamond or Netherite.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Stellar Core").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nWhat I need is the power of the sun! A cleverly enchanted alloy of Obsidian, Blackstone and Netherite should be able to withstand the temperatures to melt even Netherite coated Diamond, allowing me to extract a large \n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Stellar Core").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nportion of the material.\n\nInterestingly enough, the Arcane Sun I have created interacts with the enchantments bound to equipment and produces a glittery dust that is nearly indestructible \n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Stellar Core").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nand contains trace amounts of Arcana. This might be the key to making better equipment.").method_27692(class_124.field_1074)));
        return list;
    }

    public class StellarCoreBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2746 LIT = class_2741.field_12548;
        public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;

        public StellarCoreBlock(class_4970.class_2251 settings) {
            super(StellarCore.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return (class_2680)((class_2680)class_2246.field_16333.method_9564().method_11657((class_2769)LIT, (Comparable)((Boolean)state.method_11654((class_2769)LIT)))).method_11657(HORIZONTAL_FACING, (Comparable)((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657(HORIZONTAL_FACING, (Comparable)ctx.method_8042().method_10153());
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{LIT, HORIZONTAL_FACING});
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Nullable
        public static StellarCoreBlockEntity getEntity(class_1937 world, class_2338 pos) {
            StellarCoreBlockEntity core;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof StellarCoreBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof StellarCoreBlockEntity ? (core = (StellarCoreBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new StellarCoreBlockEntity(pos, state);
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return StellarCoreBlock.method_31618(type, ArcanaRegistry.STELLAR_CORE_BLOCK_ENTITY, StellarCoreBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            StellarCoreBlockEntity core = (StellarCoreBlockEntity)world.method_8321(pos);
            if (core != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (core.isAssembled()) {
                    if (StarlightForge.findActiveForge(player.method_51469(), pos) == null) {
                        player.method_64398((class_2561)class_2561.method_43470((String)"The Core must be within the range of an active Starlight Forge"));
                    } else {
                        core.openGui(player);
                    }
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    StellarCore.this.multiblock.displayStructure(core.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof StellarCoreBlockEntity) {
                StellarCoreBlockEntity core = (StellarCoreBlockEntity)entity;
                StellarCoreBlock.initializeArcanaBlock(stack, core);
            }
        }

        public static int getLightLevel(class_2680 state) {
            return (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? 13 : 0;
        }
    }

    public class StellarCoreItem
    extends ArcanaPolymerBlockItem {
        public StellarCoreItem(class_2248 block) {
            super(StellarCore.this.getThis(), block, StellarCore.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return StellarCore.this.prefItem;
        }
    }
}

