/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.blocks.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.StarlightForge;
import net.borisshoes.arcananovum.blocks.forge.TwilightAnvilBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaBlock;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.Multiblock;
import net.borisshoes.arcananovum.core.MultiblockCore;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockEntity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBlockItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class TwilightAnvil
extends ArcanaBlock
implements MultiblockCore {
    public static final String ID = "twilight_anvil";
    private Multiblock multiblock;

    public TwilightAnvil() {
        this.id = ID;
        this.name = "Twilight Anvil";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.BLOCKS, TomeGui.TomeFilter.FORGE};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8782;
        this.block = new TwilightAnvilBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_29292().method_9629(5.0f, 1200.0f).method_9626(class_2498.field_11531));
        this.item = new TwilightAnvilItem(this.block);
        this.displayName = class_2561.method_48321((String)"item.arcananovum.twilight_anvil", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.OBTAIN_ANVIL, ResearchTasks.UNLOCK_STARLIGHT_FORGE, ResearchTasks.OBTAIN_BOTTLES_OF_ENCHANTING};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Forge Structure").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" addon to the ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Starlight Forge").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"An improved ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"anvil ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"with ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"no XP limit").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Anvil ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"can be used to rename ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)", and apply ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"augments").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Anvil ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"can also be used to combine ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"enhanced equipment").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        this.addForgeLore(lore);
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void loadMultiblock() {
        this.multiblock = Multiblock.loadFromFile(this.getId());
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public class_2382 getCheckOffset() {
        return new class_2382(-1, -1, -1);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8477, 4);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_22021, 1);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8601, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8287, 8);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8782, 8);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Twilight Anvil").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nAnvils made of iron have their limits. They don\u2019t interact with Arcana, and they are less durable than the diamond and netherite equipment used on them, causing frequent damage. An anvil reinforced with").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Twilight Anvil").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nNetherite and infused with Arcana will have no such weaknesses.\n\nThe Anvil can act as a normal anvil, with no XP limit. The Anvil also enables the ability to Augment and rename Arcana items. It also can combine items infused with Stardust.").method_27692(class_124.field_1074)));
        return list;
    }

    public class TwilightAnvilBlock
    extends ArcanaPolymerBlockEntity {
        public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;

        public TwilightAnvilBlock(class_4970.class_2251 settings) {
            super(TwilightAnvil.this.getThis(), settings);
        }

        @Override
        public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
            return (class_2680)class_2246.field_10535.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Nullable
        public class_2680 method_9605(class_1750 ctx) {
            return (class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)ctx.method_8042().method_10170());
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
            stateManager.method_11667(new class_2769[]{HORIZONTAL_FACING});
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657(HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return state.method_26186(mirror.method_10345((class_2350)state.method_11654(HORIZONTAL_FACING)));
        }

        @Override
        @Nullable
        public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
            return TwilightAnvilBlock.method_31618(type, ArcanaRegistry.TWILIGHT_ANVIL_BLOCK_ENTITY, TwilightAnvilBlockEntity::ticker);
        }

        public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 playerEntity, class_3965 hit) {
            TwilightAnvilBlockEntity anvil = (TwilightAnvilBlockEntity)world.method_8321(pos);
            if (anvil != null && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (anvil.isAssembled()) {
                    if (StarlightForge.findActiveForge(player.method_51469(), pos) == null) {
                        player.method_64398((class_2561)class_2561.method_43470((String)"The Anvil must be within the range of an active Starlight Forge"));
                    } else {
                        anvil.openGui(0, player, "");
                    }
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Multiblock not constructed."));
                    TwilightAnvil.this.multiblock.displayStructure(anvil.getMultiblockCheck(), player);
                }
            }
            return class_1269.field_52422;
        }

        @Nullable
        public static TwilightAnvilBlockEntity getEntity(class_1937 world, class_2338 pos) {
            TwilightAnvilBlockEntity anvil;
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof TwilightAnvilBlock)) {
                return null;
            }
            class_2586 class_25862 = world.method_8321(pos);
            return class_25862 instanceof TwilightAnvilBlockEntity ? (anvil = (TwilightAnvilBlockEntity)class_25862) : null;
        }

        @Override
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new TwilightAnvilBlockEntity(pos, state);
        }

        public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TwilightAnvilBlockEntity) {
                TwilightAnvilBlockEntity anvil = (TwilightAnvilBlockEntity)entity;
                TwilightAnvilBlock.initializeArcanaBlock(stack, anvil);
            }
        }
    }

    public class TwilightAnvilItem
    extends ArcanaPolymerBlockItem {
        public TwilightAnvilItem(class_2248 block) {
            super(TwilightAnvil.this.getThis(), block, TwilightAnvil.this.getArcanaItemComponents());
        }

        public class_1799 method_7854() {
            return TwilightAnvil.this.prefItem;
        }
    }
}

