/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.bosses.dragon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.borisshoes.arcananovum.bosses.dragon.DragonBossFight;
import net.borisshoes.arcananovum.bosses.dragon.DragonDialog;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.SpawnPile;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1513;
import net.minecraft.class_1521;
import net.minecraft.class_1526;
import net.minecraft.class_1527;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1670;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.server.MinecraftServer;

public class DragonAbilities {
    private final int swoopCD = 900;
    private final int gustCD = 600;
    private final int overloadCD = 1800;
    private final int ampCD = 900;
    private final int conscriptCD = 4800;
    private final int bombardCD = 900;
    private final int obliterateCD = 2400;
    private final int resilienceCD = 5000;
    private final int corruptArcanaCD = 1200;
    private int swoopTicks;
    private int gustTicks;
    private int overloadTicks;
    private int ampTicks;
    private int conscriptTicks;
    private int bombardTicks;
    private int obliterateTicks;
    private int resilienceTicks;
    private int corruptArcanaTicks;
    private final MinecraftServer server;
    private final class_3218 endWorld;
    private final class_1510 dragon;
    private final class_1526 manager;
    private final List<class_1511> crystals;

    public DragonAbilities(MinecraftServer server, class_3218 endWorld, class_1510 dragon, List<class_1511> crystals) {
        this.server = server;
        this.endWorld = endWorld;
        this.dragon = dragon;
        this.manager = dragon.method_6831();
        this.crystals = crystals;
        this.swoopTicks = 900;
        this.gustTicks = 600;
        this.overloadTicks = 1800;
        this.ampTicks = 900;
        this.conscriptTicks = 4800;
        this.bombardTicks = 900;
        this.obliterateTicks = 2400;
        this.resilienceTicks = 5000;
        this.corruptArcanaTicks = 1200;
    }

    public ArrayList<class_3545<DragonAbilityTypes, Integer>> getCooldowns(int phase) {
        ArrayList<class_3545<DragonAbilityTypes, Integer>> cooldowns = new ArrayList<class_3545<DragonAbilityTypes, Integer>>();
        if (phase == 1) {
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.SWOOPING_CHARGE, (Object)(900 - this.swoopTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.WING_GUST, (Object)(600 - this.gustTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.BOMBARDMENT, (Object)(900 - this.bombardTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.CORRUPT_ARCANA, (Object)(1200 - this.corruptArcanaTicks)));
        } else if (phase == 2) {
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.SWOOPING_CHARGE, (Object)(900 - this.swoopTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.WING_GUST, (Object)(600 - this.gustTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.OVERLOAD_CRYSTALS, (Object)(1800 - this.overloadTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.GRAVITY_AMP, (Object)(900 - this.ampTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.BOMBARDMENT, (Object)(900 - this.bombardTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.CORRUPT_ARCANA, (Object)(1200 - this.corruptArcanaTicks)));
        } else if (phase == 3) {
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.SWOOPING_CHARGE, (Object)(900 - this.swoopTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.WING_GUST, (Object)(600 - this.gustTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.CONSCRIPT_ARMY, (Object)(4800 - this.conscriptTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.BOMBARDMENT, (Object)(900 - this.bombardTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.OBLITERATE_TOWER, (Object)(2400 - this.obliterateTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.DRACONIC_RESILIENCE, (Object)(5000 - this.resilienceTicks)));
            cooldowns.add((class_3545<DragonAbilityTypes, Integer>)new class_3545((Object)DragonAbilityTypes.CORRUPT_ARCANA, (Object)(1200 - this.corruptArcanaTicks)));
        }
        return cooldowns;
    }

    public void tick() {
        if (this.swoopTicks < 900) {
            ++this.swoopTicks;
        }
        if (this.gustTicks < 600) {
            ++this.gustTicks;
        }
        if (this.overloadTicks < 1800) {
            ++this.overloadTicks;
        }
        if (this.ampTicks < 900) {
            ++this.ampTicks;
        }
        if (this.conscriptTicks < 4800) {
            ++this.conscriptTicks;
        }
        if (this.bombardTicks < 900) {
            ++this.bombardTicks;
        }
        if (this.obliterateTicks < 2400) {
            ++this.obliterateTicks;
        }
        if (this.resilienceTicks < 5000) {
            ++this.resilienceTicks;
        }
        if (this.corruptArcanaTicks < 1200) {
            ++this.corruptArcanaTicks;
        }
        if (this.overloadTicks < 400) {
            if (this.overloadTicks % 2 == 0) {
                for (class_1511 crystal : this.crystals) {
                    if (crystal == null || !crystal.method_5805()) continue;
                    this.endWorld.method_65096((class_2394)class_2398.field_22246, crystal.method_23317(), crystal.method_23318(), crystal.method_23321(), 25, 5.0, 5.0, 5.0, 0.0);
                }
            }
            if (this.overloadTicks % 10 == 0) {
                for (class_1511 crystal : this.crystals) {
                    if (crystal == null || !crystal.method_5805()) continue;
                    List nearbyPlayers = this.endWorld.method_18766(p -> p.method_5707(crystal.method_19538()) <= 25.0);
                    for (class_3222 player : nearbyPlayers) {
                        if (player.method_68878() || player.method_7325()) continue;
                        player.method_64397(this.endWorld, new class_1282(this.endWorld.method_48963().method_48831().method_48793(), (class_1297)this.dragon, (class_1297)this.dragon), 2.0f);
                    }
                }
            }
        }
        if (this.resilienceTicks < 100 && this.resilienceTicks % 10 == 0) {
            this.dragon.method_6025(this.dragon.method_6063() / 100.0f);
        }
        if (this.bombardTicks < 60 && this.bombardTicks % 5 == 0) {
            class_3222 randomPlayer;
            int attempts = 0;
            while ((randomPlayer = this.endWorld.method_18779()) != null && (randomPlayer.method_5858((class_1297)this.dragon) > 5625.0 || randomPlayer.method_68878() || randomPlayer.method_7325()) && ++attempts < 25) {
            }
            if (randomPlayer != null) {
                class_243 vec3d3 = this.dragon.method_5828(1.0f);
                double l = this.dragon.field_7017.method_23317() - vec3d3.field_1352 * 1.0;
                double m = this.dragon.field_7017.method_23323(0.5) + 0.5;
                double n = this.dragon.field_7017.method_23321() - vec3d3.field_1350 * 1.0;
                double o = randomPlayer.method_23317() - l;
                double p2 = randomPlayer.method_23323(0.5) - m;
                double q = randomPlayer.method_23321() - n;
                if (!this.dragon.method_5701()) {
                    this.dragon.method_37908().method_8444((class_1297)((class_1657)null), 1017, this.dragon.method_24515(), 0);
                }
                class_1670 dragonFireballEntity = new class_1670(this.dragon.method_37908(), (class_1309)this.dragon, new class_243(o, p2, q));
                dragonFireballEntity.method_5808(l, m, n, 0.0f, 0.0f);
                this.dragon.method_37908().method_8649((class_1297)dragonFireballEntity);
            }
        }
        if (this.corruptArcanaTicks < 200 && this.corruptArcanaTicks % 20 == 0) {
            List nearbyPlayers300 = this.endWorld.method_18766(p -> p.method_5707(new class_243(0.0, 100.0, 0.0)) <= 90000.0);
            for (class_3222 player : nearbyPlayers300) {
                float damage = (float)ArcanaItemUtils.getUsedConcentration(player) / 12.0f * (player.method_6063() / 20.0f);
                if (player.method_68878() || player.method_7325() || (double)damage < 0.1) continue;
                player.method_64397(this.endWorld, new class_1282(this.endWorld.method_48963().method_48831().method_48793(), (class_1297)this.dragon, (class_1297)this.dragon), damage);
                player.method_7353((class_2561)class_2561.method_43470((String)"Your Arcana Items surge with corrupted Arcana!").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14545, (float)2.0f, (float)0.1f);
            }
        }
    }

    public void resetCooldowns() {
        this.swoopTicks = 900;
        this.gustTicks = 600;
        this.overloadTicks = 1800;
        this.ampTicks = 900;
        this.conscriptTicks = 4800;
        this.bombardTicks = 900;
        this.obliterateTicks = 2400;
        this.resilienceTicks = 5000;
        this.corruptArcanaTicks = 1200;
    }

    /*
     * WARNING - void declaration
     */
    public boolean doAbility(int phase) {
        class_1527 phaseType = this.manager.method_6864().method_6849();
        HashMap<DragonAbilityTypes, Integer> actions = new HashMap<DragonAbilityTypes, Integer>();
        List nearbyPlayers300 = this.endWorld.method_18766(p -> p.method_5707(new class_243(0.0, 100.0, 0.0)) <= 90000.0);
        if (phase == 1) {
            if (phaseType == class_1527.field_7069) {
                actions.put(DragonAbilityTypes.SWOOPING_CHARGE, 2);
            }
            if (phaseType == class_1527.field_7073 || phaseType == class_1527.field_7081) {
                actions.put(DragonAbilityTypes.WING_GUST, 5);
            }
            actions.put(DragonAbilityTypes.BOMBARDMENT, 5);
            actions.put(DragonAbilityTypes.CORRUPT_ARCANA, 5);
        } else if (phase == 2) {
            if (phaseType == class_1527.field_7069) {
                actions.put(DragonAbilityTypes.SWOOPING_CHARGE, 2);
            }
            if (phaseType == class_1527.field_7073 || phaseType == class_1527.field_7081) {
                actions.put(DragonAbilityTypes.WING_GUST, 5);
            }
            actions.put(DragonAbilityTypes.BOMBARDMENT, 8);
            actions.put(DragonAbilityTypes.CORRUPT_ARCANA, 5);
            int aerialCount = 0;
            for (Object player : nearbyPlayers300) {
                if (player.method_68878() || player.method_7325() || player.method_6112(class_1294.field_5902) == null && player.method_6112(class_1294.field_5913) == null) continue;
                ++aerialCount;
            }
            if (aerialCount != 0) {
                actions.put(DragonAbilityTypes.GRAVITY_AMP, aerialCount * 5);
            }
            int crystalPlayerCount = 0;
            for (class_1511 class_15112 : this.crystals) {
                if (class_15112 == null || !class_15112.method_5805()) continue;
                List nearbyPlayers = this.endWorld.method_18766(p -> p.method_5707(crystal.method_19538()) <= 36.0);
                crystalPlayerCount += nearbyPlayers.size();
            }
            if (crystalPlayerCount != 0) {
                actions.put(DragonAbilityTypes.OVERLOAD_CRYSTALS, crystalPlayerCount * 3);
            }
        } else if (phase == 3) {
            int healthCount;
            if (phaseType == class_1527.field_7069) {
                actions.put(DragonAbilityTypes.SWOOPING_CHARGE, 2);
            }
            if (phaseType == class_1527.field_7073 || phaseType == class_1527.field_7081) {
                actions.put(DragonAbilityTypes.WING_GUST, 5);
            }
            actions.put(DragonAbilityTypes.BOMBARDMENT, 8);
            actions.put(DragonAbilityTypes.CONSCRIPT_ARMY, 5);
            actions.put(DragonAbilityTypes.CORRUPT_ARCANA, 5);
            List<DragonBossFight.ReclaimState> reclaimStates = DragonBossFight.getReclaimStates();
            if (reclaimStates != null) {
                int count = 0;
                for (DragonBossFight.ReclaimState reclaimState : reclaimStates) {
                    if (reclaimState.getState() != 2) continue;
                    ++count;
                }
                actions.put(DragonAbilityTypes.OBLITERATE_TOWER, 20 * count);
            }
            if ((healthCount = 30 - (int)(30.0f * this.dragon.method_6032() / this.dragon.method_6063())) != 0) {
                actions.put(DragonAbilityTypes.DRACONIC_RESILIENCE, healthCount);
            }
        }
        DragonAbilityTypes ability = this.rollAbility(actions);
        if (ability == null) {
            return false;
        }
        if (ability == DragonAbilityTypes.SWOOPING_CHARGE) {
            class_1521 class_15212;
            this.manager.method_6863(class_1527.field_7078);
            class_1657 player = this.endWorld.method_18460((class_1297)this.dragon, 75.0);
            if (player != null && (class_15212 = this.manager.method_6864()) instanceof class_1513) {
                class_1513 charge = (class_1513)class_15212;
                charge.method_6840(player.method_19538());
                this.swoopTicks = 0;
                return true;
            }
            this.swoopTicks = 450;
            return false;
        }
        if (ability == DragonAbilityTypes.WING_GUST) {
            class_243 pos = this.dragon.method_19538();
            SoundUtils.playSound((class_1937)this.endWorld, (class_2338)this.dragon.method_24515(), (class_3414)class_3417.field_14550, (class_3419)class_3419.field_15251, (float)1.0f, (float)0.5f);
            List nearbyPlayers = this.endWorld.method_18766(p -> p.method_5707(pos) <= 100.0);
            for (class_3222 player : nearbyPlayers) {
                if (player.method_68878() || player.method_7325()) continue;
                class_2338 target = class_2338.method_49637((double)(pos.method_10216() + 0.5), (double)(pos.method_10214() - 1.0), (double)(pos.method_10215() + 0.5));
                class_2338 playerPos = player.method_24515();
                class_243 vec = new class_243((double)(target.method_10263() - playerPos.method_10263()), 0.0, (double)(target.method_10260() - playerPos.method_10260()));
                vec = vec.method_1029().method_1021(3.0);
                player.method_18800(-vec.field_1352, 1.0, -vec.field_1350);
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                player.method_7353((class_2561)class_2561.method_43470((String)"The Dragon's Wings Knock You Away!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}), true);
            }
            this.gustTicks = 0;
        } else if (ability == DragonAbilityTypes.OVERLOAD_CRYSTALS) {
            this.overloadTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_OVERLOAD_CRYSTALS, this.server, null);
        } else if (ability == DragonAbilityTypes.GRAVITY_AMP) {
            for (Object player : nearbyPlayers300) {
                if (player.method_68878() || player.method_7325()) continue;
                class_243 class_2432 = player.method_18798();
                player.method_18800(class_2432.field_1352, -3.0, class_2432.field_1350);
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                int dist = player.method_31478() - SpawnPile.getSurfaceY((class_1922)this.endWorld, player.method_31478(), player.method_31477(), player.method_31479());
                player.method_64397(this.endWorld, this.endWorld.method_48963().method_48827(), (float)dist * 0.25f);
            }
            this.ampTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_GRAVITY_AMP, this.server, null);
        } else if (ability == DragonAbilityTypes.CONSCRIPT_ARMY) {
            void var8_25;
            class_1560[] goons = new class_1560[25];
            ArrayList<class_2338> poses = SpawnPile.makeSpawnLocations(goons.length, 50, this.endWorld);
            boolean bl = false;
            while (var8_25 < goons.length) {
                goons[var8_25] = new class_1560(class_1299.field_6091, (class_1937)this.endWorld);
                goons[var8_25].method_5996(class_5134.field_23716).method_6192((double)class_3532.method_15340((int)(20 + 4 * nearbyPlayers300.size()), (int)40, (int)100));
                goons[var8_25].method_6033((float)class_3532.method_15340((int)(20 + 4 * nearbyPlayers300.size()), (int)40, (int)100));
                goons[var8_25].method_5996(class_5134.field_23721).method_6192(8.0);
                class_2338 pos = poses.get((int)var8_25);
                goons[var8_25].method_23327((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                this.endWorld.method_30771((class_1297)goons[var8_25]);
                ++var8_25;
            }
            List list = this.endWorld.method_18023((class_5575)class_1299.field_6091, new class_238(new class_2338(-300, 25, -300).method_46558(), new class_2338(300, 115, 300).method_46558()), e -> true);
            for (class_1560 enderman : list) {
                class_1657 closestPlayer = this.endWorld.method_18460((class_1297)enderman, 30.0);
                if (closestPlayer != null) {
                    if (closestPlayer.method_68878() || closestPlayer.method_7325()) continue;
                    enderman.method_22331();
                    enderman.method_5980((class_1309)closestPlayer);
                    enderman.method_29513(closestPlayer.method_5667());
                    enderman.method_29514(1200);
                    continue;
                }
                class_3222 randomPlayer = this.endWorld.method_18779();
                if (randomPlayer == null || randomPlayer.method_68878() || randomPlayer.method_7325()) continue;
                enderman.method_22331();
                enderman.method_5980((class_1309)randomPlayer);
                enderman.method_29513(randomPlayer.method_5667());
                enderman.method_29514(1200);
            }
            this.conscriptTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_CONSCRIPT_ARMY, this.server, null);
        } else if (ability == DragonAbilityTypes.BOMBARDMENT) {
            this.bombardTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_BOMBARDMENT, this.server, null);
        } else if (ability == DragonAbilityTypes.CORRUPT_ARCANA) {
            this.corruptArcanaTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_CORRUPT_ARCANA, this.server, null);
            for (Object player : nearbyPlayers300) {
                if (player.method_68878() || player.method_7325()) continue;
                class_1661 class_16612 = player.method_31548();
                class_1796 manager = player.method_7357();
                for (int i = 0; i < class_16612.method_5439(); ++i) {
                    class_1799 item = class_16612.method_5438(i);
                    if (item.method_7960() || !ArcanaItemUtils.isArcane(item) || manager.method_7904(item)) continue;
                    manager.method_62835(item, 200);
                }
            }
        } else if (ability == DragonAbilityTypes.OBLITERATE_TOWER) {
            List<DragonBossFight.ReclaimState> reclaimStates = DragonBossFight.getReclaimStates();
            if (reclaimStates != null) {
                for (DragonBossFight.ReclaimState reclaimState : reclaimStates) {
                    if (reclaimState.getState() != 2) continue;
                    reclaimState.destroyTower();
                }
            }
            this.obliterateTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_OBLITERATE_TOWER, this.server, null);
        } else if (ability == DragonAbilityTypes.DRACONIC_RESILIENCE) {
            this.resilienceTicks = 0;
            DragonDialog.announce(DragonDialog.Announcements.ABILITY_DRACONIC_RESILIENCE, this.server, null);
        }
        return true;
    }

    public DragonAbilityTypes rollAbility(HashMap<DragonAbilityTypes, Integer> actions) {
        ArrayList<DragonAbilityTypes> abilityPool = new ArrayList<DragonAbilityTypes>();
        for (Map.Entry<DragonAbilityTypes, Integer> action : actions.entrySet()) {
            DragonAbilityTypes act = action.getKey();
            int prio = action.getValue();
            if (this.onCD(act)) continue;
            for (int i = 0; i < prio; ++i) {
                abilityPool.add(act);
            }
        }
        if (abilityPool.size() == 0) {
            return null;
        }
        return (DragonAbilityTypes)((Object)abilityPool.get((int)(Math.random() * (double)abilityPool.size())));
    }

    private boolean onCD(DragonAbilityTypes action) {
        if (action == DragonAbilityTypes.SWOOPING_CHARGE) {
            return this.swoopTicks < 900;
        }
        if (action == DragonAbilityTypes.WING_GUST) {
            return this.gustTicks < 600;
        }
        if (action == DragonAbilityTypes.OVERLOAD_CRYSTALS) {
            return this.overloadTicks < 1800;
        }
        if (action == DragonAbilityTypes.GRAVITY_AMP) {
            return this.ampTicks < 900;
        }
        if (action == DragonAbilityTypes.CONSCRIPT_ARMY) {
            return this.conscriptTicks < 4800;
        }
        if (action == DragonAbilityTypes.BOMBARDMENT) {
            return this.bombardTicks < 900;
        }
        if (action == DragonAbilityTypes.CORRUPT_ARCANA) {
            return this.corruptArcanaTicks < 1200;
        }
        if (action == DragonAbilityTypes.OBLITERATE_TOWER) {
            return this.obliterateTicks < 2400;
        }
        if (action == DragonAbilityTypes.DRACONIC_RESILIENCE) {
            return this.resilienceTicks < 5000;
        }
        return true;
    }

    public static enum DragonAbilityTypes {
        SWOOPING_CHARGE,
        WING_GUST,
        OVERLOAD_CRYSTALS,
        GRAVITY_AMP,
        CONSCRIPT_ARMY,
        BOMBARDMENT,
        OBLITERATE_TOWER,
        DRACONIC_RESILIENCE,
        CORRUPT_ARCANA;


        public static DragonAbilityTypes fromLabel(String id) {
            return DragonAbilityTypes.valueOf(id.toUpperCase(Locale.ROOT));
        }
    }
}

