/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.callbacks.login;

import java.util.ArrayList;
import java.util.Arrays;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.callbacks.LoginCallback;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class AchievementLoginCallback
extends LoginCallback {
    private ArrayList<ArcanaAchievement> achievements;

    public AchievementLoginCallback() {
        super(class_2960.method_60655((String)"arcananovum", (String)"achievement_login_callback"));
    }

    public AchievementLoginCallback(MinecraftServer server, String player, ArcanaAchievement ... achievements) {
        this();
        this.world = server.method_3847(class_3218.field_25179);
        this.playerUUID = player;
        this.achievements = new ArrayList<ArcanaAchievement>(Arrays.stream(achievements).toList());
    }

    public boolean combineCallbacks(LoginCallback callback) {
        if (callback instanceof AchievementLoginCallback) {
            AchievementLoginCallback newCallback = (AchievementLoginCallback)callback;
            this.achievements.addAll(newCallback.achievements.stream().filter(a -> !this.achievements.contains(a)).toList());
            return true;
        }
        return false;
    }

    public boolean canCombine(LoginCallback loginCallback) {
        return true;
    }

    public void onLogin(class_3244 netHandler, MinecraftServer server) {
        class_3222 player = netHandler.field_14140;
        if (player.method_5845().equals(this.playerUUID)) {
            BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(100, () -> {
                for (ArcanaAchievement achievement : this.achievements) {
                    ArcanaAchievements.grant(player, achievement.id);
                }
            }));
        }
    }

    public void setData(class_2487 data) {
        this.data = data;
        this.achievements = new ArrayList();
        if (data.method_10545("achievements")) {
            class_2499 achTag = data.method_68569("achievements");
            for (class_2520 e : achTag) {
                class_2519 nbtS = (class_2519)e;
                ArcanaAchievement ach = ArcanaAchievements.registry.get(nbtS.method_68658().orElse(""));
                if (ach == null) continue;
                this.achievements.add(ach);
            }
        }
    }

    public class_2487 getData() {
        class_2487 data = new class_2487();
        class_2499 achTag = new class_2499();
        for (ArcanaAchievement achievement : this.achievements) {
            achTag.add((Object)class_2519.method_23256((String)achievement.id));
        }
        data.method_10566("achievements", (class_2520)achTag);
        this.data = data;
        return this.data;
    }

    public LoginCallback makeNew() {
        return new AchievementLoginCallback();
    }
}

