/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.cardinalcomponents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievement;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.items.BinaryBlades;
import net.borisshoes.arcananovum.research.ResearchTask;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.utils.CodecUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class ArcanaProfileComponent
implements IArcanaProfileComponent {
    public static final String ADMIN_SKILL_POINTS_TAG = "adminSkillPoints";
    public static final String CONCENTRATION_TICK_TAG = "concentration";
    private final class_1657 player;
    private final List<String> crafted = new ArrayList<String>();
    private final List<String> researchedItems = new ArrayList<String>();
    private final List<String> researchTasks = new ArrayList<String>();
    private final HashMap<String, class_2520> miscData = new HashMap();
    private final HashMap<ArcanaAugment, Integer> augments = new HashMap();
    private final HashMap<String, List<ArcanaAchievement>> achievements = new HashMap();
    private int level;
    private int xp;
    private class_1799 storedOffhand = class_1799.field_8037;

    public ArcanaProfileComponent(class_1657 player) {
        this.player = player;
    }

    public void readData(class_11368 readView) {
        this.crafted.clear();
        this.miscData.clear();
        this.achievements.clear();
        this.augments.clear();
        this.researchedItems.clear();
        this.researchTasks.clear();
        readView.method_71426("crafted", CodecUtils.STRING_LIST).ifPresent(this.crafted::addAll);
        readView.method_71426("researchedItems", CodecUtils.STRING_LIST).ifPresent(this.researchedItems::addAll);
        readView.method_71426("researchTasks", CodecUtils.STRING_LIST).ifPresent(this.researchTasks::addAll);
        class_2487 miscDataTag = readView.method_71426("miscData", class_2487.field_25128).orElse(new class_2487());
        Set keys = miscDataTag.method_10541();
        keys.forEach(key -> this.miscData.put((String)key, miscDataTag.method_10580(key)));
        this.level = readView.method_71424("level", 0);
        this.xp = readView.method_71424("xp", 0);
        class_2487 achievementsTag = readView.method_71426("achievements", class_2487.field_25128).orElse(new class_2487());
        Set achieveItemKeys = achievementsTag.method_10541();
        for (String itemKey : achieveItemKeys) {
            ArrayList<ArcanaAchievement> itemAchs = new ArrayList<ArcanaAchievement>();
            class_2487 itemAchsTag = achievementsTag.method_68568(itemKey);
            for (String achieveKey : itemAchsTag.method_10541()) {
                class_2487 achTag = itemAchsTag.method_68568(achieveKey);
                ArcanaAchievement ach = ArcanaAchievements.registry.get(achieveKey);
                if (ach == null) continue;
                itemAchs.add(ach.makeNew().fromNbt(achieveKey, achTag));
            }
            this.achievements.put(itemKey, itemAchs);
        }
        class_2487 augmentsTag = readView.method_71426("augments", class_2487.field_25128).orElse(new class_2487());
        Set augmentKeys = augmentsTag.method_10541();
        for (String augmentKey : augmentKeys) {
            ArcanaAugment aug;
            int augmentLvl = augmentsTag.method_68083(augmentKey, 0);
            if (augmentLvl <= 0 || (aug = ArcanaAugments.registry.get(augmentKey)) == null) continue;
            this.augments.put(ArcanaAugments.registry.get(augmentKey), augmentLvl);
        }
        this.storedOffhand = readView.method_71426("storedOffhand", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    public void writeData(class_11372 writeView) {
        class_2487 miscDataTag = new class_2487();
        this.miscData.forEach((arg_0, arg_1) -> ((class_2487)miscDataTag).method_10566(arg_0, arg_1));
        writeView.method_71468("crafted", CodecUtils.STRING_LIST, this.crafted);
        writeView.method_71468("researchedItems", CodecUtils.STRING_LIST, this.researchedItems);
        writeView.method_71468("researchTasks", CodecUtils.STRING_LIST, this.researchTasks);
        writeView.method_71468("miscData", class_2487.field_25128, (Object)miscDataTag);
        writeView.method_71465("level", this.level);
        writeView.method_71465("xp", this.xp);
        class_2487 achievementsTag = new class_2487();
        for (Map.Entry<String, List<ArcanaAchievement>> entry : this.achievements.entrySet()) {
            String item = entry.getKey();
            List<ArcanaAchievement> itemAchs = entry.getValue();
            class_2487 itemAchsTag = new class_2487();
            for (ArcanaAchievement itemAch : itemAchs) {
                itemAchsTag.method_10566(itemAch.id, (class_2520)itemAch.toNbt());
            }
            achievementsTag.method_10566(item, (class_2520)itemAchsTag);
        }
        writeView.method_71468("achievements", class_2487.field_25128, (Object)achievementsTag);
        class_2487 augmentsTag = new class_2487();
        for (Map.Entry<ArcanaAugment, Integer> entry : this.augments.entrySet()) {
            augmentsTag.method_10569(entry.getKey().id, entry.getValue().intValue());
        }
        writeView.method_71468("augments", class_2487.field_25128, (Object)augmentsTag);
        if (this.storedOffhand == null) {
            this.storedOffhand = class_1799.field_8037;
        }
        if (!this.storedOffhand.method_7960()) {
            writeView.method_71468("storedOffhand", class_1799.field_24671, (Object)this.storedOffhand);
        }
    }

    @Override
    public List<String> getCrafted() {
        return this.crafted;
    }

    @Override
    public boolean hasCrafted(ArcanaItem arcanaItem) {
        return this.crafted.stream().anyMatch(s -> s.equals(arcanaItem.getId()));
    }

    @Override
    public boolean hasResearched(ArcanaItem arcanaItem) {
        return this.researchedItems.stream().anyMatch(s -> s.equals(arcanaItem.getId()));
    }

    @Override
    public List<String> getResearchedItems() {
        return this.researchedItems;
    }

    @Override
    public boolean completedResearchTask(String id) {
        return this.researchTasks.stream().anyMatch(s -> s.equals(id));
    }

    @Override
    public void setResearchTask(class_5321<ResearchTask> key, boolean acquired) {
        ResearchTask task = (ResearchTask)ResearchTasks.RESEARCH_TASKS.method_29107(key);
        if (task == null) {
            return;
        }
        String id = task.getId();
        if (acquired) {
            if (this.researchTasks.stream().noneMatch(s -> s.equals(id))) {
                this.researchTasks.add(id);
            }
        } else {
            this.researchTasks.removeIf(s -> s.equals(id));
        }
    }

    @Override
    public class_2520 getMiscData(String id) {
        return this.miscData.get(id);
    }

    @Override
    public HashMap<String, List<ArcanaAchievement>> getAchievements() {
        return this.achievements;
    }

    @Override
    public HashMap<ArcanaAugment, Integer> getAugments() {
        return this.augments;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public int getAchievementSkillPoints() {
        int points = 0;
        for (Map.Entry<String, List<ArcanaAchievement>> entry : this.achievements.entrySet()) {
            List<ArcanaAchievement> achieves = entry.getValue();
            for (ArcanaAchievement achieve : achieves) {
                if (!achieve.isAcquired()) continue;
                points += achieve.pointsReward;
            }
        }
        return points;
    }

    @Override
    public int getBonusSkillPoints() {
        class_2497 pointsEle = (class_2497)this.getMiscData(ADMIN_SKILL_POINTS_TAG);
        return pointsEle == null ? 0 : pointsEle.method_10701();
    }

    @Override
    public int getTotalSkillPoints() {
        return this.getAchievementSkillPoints() + LevelUtils.getLevelSkillPoints(this.level) + this.getBonusSkillPoints();
    }

    @Override
    public int getSpentSkillPoints() {
        int spent = 0;
        ArrayList<ArcanaAugment> counted = new ArrayList<ArcanaAugment>();
        for (Map.Entry<ArcanaAugment, Integer> entry : this.augments.entrySet()) {
            ArcanaAugment augment = entry.getKey();
            if (counted.contains(augment)) continue;
            if (ArcanaAugments.linkedAugments.containsKey(augment)) {
                counted.addAll(ArcanaAugments.getLinkedAugments(augment.id));
            }
            ArcanaRarity[] tiers = augment.getTiers();
            for (int i = 0; i < entry.getValue(); ++i) {
                spent += tiers[i].rarity + 1;
            }
        }
        return spent;
    }

    @Override
    public boolean addXP(int xp) {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        if (this.getLevel() == 100 && this.xp + xp < 1000000000) {
            this.xp += xp;
            ArcanaNovum.PLAYER_XP_TRACKER.put(serverPlayer.method_5667(), this.xp);
            return true;
        }
        int newLevel = LevelUtils.levelFromXp(this.xp + xp);
        if (this.getLevel() != newLevel) {
            if (this.getLevel() / 5 < newLevel / 5) {
                MinecraftServer server = this.player.method_5682();
                ArrayList<class_5250> msgs = new ArrayList<class_5250>();
                if (server != null) {
                    if (newLevel / 5 * 5 == 100) {
                        class_5250 playerName = class_2561.method_43470((String)"").method_10852(this.player.method_5476()).method_27695(new class_124[]{class_124.field_1067, class_124.field_1073});
                        msgs.add(class_2561.method_43470((String)"=============================================").method_27695(new class_124[]{class_124.field_1067, class_124.field_1064}));
                        msgs.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"=== ").method_27695(new class_124[]{class_124.field_1051, class_124.field_1067, class_124.field_1074})).method_10852((class_2561)playerName).method_10852((class_2561)class_2561.method_43470((String)" has reached Arcana Level ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(newLevel / 5 * 5)).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)"!!!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)" ===").method_27695(new class_124[]{class_124.field_1051, class_124.field_1067, class_124.field_1074})));
                        msgs.add(class_2561.method_43470((String)"=============================================").method_27695(new class_124[]{class_124.field_1067, class_124.field_1064}));
                    } else {
                        class_5250 lvlUpMsg = class_2561.method_43470((String)"").method_10852(this.player.method_5476()).method_27692(class_124.field_1056).method_10852((class_2561)class_2561.method_43470((String)" has reached Arcana Level ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(newLevel / 5 * 5)).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067, class_124.field_1056, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)"!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}));
                        server.method_3760().method_43514((class_2561)lvlUpMsg, false);
                    }
                    if (ArcanaConfig.getBoolean(ArcanaRegistry.ANNOUNCE_ACHIEVEMENTS)) {
                        for (class_5250 msg : msgs) {
                            server.method_3760().method_43514((class_2561)msg, false);
                        }
                    } else {
                        for (class_5250 msg : msgs) {
                            this.player.method_7353((class_2561)msg, false);
                        }
                    }
                }
            }
            SoundUtils.playSongToPlayer((class_3222)serverPlayer, (class_3414)class_3417.field_15195, (float)0.5f, (float)1.5f);
            int resolve = this.getAugmentLevel(ArcanaAugments.RESOLVE.id);
            this.player.method_7353((class_2561)class_2561.method_43470((String)""), false);
            this.player.method_7353((class_2561)class_2561.method_43470((String)("Your Arcana has levelled up to level " + newLevel + "!")).method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), false);
            this.player.method_7353((class_2561)class_2561.method_43470((String)("Max Concentration increased to " + LevelUtils.concFromLevel(newLevel, resolve) + "!")).method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), false);
            this.player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        }
        this.xp += xp;
        this.level = newLevel;
        ArcanaNovum.PLAYER_XP_TRACKER.put(serverPlayer.method_5667(), this.xp);
        return true;
    }

    @Override
    public boolean setXP(int xp) {
        this.xp = xp;
        this.setLevel(LevelUtils.levelFromXp(this.xp));
        return true;
    }

    @Override
    public boolean setLevel(int lvl) {
        this.level = lvl;
        return true;
    }

    @Override
    public boolean addCraftedSilent(class_1799 stack) {
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
        if (arcanaItem == null) {
            return false;
        }
        String itemId = arcanaItem.getId();
        if (this.crafted.stream().anyMatch(i -> i.equalsIgnoreCase(itemId))) {
            return false;
        }
        this.addXP(ArcanaRarity.getFirstCraftXp(arcanaItem.getRarity()));
        return this.crafted.add(itemId);
    }

    @Override
    public boolean addCrafted(class_1799 stack) {
        MinecraftServer server;
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
        if (arcanaItem == null) {
            return false;
        }
        String itemId = arcanaItem.getId();
        if (this.crafted.stream().anyMatch(i -> i.equalsIgnoreCase(itemId))) {
            return false;
        }
        if (this.player instanceof class_3222 && (server = this.player.method_5682()) != null) {
            class_5250 newCraftMsg = class_2561.method_43470((String)"").method_10852(this.player.method_5476()).method_27692(class_124.field_1056).method_10852((class_2561)class_2561.method_43470((String)" has crafted their first ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056})).method_10852((class_2561)arcanaItem.getTranslatedName().method_27695(new class_124[]{class_124.field_1064, class_124.field_1067, class_124.field_1056, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)"!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1056}));
            server.method_3760().method_43514((class_2561)newCraftMsg.method_27694(s -> s.method_10949((class_2568)new class_2568.class_10612(stack))), false);
        }
        this.addXP(ArcanaRarity.getFirstCraftXp(arcanaItem.getRarity()));
        return this.crafted.add(itemId);
    }

    @Override
    public boolean setAchievement(String item, ArcanaAchievement achievement) {
        if (this.achievements.containsKey(item)) {
            itemAchs = this.achievements.get(item);
            boolean removed = itemAchs.removeIf(itemAch -> itemAch.id.equals(achievement.id));
            if (removed) {
                itemAchs.add(achievement);
                List<UUID> curList = ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.get(achievement.id);
                curList.removeIf(uuid -> uuid.equals(this.player.method_5667()));
                if (achievement.isAcquired()) {
                    curList.add(this.player.method_5667());
                }
                ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.put(achievement.id, curList);
                return false;
            }
            itemAchs.add(achievement);
        } else {
            itemAchs = new ArrayList<ArcanaAchievement>();
            itemAchs.add(achievement);
            this.achievements.put(item, itemAchs);
        }
        List<UUID> curList = ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.get(achievement.id);
        curList.removeIf(uuid -> uuid.equals(this.player.method_5667()));
        if (achievement.isAcquired()) {
            curList.add(this.player.method_5667());
        }
        ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.put(achievement.id, curList);
        return true;
    }

    @Override
    public boolean addResearchedItem(String item) {
        if (this.researchedItems.stream().anyMatch(i -> i.equalsIgnoreCase(item))) {
            return false;
        }
        return this.researchedItems.add(item);
    }

    @Override
    public boolean removeCrafted(String item) {
        if (this.crafted.stream().noneMatch(i -> i.equalsIgnoreCase(item))) {
            return false;
        }
        return this.crafted.removeIf(i -> i.equalsIgnoreCase(item));
    }

    @Override
    public boolean removeAchievement(String item, String achievementId) {
        boolean found = false;
        if (this.achievements.containsKey(item)) {
            List<ArcanaAchievement> itemAchs = this.achievements.get(item);
            for (ArcanaAchievement itemAch : itemAchs) {
                if (!itemAch.id.equals(achievementId)) continue;
                itemAchs.remove(itemAch);
                found = true;
                break;
            }
        }
        List<UUID> curList = ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.get(achievementId);
        curList.removeIf(uuid -> uuid.equals(this.player.method_5667()));
        ArcanaNovum.PLAYER_ACHIEVEMENT_TRACKER.put(achievementId, curList);
        return found;
    }

    @Override
    public boolean removeResearchedItem(String item) {
        if (this.researchedItems.stream().noneMatch(i -> i.equalsIgnoreCase(item))) {
            return false;
        }
        return this.researchedItems.removeIf(i -> i.equalsIgnoreCase(item));
    }

    @Override
    public void addMiscData(String id, class_2520 data) {
        this.miscData.put(id, data);
    }

    @Override
    public void removeMiscData(String id) {
        this.miscData.remove(id);
    }

    @Override
    public boolean hasAcheivement(String item, String achievementId) {
        if (this.achievements.containsKey(item)) {
            List<ArcanaAchievement> itemAchs = this.achievements.get(item);
            for (ArcanaAchievement itemAch : itemAchs) {
                if (!itemAch.id.equals(achievementId)) continue;
                return itemAch.isAcquired();
            }
        }
        return false;
    }

    @Override
    public ArcanaAchievement getAchievement(String item, String achievementId) {
        if (this.achievements.containsKey(item)) {
            List<ArcanaAchievement> itemAchs = this.achievements.get(item);
            for (ArcanaAchievement itemAch : itemAchs) {
                if (!itemAch.id.equals(achievementId)) continue;
                return itemAch;
            }
        }
        return null;
    }

    @Override
    public int totalAcquiredAchievements() {
        int count = 0;
        for (Map.Entry<String, List<ArcanaAchievement>> listEntry : this.achievements.entrySet()) {
            for (ArcanaAchievement ach : listEntry.getValue()) {
                if (!ach.isAcquired()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int getAugmentLevel(String id) {
        for (Map.Entry<ArcanaAugment, Integer> entry : this.augments.entrySet()) {
            if (!entry.getKey().id.equals(id)) continue;
            return entry.getValue();
        }
        return 0;
    }

    @Override
    public boolean setAugmentLevel(String id, int level) {
        ArcanaAugment baseAugment = ArcanaAugments.registry.get(id);
        if (baseAugment == null) {
            return false;
        }
        if (level < 0 || baseAugment.getTiers().length < level) {
            return false;
        }
        if (ArcanaAugments.linkedAugments.containsKey(baseAugment)) {
            return this.setLinkedAugmentLevel(id, level);
        }
        for (Map.Entry<ArcanaAugment, Integer> entry : this.augments.entrySet()) {
            if (!entry.getKey().id.equals(id)) continue;
            entry.setValue(level);
            return true;
        }
        this.augments.put(baseAugment, level);
        return false;
    }

    private boolean setLinkedAugmentLevel(String id, int level) {
        List<ArcanaAugment> linkedAugments = ArcanaAugments.getLinkedAugments(id);
        if (linkedAugments.isEmpty()) {
            return false;
        }
        boolean had = false;
        int[] levels = new int[linkedAugments.size()];
        block0: for (int i = 0; i < linkedAugments.size(); ++i) {
            ArcanaAugment augment = linkedAugments.get(i);
            levels[i] = this.getAugmentLevel(augment.id);
            if (levels[i] != 0) {
                had = true;
                for (Map.Entry<ArcanaAugment, Integer> entry : this.augments.entrySet()) {
                    if (!entry.getKey().id.equals(augment.id)) continue;
                    entry.setValue(level);
                    continue block0;
                }
                continue;
            }
            this.augments.put(augment, level);
        }
        return had;
    }

    @Override
    public boolean removeAugment(String id) {
        if (this.augments.entrySet().stream().noneMatch(e -> ((ArcanaAugment)e.getKey()).id.equals(id))) {
            return false;
        }
        return this.augments.entrySet().removeIf(e -> ((ArcanaAugment)e.getKey()).id.equals(id));
    }

    @Override
    public void removeAllAugments() {
        this.augments.clear();
    }

    @Override
    public int getArcanePaperRequirement(ArcanaRarity rarity) {
        int totalResearched = ArcanaItemUtils.countRarityInList(this.getResearchedItems(), rarity, false);
        return Math.min(64, (int)(0.025 * Math.pow(totalResearched, 2.5) + (double)totalResearched + 1.0));
    }

    @Override
    public boolean restoreOffhand() {
        if (this.storedOffhand == null) {
            this.storedOffhand = class_1799.field_8037;
        }
        if (this.storedOffhand.method_7960()) {
            return false;
        }
        class_1799 offHand = this.player.method_6079().method_7972();
        this.player.method_31548().method_5447(40, this.storedOffhand.method_51164());
        if (!offHand.method_7960() && !BinaryBlades.isFakeBlade(offHand)) {
            this.player.method_31548().method_7398(offHand);
        }
        return true;
    }

    @Override
    public boolean storeOffhand(class_1799 replacement) {
        if (this.storedOffhand == null) {
            this.storedOffhand = class_1799.field_8037;
        }
        if (!this.storedOffhand.method_7960()) {
            return false;
        }
        this.storedOffhand = this.player.method_6079();
        this.player.method_31548().method_5447(40, replacement);
        return true;
    }

    @Override
    public class_1799 getStoredOffhand() {
        return this.storedOffhand == null ? class_1799.field_8037 : this.storedOffhand;
    }
}

