/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.core;

import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularityBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public interface ArcanaBlockEntity {
    public static final String AUGMENT_TAG = "arcanaAugments";
    public static final String ARCANA_UUID_TAG = "arcanaUuid";
    public static final String CRAFTER_ID_TAG = "crafterId";
    public static final String CUSTOM_NAME = "customName";
    public static final String ORIGIN_TAG = "synthetic";

    public TreeMap<ArcanaAugment, Integer> getAugments();

    public String getCrafterId();

    public String getUuid();

    public int getOrigin();

    public String getCustomArcanaName();

    public void initialize(TreeMap<ArcanaAugment, Integer> var1, String var2, String var3, int var4, @Nullable String var5);

    public ArcanaItem getArcanaItem();

    default public boolean isAssembled() {
        return true;
    }

    public static class_1799 getBlockEntityAsItem(ArcanaBlockEntity arcanaBlockEntity, class_1937 world) {
        return ArcanaBlockEntity.getBlockEntityAsItem(arcanaBlockEntity, world, null);
    }

    public static class_1799 getBlockEntityAsItem(ArcanaBlockEntity arcanaBlockEntity, class_1937 world, @Nullable class_1799 stack) {
        String uuid = arcanaBlockEntity.getUuid();
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }
        class_2487 augmentsTag = new class_2487();
        if (arcanaBlockEntity.getAugments() != null) {
            for (Map.Entry<ArcanaAugment, Integer> entry : arcanaBlockEntity.getAugments().entrySet()) {
                augmentsTag.method_10569(entry.getKey().id, entry.getValue().intValue());
            }
        } else {
            augmentsTag = null;
        }
        ArcanaItem arcanaItem = arcanaBlockEntity.getArcanaItem();
        if (stack != null) {
            arcanaItem.initializeArcanaTag(stack, false);
        } else {
            stack = arcanaItem.getNewItem();
        }
        stack = arcanaItem.addCrafter(stack, arcanaBlockEntity.getCrafterId(), arcanaBlockEntity.getOrigin(), world.method_8503());
        if (augmentsTag != null) {
            ArcanaItem.putProperty(stack, "augments", (class_2520)augmentsTag);
        }
        ArcanaItem.putProperty(stack, "uuid", uuid);
        if (arcanaBlockEntity.getCustomArcanaName() != null && !arcanaBlockEntity.getCustomArcanaName().isEmpty()) {
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)arcanaBlockEntity.getCustomArcanaName()));
        }
        if (arcanaBlockEntity instanceof ArcaneSingularityBlockEntity) {
            ArcaneSingularityBlockEntity singularity = (ArcaneSingularityBlockEntity)arcanaBlockEntity;
            ArcanaItem.putProperty(stack, "books", (class_2520)singularity.saveBooks((class_7225.class_7874)world.method_30349()));
        }
        if (arcanaBlockEntity instanceof StarpathAltarBlockEntity) {
            StarpathAltarBlockEntity altar = (StarpathAltarBlockEntity)arcanaBlockEntity;
            ArcanaItem.putProperty(stack, "targets", (class_2520)altar.writeTargets());
        }
        if (arcanaBlockEntity instanceof StarlightForgeBlockEntity) {
            StarlightForgeBlockEntity forge = (StarlightForgeBlockEntity)arcanaBlockEntity;
            ArcanaItem.putProperty(stack, "seedUses", forge.getSeedUses());
        }
        arcanaItem.buildItemLore(stack, world.method_8503());
        return stack;
    }
}

