/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.core;

import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public enum ArcanaRarity {
    MUNDANE(0, "Mundane", "mundane"),
    EMPOWERED(1, "Empowered", "empowered"),
    EXOTIC(2, "Exotic", "exotic"),
    SOVEREIGN(3, "Sovereign", "sovereign"),
    DIVINE(4, "Divine", "divine");

    public final String label;
    public final int rarity;
    public final String id;

    private ArcanaRarity(int rarity, String label, String id) {
        this.label = label;
        this.rarity = rarity;
        this.id = id;
    }

    public String getTranslationKey() {
        return "rarity.arcananovum." + this.id;
    }

    public static ArcanaRarity rarityFromInt(int value) {
        for (ArcanaRarity arcanaRarity : ArcanaRarity.values()) {
            if (arcanaRarity.rarity != value) continue;
            return arcanaRarity;
        }
        return null;
    }

    public static class_2561 getColoredLabel(ArcanaRarity rarity, boolean bold) {
        class_5250 text = rarity == null ? class_2561.method_43470((String)"None").method_27692(class_124.field_1068) : class_2561.method_48321((String)rarity.getTranslationKey(), (String)rarity.label);
        if (bold) {
            text = text.method_27692(class_124.field_1067);
        }
        if (rarity == null) {
            return text;
        }
        return switch (rarity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> text.method_27692(class_124.field_1080);
            case 1 -> text.method_27692(class_124.field_1060);
            case 2 -> text.method_27692(class_124.field_1075);
            case 3 -> text.method_27692(class_124.field_1065);
            case 4 -> text.method_27692(class_124.field_1076);
        };
    }

    public static class_124 getColor(ArcanaRarity rarity) {
        if (rarity == null) {
            return null;
        }
        return switch (rarity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_124.field_1080;
            case 1 -> class_124.field_1060;
            case 2 -> class_124.field_1075;
            case 3 -> class_124.field_1065;
            case 4 -> class_124.field_1076;
        };
    }

    public static class_1792 getColoredConcrete(ArcanaRarity rarity) {
        if (rarity == null) {
            return class_1802.field_8704;
        }
        return switch (rarity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_1802.field_8735;
            case 1 -> class_1802.field_8839;
            case 2 -> class_1802.field_8364;
            case 3 -> class_1802.field_8771;
            case 4 -> class_1802.field_8508;
        };
    }

    public static ArcanaItem getAugmentCatalyst(ArcanaRarity rarity) {
        if (rarity == null) {
            return null;
        }
        return switch (rarity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ArcanaRegistry.MUNDANE_CATALYST;
            case 1 -> ArcanaRegistry.EMPOWERED_CATALYST;
            case 2 -> ArcanaRegistry.EXOTIC_CATALYST;
            case 3 -> ArcanaRegistry.SOVEREIGN_CATALYST;
            case 4 -> ArcanaRegistry.DIVINE_CATALYST;
        };
    }

    public static int getRarityInt(ArcanaRarity rarity) {
        return rarity.rarity;
    }

    public static int getConcentration(ArcanaRarity rarity) {
        return switch (rarity.ordinal()) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 5;
            case 3 -> 20;
            case 4 -> 0;
            default -> 0;
        };
    }

    public static int getFirstCraftXp(ArcanaRarity rarity) {
        switch (rarity.ordinal()) {
            case 0: {
                return 5000;
            }
            case 1: {
                return 10000;
            }
            case 2: {
                return 50000;
            }
            case 3: {
                return 100000;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public static int getCraftXp(ArcanaRarity rarity) {
        switch (rarity.ordinal()) {
            case 0: {
                return 1000;
            }
            case 1: {
                return 5000;
            }
            case 2: {
                return 10000;
            }
            case 3: {
                return 50000;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public static String getRarityLabel(ArcanaRarity rarity) {
        return rarity.label;
    }

    public static class_1792 getArcanePaper(ArcanaRarity rarity) {
        return switch (rarity.ordinal()) {
            case 0 -> ArcanaRegistry.MUNDANE_ARCANE_PAPER;
            case 1 -> ArcanaRegistry.EMPOWERED_ARCANE_PAPER;
            case 2 -> ArcanaRegistry.EXOTIC_ARCANE_PAPER;
            case 3 -> ArcanaRegistry.SOVEREIGN_ARCANE_PAPER;
            case 4 -> ArcanaRegistry.DIVINE_ARCANE_PAPER;
            default -> ArcanaRegistry.MUNDANE_ARCANE_PAPER;
        };
    }

    public static TomeGui.TomeFilter getTomeFilter(ArcanaRarity rarity) {
        return switch (rarity.ordinal()) {
            case 0 -> TomeGui.TomeFilter.MUNDANE;
            case 1 -> TomeGui.TomeFilter.EMPOWERED;
            case 2 -> TomeGui.TomeFilter.EXOTIC;
            case 3 -> TomeGui.TomeFilter.SOVEREIGN;
            case 4 -> TomeGui.TomeFilter.DIVINE;
            default -> TomeGui.TomeFilter.NONE;
        };
    }
}

