/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.core;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.BlockDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2510;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Multiblock {
    private final int[][][] statePattern;
    private final List<class_3545<class_2680, Predicate<class_2680>>> predicates;
    private static final HashMap<class_3222, List<HolderAttachment>> MULTIBLOCK_DISPLAYS = new HashMap();

    private Multiblock(int[][][] statePattern, List<class_3545<class_2680, Predicate<class_2680>>> predicates) {
        this.statePattern = statePattern;
        this.predicates = predicates;
    }

    public HashMap<class_1792, Integer> getMaterialList() {
        HashMap<class_1792, Integer> mats = new HashMap<class_1792, Integer>();
        int width = this.statePattern.length;
        int height = this.statePattern[0].length;
        int length = this.statePattern[0][0].length;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    class_3545<class_2680, Predicate<class_2680>> pair;
                    class_1792 item;
                    int pattern = this.statePattern[x][y][z];
                    if (pattern == -1 || (item = ((class_2680)(pair = this.predicates.get(pattern)).method_15442()).method_26204().method_8389()) == class_1802.field_8162) continue;
                    if (mats.containsKey(item)) {
                        mats.put(item, mats.get(item) + 1);
                        continue;
                    }
                    mats.put(item, 1);
                }
            }
        }
        return mats;
    }

    public void displayStructure(MultiblockCheck checkParams, class_3222 player) {
        List<Object> playerAttachments;
        if (checkParams == null) {
            return;
        }
        List<MultiblockCheckResult> incorrect = this.getIncorrect(checkParams);
        if (MULTIBLOCK_DISPLAYS.containsKey(player)) {
            playerAttachments = MULTIBLOCK_DISPLAYS.get(player);
            for (HolderAttachment holderAttachment : playerAttachments) {
                holderAttachment.holder().destroy();
            }
            playerAttachments.clear();
        } else {
            playerAttachments = new ArrayList();
        }
        for (MultiblockCheckResult multiblockCheckResult : incorrect) {
            class_2338 blockPos = multiblockCheckResult.pos();
            class_2680 blockState = multiblockCheckResult.displayState();
            BlockDisplayElement element = this.createEmptyElement();
            ElementHolder holder = this.createHolder(blockPos, checkParams.coreState(), checkParams.corePos(), multiblockCheckResult.predicate());
            HolderAttachment attachment = ChunkAttachment.ofTicking((ElementHolder)holder, (class_3218)checkParams.world(), (class_2338)blockPos);
            if (blockState.method_26215()) {
                element.setBlockState(class_2246.field_10033.method_9564());
            } else {
                element.setBlockState(blockState);
            }
            if (multiblockCheckResult.foundState().method_26215()) {
                element.setGlowColorOverride(0xFF55FF);
            } else {
                element.setGlowColorOverride(0xFF0000);
            }
            element.setGlowing(true);
            holder.addElement((VirtualElement)element);
            playerAttachments.add(attachment);
            for (class_3222 serverPlayer : player.method_5682().method_3760().method_14571()) {
                if (serverPlayer == player) continue;
                holder.stopWatching(serverPlayer);
                attachment.stopWatching(serverPlayer);
            }
        }
        MULTIBLOCK_DISPLAYS.put(player, playerAttachments);
    }

    public boolean matches(MultiblockCheck checkParams) {
        if (checkParams == null) {
            return false;
        }
        return this.getIncorrect(checkParams).isEmpty();
    }

    public List<MultiblockCheckResult> getIncorrect(MultiblockCheck checkParams) {
        if (checkParams == null) {
            return new ArrayList<MultiblockCheckResult>();
        }
        ArrayList<MultiblockCheckResult> incorrect = new ArrayList<MultiblockCheckResult>();
        int numRotations = this.calculateRotations(checkParams);
        int[][][] rotatedPattern = this.calculateRotated(numRotations);
        int width = rotatedPattern.length;
        int height = rotatedPattern[0].length;
        int length = rotatedPattern[0][0].length;
        class_2338 cornerOffset = checkParams.cornerOffset();
        class_2338 rotatedOffset = this.calculateRotOffset(numRotations, cornerOffset);
        class_2338 corner = checkParams.corePos().method_10081((class_2382)rotatedOffset);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int pattern = rotatedPattern[x][y][z];
                    if (pattern == -1) continue;
                    class_2338 pos = corner.method_10069(x, y, z);
                    class_2680 state = checkParams.world.method_8320(pos);
                    class_3545<class_2680, Predicate<class_2680>> pair = this.predicates.get(pattern);
                    class_2680 rotatedRawState = (class_2680)pair.method_15442();
                    for (int i = 0; i < numRotations; ++i) {
                        rotatedRawState = rotatedRawState.method_26186(class_2470.field_11465);
                    }
                    Predicate predicate = (Predicate)pair.method_15441();
                    Predicate<class_2680> rotatedPred = bs -> {
                        for (int i = 0; i < numRotations; ++i) {
                            bs = bs.method_26186(class_2470.field_11463);
                        }
                        return predicate.test(bs);
                    };
                    if (rotatedPred.test(state)) continue;
                    incorrect.add(new MultiblockCheckResult(checkParams.world(), rotatedRawState, state, rotatedPred, new class_2338((class_2382)pos)));
                }
            }
        }
        return incorrect;
    }

    private int calculateRotations(MultiblockCheck checkParams) {
        class_2350 direction = checkParams.direction();
        if (direction == null) {
            return 0;
        }
        class_2338 offset = checkParams.cornerOffset();
        class_2680 storedCore = (class_2680)this.predicates.get(this.statePattern[-offset.method_10263()][-offset.method_10264()][-offset.method_10260()]).method_15442();
        class_2350 storedDir = (class_2350)storedCore.method_11654((class_2769)class_2741.field_12481);
        int numRotations = 0;
        class_2350 testDir = storedDir;
        while (direction.method_10161() != testDir.method_10161()) {
            testDir = testDir.method_10160();
            ++numRotations;
        }
        return numRotations;
    }

    private int[][][] calculateRotated(int numRotations) {
        if (numRotations == 0) {
            return this.statePattern;
        }
        int[][][] rotatedPattern = this.statePattern;
        for (int i = 0; i < numRotations; ++i) {
            int M = rotatedPattern.length;
            int Y = rotatedPattern[0].length;
            int N = rotatedPattern[0][0].length;
            int[][][] ret = new int[N][Y][M];
            for (int y = 0; y < Y; ++y) {
                for (int r = 0; r < M; ++r) {
                    for (int c = 0; c < N; ++c) {
                        ret[c][y][M - 1 - r] = rotatedPattern[r][y][c];
                    }
                }
            }
            rotatedPattern = ret;
        }
        return rotatedPattern;
    }

    private class_2338 calculateRotOffset(int numRotations, class_2338 pos) {
        if (numRotations == 0) {
            return pos;
        }
        class_2338 newPos = pos.method_35830(-1);
        int M = this.statePattern.length;
        int N = this.statePattern[0][0].length;
        for (int i = 0; i < numRotations; ++i) {
            newPos = new class_2338(newPos.method_10260(), newPos.method_10264(), M - 1 - newPos.method_10263());
            int T = M;
            M = N;
            N = T;
        }
        return newPos.method_35830(-1);
    }

    public static Multiblock loadFromFile(String id) {
        return Multiblock.loadFromFile("arcananovum", id);
    }

    public static Multiblock loadFromFile(String namespace, String id) {
        try {
            Optional<Optional> pathOptional = FabricLoader.getInstance().getModContainer(namespace).map(container -> container.findPath("data/" + namespace + "/multiblocks/" + id + ".nbt"));
            if (pathOptional.isEmpty() || pathOptional.get().isEmpty()) {
                return null;
            }
            Path path = (Path)pathOptional.get().get();
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            class_2487 compound = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            if (compound == null) {
                return null;
            }
            class_2499 size = compound.method_68569("size");
            int sizeX = size.method_68576(0, 0);
            int sizeY = size.method_68576(1, 0);
            int sizeZ = size.method_68576(2, 0);
            int[][][] pattern = new int[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeY; ++j) {
                    for (int k = 0; k < sizeZ; ++k) {
                        pattern[i][j][k] = -1;
                    }
                }
            }
            class_2499 blocks = compound.method_68569("blocks");
            for (class_2520 b : blocks) {
                class_2487 block = (class_2487)b;
                class_2499 pos = block.method_68569("pos");
                pattern[pos.method_68576((int)0, (int)0)][pos.method_68576((int)1, (int)0)][pos.method_68576((int)2, (int)0)] = block.method_68083("state", 0);
            }
            class_2499 palette = compound.method_68569("palette");
            ArrayList<class_3545<class_2680, Predicate<class_2680>>> preds = new ArrayList<class_3545<class_2680, Predicate<class_2680>>>();
            for (class_2520 e : palette) {
                Predicate<class_2680> pred;
                class_2487 blockTag = (class_2487)e;
                String blockName = blockTag.method_68564("Name", "");
                class_2680 rawState = class_2512.method_10681((class_7871)class_7923.field_41175, (class_2487)blockTag);
                class_2960 identifier = class_2960.method_60654((String)blockName);
                Optional optional = class_7923.field_41175.method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier));
                if (optional.isEmpty()) {
                    pred = blockState -> true;
                    preds.add((class_3545<class_2680, Predicate<class_2680>>)new class_3545((Object)rawState, pred));
                    continue;
                }
                class_2248 block = (class_2248)((class_6880)optional.get()).comp_349();
                HashMap<class_2769, Comparable> blockProperties = new HashMap<class_2769, Comparable>();
                if (blockTag.method_10545("Properties")) {
                    class_2487 properties = blockTag.method_68568("Properties");
                    class_2689 stateManager = block.method_9595();
                    for (String key : properties.method_10541()) {
                        class_2769 p = stateManager.method_11663(key);
                        if (p == null) continue;
                        blockProperties.put(p, rawState.method_11654(p));
                    }
                }
                pred = state -> {
                    if (!state.method_27852(rawState.method_26204())) {
                        return false;
                    }
                    boolean stairExempt = false;
                    if (rawState.method_26204() instanceof class_2510 && blockProperties.containsKey(class_2510.field_11571) && blockProperties.containsKey(class_2510.field_11565)) {
                        class_2350 desiredDirection = (class_2350)rawState.method_11654((class_2769)class_2510.field_11571);
                        class_2778 desiredShape = (class_2778)rawState.method_11654((class_2769)class_2510.field_11565);
                        class_2350 stateDirection = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
                        class_2778 stateShape = (class_2778)state.method_11654((class_2769)class_2510.field_11565);
                        if (desiredShape.equals((Object)class_2778.field_12712) && stateShape.equals((Object)class_2778.field_12713) || desiredShape.equals((Object)class_2778.field_12708) && stateShape.equals((Object)class_2778.field_12709)) {
                            stairExempt = switch (desiredDirection) {
                                case class_2350.field_11043 -> stateDirection.equals((Object)class_2350.field_11039);
                                case class_2350.field_11035 -> stateDirection.equals((Object)class_2350.field_11034);
                                case class_2350.field_11034 -> stateDirection.equals((Object)class_2350.field_11043);
                                case class_2350.field_11039 -> stateDirection.equals((Object)class_2350.field_11035);
                                default -> false;
                            };
                        } else if (desiredShape.equals((Object)class_2778.field_12713) && stateShape.equals((Object)class_2778.field_12712) || desiredShape.equals((Object)class_2778.field_12709) && stateShape.equals((Object)class_2778.field_12708)) {
                            stairExempt = switch (desiredDirection) {
                                case class_2350.field_11039 -> stateDirection.equals((Object)class_2350.field_11043);
                                case class_2350.field_11034 -> stateDirection.equals((Object)class_2350.field_11035);
                                case class_2350.field_11043 -> stateDirection.equals((Object)class_2350.field_11034);
                                case class_2350.field_11035 -> stateDirection.equals((Object)class_2350.field_11039);
                                default -> false;
                            };
                        }
                    }
                    for (Map.Entry entry : blockProperties.entrySet()) {
                        if ((((class_2769)entry.getKey()).equals((Object)class_2510.field_11571) || ((class_2769)entry.getKey()).equals((Object)class_2510.field_11565)) && stairExempt || state.method_11654((class_2769)entry.getKey()).equals(entry.getValue())) continue;
                        return false;
                    }
                    return true;
                };
                preds.add((class_3545<class_2680, Predicate<class_2680>>)new class_3545((Object)rawState, pred));
            }
            return new Multiblock(pattern, preds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ElementHolder createHolder(final class_2338 pos, final class_2680 cs, final class_2338 cp, final Predicate<class_2680> p) {
        return new ElementHolder(this){
            int lifeTime = 600;
            final class_2680 coreState = cs;
            final class_2338 corePos = cp;
            final Predicate<class_2680> pred = p;

            public class_243 getPos() {
                return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            }

            protected void onTick() {
                super.onTick();
                if (this.lifeTime-- <= 0) {
                    this.destroy();
                    return;
                }
                if (this.getAttachment() != null && this.getAttachment().getWorld() != null) {
                    class_3218 world = this.getAttachment().getWorld();
                    if (!world.method_8320(this.corePos).method_27852(this.coreState.method_26204())) {
                        this.destroy();
                        return;
                    }
                    if (this.pred.test(world.method_8320(pos))) {
                        this.destroy();
                        return;
                    }
                    for (VirtualElement element : this.getElements()) {
                        if (!(element instanceof BlockDisplayElement)) continue;
                        BlockDisplayElement elem = (BlockDisplayElement)element;
                        if (world.method_8320(pos).method_26215()) {
                            elem.setGlowColorOverride(0xFF55FF);
                            continue;
                        }
                        elem.setGlowColorOverride(0xFF0000);
                    }
                }
            }
        };
    }

    public BlockDisplayElement createEmptyElement() {
        BlockDisplayElement element = new BlockDisplayElement();
        element.setScale((Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f));
        element.setOffset(new class_243(0.25, 0.25, 0.25));
        return element;
    }

    public record MultiblockCheck(class_3218 world, class_2338 corePos, class_2680 coreState, class_2338 cornerOffset, @Nullable class_2350 direction) {
        public MultiblockCheck(class_3218 world, class_2338 corePos, class_2680 coreState, class_2338 cornerOffset, @Nullable class_2350 direction) {
            Objects.requireNonNull(world);
            Objects.requireNonNull(corePos);
            Objects.requireNonNull(coreState);
            Objects.requireNonNull(cornerOffset);
        }
    }

    public record MultiblockCheckResult(class_3218 world, class_2680 displayState, class_2680 foundState, Predicate<class_2680> predicate, class_2338 pos) {
        public MultiblockCheckResult {
            Objects.requireNonNull(world);
            Objects.requireNonNull(displayState);
            Objects.requireNonNull(foundState);
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(pos);
        }
    }
}

