/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.entities;

import eu.pb4.polymer.core.api.entity.PolymerEntity;
import java.util.Collections;
import java.util.List;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.entities.NulConstructEntity;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1687;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class NulGuardianEntity
extends class_1639
implements PolymerEntity {
    private boolean mage;
    private NulConstructEntity construct;

    public NulGuardianEntity(class_1937 world, NulConstructEntity construct, boolean mage) {
        super(ArcanaRegistry.NUL_GUARDIAN_ENTITY, world);
        this.mage = mage;
        this.construct = construct;
    }

    public NulGuardianEntity(class_1299<? extends class_1639> entityType, class_1937 world) {
        super(entityType, world);
        this.mage = false;
        this.construct = null;
    }

    public boolean method_5973(class_1299<?> type) {
        boolean base = super.method_5973(type);
        if (type == ArcanaRegistry.NUL_GUARDIAN_ENTITY || type == ArcanaRegistry.NUL_CONSTRUCT_ENTITY) {
            return false;
        }
        return base;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 entityData2 = super.method_5943(world, difficulty, spawnReason, entityData);
        this.method_5996(class_5134.field_23721).method_6192(10.0);
        this.method_6997();
        this.method_5946(class_1304.field_6173, 0.0f);
        class_1293 res = new class_1293(class_1294.field_5907, -1, 1, false, false, false);
        this.method_6092(res);
        return entityData2;
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        if (this.mage) {
            class_1799 bowStack = new class_1799((class_1935)class_1802.field_8102);
            bowStack.method_57379(class_9334.field_54199, (Object)class_2960.method_60655((String)"arcananovum", (String)"nul_guardian_staff"));
            this.method_5673(class_1304.field_6173, bowStack);
        } else {
            class_1799 meleeStack = new class_1799((class_1935)class_1802.field_22025);
            float rand = this.field_5974.method_43057();
            if ((double)rand < 0.1) {
                meleeStack.method_57379(class_9334.field_54199, (Object)class_2960.method_60655((String)"arcananovum", (String)"nul_guardian_glaive"));
            } else if ((double)rand < 0.5) {
                meleeStack.method_57379(class_9334.field_54199, (Object)class_2960.method_60655((String)"arcananovum", (String)"nul_guardian_sword"));
            } else {
                meleeStack.method_57379(class_9334.field_54199, (Object)class_2960.method_60655((String)"arcananovum", (String)"nul_guardian_axe"));
            }
            this.method_5673(class_1304.field_6173, meleeStack);
        }
    }

    public void method_6078(class_1282 damageSource) {
        class_1937 class_19372;
        super.method_6078(damageSource);
        if (this.construct != null && this.mage && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ArcanaEffectUtils.trackedAnimatedLightningBolt((class_3218)serverWorld, () -> ((NulGuardianEntity)this).method_33571(), () -> ((NulConstructEntity)this.construct).method_33571(), (int)20, (double)1.0, (class_2394)class_2398.field_50250, (int)4, (int)1, (double)0.0, (double)0.0, (boolean)false, (int)0, (int)50);
            BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(50, () -> {
                if (this.construct != null && this.construct.method_5805()) {
                    this.construct.method_64397(serverWorld, ArcanaDamageTypes.of(this.method_37908(), ArcanaDamageTypes.CONCENTRATION, damageSource.method_5526(), damageSource.method_5529()), 35.0f);
                }
            }));
        }
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (this.construct != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (!this.construct.method_5805() || !this.construct.method_37908().method_27983().equals(this.method_37908().method_27983())) {
                this.method_5768(serverWorld);
            } else if (this.mage && this.field_6012 % 20 == 0 && (double)this.construct.method_5739((class_1297)this) < 64.0) {
                this.construct.method_6025(this.construct.isExalted() ? 2.0f : 5.0f);
                List entities = serverWorld.method_8333((class_1297)this, this.method_5829().method_1014(64.0), e -> !e.method_7325() && (double)e.method_5739((class_1297)this) < 16.0 && e instanceof NulGuardianEntity);
                Collections.shuffle(entities);
                for (class_1297 entity : entities) {
                    NulGuardianEntity otherGuardian = (NulGuardianEntity)entity;
                    otherGuardian.method_6025(otherGuardian.mage ? 1.0f : 2.0f);
                }
                if (this.field_6012 % 80 == 0) {
                    class_2390 dust = new class_2390(10357061, 0.8f);
                    ArcanaEffectUtils.trackedAnimatedLightningBolt((class_3218)serverWorld, () -> ((NulGuardianEntity)this).method_33571(), () -> ((NulConstructEntity)this.construct).method_33571(), (int)12, (double)0.5, (class_2394)dust, (int)8, (int)1, (double)0.0, (double)0.0, (boolean)false, (int)0, (int)60);
                    if (!entities.isEmpty()) {
                        ArcanaEffectUtils.trackedAnimatedLightningBolt((class_3218)serverWorld, () -> ((NulGuardianEntity)this).method_33571(), () -> ((class_1297)((class_1297)entities.getFirst())).method_33571(), (int)12, (double)0.5, (class_2394)dust, (int)8, (int)1, (double)0.0, (double)0.0, (boolean)false, (int)0, (int)60);
                    }
                }
            }
        }
    }

    protected float method_6036(class_1282 source, float amount) {
        float modified = super.method_6036(source, amount);
        if (source.method_5530() || source.method_48789(class_8103.field_42242)) {
            return modified;
        }
        if (this.construct != null && this.construct.isExalted()) {
            modified *= 0.75f;
        }
        if (source.method_48789(ArcanaRegistry.NUL_CONSTRUCT_VULNERABLE_TO)) {
            modified *= 2.0f;
        }
        if (source.method_49708(class_8111.field_42350) || source.method_49708(class_8111.field_42327) || source.method_49708(ArcanaDamageTypes.NUL)) {
            modified *= 0.0f;
        }
        if (source.method_48789(class_8103.field_42249)) {
            modified *= 0.5f;
        }
        if (source.method_48789(class_8103.field_42241)) {
            modified *= 0.85f;
        }
        return modified;
    }

    protected void method_5959() {
        this.field_6201.method_35113(g -> true);
        this.field_6185.method_35113(g -> true);
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (!this.method_5701()) {
            this.method_5783(class_3417.field_14588, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        }
        double eyeX = this.method_33571().field_1352;
        double eyeY = this.method_33571().field_1351;
        double eyeZ = this.method_33571().field_1350;
        double g = target.method_23317() - eyeX;
        double h = target.method_23323(0.34) - eyeY;
        double i = target.method_23321() - eyeZ;
        class_243 vec3d = new class_243(g, h, i);
        class_1687 witherSkullEntity = new class_1687(this.method_37908(), (class_1309)this, vec3d.method_1029());
        witherSkullEntity.method_7432((class_1297)this);
        if (this.construct != null && this.construct.isExalted()) {
            witherSkullEntity.method_7502(true);
        } else {
            witherSkullEntity.method_7502(this.field_5974.method_43057() < 0.34f);
        }
        witherSkullEntity.method_23327(eyeX, eyeY, eyeZ);
        this.method_37908().method_8649((class_1297)witherSkullEntity);
    }

    public static class_5132.class_5133 createGuardianAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23725, 4.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23718, 1.0);
    }

    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_6076;
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71472("mage", this.mage);
        if (this.construct != null) {
            view.method_71469("construct", this.construct.method_5845());
        }
    }

    protected void method_5749(class_11368 view) {
        class_3218 serverWorld;
        class_1297 class_12972;
        super.method_5749(view);
        this.mage = view.method_71433("mage", false);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (class_12972 = (serverWorld = (class_3218)class_19372).method_66347(AlgoUtils.getUUID((String)view.method_71428("construct", "")))) instanceof NulConstructEntity) {
            NulConstructEntity con;
            this.construct = con = (NulConstructEntity)class_12972;
        }
    }
}

