/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.function.Consumer;
import net.borisshoes.arcananovum.blocks.altars.StarpathAltarBlockEntity;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class StarpathTargetGui
extends AnvilInputGui {
    private final StarpathAltarBlockEntity blockEntity;
    private String text;
    private final boolean targetMode;
    private final SimpleGui returnGui;
    private final Consumer<Object> onCompletion;

    public StarpathTargetGui(class_3222 player, StarpathAltarBlockEntity blockEntity, boolean targetMode, SimpleGui returnGui, Consumer<Object> onCompletion) {
        super(player, false);
        this.blockEntity = blockEntity;
        this.targetMode = targetMode;
        this.returnGui = returnGui;
        this.onCompletion = onCompletion;
        this.setTitle((class_2561)class_2561.method_43470((String)(this.targetMode ? "Input Coordinates" : "Input Name")));
        if (targetMode) {
            GuiElementBuilder locationItem = new GuiElementBuilder(class_1802.field_8204).hideDefaultTooltip();
            locationItem.setName((class_2561)class_2561.method_43470((String)"Enter a Location").method_27692(class_124.field_1065));
            locationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Use format: x,y,z").method_27692(class_124.field_1054))));
            this.setSlot(0, (GuiElementBuilderInterface)locationItem);
        } else {
            GuiElementBuilder locationItem = new GuiElementBuilder(class_1802.field_8674).hideDefaultTooltip();
            locationItem.setName((class_2561)class_2561.method_43470((String)"Enter a Name").method_27692(class_124.field_1065));
            this.setSlot(0, (GuiElementBuilderInterface)locationItem);
        }
        this.setSlot(1, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)1704246)).hideTooltip());
    }

    private class_2338 parseValid() {
        String[] split = this.text.split(",");
        if (split.length != 3) {
            return null;
        }
        try {
            class_2338 target = new class_2338(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            if (this.blockEntity.method_10997() != null && this.blockEntity.method_10997().method_31606(target)) {
                return null;
            }
            return target;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (index == 2) {
            if (this.targetMode) {
                class_2338 parsed = this.parseValid();
                if (parsed == null) {
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                } else {
                    this.onCompletion.accept(parsed);
                    this.close();
                }
            } else {
                String trimmedName = this.text.trim();
                if (trimmedName.isBlank() || trimmedName.length() > 50) {
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                } else {
                    this.onCompletion.accept(trimmedName);
                    this.close();
                }
            }
        }
        return true;
    }

    public void onInput(String input) {
        this.text = input;
        if (this.targetMode) {
            class_2338 parsed = this.parseValid();
            if (parsed == null) {
                this.setSlot(2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CANCEL)).setName((class_2561)class_2561.method_43470((String)"Invalid Location").method_27692(class_124.field_1062)));
            } else {
                this.setSlot(2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CONFIRM)).hideDefaultTooltip().setName((class_2561)class_2561.method_43470((String)("Valid Location: " + parsed.method_23854())).method_27692(class_124.field_1062)));
            }
        } else {
            String trimmedName = this.text.trim();
            if (trimmedName.isBlank() || trimmedName.length() > 50) {
                this.setSlot(2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CANCEL)).setName((class_2561)class_2561.method_43470((String)"Invalid Name").method_27692(class_124.field_1062)));
            } else {
                this.setSlot(2, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CONFIRM)).setName((class_2561)class_2561.method_43470((String)("Valid Name: " + trimmedName)).method_27692(class_124.field_1062)));
            }
        }
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive()) {
            this.close();
        }
        super.onTick();
    }

    public void onClose() {
        if (this.returnGui != null) {
            this.returnGui.open();
        }
    }

    public void close() {
        super.close();
    }
}

