/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.StormcallerAltarBlockEntity;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9275;
import net.minecraft.class_9334;

public class StormcallerAltarGui
extends SimpleGui {
    private final StormcallerAltarBlockEntity blockEntity;
    private final boolean tempest;

    public StormcallerAltarGui(class_3222 player, StormcallerAltarBlockEntity blockEntity) {
        super(class_3917.field_17337, player, false);
        this.blockEntity = blockEntity;
        this.setTitle((class_2561)class_2561.method_43470((String)"Altar of the Stormcaller"));
        this.tempest = ArcanaAugments.getAugmentFromMap(blockEntity.getAugments(), ArcanaAugments.PERSISTENT_TEMPEST.id) >= 1;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        int duration = this.blockEntity.getDuration();
        int mode = this.blockEntity.getMode();
        if (index == 2 && this.tempest) {
            this.blockEntity.setDuration((duration + 1) % 16);
        } else if (index == 4) {
            if (type == ClickType.MOUSE_RIGHT || type == ClickType.MOUSE_RIGHT_SHIFT) {
                this.blockEntity.setMode((mode + 1) % 3);
            } else if (this.blockEntity.getCooldown() <= 0) {
                if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)((class_1792)StormcallerAltarBlockEntity.COST.method_15442()), (int)((Integer)StormcallerAltarBlockEntity.COST.method_15441()))) {
                    this.blockEntity.startWeatherChange(this.player);
                    this.close();
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)("You do not have " + String.valueOf(StormcallerAltarBlockEntity.COST.method_15441()) + " ")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)((class_1792)StormcallerAltarBlockEntity.COST.method_15442()).method_7876()).method_27695(new class_124[]{class_124.field_1075, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" to power the Altar").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056})), false);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                    this.close();
                }
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"The Altar is on Cooldown").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                this.close();
            }
        }
        return true;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled() || this.blockEntity.isActive()) {
            this.close();
        }
        this.build();
    }

    public void build() {
        int duration = this.blockEntity.getDuration();
        int mode = this.blockEntity.getMode();
        for (int i = 0; i < this.getSize(); ++i) {
            this.clearSlot(i);
            GuiElementBuilder menuItem = switch (mode) {
                case 1 -> GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)8951219));
                case 2 -> GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)5395041));
                default -> GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)0x1CFFFF));
            };
            this.setSlot(i, (GuiElementBuilderInterface)menuItem.setName((class_2561)class_2561.method_43470((String)"Altar of the Stormcaller").method_27692(class_124.field_1063)));
        }
        GuiElementBuilder cooldownItem = new GuiElementBuilder(class_1802.field_8557).hideDefaultTooltip();
        if (this.blockEntity.getCooldown() <= 0) {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Ready").method_27692(class_124.field_1075)));
        } else {
            cooldownItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Altar Recharging").method_27692(class_124.field_1063)));
            cooldownItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.blockEntity.getCooldown() / 20 + " Seconds")).method_27692(class_124.field_1080))));
        }
        this.setSlot(0, (GuiElementBuilderInterface)cooldownItem);
        class_1799 lightItem = new class_1799((class_1935)class_1802.field_30904);
        lightItem.method_57379(class_9334.field_49623, (Object)class_9275.field_49284.method_57420((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(duration)));
        GuiElementBuilder durationItem = GuiElementBuilder.from((class_1799)lightItem).hideDefaultTooltip();
        durationItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Weather Duration").method_27692(class_124.field_1054)));
        if (this.tempest) {
            int dur = switch (mode) {
                case 0 -> StormcallerAltarBlockEntity.DURATIONS[duration] * 3;
                case 1 -> StormcallerAltarBlockEntity.DURATIONS[duration];
                case 2 -> StormcallerAltarBlockEntity.DURATIONS[duration] / 2;
                default -> 0;
            };
            Object durStr = dur <= 0 ? "Random" : dur + " Minutes";
            durationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Current Duration: " + (String)durStr)).method_27692(class_124.field_1065))));
            durationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
            durationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to change duration").method_27692(class_124.field_1080))));
        } else {
            durationItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Unlock this ability with Augmentation").method_27692(class_124.field_1061))));
        }
        this.setSlot(2, (GuiElementBuilderInterface)durationItem);
        String modeString = switch (mode) {
            case 0 -> "Clear the Sky";
            case 1 -> "Condense the Moisture";
            case 2 -> "Charge the Clouds";
            default -> "-";
        };
        GuiElementBuilder activateItem = new GuiElementBuilder(class_1802.field_27051);
        activateItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Activate Altar").method_27692(class_124.field_1078)));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click to harness the clouds").method_27692(class_124.field_1065))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("Current Mode: " + modeString)).method_27692(class_124.field_1078))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click to switch modes").method_27692(class_124.field_1065))));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        activateItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("The Altar Requires " + String.valueOf(StormcallerAltarBlockEntity.COST.method_15441()) + " ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43471((String)((class_1792)StormcallerAltarBlockEntity.COST.method_15442()).method_7876()).method_27692(class_124.field_1075))));
        this.setSlot(4, (GuiElementBuilderInterface)activateItem);
    }

    public void close() {
        super.close();
    }
}

