/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.altars;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.Optional;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltar;
import net.borisshoes.arcananovum.blocks.altars.TransmutationAltarBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.AequalisScientia;
import net.borisshoes.arcananovum.recipes.transmutation.AequalisCatalystTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.AequalisSkillTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.AequalisUnattuneTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.CommutativeTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.InfusionTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.PermutationTransmutationRecipe;
import net.borisshoes.arcananovum.recipes.transmutation.TransmutationRecipe;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class TransmutationAltarRecipeGui
extends SimpleGui {
    private int page = 1;
    private int commiePage = 1;
    private int costMode;
    private String curRecipeName = "";
    private CommutativeTransmutationRecipe curRecipe = null;
    private final List<TransmutationRecipe> recipes;
    private final TransmutationAltarBlockEntity blockEntity;
    private final SimpleGui returnGui;
    private class_1799 selectionModeStack;

    public TransmutationAltarRecipeGui(class_3222 player, SimpleGui returnGui, Optional<TransmutationAltarBlockEntity> altarOpt) {
        super(class_3917.field_17327, player, false);
        this.recipes = TransmutationAltar.getUnlockedRecipes(player);
        this.blockEntity = altarOpt.orElse(null);
        this.returnGui = returnGui;
        this.costMode = this.blockEntity == null ? 0 : ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.HASTY_BARGAIN.id);
        this.setTitle((class_2561)class_2561.method_43470((String)"Transmutation Altar"));
    }

    public void enableSelectionMode(class_1799 stack) {
        this.selectionModeStack = stack;
        this.recipes.removeIf(recipe -> recipe instanceof AequalisCatalystTransmutationRecipe || recipe instanceof AequalisSkillTransmutationRecipe);
        if (stack.method_31574(ArcanaRegistry.AEQUALIS_SCIENTIA.getItem())) {
            this.costMode = -1;
        }
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean indexInCenter;
        boolean bl = indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
        if (this.curRecipe == null) {
            int numPages = (int)Math.ceil((double)this.recipes.size() / 28.0);
            if (index == 45) {
                if (this.page > 1) {
                    --this.page;
                    this.buildRecipeListGui();
                }
            } else if (index == 53) {
                if (this.page < numPages) {
                    ++this.page;
                    this.buildRecipeListGui();
                }
            } else if (indexInCenter) {
                ArcanaItem arcanaItem;
                int ind = 7 * (index / 9 - 1) + (index % 9 - 1) + 28 * (this.page - 1);
                List<TransmutationRecipe> pageRecipes = this.recipes;
                if (ind >= pageRecipes.size()) {
                    return true;
                }
                TransmutationRecipe recipe = pageRecipes.get(ind);
                if (this.selectionModeStack != null && (arcanaItem = ArcanaItemUtils.identifyItem(this.selectionModeStack)) instanceof AequalisScientia) {
                    AequalisScientia aq = (AequalisScientia)arcanaItem;
                    if (recipe.getName().equals("Aequalis Reconfiguration")) {
                        ArcanaAchievements.grant(this.player, ArcanaAchievements.FRACTAL_ATTUNEMENT);
                    }
                    ArcanaItem.putProperty(this.selectionModeStack, "transmutation_id", recipe.getName());
                    aq.buildItemLore(this.selectionModeStack, this.player.method_5682());
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_38365, (float)1.0f, (float)0.8f);
                    this.close();
                    return true;
                }
                if (!(recipe instanceof CommutativeTransmutationRecipe)) {
                    return true;
                }
                CommutativeTransmutationRecipe cr = (CommutativeTransmutationRecipe)recipe;
                this.curRecipe = cr;
                this.curRecipeName = cr.getName();
                this.buildRecipeViewGui(this.curRecipeName);
            } else if (index == 8) {
                int bargainTiers = ArcanaAugments.HASTY_BARGAIN.getTiers().length;
                this.costMode += type.isRight ? 0 : 2;
                if (this.costMode >= bargainTiers + 2) {
                    this.costMode = 0;
                }
                if (this.costMode < 0) {
                    this.costMode = bargainTiers + 1;
                }
                --this.costMode;
                this.buildRecipeListGui();
            }
        } else {
            List<class_1799> inputs = this.curRecipe.getCommunalInputs();
            int numPages = (int)Math.ceil((double)inputs.size() / 28.0);
            if (index == 49) {
                this.curRecipeName = "";
                this.curRecipe = null;
                this.buildRecipeListGui();
                this.commiePage = 1;
            } else if (index == 45) {
                if (this.commiePage > 1) {
                    --this.commiePage;
                    this.buildRecipeViewGui(this.curRecipeName);
                }
            } else if (index == 53) {
                if (this.commiePage < numPages) {
                    ++this.commiePage;
                    this.buildRecipeViewGui(this.curRecipeName);
                }
            } else if (index == 8) {
                int bargainTiers = ArcanaAugments.HASTY_BARGAIN.getTiers().length;
                this.costMode += type.isRight ? 0 : 2;
                if (this.costMode >= bargainTiers + 2) {
                    this.costMode = 0;
                }
                if (this.costMode < 0) {
                    this.costMode = bargainTiers + 1;
                }
                --this.costMode;
                this.buildRecipeViewGui(this.curRecipeName);
            }
        }
        return true;
    }

    public void buildRecipeListGui() {
        GuiElementBuilder costItem;
        GuiHelper.outlineGUI((SimpleGui)this, (int)51450, (class_2561)class_2561.method_43470((String)"Transmutation Recipes").method_27692(class_124.field_1078));
        List<TransmutationRecipe> pageRecipes = this.recipes;
        int numPages = (int)Math.ceil((double)pageRecipes.size() / 28.0);
        if (numPages > 1) {
            GuiElementBuilder nextArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW)).hideDefaultTooltip();
            nextArrow.setName((class_2561)class_2561.method_43470((String)("Next Page (" + this.page + "/" + numPages + ")")).method_27692(class_124.field_1065));
            nextArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Next Page").method_27692(class_124.field_1064))));
            this.setSlot(53, (GuiElementBuilderInterface)nextArrow);
            GuiElementBuilder prevArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip();
            prevArrow.setName((class_2561)class_2561.method_43470((String)("Previous Page (" + this.page + "/" + numPages + ")")).method_27692(class_124.field_1065));
            prevArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to go to the Previous Page").method_27692(class_124.field_1064))));
            this.setSlot(45, (GuiElementBuilderInterface)prevArrow);
        }
        if (this.costMode == -1) {
            costItem = GuiElementBuilder.from((class_1799)ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItemNoLore()).hideDefaultTooltip();
            costItem.setName((class_2561)class_2561.method_43470((String)"Cost Calculation Mode").method_27692(class_124.field_1062));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)ArcanaRegistry.AEQUALIS_SCIENTIA.getTranslatedName().method_27692(class_124.field_1075))));
            costItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to change cost calculation").method_27692(class_124.field_1078))));
        } else if (this.costMode == 0) {
            costItem = GuiElementBuilder.from((class_1799)new class_1799((class_1935)class_1802.field_8687)).hideDefaultTooltip();
            costItem.setName((class_2561)class_2561.method_43470((String)"Cost Calculation Mode").method_27692(class_124.field_1062));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Normal").method_27692(class_124.field_1060))));
            costItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to change cost calculation").method_27692(class_124.field_1078))));
        } else {
            costItem = GuiElementBuilder.from((class_1799)new class_1799((class_1935)class_1802.field_27063, this.costMode)).hideDefaultTooltip();
            costItem.setName((class_2561)class_2561.method_43470((String)"Cost Calculation Mode").method_27692(class_124.field_1062));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)ArcanaAugments.HASTY_BARGAIN.getTranslationKey()).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(" " + LevelUtils.intToRoman(this.costMode))).method_27692(class_124.field_1076))));
            costItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to change cost calculation").method_27692(class_124.field_1078))));
        }
        this.setSlot(8, (GuiElementBuilderInterface)costItem);
        int k = (this.page - 1) * 28;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < pageRecipes.size()) {
                    int reagent2Count;
                    int reagent1Count;
                    TransmutationRecipe recipe = pageRecipes.get(k);
                    GuiElementBuilder viewItem = GuiElementBuilder.from((class_1799)recipe.getViewStack()).hideDefaultTooltip();
                    viewItem.setName((class_2561)class_2561.method_43470((String)recipe.getName()).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
                    if (this.costMode == -1) {
                        reagent1Count = recipe.getAequalisReagent(recipe.getReagent1()).method_7947();
                        reagent2Count = recipe.getAequalisReagent(recipe.getReagent2()).method_7947();
                    } else {
                        reagent1Count = recipe.getBargainReagent(recipe.getReagent1(), this.costMode).method_7947();
                        reagent2Count = recipe.getBargainReagent(recipe.getReagent2(), this.costMode).method_7947();
                    }
                    if (recipe instanceof CommutativeTransmutationRecipe) {
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Commutative Transmutation").method_27692(class_124.field_1060)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent1().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent2().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to view full recipe").method_27692(class_124.field_1077))));
                    } else if (recipe instanceof InfusionTransmutationRecipe) {
                        InfusionTransmutationRecipe infusion = (InfusionTransmutationRecipe)recipe;
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Infusion Transmutation").method_27692(class_124.field_1064)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(infusion.getInput().method_7947() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)infusion.getInput().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Output: ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)(infusion.getOutput().method_7947() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)infusion.getOutput().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent1().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent2().method_7909().method_7876()).method_27692(class_124.field_1075))));
                    } else if (recipe instanceof PermutationTransmutationRecipe) {
                        PermutationTransmutationRecipe permutation = (PermutationTransmutationRecipe)recipe;
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Permutation Transmutation").method_27692(class_124.field_1062)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(permutation.getInput().method_7947() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)permutation.getInput().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Output: ").method_27692(class_124.field_1063)).method_10852(permutation.getOutputDescription()).method_27692(class_124.field_1075)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent1().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent2().method_7909().method_7876()).method_27692(class_124.field_1075))));
                    } else if (recipe instanceof AequalisUnattuneTransmutationRecipe) {
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Aequalis Transmutation").method_27692(class_124.field_1075)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"An Aequalis Scientia").method_27692(class_124.field_1064))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Output: ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"An Unattuned Aequalis Scientia").method_27692(class_124.field_1064))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent1().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent2().method_7909().method_7876()).method_27692(class_124.field_1075))));
                    } else if (recipe instanceof AequalisSkillTransmutationRecipe) {
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Aequalis Transmutation").method_27692(class_124.field_1075)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"An Arcana Item").method_27692(class_124.field_1064))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"An Arcana Item").method_27692(class_124.field_1064))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Your Aequalis Scientia").method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent1().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent2().method_7909().method_7876()).method_27692(class_124.field_1075))));
                    } else if (recipe instanceof AequalisCatalystTransmutationRecipe) {
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Aequalis Transmutation").method_27692(class_124.field_1075)));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"An Arcana Item").method_27692(class_124.field_1064))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"1-4 ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"Catalytic Matrices").method_27692(class_124.field_1054))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Your Aequalis Scientia").method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent1().method_7909().method_7876()).method_27692(class_124.field_1075))));
                        viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2Count + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)recipe.getReagent2().method_7909().method_7876()).method_27692(class_124.field_1075))));
                    }
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)viewItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"Transmutation Recipes"));
    }

    public void buildRecipeViewGui(String recipeName) {
        class_1799 reagent2;
        class_1799 reagent1;
        GuiElementBuilder costItem;
        this.curRecipeName = recipeName;
        GuiHelper.outlineGUI((SimpleGui)this, (int)51450, (class_2561)class_2561.method_43470((String)"Transmutation Recipes").method_27692(class_124.field_1078));
        for (TransmutationRecipe rec : this.recipes) {
            CommutativeTransmutationRecipe crec;
            if (!rec.getName().equals(recipeName) || !(rec instanceof CommutativeTransmutationRecipe)) continue;
            this.curRecipe = crec = (CommutativeTransmutationRecipe)rec;
            break;
        }
        if (this.curRecipe == null) {
            return;
        }
        List<class_1799> inputs = this.curRecipe.getCommunalInputs();
        int numPages = (int)Math.ceil((double)inputs.size() / 28.0);
        if (numPages > 1) {
            GuiElementBuilder nextArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW)).hideDefaultTooltip();
            nextArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Page").method_27692(class_124.field_1065)));
            nextArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.commiePage + " of " + numPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(53, (GuiElementBuilderInterface)nextArrow);
            GuiElementBuilder prevArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip();
            prevArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Prev Page").method_27692(class_124.field_1065)));
            prevArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.commiePage + " of " + numPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(45, (GuiElementBuilderInterface)prevArrow);
        }
        int k = (this.commiePage - 1) * 28;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < inputs.size()) {
                    class_1799 item = inputs.get(k);
                    GuiElementBuilder viewItem = GuiElementBuilder.from((class_1799)item).hideDefaultTooltip();
                    viewItem.setName((class_2561)class_2561.method_43471((String)item.method_7909().method_7876()).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075}));
                    viewItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Input").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" or ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Focus").method_27692(class_124.field_1063))));
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)viewItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
        if (this.costMode == -1) {
            costItem = GuiElementBuilder.from((class_1799)ArcanaRegistry.AEQUALIS_SCIENTIA.getPrefItemNoLore()).hideDefaultTooltip();
            costItem.setName((class_2561)class_2561.method_43470((String)"Cost Calculation Mode").method_27692(class_124.field_1062));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)ArcanaRegistry.AEQUALIS_SCIENTIA.getTranslatedName().method_27692(class_124.field_1075))));
            costItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to change cost calculation").method_27692(class_124.field_1078))));
        } else if (this.costMode == 0) {
            costItem = GuiElementBuilder.from((class_1799)new class_1799((class_1935)class_1802.field_8687)).hideDefaultTooltip();
            costItem.setName((class_2561)class_2561.method_43470((String)"Cost Calculation Mode").method_27692(class_124.field_1062));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Normal").method_27692(class_124.field_1060))));
            costItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to change cost calculation").method_27692(class_124.field_1078))));
        } else {
            costItem = GuiElementBuilder.from((class_1799)new class_1799((class_1935)class_1802.field_27063, this.costMode)).hideDefaultTooltip();
            costItem.setName((class_2561)class_2561.method_43470((String)"Cost Calculation Mode").method_27692(class_124.field_1062));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)ArcanaAugments.HASTY_BARGAIN.getTranslationKey()).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(" " + LevelUtils.intToRoman(this.costMode))).method_27692(class_124.field_1076))));
            costItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            costItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to change cost calculation").method_27692(class_124.field_1078))));
        }
        this.setSlot(8, (GuiElementBuilderInterface)costItem);
        if (this.costMode == -1) {
            reagent1 = this.curRecipe.getAequalisReagent(this.curRecipe.getReagent1());
            reagent2 = this.curRecipe.getAequalisReagent(this.curRecipe.getReagent2());
        } else {
            reagent1 = this.curRecipe.getBargainReagent(this.curRecipe.getReagent1(), this.costMode);
            reagent2 = this.curRecipe.getBargainReagent(this.curRecipe.getReagent2(), this.costMode);
        }
        GuiElementBuilder reagent1Item = GuiElementBuilder.from((class_1799)reagent1).hideDefaultTooltip();
        reagent1Item.setName((class_2561)class_2561.method_43471((String)reagent1.method_7909().method_7876()).method_27695(new class_124[]{class_124.field_1067, class_124.field_1060}));
        reagent1Item.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent1.method_7947() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)reagent1.method_7909().method_7876()).method_27692(class_124.field_1075))));
        this.setSlot(48, (GuiElementBuilderInterface)reagent1Item);
        GuiElementBuilder reagent2Item = GuiElementBuilder.from((class_1799)reagent2).hideDefaultTooltip();
        reagent2Item.setName((class_2561)class_2561.method_43471((String)reagent2.method_7909().method_7876()).method_27695(new class_124[]{class_124.field_1067, class_124.field_1060}));
        reagent2Item.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Reagent: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(reagent2.method_7947() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43471((String)reagent2.method_7909().method_7876()).method_27692(class_124.field_1075))));
        this.setSlot(50, (GuiElementBuilderInterface)reagent2Item);
        GuiElementBuilder recipeItem = new GuiElementBuilder(GraphicalItem.with((GraphicalItem.GraphicElement)ArcanaRegistry.TRANSMUTATION_BOOK)).hideDefaultTooltip();
        recipeItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Transmutation Recipes").method_27692(class_124.field_1062)));
        recipeItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to view all Transmutation Recipes").method_27692(class_124.field_1078))));
        this.setSlot(49, (GuiElementBuilderInterface)recipeItem);
        this.setTitle((class_2561)class_2561.method_43470((String)(this.curRecipeName + " Transmutation")));
    }

    public void onTick() {
        class_1937 world;
        if (!(this.blockEntity == null || (world = this.blockEntity.method_10997()) != null && world.method_8321(this.blockEntity.method_11016()) == this.blockEntity && this.blockEntity.isAssembled())) {
            this.close();
        }
    }

    public void onClose() {
        if (this.returnGui != null) {
            this.returnGui.open();
        }
    }
}

