/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.arcanesingularity;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.ArcaneSingularityBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9636;

public class ArcaneSingularityGui
extends SimpleGui {
    private final ArcaneSingularityBlockEntity blockEntity;
    private int page = 1;
    private final int capacity;
    private ArrayList<class_1799> filteredBooks;
    private List<class_1799> books;
    private BookFilter filter;
    private BookSort sort;
    private class_1799 selected = class_1799.field_8037;

    public ArcaneSingularityGui(class_3222 player, ArcaneSingularityBlockEntity blockEntity, int capacity) {
        super(class_3917.field_17327, player, false);
        this.blockEntity = blockEntity;
        this.filter = BookFilter.NONE;
        this.sort = BookSort.FIRST_ALPHABETICAL;
        this.capacity = capacity;
        this.loadBooks();
        this.setTitle((class_2561)class_2561.method_43470((String)"Arcane Singularity"));
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean accretion;
        boolean indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
        boolean bl = accretion = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.ACCRETION.id) >= 1;
        if (index >= this.size && type == ClickType.MOUSE_LEFT_SHIFT) {
            int invSlot = index >= 27 + this.size ? index - (27 + this.size) : index - 45;
            class_1799 stack = this.player.method_31548().method_5438(invSlot);
            if (stack.method_31574(class_1802.field_8598) && class_1890.method_58117((class_1799)stack) && this.tryAddBook(stack)) {
                this.player.method_31548().method_5447(invSlot, class_1799.field_8037);
            }
        } else if (index == 0) {
            boolean backwards = type == ClickType.MOUSE_RIGHT;
            boolean shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            this.sort = shiftLeft ? BookSort.FIRST_ALPHABETICAL : BookSort.cycleSort(this.sort, backwards);
            this.buildGui();
        } else if (index == 8) {
            boolean shiftLeft;
            boolean backwards = type == ClickType.MOUSE_RIGHT;
            boolean bl2 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            if (shiftLeft) {
                this.filter = BookFilter.NONE;
            } else {
                this.filter = BookFilter.cycleFilter(this.filter, backwards);
                this.page = 1;
            }
            this.buildGui();
        } else if (index == 45) {
            this.prevPage();
            this.buildGui();
        } else if (index == 53) {
            this.nextPage();
            this.buildGui();
        } else if (indexInCenter) {
            int ind = 7 * (index / 9 - 1) + (index % 9 - 1) + 28 * (this.page - 1);
            if (ind >= this.filteredBooks.size()) {
                return true;
            }
            class_1799 targetBook = this.filteredBooks.get(ind);
            block0: for (class_1799 book : this.books) {
                if (!class_1799.method_31577((class_1799)targetBook, (class_1799)book)) continue;
                if (accretion && type == ClickType.MOUSE_LEFT_SHIFT) {
                    if (class_1799.method_31577((class_1799)targetBook, (class_1799)this.selected)) {
                        this.selected = class_1799.field_8037;
                        break;
                    }
                    if (this.selected != class_1799.field_8037) {
                        for (class_1799 otherBook : this.books) {
                            if (!class_1799.method_31577((class_1799)this.selected, (class_1799)otherBook)) continue;
                            ArcaneSingularityBlockEntity.SingularityResult result = this.blockEntity.mergeBooks(book, otherBook);
                            if (result == ArcaneSingularityBlockEntity.SingularityResult.SUCCESS) {
                                MinecraftUtils.returnItems((class_1263)new class_1277(new class_1799[]{new class_1799((class_1935)class_1802.field_8529)}), (class_1657)this.player);
                                this.selected = class_1799.field_8037;
                                break block0;
                            }
                            if (result != ArcaneSingularityBlockEntity.SingularityResult.FAIL) break block0;
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"Those books are incompatible").method_27692(class_124.field_1061), false);
                            break block0;
                        }
                        break;
                    }
                    this.selected = book;
                    break;
                }
                if (accretion && type == ClickType.MOUSE_RIGHT) {
                    if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)class_1802.field_8529, (int)1)) {
                        ArcaneSingularityBlockEntity.SingularityResult result = this.blockEntity.splitBook(book);
                        if (result == ArcaneSingularityBlockEntity.SingularityResult.FULL) {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"That Singularity is full").method_27692(class_124.field_1061), false);
                            break;
                        }
                        if (result == ArcaneSingularityBlockEntity.SingularityResult.FAIL) {
                            this.player.method_7353((class_2561)class_2561.method_43470((String)"That book cannot be split").method_27692(class_124.field_1061), false);
                            break;
                        }
                        if (result != ArcaneSingularityBlockEntity.SingularityResult.SUCCESS) break;
                        this.selected = class_1799.field_8037;
                        break;
                    }
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You need a book to split the enchants to").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    break;
                }
                if (class_1799.method_31577((class_1799)book, (class_1799)this.selected)) {
                    this.selected = class_1799.field_8037;
                }
                if (this.blockEntity.removeBook(book) != ArcaneSingularityBlockEntity.SingularityResult.SUCCESS) break;
                ArcanaItem.removeProperty(book, "singularityId");
                MinecraftUtils.returnItems((class_1263)new class_1277(new class_1799[]{book}), (class_1657)this.player);
                break;
            }
            this.buildGui();
        }
        return true;
    }

    private boolean tryAddBook(class_1799 book) {
        int curSize = this.blockEntity.getNumBooks();
        boolean isFull = curSize == this.capacity;
        ArcaneSingularityBlockEntity.SingularityResult result = this.blockEntity.addBook(book);
        if (result == ArcaneSingularityBlockEntity.SingularityResult.FULL) {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"The Singularity is Full").method_27692(class_124.field_1061), false);
            return false;
        }
        if (!isFull && this.blockEntity.getNumBooks() == this.capacity) {
            ArcanaAchievements.grant(this.player, ArcanaAchievements.ARCANE_QUASAR.id);
        }
        this.buildGui();
        return result == ArcaneSingularityBlockEntity.SingularityResult.SUCCESS;
    }

    public void buildGui() {
        this.loadBooks();
        boolean accretion = ArcanaAugments.getAugmentFromMap(this.blockEntity.getAugments(), ArcanaAugments.ACCRETION.id) >= 1;
        int maxPages = (int)Math.ceil((double)this.filteredBooks.size() / 28.0);
        GuiHelper.outlineGUI((SimpleGui)this, (int)7996617, (class_2561)class_2561.method_43473());
        if (maxPages > 1) {
            GuiElementBuilder nextArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW)).hideDefaultTooltip();
            nextArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Page").method_27692(class_124.field_1065)));
            nextArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + maxPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(53, (GuiElementBuilderInterface)nextArrow);
            GuiElementBuilder prevArrow = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip();
            prevArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Prev Page").method_27692(class_124.field_1065)));
            prevArrow.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + maxPages + ")")).method_27692(class_124.field_1064))));
            this.setSlot(45, (GuiElementBuilderInterface)prevArrow);
        }
        GuiElementBuilder singularityItem = new GuiElementBuilder(class_1802.field_16312).hideDefaultTooltip();
        singularityItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcane Singularity").method_27692(class_124.field_1076)));
        singularityItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" a book in your inventory to insert it").method_27692(class_124.field_1064))));
        singularityItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" a book in the singularity to remove it").method_27692(class_124.field_1064))));
        this.setSlot(4, (GuiElementBuilderInterface)singularityItem);
        GuiElementBuilder filterBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.FILTER)).hideDefaultTooltip();
        filterBuilt.setName((class_2561)class_2561.method_43470((String)"Filter Books").method_27692(class_124.field_1064));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle filter backwards.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        filterBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Current Filter: ").method_27692(class_124.field_1075)).method_10852(BookFilter.getColoredLabel(this.filter))));
        this.setSlot(8, (GuiElementBuilderInterface)filterBuilt);
        GuiElementBuilder sortBuilt = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.SORT)).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Books").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(BookSort.getColoredLabel(this.sort))));
        this.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        List<class_1799> pageItems = this.getPage();
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < pageItems.size()) {
                    class_9304 comp = class_1890.method_57532((class_1799)pageItems.get(k));
                    GuiElementBuilder enchantBook = new GuiElementBuilder(class_1802.field_8598).glow();
                    enchantBook.setName((class_2561)class_2561.method_43470((String)"Enchanted Book").method_27692(class_124.field_1054));
                    for (Object2IntMap.Entry entry : comp.method_57539()) {
                        enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_2561)class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue())));
                    }
                    enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43473()));
                    enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to take the book").method_27692(class_124.field_1076))));
                    if (accretion) {
                        enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to select the book for merging").method_27692(class_124.field_1076))));
                        enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to split the book").method_27692(class_124.field_1076))));
                        if (class_1799.method_31577((class_1799)pageItems.get(k), (class_1799)this.selected)) {
                            enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43473()));
                            enchantBook.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"<< Selected >>").method_27692(class_124.field_1078)));
                        }
                    }
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)enchantBook);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)ArcanaRegistry.GAS)).setName((class_2561)class_2561.method_43473()).hideTooltip());
                }
                ++k;
            }
        }
    }

    private void loadBooks() {
        this.books = new ArrayList<class_1799>(this.blockEntity.getBooks());
        this.filteredBooks = new ArrayList();
        for (class_1799 book : this.books) {
            if (!BookFilter.matchesFilter(this.filter, class_1890.method_57532((class_1799)book).method_57539())) continue;
            this.filteredBooks.add(book.method_7972());
        }
        switch (this.sort.ordinal()) {
            case 0: {
                Comparator<class_1799> levelComparator = Comparator.comparingInt(stack -> {
                    int count = 0;
                    for (Object2IntMap.Entry e : class_1890.method_57532((class_1799)stack).method_57539()) {
                        count += e.getIntValue();
                    }
                    return -count;
                });
                this.filteredBooks.sort(levelComparator);
                break;
            }
            case 1: {
                Comparator<class_1799> levelComparator = Comparator.comparingInt(stack -> {
                    int highest = 0;
                    for (Object2IntMap.Entry e : class_1890.method_57532((class_1799)stack).method_57539()) {
                        if (e.getIntValue() <= highest) continue;
                        highest = e.getIntValue();
                    }
                    return -highest;
                });
                this.filteredBooks.sort(levelComparator);
                break;
            }
            case 2: {
                Comparator<class_1799> levelComparator = Comparator.comparingInt(stack -> {
                    int count = 0;
                    for (Object2IntMap.Entry e : class_1890.method_57532((class_1799)stack).method_57539()) {
                        count += e.getIntValue();
                    }
                    return count;
                });
                this.filteredBooks.sort(levelComparator);
                break;
            }
            case 3: {
                Comparator<class_1799> nameComparator = Comparator.comparing(stack -> {
                    Iterator iter = class_1890.method_57532((class_1799)stack).method_57534().iterator();
                    if (iter.hasNext()) {
                        return class_1887.method_8179((class_6880)((class_6880)iter.next()), (int)1).getString();
                    }
                    return "";
                });
                this.filteredBooks.sort(nameComparator);
            }
        }
    }

    private List<class_1799> getPage() {
        ArrayList<class_1799> pageItems = new ArrayList<class_1799>();
        for (int i = (this.page - 1) * 28; i < this.page * 28 && i < this.filteredBooks.size(); ++i) {
            pageItems.add(this.filteredBooks.get(i));
        }
        return pageItems;
    }

    public void nextPage() {
        int maxPages = (int)Math.ceil((double)this.filteredBooks.size() / 28.0);
        if (this.page < maxPages) {
            ++this.page;
        }
    }

    public void prevPage() {
        if (this.page > 1) {
            --this.page;
        }
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled()) {
            this.close();
        }
        super.onTick();
    }

    public void close() {
        this.blockEntity.removePlayer(this.player);
        super.close();
    }

    public static enum BookFilter {
        NONE("None"),
        SINGLE_ENCHANT("Single Enchant"),
        MAX_LEVEL("Max Level"),
        MULTIPLE_ENCHANT("Multiple Enchants"),
        SWORDS("Sword Enchants"),
        BOWS("Bow Enchants"),
        AXES("Axe Enchants"),
        TOOLS("Tool Enchants"),
        CROSSBOWS("Crossbow Enchants"),
        TRIDENTS("Trident Enchants"),
        FISHING("Fishing Rod Enchants"),
        ARMOR("Armor Enchants"),
        MACES("Mace Enchants"),
        TREASURE("Treasure Enchants"),
        CURSES("Curses");

        public final String label;

        private BookFilter(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(BookFilter filter) {
            class_5250 text = class_2561.method_43470((String)filter.label);
            return switch (filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1068);
                case 8 -> text.method_27692(class_124.field_1080);
                case 1 -> text.method_27692(class_124.field_1060);
                case 3 -> text.method_27692(class_124.field_1075);
                case 5 -> text.method_27692(class_124.field_1065);
                case 2 -> text.method_27692(class_124.field_1076);
                case 9 -> text.method_27692(class_124.field_1062);
                case 14 -> text.method_27692(class_124.field_1064);
                case 11 -> text.method_27692(class_124.field_1077);
                case 4 -> text.method_27692(class_124.field_1061);
                case 7 -> text.method_27692(class_124.field_1078);
                case 6 -> text.method_27692(class_124.field_1079);
                case 13 -> text.method_27692(class_124.field_1054);
                case 10 -> text.method_27692(class_124.field_1063);
                case 12 -> text.method_27692(class_124.field_1058);
            };
        }

        public static BookFilter cycleFilter(BookFilter filter, boolean backwards) {
            BookFilter[] filters = BookFilter.values();
            int ind = -1;
            for (int i = 0; i < filters.length; ++i) {
                if (filter != filters[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= filters.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = filters.length - 1;
            }
            return filters[ind];
        }

        public static boolean matchesFilter(BookFilter filter, Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantMap) {
            if (enchantMap.isEmpty()) {
                return false;
            }
            return switch (filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 8 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8399)));
                case 1 -> {
                    if (enchantMap.size() == 1) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (enchantMap.size() > 1) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8102)));
                case 2 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_8183() == e.getIntValue());
                case 9 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8547)));
                case 14 -> enchantMap.stream().anyMatch(e -> ((class_6880)e.getKey()).method_40220(class_9636.field_51551));
                case 11 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8862)) || ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8678)) || ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8416)) || ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8753)));
                case 4 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8845)));
                case 7 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8335)));
                case 6 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8825)));
                case 13 -> enchantMap.stream().anyMatch(e -> ((class_6880)e.getKey()).method_40220(class_9636.field_51557) && !((class_6880)e.getKey()).method_40220(class_9636.field_51551));
                case 10 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_8378)));
                case 12 -> enchantMap.stream().anyMatch(e -> ((class_1887)((class_6880)e.getKey()).comp_349()).method_60046(new class_1799((class_1935)class_1802.field_49814)));
            };
        }
    }

    public static enum BookSort {
        TOTAL_LEVELS("Total Levels"),
        HIGHEST_LEVEL("Highest Level"),
        LEAST_LEVELS("Least Levels"),
        FIRST_ALPHABETICAL("Alphabetical");

        public final String label;

        private BookSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(BookSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1076);
                case 1 -> text.method_27692(class_124.field_1075);
                case 2 -> text.method_27692(class_124.field_1061);
                case 3 -> text.method_27692(class_124.field_1060);
            };
        }

        public static BookSort cycleSort(BookSort sort, boolean backwards) {
            BookSort[] sorts = BookSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }
}

