/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.starlightforge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.borisshoes.arcananovum.gui.starlightforge.EFItem;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.minecraft.class_3545;
import net.minecraft.class_5819;

class EnhancedForgingGame {
    public static final int PLAY_COST = 10;
    public final int width = 7;
    public final int height = 6;
    private final class_3545<EFItem, Integer>[][] board = new class_3545[7][6];
    private final class_3545<EFItem, Integer>[][] originalBoard;
    private final List<EFChange> changes;
    private int turn;
    private final class_5819 random = class_5819.method_43047();

    public EnhancedForgingGame(int startingValue, int planetCount, int starCount, long seed) {
        this.random.method_43052(seed);
        this.originalBoard = new class_3545[7][6];
        this.createNewBoard(startingValue, planetCount, starCount);
        this.changes = new ArrayList<EFChange>();
    }

    private void createNewBoard(int startingValue, int planetCount, int starCount) {
        int i;
        this.turn = 0;
        ArrayList<class_3545> eligible = new ArrayList<class_3545>();
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.board[x][y] = new class_3545((Object)EFItem.GAS, (Object)0);
                eligible.add(new class_3545((Object)x, (Object)y));
            }
        }
        for (i = 0; i < planetCount && !eligible.isEmpty(); ++i) {
            class_3545 tile = (class_3545)eligible.get(this.random.method_43048(eligible.size()));
            this.board[((Integer)tile.method_15442()).intValue()][((Integer)tile.method_15441()).intValue()] = new class_3545((Object)EFItem.PLANET, (Object)0);
            eligible.remove(tile);
        }
        for (i = 0; i < starCount && !eligible.isEmpty(); ++i) {
            class_3545 tile = (class_3545)eligible.get(this.random.method_43048(eligible.size()));
            this.board[((Integer)tile.method_15442()).intValue()][((Integer)tile.method_15441()).intValue()] = new class_3545((Object)((double)this.random.method_43057() < 0.66 ? EFItem.STAR : EFItem.PULSAR), (Object)0);
            eligible.remove(tile);
        }
        EFItem placeItem = EFItem.randomPlacementItem(startingValue, this.random);
        while (placeItem != null && !eligible.isEmpty()) {
            class_3545 tile = (class_3545)eligible.get(this.random.method_43048(eligible.size()));
            this.board[((Integer)tile.method_15442()).intValue()][((Integer)tile.method_15441()).intValue()] = new class_3545((Object)placeItem, (Object)0);
            eligible.remove(tile);
            placeItem = EFItem.randomPlacementItem(startingValue -= placeItem.startingValue, this.random);
        }
        eligible.clear();
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                if (!EFItem.hasTurn((EFItem)((Object)this.board[x][y].method_15442()))) continue;
                eligible.add(new class_3545((Object)x, (Object)y));
            }
        }
        int itemTurn = 1;
        while (!eligible.isEmpty()) {
            int index = this.random.method_43048(eligible.size());
            class_3545 tile = (class_3545)eligible.get(index);
            this.board[(Integer)tile.method_15442()][(Integer)tile.method_15441()].method_34965((Object)itemTurn);
            ++itemTurn;
            eligible.remove(tile);
        }
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.originalBoard[x][y] = new class_3545((Object)((EFItem)((Object)this.board[x][y].method_15442())), (Object)((Integer)this.board[x][y].method_15441()));
            }
        }
    }

    public class_3545<EFItem, Integer>[][] getBoard() {
        return this.board;
    }

    public boolean nextTurn() {
        boolean tileChanged = false;
        ++this.turn;
        class_3545<EFItem, Integer> turnPair = null;
        int itemX = -1;
        int itemY = -1;
        int highestTurn = 0;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                if ((Integer)this.board[x][y].method_15441() == this.turn) {
                    turnPair = this.board[x][y];
                    itemX = x;
                    itemY = y;
                }
                if ((Integer)this.board[x][y].method_15441() <= highestTurn) continue;
                highestTurn = (Integer)this.board[x][y].method_15441();
            }
        }
        if (turnPair == null) {
            if (this.turn < this.getHighestTurn()) {
                tileChanged = this.nextTurn();
            }
            return tileChanged;
        }
        EFItem turnItem = (EFItem)((Object)turnPair.method_15442());
        if (turnItem == EFItem.NOVA) {
            count = 0;
            for (class_3545<Integer, Integer> slot : this.getValidEffectedSlots(itemX, itemY, turnItem)) {
                EFItem slotItem = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                if (slotItem != EFItem.PLASMA) continue;
                ++count;
            }
            this.board[itemX][itemY] = new class_3545((Object)(count >= 3 ? EFItem.STAR : EFItem.PLASMA), (Object)(count >= 3 ? ++highestTurn : 0));
            tileChanged = true;
        } else if (turnItem == EFItem.QUASAR || turnItem == EFItem.PULSAR || turnItem == EFItem.STAR) {
            for (class_3545<Integer, Integer> slot : this.getValidEffectedSlots(itemX, itemY, turnItem)) {
                EFItem slotItem = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                if (slotItem != EFItem.GAS && slotItem != EFItem.PLASMA) continue;
                EFItem before = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                this.board[((Integer)slot.method_15442()).intValue()][((Integer)slot.method_15441()).intValue()] = new class_3545((Object)EFItem.PLASMA, (Object)0);
                if (this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442() == before) continue;
                tileChanged = true;
            }
        } else if (turnItem == EFItem.SUPERNOVA) {
            for (class_3545<Integer, Integer> slot : this.getValidEffectedSlots(itemX, itemY, turnItem)) {
                EFItem slotItem = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                if (slotItem != EFItem.GAS && slotItem != EFItem.PLASMA) continue;
                this.board[((Integer)slot.method_15442()).intValue()][((Integer)slot.method_15441()).intValue()] = new class_3545((Object)EFItem.PLASMA, (Object)0);
            }
            this.board[itemX][itemY] = new class_3545((Object)EFItem.QUASAR, (Object)(++highestTurn));
            tileChanged = true;
        } else if (turnItem == EFItem.NEBULA) {
            count = 0;
            for (class_3545<Integer, Integer> slot : this.getValidEffectedSlots(itemX, itemY, turnItem)) {
                EFItem slotItem = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                if (slotItem != EFItem.PLASMA) continue;
                ++count;
            }
            if (count >= 4) {
                this.board[itemX][itemY] = new class_3545((Object)EFItem.NOVA, (Object)(++highestTurn));
                tileChanged = true;
            }
        } else if (turnItem == EFItem.BLACK_HOLE) {
            boolean convert = false;
            for (class_3545<Integer, Integer> slot : this.getValidEffectedSlots(itemX, itemY, turnItem)) {
                EFItem slotItem = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                if (slotItem == EFItem.STAR || slotItem == EFItem.QUASAR || slotItem == EFItem.PULSAR || slotItem == EFItem.BLACK_HOLE) {
                    convert = true;
                }
                if (slotItem == EFItem.NEBULA) continue;
                EFItem before = (EFItem)((Object)this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442());
                this.board[((Integer)slot.method_15442()).intValue()][((Integer)slot.method_15441()).intValue()] = new class_3545((Object)EFItem.PLASMA, (Object)0);
                if (this.board[(Integer)slot.method_15442()][(Integer)slot.method_15441()].method_15442() == before) continue;
                tileChanged = true;
            }
            if (convert) {
                this.board[itemX][itemY] = new class_3545((Object)EFItem.QUASAR, (Object)(++highestTurn));
                tileChanged = true;
            }
        }
        return tileChanged;
    }

    private List<class_3545<Integer, Integer>> getValidEffectedSlots(int x, int y, EFItem item) {
        ArrayList<class_3545<Integer, Integer>> list = new ArrayList<class_3545<Integer, Integer>>();
        ArrayList<class_3545<Integer, Integer>> touching = new ArrayList<class_3545<Integer, Integer>>();
        ArrayList<class_3545<Integer, Integer>> diagonal = new ArrayList<class_3545<Integer, Integer>>();
        ArrayList<class_3545<Integer, Integer>> surrounding = new ArrayList<class_3545<Integer, Integer>>();
        this.addIfValid(touching, x - 1, y);
        this.addIfValid(touching, x + 1, y);
        this.addIfValid(touching, x, y - 1);
        this.addIfValid(touching, x, y + 1);
        this.addIfValid(diagonal, x - 1, y - 1);
        this.addIfValid(diagonal, x + 1, y + 1);
        this.addIfValid(diagonal, x + 1, y - 1);
        this.addIfValid(diagonal, x - 1, y + 1);
        surrounding.addAll(touching);
        surrounding.addAll(diagonal);
        if (item == EFItem.BLACK_HOLE || item == EFItem.NEBULA) {
            list.addAll(surrounding);
        } else if (item == EFItem.SUPERNOVA) {
            list.addAll(surrounding);
            this.addIfValid(list, x - 2, y);
            this.addIfValid(list, x + 2, y);
            this.addIfValid(list, x, y - 2);
            this.addIfValid(list, x, y + 2);
        } else if (item == EFItem.NOVA || item == EFItem.STAR) {
            list.addAll(touching);
        } else if (item == EFItem.PULSAR) {
            list.addAll(diagonal);
        } else if (item == EFItem.QUASAR) {
            list.addAll(surrounding);
            for (int i = 1; i < 6; ++i) {
                this.addIfValid(list, x, y + i);
                this.addIfValid(list, x, y - i);
            }
        }
        return list;
    }

    private boolean validSlot(int x, int y) {
        return x >= 0 && y >= 0 && x < 7 && y < 6;
    }

    private boolean addIfValid(List<class_3545<Integer, Integer>> list, int x, int y) {
        if (this.validSlot(x, y)) {
            list.add((class_3545<Integer, Integer>)new class_3545((Object)x, (Object)y));
            return true;
        }
        return false;
    }

    public int getStarCount() {
        int starCount = 0;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                if (this.board[x][y].method_15442() != EFItem.STAR && this.board[x][y].method_15442() != EFItem.PULSAR) continue;
                ++starCount;
            }
        }
        return starCount;
    }

    public boolean hasNextTurn() {
        return Arrays.stream(this.board).anyMatch(subboard -> Arrays.stream(subboard).anyMatch(pair -> (Integer)pair.method_15441() > this.turn)) && this.turn < 99;
    }

    public int getTurn() {
        return this.turn;
    }

    private int getHighestTurn() {
        int highestTurn = 0;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                if ((Integer)this.board[x][y].method_15441() <= highestTurn) continue;
                highestTurn = (Integer)this.board[x][y].method_15441();
            }
        }
        return highestTurn;
    }

    private int getLowestTurn() {
        int lowestTurn = 999;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                if ((Integer)this.board[x][y].method_15441() >= lowestTurn || (Integer)this.board[x][y].method_15441() <= 0) continue;
                lowestTurn = (Integer)this.board[x][y].method_15441();
            }
        }
        return lowestTurn;
    }

    public void applyChanges() {
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                class_3545<EFItem, Integer> pair = this.originalBoard[x][y];
                this.board[x][y] = new class_3545((Object)((EFItem)((Object)pair.method_15442())), (Object)((Integer)pair.method_15441()));
            }
        }
        for (EFChange change : this.changes) {
            int turn = (Integer)this.board[change.x][change.y].method_15441();
            if (change.type != EFChangeType.TILE_CHANGE) continue;
            EFItem newTile = change.newTile.get();
            if (EFItem.hasTurn(newTile)) {
                if (turn == 0) {
                    this.board[change.x][change.y] = new class_3545((Object)newTile, (Object)(this.getHighestTurn() + 1));
                    continue;
                }
                this.board[change.x][change.y] = new class_3545((Object)newTile, (Object)turn);
                continue;
            }
            this.board[change.x][change.y] = new class_3545((Object)newTile, (Object)0);
        }
        ArrayList<class_3545> turnArray = new ArrayList<class_3545>();
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 6; ++y) {
                if (!EFItem.hasTurn((EFItem)((Object)this.board[x][y].method_15442()))) continue;
                int turn = (Integer)this.board[x][y].method_15441();
                turnArray.add(new class_3545((Object)turn, (Object)new class_3545((Object)x, (Object)y)));
            }
        }
        Comparator<class_3545> turnComparator = Comparator.comparingInt(class_3545::method_15442);
        turnArray.sort(turnComparator);
        ArrayList<class_3545> turnlessArray = new ArrayList<class_3545>();
        for (class_3545 majorPair : turnArray) {
            turnlessArray.add((class_3545)majorPair.method_15441());
        }
        block6: for (EFChange change : this.changes) {
            boolean increase = false;
            if (change.type == EFChangeType.TURN_INCREASE) {
                increase = true;
            } else if (change.type == EFChangeType.TILE_CHANGE) continue;
            for (int i = 0; i < turnlessArray.size(); ++i) {
                int x = (Integer)((class_3545)turnlessArray.get(i)).method_15442();
                int y = (Integer)((class_3545)turnlessArray.get(i)).method_15441();
                if (change.x != x || change.y != y || !increase && i == 0 || increase && i == turnlessArray.size() - 1) continue;
                if (increase) {
                    Collections.swap(turnlessArray, i, i + 1);
                    continue block6;
                }
                Collections.swap(turnlessArray, i, i - 1);
                continue block6;
            }
        }
        for (int i = 0; i < turnlessArray.size(); ++i) {
            int x = (Integer)((class_3545)turnlessArray.get(i)).method_15442();
            int y = (Integer)((class_3545)turnlessArray.get(i)).method_15441();
            this.board[x][y] = new class_3545((Object)((EFItem)((Object)this.board[x][y].method_15442())), (Object)(i + 1));
        }
    }

    public void addChange(EFChange change) {
        Iterator<EFChange> iter = this.changes.iterator();
        if (change.type == EFChangeType.TILE_CHANGE && this.board[change.x][change.y].method_15442() == EFItem.PLANET) {
            return;
        }
        if (!(change.type != EFChangeType.TURN_INCREASE && change.type != EFChangeType.TURN_DECREASE || EFItem.hasTurn((EFItem)((Object)this.board[change.x][change.y].method_15442())))) {
            return;
        }
        while (iter.hasNext()) {
            EFChange c = iter.next();
            if (c.y != change.y || c.x != change.x) continue;
            if (change.type == EFChangeType.TILE_CHANGE && c.type == EFChangeType.TILE_CHANGE) {
                iter.remove();
                continue;
            }
            if (change.type == EFChangeType.TILE_CHANGE && !EFItem.hasTurn(change.newTile.get())) {
                if (c.type != EFChangeType.TURN_DECREASE && c.type != EFChangeType.TURN_INCREASE) continue;
                iter.remove();
                continue;
            }
            if (change.type == EFChangeType.TURN_INCREASE && c.type == EFChangeType.TURN_DECREASE) {
                iter.remove();
                return;
            }
            if (change.type != EFChangeType.TURN_DECREASE || c.type != EFChangeType.TURN_INCREASE) continue;
            iter.remove();
            return;
        }
        if (change.type == EFChangeType.TILE_CHANGE && this.originalBoard[change.x][change.y].method_15442() == change.newTile.get()) {
            return;
        }
        if (change.type == EFChangeType.TURN_INCREASE && ((Integer)this.board[change.x][change.y].method_15441()).intValue() == this.getHighestTurn()) {
            return;
        }
        if (change.type == EFChangeType.TURN_DECREASE && ((Integer)this.board[change.x][change.y].method_15441()).intValue() == this.getLowestTurn()) {
            return;
        }
        this.changes.add(change);
    }

    public void removeChanges(int x, int y) {
        if (!this.validSlot(x, y)) {
            return;
        }
        this.changes.removeIf(c -> c.y == y && c.x == x);
    }

    public EFItem getItemAt(int x, int y) {
        if (!this.validSlot(x, y)) {
            return null;
        }
        return (EFItem)((Object)this.board[x][y].method_15442());
    }

    public void resetBoard() {
        this.changes.clear();
    }

    public int getTileChangeCost() {
        int cost = 0;
        for (EFChange change : this.changes) {
            if (change.type != EFChangeType.TILE_CHANGE) continue;
            cost += change.getCost();
        }
        return cost;
    }

    public int getTurnChangeCost() {
        int cost = 0;
        for (EFChange change : this.changes) {
            if (change.type != EFChangeType.TURN_DECREASE && change.type != EFChangeType.TURN_INCREASE) continue;
            cost += change.getCost();
        }
        return cost;
    }

    public int getTotalCost() {
        return this.getTurnChangeCost() + this.getTileChangeCost() + 10;
    }

    private static String boardToCode(class_3545<EFItem, Integer>[][] board) {
        StringBuilder binaryString = new StringBuilder();
        binaryString.append("0001");
        int width = board.length;
        int height = board[0].length;
        binaryString.append(String.format("%4s", Integer.toBinaryString(width & 0xF)).replace(' ', '0'));
        binaryString.append(String.format("%4s", Integer.toBinaryString(height & 0xF)).replace(' ', '0'));
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                EFItem item = (EFItem)((Object)board[x][y].method_15442());
                if (item == EFItem.GAS) {
                    binaryString.append("1");
                    continue;
                }
                binaryString.append("0");
                binaryString.append(String.format("%5s", Integer.toBinaryString(item.ordinal() & 0x1F)).replace(' ', '0'));
                if (EFItem.hasTurn(item)) {
                    int turn = (Integer)board[x][y].method_15441();
                    binaryString.append("1");
                    binaryString.append(String.format("%7s", Integer.toBinaryString(turn & 0x7F)).replace(' ', '0'));
                    continue;
                }
                binaryString.append("0");
            }
        }
        return AlgoUtils.convertToBase64((String)binaryString.toString());
    }

    public String getStartingCode() {
        return EnhancedForgingGame.boardToCode(this.originalBoard);
    }

    public String getGameCode() {
        return EnhancedForgingGame.boardToCode(this.board);
    }

    public record EFChange(EFChangeType type, int x, int y, Optional<EFItem> newTile) {
        static final int TURN_CHANGE_COST = 1;

        public int getCost() {
            if (this.type == EFChangeType.TILE_CHANGE) {
                return this.newTile.get().placementCost;
            }
            return 1;
        }
    }

    public static enum EFChangeType {
        TURN_INCREASE,
        TURN_DECREASE,
        TILE_CHANGE;

    }
}

